/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.net.InetAddress;
import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.IPAddressMaskPropertyDefinition;
import org.forgerock.opendj.config.IPAddressPropertyDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.AddressMask;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.SNMPConnectionHandlerCfgClient;
import org.forgerock.opendj.server.config.meta.ConnectionHandlerCfgDefn;
import org.forgerock.opendj.server.config.server.ConnectionHandlerCfg;
import org.forgerock.opendj.server.config.server.SNMPConnectionHandlerCfg;

public final class SNMPConnectionHandlerCfgDefn
extends ManagedObjectDefinition<SNMPConnectionHandlerCfgClient, SNMPConnectionHandlerCfg> {
    private static final SNMPConnectionHandlerCfgDefn INSTANCE = new SNMPConnectionHandlerCfgDefn();
    private static final StringPropertyDefinition PD_ALLOWED_MANAGER;
    private static final StringPropertyDefinition PD_ALLOWED_USER;
    private static final StringPropertyDefinition PD_COMMUNITY;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final IPAddressPropertyDefinition PD_LISTEN_ADDRESS;
    private static final IntegerPropertyDefinition PD_LISTEN_PORT;
    private static final StringPropertyDefinition PD_OPENDMK_JARFILE;
    private static final BooleanPropertyDefinition PD_REGISTERED_MBEAN;
    private static final StringPropertyDefinition PD_SECURITY_AGENT_FILE;
    private static final EnumPropertyDefinition<SecurityLevel> PD_SECURITY_LEVEL;
    private static final IntegerPropertyDefinition PD_TRAP_PORT;
    private static final StringPropertyDefinition PD_TRAPS_COMMUNITY;
    private static final StringPropertyDefinition PD_TRAPS_DESTINATION;

    public static SNMPConnectionHandlerCfgDefn getInstance() {
        return INSTANCE;
    }

    private SNMPConnectionHandlerCfgDefn() {
        super("snmp-connection-handler", ConnectionHandlerCfgDefn.getInstance());
    }

    @Override
    public SNMPConnectionHandlerCfgClient createClientConfiguration(ManagedObject<? extends SNMPConnectionHandlerCfgClient> impl) {
        return new SNMPConnectionHandlerCfgClientImpl(impl);
    }

    @Override
    public SNMPConnectionHandlerCfg createServerConfiguration(ServerManagedObject<? extends SNMPConnectionHandlerCfg> impl) {
        return new SNMPConnectionHandlerCfgServerImpl(impl);
    }

    @Override
    public Class<SNMPConnectionHandlerCfg> getServerConfigurationClass() {
        return SNMPConnectionHandlerCfg.class;
    }

    public IPAddressMaskPropertyDefinition getAllowedClientPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getAllowedClientPropertyDefinition();
    }

    public StringPropertyDefinition getAllowedManagerPropertyDefinition() {
        return PD_ALLOWED_MANAGER;
    }

    public StringPropertyDefinition getAllowedUserPropertyDefinition() {
        return PD_ALLOWED_USER;
    }

    public StringPropertyDefinition getCommunityPropertyDefinition() {
        return PD_COMMUNITY;
    }

    public IPAddressMaskPropertyDefinition getDeniedClientPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getDeniedClientPropertyDefinition();
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public IPAddressPropertyDefinition getListenAddressPropertyDefinition() {
        return PD_LISTEN_ADDRESS;
    }

    public IntegerPropertyDefinition getListenPortPropertyDefinition() {
        return PD_LISTEN_PORT;
    }

    public StringPropertyDefinition getOpendmkJarfilePropertyDefinition() {
        return PD_OPENDMK_JARFILE;
    }

    public BooleanPropertyDefinition getRegisteredMbeanPropertyDefinition() {
        return PD_REGISTERED_MBEAN;
    }

    public StringPropertyDefinition getSecurityAgentFilePropertyDefinition() {
        return PD_SECURITY_AGENT_FILE;
    }

    public EnumPropertyDefinition<SecurityLevel> getSecurityLevelPropertyDefinition() {
        return PD_SECURITY_LEVEL;
    }

    public IntegerPropertyDefinition getTrapPortPropertyDefinition() {
        return PD_TRAP_PORT;
    }

    public StringPropertyDefinition getTrapsCommunityPropertyDefinition() {
        return PD_TRAPS_COMMUNITY;
    }

    public StringPropertyDefinition getTrapsDestinationPropertyDefinition() {
        return PD_TRAPS_DESTINATION;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = StringPropertyDefinition.createBuilder(INSTANCE, "allowed-manager");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "allowed-manager"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("*");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALLOWED_MANAGER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOWED_MANAGER);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "allowed-user");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "allowed-user"));
        provider = new DefinedDefaultBehaviorProvider("*");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALLOWED_USER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOWED_USER);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "community");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "community"));
        provider = new DefinedDefaultBehaviorProvider("OpenDJ");
        builder.setDefaultBehaviorProvider(provider);
        PD_COMMUNITY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_COMMUNITY);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.snmp.SNMPConnectionHandler");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.ConnectionHandler");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = IPAddressPropertyDefinition.createBuilder(INSTANCE, "listen-address");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "listen-address"));
        provider = new DefinedDefaultBehaviorProvider("0.0.0.0");
        builder.setDefaultBehaviorProvider(provider);
        PD_LISTEN_ADDRESS = (IPAddressPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LISTEN_ADDRESS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "listen-port");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "listen-port"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(65535);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_LISTEN_PORT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LISTEN_PORT);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "opendmk-jarfile");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "opendmk-jarfile"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_OPENDMK_JARFILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_OPENDMK_JARFILE);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "registered-mbean");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "registered-mbean"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_REGISTERED_MBEAN = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REGISTERED_MBEAN);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "security-agent-file");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "security-agent-file"));
        provider = new DefinedDefaultBehaviorProvider("config/snmp/security/opendj-snmp.security");
        builder.setDefaultBehaviorProvider(provider);
        PD_SECURITY_AGENT_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SECURITY_AGENT_FILE);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "security-level");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "security-level"));
        provider = new DefinedDefaultBehaviorProvider("authnopriv");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(SecurityLevel.class);
        PD_SECURITY_LEVEL = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SECURITY_LEVEL);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "trap-port");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "trap-port"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_TRAP_PORT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TRAP_PORT);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "traps-community");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "traps-community"));
        provider = new DefinedDefaultBehaviorProvider("OpenDJ");
        builder.setDefaultBehaviorProvider(provider);
        PD_TRAPS_COMMUNITY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TRAPS_COMMUNITY);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "traps-destination");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "traps-destination"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "traps-destination"));
        PD_TRAPS_DESTINATION = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TRAPS_DESTINATION);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class SNMPConnectionHandlerCfgServerImpl
    implements SNMPConnectionHandlerCfg {
        private ServerManagedObject<? extends SNMPConnectionHandlerCfg> impl;
        private final SortedSet<AddressMask> pAllowedClient;
        private final SortedSet<String> pAllowedManager;
        private final SortedSet<String> pAllowedUser;
        private final String pCommunity;
        private final SortedSet<AddressMask> pDeniedClient;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final SortedSet<InetAddress> pListenAddress;
        private final int pListenPort;
        private final String pOpendmkJarfile;
        private final boolean pRegisteredMbean;
        private final String pSecurityAgentFile;
        private final SecurityLevel pSecurityLevel;
        private final int pTrapPort;
        private final String pTrapsCommunity;
        private final SortedSet<String> pTrapsDestination;

        private SNMPConnectionHandlerCfgServerImpl(ServerManagedObject<? extends SNMPConnectionHandlerCfg> impl) {
            this.impl = impl;
            this.pAllowedClient = impl.getPropertyValues((PropertyDefinition)INSTANCE.getAllowedClientPropertyDefinition());
            this.pAllowedManager = impl.getPropertyValues((PropertyDefinition)INSTANCE.getAllowedManagerPropertyDefinition());
            this.pAllowedUser = impl.getPropertyValues((PropertyDefinition)INSTANCE.getAllowedUserPropertyDefinition());
            this.pCommunity = impl.getPropertyValue(INSTANCE.getCommunityPropertyDefinition());
            this.pDeniedClient = impl.getPropertyValues((PropertyDefinition)INSTANCE.getDeniedClientPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pListenAddress = impl.getPropertyValues((PropertyDefinition)INSTANCE.getListenAddressPropertyDefinition());
            this.pListenPort = impl.getPropertyValue(INSTANCE.getListenPortPropertyDefinition());
            this.pOpendmkJarfile = impl.getPropertyValue(INSTANCE.getOpendmkJarfilePropertyDefinition());
            this.pRegisteredMbean = impl.getPropertyValue(INSTANCE.getRegisteredMbeanPropertyDefinition());
            this.pSecurityAgentFile = impl.getPropertyValue(INSTANCE.getSecurityAgentFilePropertyDefinition());
            this.pSecurityLevel = impl.getPropertyValue(INSTANCE.getSecurityLevelPropertyDefinition());
            this.pTrapPort = impl.getPropertyValue(INSTANCE.getTrapPortPropertyDefinition());
            this.pTrapsCommunity = impl.getPropertyValue(INSTANCE.getTrapsCommunityPropertyDefinition());
            this.pTrapsDestination = impl.getPropertyValues((PropertyDefinition)INSTANCE.getTrapsDestinationPropertyDefinition());
        }

        @Override
        public void addSNMPChangeListener(ConfigurationChangeListener<SNMPConnectionHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeSNMPChangeListener(ConfigurationChangeListener<SNMPConnectionHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<ConnectionHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<ConnectionHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<AddressMask> getAllowedClient() {
            return this.pAllowedClient;
        }

        @Override
        public SortedSet<String> getAllowedManager() {
            return this.pAllowedManager;
        }

        @Override
        public SortedSet<String> getAllowedUser() {
            return this.pAllowedUser;
        }

        @Override
        public String getCommunity() {
            return this.pCommunity;
        }

        @Override
        public SortedSet<AddressMask> getDeniedClient() {
            return this.pDeniedClient;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public SortedSet<InetAddress> getListenAddress() {
            return this.pListenAddress;
        }

        @Override
        public int getListenPort() {
            return this.pListenPort;
        }

        @Override
        public String getOpendmkJarfile() {
            return this.pOpendmkJarfile;
        }

        @Override
        public boolean isRegisteredMbean() {
            return this.pRegisteredMbean;
        }

        @Override
        public String getSecurityAgentFile() {
            return this.pSecurityAgentFile;
        }

        @Override
        public SecurityLevel getSecurityLevel() {
            return this.pSecurityLevel;
        }

        @Override
        public int getTrapPort() {
            return this.pTrapPort;
        }

        @Override
        public String getTrapsCommunity() {
            return this.pTrapsCommunity;
        }

        @Override
        public SortedSet<String> getTrapsDestination() {
            return this.pTrapsDestination;
        }

        @Override
        public Class<? extends SNMPConnectionHandlerCfg> configurationClass() {
            return SNMPConnectionHandlerCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class SNMPConnectionHandlerCfgClientImpl
    implements SNMPConnectionHandlerCfgClient {
        private ManagedObject<? extends SNMPConnectionHandlerCfgClient> impl;

        private SNMPConnectionHandlerCfgClientImpl(ManagedObject<? extends SNMPConnectionHandlerCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<AddressMask> getAllowedClient() {
            return this.impl.getPropertyValues(INSTANCE.getAllowedClientPropertyDefinition());
        }

        @Override
        public void setAllowedClient(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getAllowedClientPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getAllowedManager() {
            return this.impl.getPropertyValues(INSTANCE.getAllowedManagerPropertyDefinition());
        }

        @Override
        public void setAllowedManager(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getAllowedManagerPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getAllowedUser() {
            return this.impl.getPropertyValues(INSTANCE.getAllowedUserPropertyDefinition());
        }

        @Override
        public void setAllowedUser(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getAllowedUserPropertyDefinition(), values);
        }

        @Override
        public String getCommunity() {
            return this.impl.getPropertyValue(INSTANCE.getCommunityPropertyDefinition());
        }

        @Override
        public void setCommunity(String value) {
            this.impl.setPropertyValue(INSTANCE.getCommunityPropertyDefinition(), value);
        }

        @Override
        public SortedSet<AddressMask> getDeniedClient() {
            return this.impl.getPropertyValues(INSTANCE.getDeniedClientPropertyDefinition());
        }

        @Override
        public void setDeniedClient(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getDeniedClientPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public SortedSet<InetAddress> getListenAddress() {
            return this.impl.getPropertyValues(INSTANCE.getListenAddressPropertyDefinition());
        }

        @Override
        public void setListenAddress(Collection<InetAddress> values) throws PropertyException {
            this.impl.setPropertyValues(INSTANCE.getListenAddressPropertyDefinition(), values);
        }

        @Override
        public Integer getListenPort() {
            return this.impl.getPropertyValue(INSTANCE.getListenPortPropertyDefinition());
        }

        @Override
        public void setListenPort(int value) {
            this.impl.setPropertyValue(INSTANCE.getListenPortPropertyDefinition(), value);
        }

        @Override
        public String getOpendmkJarfile() {
            return this.impl.getPropertyValue(INSTANCE.getOpendmkJarfilePropertyDefinition());
        }

        @Override
        public void setOpendmkJarfile(String value) {
            this.impl.setPropertyValue(INSTANCE.getOpendmkJarfilePropertyDefinition(), value);
        }

        @Override
        public boolean isRegisteredMbean() {
            return this.impl.getPropertyValue(INSTANCE.getRegisteredMbeanPropertyDefinition());
        }

        @Override
        public void setRegisteredMbean(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getRegisteredMbeanPropertyDefinition(), value);
        }

        @Override
        public String getSecurityAgentFile() {
            return this.impl.getPropertyValue(INSTANCE.getSecurityAgentFilePropertyDefinition());
        }

        @Override
        public void setSecurityAgentFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getSecurityAgentFilePropertyDefinition(), value);
        }

        @Override
        public SecurityLevel getSecurityLevel() {
            return this.impl.getPropertyValue(INSTANCE.getSecurityLevelPropertyDefinition());
        }

        @Override
        public void setSecurityLevel(SecurityLevel value) {
            this.impl.setPropertyValue(INSTANCE.getSecurityLevelPropertyDefinition(), value);
        }

        @Override
        public Integer getTrapPort() {
            return this.impl.getPropertyValue(INSTANCE.getTrapPortPropertyDefinition());
        }

        @Override
        public void setTrapPort(int value) {
            this.impl.setPropertyValue(INSTANCE.getTrapPortPropertyDefinition(), value);
        }

        @Override
        public String getTrapsCommunity() {
            return this.impl.getPropertyValue(INSTANCE.getTrapsCommunityPropertyDefinition());
        }

        @Override
        public void setTrapsCommunity(String value) {
            this.impl.setPropertyValue(INSTANCE.getTrapsCommunityPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getTrapsDestination() {
            return this.impl.getPropertyValues(INSTANCE.getTrapsDestinationPropertyDefinition());
        }

        @Override
        public void setTrapsDestination(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getTrapsDestinationPropertyDefinition(), values);
        }

        @Override
        public ManagedObjectDefinition<? extends SNMPConnectionHandlerCfgClient, ? extends SNMPConnectionHandlerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }
    }

    public static enum SecurityLevel {
        AUTHNOPRIV("authnopriv"),
        AUTHPRIV("authpriv"),
        NOAUTHNOPRIV("noauthnopriv");

        private final String name;

        private SecurityLevel(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

