/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.ProfilerPluginCfgClient;
import org.forgerock.opendj.server.config.meta.PluginCfgDefn;
import org.forgerock.opendj.server.config.server.PluginCfg;
import org.forgerock.opendj.server.config.server.ProfilerPluginCfg;

public final class ProfilerPluginCfgDefn
extends ManagedObjectDefinition<ProfilerPluginCfgClient, ProfilerPluginCfg> {
    private static final ProfilerPluginCfgDefn INSTANCE = new ProfilerPluginCfgDefn();
    private static final BooleanPropertyDefinition PD_ENABLE_PROFILING_ON_STARTUP;
    private static final BooleanPropertyDefinition PD_INVOKE_FOR_INTERNAL_OPERATIONS;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final EnumPropertyDefinition<PluginCfgDefn.PluginType> PD_PLUGIN_TYPE;
    private static final EnumPropertyDefinition<ProfileAction> PD_PROFILE_ACTION;
    private static final StringPropertyDefinition PD_PROFILE_DIRECTORY;
    private static final DurationPropertyDefinition PD_PROFILE_SAMPLE_INTERVAL;

    public static ProfilerPluginCfgDefn getInstance() {
        return INSTANCE;
    }

    private ProfilerPluginCfgDefn() {
        super("profiler-plugin", PluginCfgDefn.getInstance());
    }

    @Override
    public ProfilerPluginCfgClient createClientConfiguration(ManagedObject<? extends ProfilerPluginCfgClient> impl) {
        return new ProfilerPluginCfgClientImpl(impl);
    }

    @Override
    public ProfilerPluginCfg createServerConfiguration(ServerManagedObject<? extends ProfilerPluginCfg> impl) {
        return new ProfilerPluginCfgServerImpl(impl);
    }

    @Override
    public Class<ProfilerPluginCfg> getServerConfigurationClass() {
        return ProfilerPluginCfg.class;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PluginCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public BooleanPropertyDefinition getEnableProfilingOnStartupPropertyDefinition() {
        return PD_ENABLE_PROFILING_ON_STARTUP;
    }

    public BooleanPropertyDefinition getInvokeForInternalOperationsPropertyDefinition() {
        return PD_INVOKE_FOR_INTERNAL_OPERATIONS;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public EnumPropertyDefinition<PluginCfgDefn.PluginType> getPluginTypePropertyDefinition() {
        return PD_PLUGIN_TYPE;
    }

    public EnumPropertyDefinition<ProfileAction> getProfileActionPropertyDefinition() {
        return PD_PROFILE_ACTION;
    }

    public StringPropertyDefinition getProfileDirectoryPropertyDefinition() {
        return PD_PROFILE_DIRECTORY;
    }

    public DurationPropertyDefinition getProfileSampleIntervalPropertyDefinition() {
        return PD_PROFILE_SAMPLE_INTERVAL;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "enable-profiling-on-startup");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "enable-profiling-on-startup"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ENABLE_PROFILING_ON_STARTUP = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ENABLE_PROFILING_ON_STARTUP);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "invoke-for-internal-operations");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "invoke-for-internal-operations"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_INVOKE_FOR_INTERNAL_OPERATIONS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INVOKE_FOR_INTERNAL_OPERATIONS);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.plugins.profiler.ProfilerPlugin");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.plugin.DirectoryServerPlugin");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "plugin-type");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "plugin-type"));
        provider = new DefinedDefaultBehaviorProvider("startup");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(PluginCfgDefn.PluginType.class);
        PD_PLUGIN_TYPE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PLUGIN_TYPE);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "profile-action");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "profile-action"));
        provider = new DefinedDefaultBehaviorProvider("none");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(ProfileAction.class);
        PD_PROFILE_ACTION = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PROFILE_ACTION);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "profile-directory");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "profile-directory"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "DIR");
        PD_PROFILE_DIRECTORY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PROFILE_DIRECTORY);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "profile-sample-interval");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "profile-sample-interval"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setUpperLimit("2147483647");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_PROFILE_SAMPLE_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PROFILE_SAMPLE_INTERVAL);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class ProfilerPluginCfgServerImpl
    implements ProfilerPluginCfg {
        private ServerManagedObject<? extends ProfilerPluginCfg> impl;
        private final boolean pEnabled;
        private final boolean pEnableProfilingOnStartup;
        private final boolean pInvokeForInternalOperations;
        private final String pJavaClass;
        private final SortedSet<PluginCfgDefn.PluginType> pPluginType;
        private final ProfileAction pProfileAction;
        private final String pProfileDirectory;
        private final long pProfileSampleInterval;

        private ProfilerPluginCfgServerImpl(ServerManagedObject<? extends ProfilerPluginCfg> impl) {
            this.impl = impl;
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pEnableProfilingOnStartup = impl.getPropertyValue(INSTANCE.getEnableProfilingOnStartupPropertyDefinition());
            this.pInvokeForInternalOperations = impl.getPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pPluginType = impl.getPropertyValues(INSTANCE.getPluginTypePropertyDefinition());
            this.pProfileAction = impl.getPropertyValue(INSTANCE.getProfileActionPropertyDefinition());
            this.pProfileDirectory = impl.getPropertyValue(INSTANCE.getProfileDirectoryPropertyDefinition());
            this.pProfileSampleInterval = impl.getPropertyValue(INSTANCE.getProfileSampleIntervalPropertyDefinition());
        }

        @Override
        public void addProfilerChangeListener(ConfigurationChangeListener<ProfilerPluginCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeProfilerChangeListener(ConfigurationChangeListener<ProfilerPluginCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<PluginCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<PluginCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public boolean isEnableProfilingOnStartup() {
            return this.pEnableProfilingOnStartup;
        }

        @Override
        public boolean isInvokeForInternalOperations() {
            return this.pInvokeForInternalOperations;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public SortedSet<PluginCfgDefn.PluginType> getPluginType() {
            return this.pPluginType;
        }

        @Override
        public ProfileAction getProfileAction() {
            return this.pProfileAction;
        }

        @Override
        public String getProfileDirectory() {
            return this.pProfileDirectory;
        }

        @Override
        public long getProfileSampleInterval() {
            return this.pProfileSampleInterval;
        }

        @Override
        public Class<? extends ProfilerPluginCfg> configurationClass() {
            return ProfilerPluginCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class ProfilerPluginCfgClientImpl
    implements ProfilerPluginCfgClient {
        private ManagedObject<? extends ProfilerPluginCfgClient> impl;

        private ProfilerPluginCfgClientImpl(ManagedObject<? extends ProfilerPluginCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnableProfilingOnStartup() {
            return this.impl.getPropertyValue(INSTANCE.getEnableProfilingOnStartupPropertyDefinition());
        }

        @Override
        public void setEnableProfilingOnStartup(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnableProfilingOnStartupPropertyDefinition(), value);
        }

        @Override
        public boolean isInvokeForInternalOperations() {
            return this.impl.getPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition());
        }

        @Override
        public void setInvokeForInternalOperations(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getInvokeForInternalOperationsPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public SortedSet<PluginCfgDefn.PluginType> getPluginType() {
            return this.impl.getPropertyValues(INSTANCE.getPluginTypePropertyDefinition());
        }

        @Override
        public void setPluginType(Collection<PluginCfgDefn.PluginType> values) {
            this.impl.setPropertyValues(INSTANCE.getPluginTypePropertyDefinition(), values);
        }

        @Override
        public ProfileAction getProfileAction() {
            return this.impl.getPropertyValue(INSTANCE.getProfileActionPropertyDefinition());
        }

        @Override
        public void setProfileAction(ProfileAction value) {
            this.impl.setPropertyValue(INSTANCE.getProfileActionPropertyDefinition(), value);
        }

        @Override
        public String getProfileDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getProfileDirectoryPropertyDefinition());
        }

        @Override
        public void setProfileDirectory(String value) {
            this.impl.setPropertyValue(INSTANCE.getProfileDirectoryPropertyDefinition(), value);
        }

        @Override
        public Long getProfileSampleInterval() {
            return this.impl.getPropertyValue(INSTANCE.getProfileSampleIntervalPropertyDefinition());
        }

        @Override
        public void setProfileSampleInterval(long value) {
            this.impl.setPropertyValue(INSTANCE.getProfileSampleIntervalPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends ProfilerPluginCfgClient, ? extends ProfilerPluginCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }
    }

    public static enum ProfileAction {
        CANCEL("cancel"),
        NONE("none"),
        START("start"),
        STOP("stop");

        private final String name;

        private ProfileAction(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

