/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AttributeTypePropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.server.config.client.AccountStatusNotificationHandlerCfgClient;
import org.forgerock.opendj.server.config.client.PasswordGeneratorCfgClient;
import org.forgerock.opendj.server.config.client.PasswordPolicyCfgClient;
import org.forgerock.opendj.server.config.client.PasswordStorageSchemeCfgClient;
import org.forgerock.opendj.server.config.client.PasswordValidatorCfgClient;
import org.forgerock.opendj.server.config.meta.AuthenticationPolicyCfgDefn;
import org.forgerock.opendj.server.config.server.AccountStatusNotificationHandlerCfg;
import org.forgerock.opendj.server.config.server.AuthenticationPolicyCfg;
import org.forgerock.opendj.server.config.server.PasswordGeneratorCfg;
import org.forgerock.opendj.server.config.server.PasswordPolicyCfg;
import org.forgerock.opendj.server.config.server.PasswordStorageSchemeCfg;
import org.forgerock.opendj.server.config.server.PasswordValidatorCfg;

public final class PasswordPolicyCfgDefn
extends ManagedObjectDefinition<PasswordPolicyCfgClient, PasswordPolicyCfg> {
    private static final PasswordPolicyCfgDefn INSTANCE = new PasswordPolicyCfgDefn();
    private static final AggregationPropertyDefinition<AccountStatusNotificationHandlerCfgClient, AccountStatusNotificationHandlerCfg> PD_ACCOUNT_STATUS_NOTIFICATION_HANDLER;
    private static final BooleanPropertyDefinition PD_ALLOW_EXPIRED_PASSWORD_CHANGES;
    private static final BooleanPropertyDefinition PD_ALLOW_MULTIPLE_PASSWORD_VALUES;
    private static final BooleanPropertyDefinition PD_ALLOW_PRE_ENCODED_PASSWORDS;
    private static final BooleanPropertyDefinition PD_ALLOW_USER_PASSWORD_CHANGES;
    private static final AggregationPropertyDefinition<PasswordStorageSchemeCfgClient, PasswordStorageSchemeCfg> PD_DEFAULT_PASSWORD_STORAGE_SCHEME;
    private static final AggregationPropertyDefinition<PasswordStorageSchemeCfgClient, PasswordStorageSchemeCfg> PD_DEPRECATED_PASSWORD_STORAGE_SCHEME;
    private static final BooleanPropertyDefinition PD_EXPIRE_PASSWORDS_WITHOUT_WARNING;
    private static final BooleanPropertyDefinition PD_FORCE_CHANGE_ON_ADD;
    private static final BooleanPropertyDefinition PD_FORCE_CHANGE_ON_RESET;
    private static final IntegerPropertyDefinition PD_GRACE_LOGIN_COUNT;
    private static final DurationPropertyDefinition PD_IDLE_LOCKOUT_INTERVAL;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final AttributeTypePropertyDefinition PD_LAST_LOGIN_TIME_ATTRIBUTE;
    private static final StringPropertyDefinition PD_LAST_LOGIN_TIME_FORMAT;
    private static final DurationPropertyDefinition PD_LOCKOUT_DURATION;
    private static final IntegerPropertyDefinition PD_LOCKOUT_FAILURE_COUNT;
    private static final DurationPropertyDefinition PD_LOCKOUT_FAILURE_EXPIRATION_INTERVAL;
    private static final DurationPropertyDefinition PD_MAX_PASSWORD_AGE;
    private static final DurationPropertyDefinition PD_MAX_PASSWORD_RESET_AGE;
    private static final DurationPropertyDefinition PD_MIN_PASSWORD_AGE;
    private static final AttributeTypePropertyDefinition PD_PASSWORD_ATTRIBUTE;
    private static final BooleanPropertyDefinition PD_PASSWORD_CHANGE_REQUIRES_CURRENT_PASSWORD;
    private static final DurationPropertyDefinition PD_PASSWORD_EXPIRATION_WARNING_INTERVAL;
    private static final AggregationPropertyDefinition<PasswordGeneratorCfgClient, PasswordGeneratorCfg> PD_PASSWORD_GENERATOR;
    private static final IntegerPropertyDefinition PD_PASSWORD_HISTORY_COUNT;
    private static final DurationPropertyDefinition PD_PASSWORD_HISTORY_DURATION;
    private static final AggregationPropertyDefinition<PasswordValidatorCfgClient, PasswordValidatorCfg> PD_PASSWORD_VALIDATOR;
    private static final StringPropertyDefinition PD_PREVIOUS_LAST_LOGIN_TIME_FORMAT;
    private static final StringPropertyDefinition PD_REQUIRE_CHANGE_BY_TIME;
    private static final BooleanPropertyDefinition PD_REQUIRE_SECURE_AUTHENTICATION;
    private static final BooleanPropertyDefinition PD_REQUIRE_SECURE_PASSWORD_CHANGES;
    private static final BooleanPropertyDefinition PD_SKIP_VALIDATION_FOR_ADMINISTRATORS;
    private static final EnumPropertyDefinition<StateUpdateFailurePolicy> PD_STATE_UPDATE_FAILURE_POLICY;

    public static PasswordPolicyCfgDefn getInstance() {
        return INSTANCE;
    }

    private PasswordPolicyCfgDefn() {
        super("password-policy", AuthenticationPolicyCfgDefn.getInstance());
    }

    @Override
    public PasswordPolicyCfgClient createClientConfiguration(ManagedObject<? extends PasswordPolicyCfgClient> impl) {
        return new PasswordPolicyCfgClientImpl(impl);
    }

    @Override
    public PasswordPolicyCfg createServerConfiguration(ServerManagedObject<? extends PasswordPolicyCfg> impl) {
        return new PasswordPolicyCfgServerImpl(impl);
    }

    @Override
    public Class<PasswordPolicyCfg> getServerConfigurationClass() {
        return PasswordPolicyCfg.class;
    }

    public AggregationPropertyDefinition<AccountStatusNotificationHandlerCfgClient, AccountStatusNotificationHandlerCfg> getAccountStatusNotificationHandlerPropertyDefinition() {
        return PD_ACCOUNT_STATUS_NOTIFICATION_HANDLER;
    }

    public BooleanPropertyDefinition getAllowExpiredPasswordChangesPropertyDefinition() {
        return PD_ALLOW_EXPIRED_PASSWORD_CHANGES;
    }

    public BooleanPropertyDefinition getAllowMultiplePasswordValuesPropertyDefinition() {
        return PD_ALLOW_MULTIPLE_PASSWORD_VALUES;
    }

    public BooleanPropertyDefinition getAllowPreEncodedPasswordsPropertyDefinition() {
        return PD_ALLOW_PRE_ENCODED_PASSWORDS;
    }

    public BooleanPropertyDefinition getAllowUserPasswordChangesPropertyDefinition() {
        return PD_ALLOW_USER_PASSWORD_CHANGES;
    }

    public AggregationPropertyDefinition<PasswordStorageSchemeCfgClient, PasswordStorageSchemeCfg> getDefaultPasswordStorageSchemePropertyDefinition() {
        return PD_DEFAULT_PASSWORD_STORAGE_SCHEME;
    }

    public AggregationPropertyDefinition<PasswordStorageSchemeCfgClient, PasswordStorageSchemeCfg> getDeprecatedPasswordStorageSchemePropertyDefinition() {
        return PD_DEPRECATED_PASSWORD_STORAGE_SCHEME;
    }

    public BooleanPropertyDefinition getExpirePasswordsWithoutWarningPropertyDefinition() {
        return PD_EXPIRE_PASSWORDS_WITHOUT_WARNING;
    }

    public BooleanPropertyDefinition getForceChangeOnAddPropertyDefinition() {
        return PD_FORCE_CHANGE_ON_ADD;
    }

    public BooleanPropertyDefinition getForceChangeOnResetPropertyDefinition() {
        return PD_FORCE_CHANGE_ON_RESET;
    }

    public IntegerPropertyDefinition getGraceLoginCountPropertyDefinition() {
        return PD_GRACE_LOGIN_COUNT;
    }

    public DurationPropertyDefinition getIdleLockoutIntervalPropertyDefinition() {
        return PD_IDLE_LOCKOUT_INTERVAL;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public AttributeTypePropertyDefinition getLastLoginTimeAttributePropertyDefinition() {
        return PD_LAST_LOGIN_TIME_ATTRIBUTE;
    }

    public StringPropertyDefinition getLastLoginTimeFormatPropertyDefinition() {
        return PD_LAST_LOGIN_TIME_FORMAT;
    }

    public DurationPropertyDefinition getLockoutDurationPropertyDefinition() {
        return PD_LOCKOUT_DURATION;
    }

    public IntegerPropertyDefinition getLockoutFailureCountPropertyDefinition() {
        return PD_LOCKOUT_FAILURE_COUNT;
    }

    public DurationPropertyDefinition getLockoutFailureExpirationIntervalPropertyDefinition() {
        return PD_LOCKOUT_FAILURE_EXPIRATION_INTERVAL;
    }

    public DurationPropertyDefinition getMaxPasswordAgePropertyDefinition() {
        return PD_MAX_PASSWORD_AGE;
    }

    public DurationPropertyDefinition getMaxPasswordResetAgePropertyDefinition() {
        return PD_MAX_PASSWORD_RESET_AGE;
    }

    public DurationPropertyDefinition getMinPasswordAgePropertyDefinition() {
        return PD_MIN_PASSWORD_AGE;
    }

    public AttributeTypePropertyDefinition getPasswordAttributePropertyDefinition() {
        return PD_PASSWORD_ATTRIBUTE;
    }

    public BooleanPropertyDefinition getPasswordChangeRequiresCurrentPasswordPropertyDefinition() {
        return PD_PASSWORD_CHANGE_REQUIRES_CURRENT_PASSWORD;
    }

    public DurationPropertyDefinition getPasswordExpirationWarningIntervalPropertyDefinition() {
        return PD_PASSWORD_EXPIRATION_WARNING_INTERVAL;
    }

    public AggregationPropertyDefinition<PasswordGeneratorCfgClient, PasswordGeneratorCfg> getPasswordGeneratorPropertyDefinition() {
        return PD_PASSWORD_GENERATOR;
    }

    public IntegerPropertyDefinition getPasswordHistoryCountPropertyDefinition() {
        return PD_PASSWORD_HISTORY_COUNT;
    }

    public DurationPropertyDefinition getPasswordHistoryDurationPropertyDefinition() {
        return PD_PASSWORD_HISTORY_DURATION;
    }

    public AggregationPropertyDefinition<PasswordValidatorCfgClient, PasswordValidatorCfg> getPasswordValidatorPropertyDefinition() {
        return PD_PASSWORD_VALIDATOR;
    }

    public StringPropertyDefinition getPreviousLastLoginTimeFormatPropertyDefinition() {
        return PD_PREVIOUS_LAST_LOGIN_TIME_FORMAT;
    }

    public StringPropertyDefinition getRequireChangeByTimePropertyDefinition() {
        return PD_REQUIRE_CHANGE_BY_TIME;
    }

    public BooleanPropertyDefinition getRequireSecureAuthenticationPropertyDefinition() {
        return PD_REQUIRE_SECURE_AUTHENTICATION;
    }

    public BooleanPropertyDefinition getRequireSecurePasswordChangesPropertyDefinition() {
        return PD_REQUIRE_SECURE_PASSWORD_CHANGES;
    }

    public BooleanPropertyDefinition getSkipValidationForAdministratorsPropertyDefinition() {
        return PD_SKIP_VALIDATION_FOR_ADMINISTRATORS;
    }

    public EnumPropertyDefinition<StateUpdateFailurePolicy> getStateUpdateFailurePolicyPropertyDefinition() {
        return PD_STATE_UPDATE_FAILURE_POLICY;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "account-status-notification-handler");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "account-status-notification-handler"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("account-status-notification-handler");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_ACCOUNT_STATUS_NOTIFICATION_HANDLER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ACCOUNT_STATUS_NOTIFICATION_HANDLER);
        INSTANCE.registerConstraint(PD_ACCOUNT_STATUS_NOTIFICATION_HANDLER.getSourceConstraint());
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "allow-expired-password-changes");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allow-expired-password-changes"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALLOW_EXPIRED_PASSWORD_CHANGES = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOW_EXPIRED_PASSWORD_CHANGES);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "allow-multiple-password-values");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allow-multiple-password-values"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALLOW_MULTIPLE_PASSWORD_VALUES = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOW_MULTIPLE_PASSWORD_VALUES);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "allow-pre-encoded-passwords");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allow-pre-encoded-passwords"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALLOW_PRE_ENCODED_PASSWORDS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOW_PRE_ENCODED_PASSWORDS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "allow-user-password-changes");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allow-user-password-changes"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALLOW_USER_PASSWORD_CHANGES = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOW_USER_PASSWORD_CHANGES);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "default-password-storage-scheme");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "default-password-storage-scheme"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("password-storage-scheme");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_DEFAULT_PASSWORD_STORAGE_SCHEME = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DEFAULT_PASSWORD_STORAGE_SCHEME);
        INSTANCE.registerConstraint(PD_DEFAULT_PASSWORD_STORAGE_SCHEME.getSourceConstraint());
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "deprecated-password-storage-scheme");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "deprecated-password-storage-scheme"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("password-storage-scheme");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_DEPRECATED_PASSWORD_STORAGE_SCHEME = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DEPRECATED_PASSWORD_STORAGE_SCHEME);
        INSTANCE.registerConstraint(PD_DEPRECATED_PASSWORD_STORAGE_SCHEME.getSourceConstraint());
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "expire-passwords-without-warning");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "expire-passwords-without-warning"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_EXPIRE_PASSWORDS_WITHOUT_WARNING = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_EXPIRE_PASSWORDS_WITHOUT_WARNING);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "force-change-on-add");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "force-change-on-add"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_FORCE_CHANGE_ON_ADD = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_FORCE_CHANGE_ON_ADD);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "force-change-on-reset");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "force-change-on-reset"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_FORCE_CHANGE_ON_RESET = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_FORCE_CHANGE_ON_RESET);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "grace-login-count");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "grace-login-count"));
        provider = new DefinedDefaultBehaviorProvider("0");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_GRACE_LOGIN_COUNT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_GRACE_LOGIN_COUNT);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "idle-lockout-interval");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "idle-lockout-interval"));
        provider = new DefinedDefaultBehaviorProvider("0 seconds");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setUpperLimit("2147483647");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_IDLE_LOCKOUT_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_IDLE_LOCKOUT_INTERVAL);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.core.PasswordPolicyFactory");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.AuthenticationPolicyFactory");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = AttributeTypePropertyDefinition.createBuilder(INSTANCE, "last-login-time-attribute");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "last-login-time-attribute"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_LAST_LOGIN_TIME_ATTRIBUTE = (AttributeTypePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LAST_LOGIN_TIME_ATTRIBUTE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "last-login-time-format");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "last-login-time-format"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "STRING");
        PD_LAST_LOGIN_TIME_FORMAT = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LAST_LOGIN_TIME_FORMAT);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "lockout-duration");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "lockout-duration"));
        provider = new DefinedDefaultBehaviorProvider("0 seconds");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)builder).setUpperLimit("2147483647");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_LOCKOUT_DURATION = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOCKOUT_DURATION);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "lockout-failure-count");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "lockout-failure-count"));
        provider = new DefinedDefaultBehaviorProvider("0");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_LOCKOUT_FAILURE_COUNT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOCKOUT_FAILURE_COUNT);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "lockout-failure-expiration-interval");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "lockout-failure-expiration-interval"));
        provider = new DefinedDefaultBehaviorProvider("0 seconds");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)builder).setUpperLimit("2147483647");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_LOCKOUT_FAILURE_EXPIRATION_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOCKOUT_FAILURE_EXPIRATION_INTERVAL);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "max-password-age");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-password-age"));
        provider = new DefinedDefaultBehaviorProvider("0 seconds");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)builder).setUpperLimit("2147483647");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_MAX_PASSWORD_AGE = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_PASSWORD_AGE);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "max-password-reset-age");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-password-reset-age"));
        provider = new DefinedDefaultBehaviorProvider("0 seconds");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)builder).setUpperLimit("2147483647");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_MAX_PASSWORD_RESET_AGE = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_PASSWORD_RESET_AGE);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "min-password-age");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "min-password-age"));
        provider = new DefinedDefaultBehaviorProvider("0 seconds");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)builder).setUpperLimit("2147483647");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_MIN_PASSWORD_AGE = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MIN_PASSWORD_AGE);
        builder = AttributeTypePropertyDefinition.createBuilder(INSTANCE, "password-attribute");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "password-attribute"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_PASSWORD_ATTRIBUTE = (AttributeTypePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PASSWORD_ATTRIBUTE);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "password-change-requires-current-password");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "password-change-requires-current-password"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_PASSWORD_CHANGE_REQUIRES_CURRENT_PASSWORD = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PASSWORD_CHANGE_REQUIRES_CURRENT_PASSWORD);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "password-expiration-warning-interval");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "password-expiration-warning-interval"));
        provider = new DefinedDefaultBehaviorProvider("5 days");
        builder.setDefaultBehaviorProvider(provider);
        PD_PASSWORD_EXPIRATION_WARNING_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PASSWORD_EXPIRATION_WARNING_INTERVAL);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "password-generator");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "password-generator"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("password-generator");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_PASSWORD_GENERATOR = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PASSWORD_GENERATOR);
        INSTANCE.registerConstraint(PD_PASSWORD_GENERATOR.getSourceConstraint());
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "password-history-count");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "password-history-count"));
        provider = new DefinedDefaultBehaviorProvider("0");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_PASSWORD_HISTORY_COUNT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PASSWORD_HISTORY_COUNT);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "password-history-duration");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "password-history-duration"));
        provider = new DefinedDefaultBehaviorProvider("0 seconds");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setAllowUnlimited(false);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)builder).setUpperLimit("2147483647");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_PASSWORD_HISTORY_DURATION = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PASSWORD_HISTORY_DURATION);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "password-validator");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "password-validator"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("password-validator");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_PASSWORD_VALIDATOR = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PASSWORD_VALIDATOR);
        INSTANCE.registerConstraint(PD_PASSWORD_VALIDATOR.getSourceConstraint());
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "previous-last-login-time-format");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "previous-last-login-time-format"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "STRING");
        PD_PREVIOUS_LAST_LOGIN_TIME_FORMAT = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PREVIOUS_LAST_LOGIN_TIME_FORMAT);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "require-change-by-time");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "require-change-by-time"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "STRING");
        PD_REQUIRE_CHANGE_BY_TIME = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REQUIRE_CHANGE_BY_TIME);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "require-secure-authentication");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "require-secure-authentication"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_REQUIRE_SECURE_AUTHENTICATION = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REQUIRE_SECURE_AUTHENTICATION);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "require-secure-password-changes");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "require-secure-password-changes"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_REQUIRE_SECURE_PASSWORD_CHANGES = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REQUIRE_SECURE_PASSWORD_CHANGES);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "skip-validation-for-administrators");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "skip-validation-for-administrators"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_SKIP_VALIDATION_FOR_ADMINISTRATORS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SKIP_VALIDATION_FOR_ADMINISTRATORS);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "state-update-failure-policy");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "state-update-failure-policy"));
        provider = new DefinedDefaultBehaviorProvider("reactive");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(StateUpdateFailurePolicy.class);
        PD_STATE_UPDATE_FAILURE_POLICY = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_STATE_UPDATE_FAILURE_POLICY);
        INSTANCE.registerTag(Tag.valueOf("user-management"));
    }

    private static class PasswordPolicyCfgServerImpl
    implements PasswordPolicyCfg {
        private ServerManagedObject<? extends PasswordPolicyCfg> impl;
        private final SortedSet<String> pAccountStatusNotificationHandler;
        private final boolean pAllowExpiredPasswordChanges;
        private final boolean pAllowMultiplePasswordValues;
        private final boolean pAllowPreEncodedPasswords;
        private final boolean pAllowUserPasswordChanges;
        private final SortedSet<String> pDefaultPasswordStorageScheme;
        private final SortedSet<String> pDeprecatedPasswordStorageScheme;
        private final boolean pExpirePasswordsWithoutWarning;
        private final boolean pForceChangeOnAdd;
        private final boolean pForceChangeOnReset;
        private final int pGraceLoginCount;
        private final long pIdleLockoutInterval;
        private final String pJavaClass;
        private final AttributeType pLastLoginTimeAttribute;
        private final String pLastLoginTimeFormat;
        private final long pLockoutDuration;
        private final int pLockoutFailureCount;
        private final long pLockoutFailureExpirationInterval;
        private final long pMaxPasswordAge;
        private final long pMaxPasswordResetAge;
        private final long pMinPasswordAge;
        private final AttributeType pPasswordAttribute;
        private final boolean pPasswordChangeRequiresCurrentPassword;
        private final long pPasswordExpirationWarningInterval;
        private final String pPasswordGenerator;
        private final int pPasswordHistoryCount;
        private final long pPasswordHistoryDuration;
        private final SortedSet<String> pPasswordValidator;
        private final SortedSet<String> pPreviousLastLoginTimeFormat;
        private final String pRequireChangeByTime;
        private final boolean pRequireSecureAuthentication;
        private final boolean pRequireSecurePasswordChanges;
        private final boolean pSkipValidationForAdministrators;
        private final StateUpdateFailurePolicy pStateUpdateFailurePolicy;

        private PasswordPolicyCfgServerImpl(ServerManagedObject<? extends PasswordPolicyCfg> impl) {
            this.impl = impl;
            this.pAccountStatusNotificationHandler = impl.getPropertyValues(INSTANCE.getAccountStatusNotificationHandlerPropertyDefinition());
            this.pAllowExpiredPasswordChanges = impl.getPropertyValue(INSTANCE.getAllowExpiredPasswordChangesPropertyDefinition());
            this.pAllowMultiplePasswordValues = impl.getPropertyValue(INSTANCE.getAllowMultiplePasswordValuesPropertyDefinition());
            this.pAllowPreEncodedPasswords = impl.getPropertyValue(INSTANCE.getAllowPreEncodedPasswordsPropertyDefinition());
            this.pAllowUserPasswordChanges = impl.getPropertyValue(INSTANCE.getAllowUserPasswordChangesPropertyDefinition());
            this.pDefaultPasswordStorageScheme = impl.getPropertyValues(INSTANCE.getDefaultPasswordStorageSchemePropertyDefinition());
            this.pDeprecatedPasswordStorageScheme = impl.getPropertyValues(INSTANCE.getDeprecatedPasswordStorageSchemePropertyDefinition());
            this.pExpirePasswordsWithoutWarning = impl.getPropertyValue(INSTANCE.getExpirePasswordsWithoutWarningPropertyDefinition());
            this.pForceChangeOnAdd = impl.getPropertyValue(INSTANCE.getForceChangeOnAddPropertyDefinition());
            this.pForceChangeOnReset = impl.getPropertyValue(INSTANCE.getForceChangeOnResetPropertyDefinition());
            this.pGraceLoginCount = impl.getPropertyValue(INSTANCE.getGraceLoginCountPropertyDefinition());
            this.pIdleLockoutInterval = impl.getPropertyValue(INSTANCE.getIdleLockoutIntervalPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pLastLoginTimeAttribute = impl.getPropertyValue(INSTANCE.getLastLoginTimeAttributePropertyDefinition());
            this.pLastLoginTimeFormat = impl.getPropertyValue(INSTANCE.getLastLoginTimeFormatPropertyDefinition());
            this.pLockoutDuration = impl.getPropertyValue(INSTANCE.getLockoutDurationPropertyDefinition());
            this.pLockoutFailureCount = impl.getPropertyValue(INSTANCE.getLockoutFailureCountPropertyDefinition());
            this.pLockoutFailureExpirationInterval = impl.getPropertyValue(INSTANCE.getLockoutFailureExpirationIntervalPropertyDefinition());
            this.pMaxPasswordAge = impl.getPropertyValue(INSTANCE.getMaxPasswordAgePropertyDefinition());
            this.pMaxPasswordResetAge = impl.getPropertyValue(INSTANCE.getMaxPasswordResetAgePropertyDefinition());
            this.pMinPasswordAge = impl.getPropertyValue(INSTANCE.getMinPasswordAgePropertyDefinition());
            this.pPasswordAttribute = impl.getPropertyValue(INSTANCE.getPasswordAttributePropertyDefinition());
            this.pPasswordChangeRequiresCurrentPassword = impl.getPropertyValue(INSTANCE.getPasswordChangeRequiresCurrentPasswordPropertyDefinition());
            this.pPasswordExpirationWarningInterval = impl.getPropertyValue(INSTANCE.getPasswordExpirationWarningIntervalPropertyDefinition());
            this.pPasswordGenerator = impl.getPropertyValue(INSTANCE.getPasswordGeneratorPropertyDefinition());
            this.pPasswordHistoryCount = impl.getPropertyValue(INSTANCE.getPasswordHistoryCountPropertyDefinition());
            this.pPasswordHistoryDuration = impl.getPropertyValue(INSTANCE.getPasswordHistoryDurationPropertyDefinition());
            this.pPasswordValidator = impl.getPropertyValues(INSTANCE.getPasswordValidatorPropertyDefinition());
            this.pPreviousLastLoginTimeFormat = impl.getPropertyValues((PropertyDefinition)INSTANCE.getPreviousLastLoginTimeFormatPropertyDefinition());
            this.pRequireChangeByTime = impl.getPropertyValue(INSTANCE.getRequireChangeByTimePropertyDefinition());
            this.pRequireSecureAuthentication = impl.getPropertyValue(INSTANCE.getRequireSecureAuthenticationPropertyDefinition());
            this.pRequireSecurePasswordChanges = impl.getPropertyValue(INSTANCE.getRequireSecurePasswordChangesPropertyDefinition());
            this.pSkipValidationForAdministrators = impl.getPropertyValue(INSTANCE.getSkipValidationForAdministratorsPropertyDefinition());
            this.pStateUpdateFailurePolicy = impl.getPropertyValue(INSTANCE.getStateUpdateFailurePolicyPropertyDefinition());
        }

        @Override
        public void addPasswordPolicyChangeListener(ConfigurationChangeListener<PasswordPolicyCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removePasswordPolicyChangeListener(ConfigurationChangeListener<PasswordPolicyCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<AuthenticationPolicyCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<AuthenticationPolicyCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<String> getAccountStatusNotificationHandler() {
            return this.pAccountStatusNotificationHandler;
        }

        @Override
        public SortedSet<DN> getAccountStatusNotificationHandlerDNs() {
            SortedSet<String> values = this.getAccountStatusNotificationHandler();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getAccountStatusNotificationHandlerPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public boolean isAllowExpiredPasswordChanges() {
            return this.pAllowExpiredPasswordChanges;
        }

        @Override
        public boolean isAllowMultiplePasswordValues() {
            return this.pAllowMultiplePasswordValues;
        }

        @Override
        public boolean isAllowPreEncodedPasswords() {
            return this.pAllowPreEncodedPasswords;
        }

        @Override
        public boolean isAllowUserPasswordChanges() {
            return this.pAllowUserPasswordChanges;
        }

        @Override
        public SortedSet<String> getDefaultPasswordStorageScheme() {
            return this.pDefaultPasswordStorageScheme;
        }

        @Override
        public SortedSet<DN> getDefaultPasswordStorageSchemeDNs() {
            SortedSet<String> values = this.getDefaultPasswordStorageScheme();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getDefaultPasswordStorageSchemePropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public SortedSet<String> getDeprecatedPasswordStorageScheme() {
            return this.pDeprecatedPasswordStorageScheme;
        }

        @Override
        public SortedSet<DN> getDeprecatedPasswordStorageSchemeDNs() {
            SortedSet<String> values = this.getDeprecatedPasswordStorageScheme();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getDeprecatedPasswordStorageSchemePropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public boolean isExpirePasswordsWithoutWarning() {
            return this.pExpirePasswordsWithoutWarning;
        }

        @Override
        public boolean isForceChangeOnAdd() {
            return this.pForceChangeOnAdd;
        }

        @Override
        public boolean isForceChangeOnReset() {
            return this.pForceChangeOnReset;
        }

        @Override
        public int getGraceLoginCount() {
            return this.pGraceLoginCount;
        }

        @Override
        public long getIdleLockoutInterval() {
            return this.pIdleLockoutInterval;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public AttributeType getLastLoginTimeAttribute() {
            return this.pLastLoginTimeAttribute;
        }

        @Override
        public String getLastLoginTimeFormat() {
            return this.pLastLoginTimeFormat;
        }

        @Override
        public long getLockoutDuration() {
            return this.pLockoutDuration;
        }

        @Override
        public int getLockoutFailureCount() {
            return this.pLockoutFailureCount;
        }

        @Override
        public long getLockoutFailureExpirationInterval() {
            return this.pLockoutFailureExpirationInterval;
        }

        @Override
        public long getMaxPasswordAge() {
            return this.pMaxPasswordAge;
        }

        @Override
        public long getMaxPasswordResetAge() {
            return this.pMaxPasswordResetAge;
        }

        @Override
        public long getMinPasswordAge() {
            return this.pMinPasswordAge;
        }

        @Override
        public AttributeType getPasswordAttribute() {
            return this.pPasswordAttribute;
        }

        @Override
        public boolean isPasswordChangeRequiresCurrentPassword() {
            return this.pPasswordChangeRequiresCurrentPassword;
        }

        @Override
        public long getPasswordExpirationWarningInterval() {
            return this.pPasswordExpirationWarningInterval;
        }

        @Override
        public String getPasswordGenerator() {
            return this.pPasswordGenerator;
        }

        @Override
        public DN getPasswordGeneratorDN() {
            String value = this.getPasswordGenerator();
            if (value == null) {
                return null;
            }
            return INSTANCE.getPasswordGeneratorPropertyDefinition().getChildDN(value);
        }

        @Override
        public int getPasswordHistoryCount() {
            return this.pPasswordHistoryCount;
        }

        @Override
        public long getPasswordHistoryDuration() {
            return this.pPasswordHistoryDuration;
        }

        @Override
        public SortedSet<String> getPasswordValidator() {
            return this.pPasswordValidator;
        }

        @Override
        public SortedSet<DN> getPasswordValidatorDNs() {
            SortedSet<String> values = this.getPasswordValidator();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getPasswordValidatorPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public SortedSet<String> getPreviousLastLoginTimeFormat() {
            return this.pPreviousLastLoginTimeFormat;
        }

        @Override
        public String getRequireChangeByTime() {
            return this.pRequireChangeByTime;
        }

        @Override
        public boolean isRequireSecureAuthentication() {
            return this.pRequireSecureAuthentication;
        }

        @Override
        public boolean isRequireSecurePasswordChanges() {
            return this.pRequireSecurePasswordChanges;
        }

        @Override
        public boolean isSkipValidationForAdministrators() {
            return this.pSkipValidationForAdministrators;
        }

        @Override
        public StateUpdateFailurePolicy getStateUpdateFailurePolicy() {
            return this.pStateUpdateFailurePolicy;
        }

        @Override
        public Class<? extends PasswordPolicyCfg> configurationClass() {
            return PasswordPolicyCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class PasswordPolicyCfgClientImpl
    implements PasswordPolicyCfgClient {
        private ManagedObject<? extends PasswordPolicyCfgClient> impl;

        private PasswordPolicyCfgClientImpl(ManagedObject<? extends PasswordPolicyCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<String> getAccountStatusNotificationHandler() {
            return this.impl.getPropertyValues(INSTANCE.getAccountStatusNotificationHandlerPropertyDefinition());
        }

        @Override
        public void setAccountStatusNotificationHandler(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getAccountStatusNotificationHandlerPropertyDefinition(), values);
        }

        @Override
        public boolean isAllowExpiredPasswordChanges() {
            return this.impl.getPropertyValue(INSTANCE.getAllowExpiredPasswordChangesPropertyDefinition());
        }

        @Override
        public void setAllowExpiredPasswordChanges(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAllowExpiredPasswordChangesPropertyDefinition(), value);
        }

        @Override
        public boolean isAllowMultiplePasswordValues() {
            return this.impl.getPropertyValue(INSTANCE.getAllowMultiplePasswordValuesPropertyDefinition());
        }

        @Override
        public void setAllowMultiplePasswordValues(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAllowMultiplePasswordValuesPropertyDefinition(), value);
        }

        @Override
        public boolean isAllowPreEncodedPasswords() {
            return this.impl.getPropertyValue(INSTANCE.getAllowPreEncodedPasswordsPropertyDefinition());
        }

        @Override
        public void setAllowPreEncodedPasswords(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAllowPreEncodedPasswordsPropertyDefinition(), value);
        }

        @Override
        public boolean isAllowUserPasswordChanges() {
            return this.impl.getPropertyValue(INSTANCE.getAllowUserPasswordChangesPropertyDefinition());
        }

        @Override
        public void setAllowUserPasswordChanges(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAllowUserPasswordChangesPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getDefaultPasswordStorageScheme() {
            return this.impl.getPropertyValues(INSTANCE.getDefaultPasswordStorageSchemePropertyDefinition());
        }

        @Override
        public void setDefaultPasswordStorageScheme(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getDefaultPasswordStorageSchemePropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getDeprecatedPasswordStorageScheme() {
            return this.impl.getPropertyValues(INSTANCE.getDeprecatedPasswordStorageSchemePropertyDefinition());
        }

        @Override
        public void setDeprecatedPasswordStorageScheme(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getDeprecatedPasswordStorageSchemePropertyDefinition(), values);
        }

        @Override
        public boolean isExpirePasswordsWithoutWarning() {
            return this.impl.getPropertyValue(INSTANCE.getExpirePasswordsWithoutWarningPropertyDefinition());
        }

        @Override
        public void setExpirePasswordsWithoutWarning(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getExpirePasswordsWithoutWarningPropertyDefinition(), value);
        }

        @Override
        public boolean isForceChangeOnAdd() {
            return this.impl.getPropertyValue(INSTANCE.getForceChangeOnAddPropertyDefinition());
        }

        @Override
        public void setForceChangeOnAdd(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getForceChangeOnAddPropertyDefinition(), value);
        }

        @Override
        public boolean isForceChangeOnReset() {
            return this.impl.getPropertyValue(INSTANCE.getForceChangeOnResetPropertyDefinition());
        }

        @Override
        public void setForceChangeOnReset(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getForceChangeOnResetPropertyDefinition(), value);
        }

        @Override
        public int getGraceLoginCount() {
            return this.impl.getPropertyValue(INSTANCE.getGraceLoginCountPropertyDefinition());
        }

        @Override
        public void setGraceLoginCount(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getGraceLoginCountPropertyDefinition(), value);
        }

        @Override
        public long getIdleLockoutInterval() {
            return this.impl.getPropertyValue(INSTANCE.getIdleLockoutIntervalPropertyDefinition());
        }

        @Override
        public void setIdleLockoutInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getIdleLockoutIntervalPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public AttributeType getLastLoginTimeAttribute() {
            return this.impl.getPropertyValue(INSTANCE.getLastLoginTimeAttributePropertyDefinition());
        }

        @Override
        public void setLastLoginTimeAttribute(AttributeType value) {
            this.impl.setPropertyValue(INSTANCE.getLastLoginTimeAttributePropertyDefinition(), value);
        }

        @Override
        public String getLastLoginTimeFormat() {
            return this.impl.getPropertyValue(INSTANCE.getLastLoginTimeFormatPropertyDefinition());
        }

        @Override
        public void setLastLoginTimeFormat(String value) {
            this.impl.setPropertyValue(INSTANCE.getLastLoginTimeFormatPropertyDefinition(), value);
        }

        @Override
        public long getLockoutDuration() {
            return this.impl.getPropertyValue(INSTANCE.getLockoutDurationPropertyDefinition());
        }

        @Override
        public void setLockoutDuration(Long value) {
            this.impl.setPropertyValue(INSTANCE.getLockoutDurationPropertyDefinition(), value);
        }

        @Override
        public int getLockoutFailureCount() {
            return this.impl.getPropertyValue(INSTANCE.getLockoutFailureCountPropertyDefinition());
        }

        @Override
        public void setLockoutFailureCount(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getLockoutFailureCountPropertyDefinition(), value);
        }

        @Override
        public long getLockoutFailureExpirationInterval() {
            return this.impl.getPropertyValue(INSTANCE.getLockoutFailureExpirationIntervalPropertyDefinition());
        }

        @Override
        public void setLockoutFailureExpirationInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getLockoutFailureExpirationIntervalPropertyDefinition(), value);
        }

        @Override
        public long getMaxPasswordAge() {
            return this.impl.getPropertyValue(INSTANCE.getMaxPasswordAgePropertyDefinition());
        }

        @Override
        public void setMaxPasswordAge(Long value) {
            this.impl.setPropertyValue(INSTANCE.getMaxPasswordAgePropertyDefinition(), value);
        }

        @Override
        public long getMaxPasswordResetAge() {
            return this.impl.getPropertyValue(INSTANCE.getMaxPasswordResetAgePropertyDefinition());
        }

        @Override
        public void setMaxPasswordResetAge(Long value) {
            this.impl.setPropertyValue(INSTANCE.getMaxPasswordResetAgePropertyDefinition(), value);
        }

        @Override
        public long getMinPasswordAge() {
            return this.impl.getPropertyValue(INSTANCE.getMinPasswordAgePropertyDefinition());
        }

        @Override
        public void setMinPasswordAge(Long value) {
            this.impl.setPropertyValue(INSTANCE.getMinPasswordAgePropertyDefinition(), value);
        }

        @Override
        public AttributeType getPasswordAttribute() {
            return this.impl.getPropertyValue(INSTANCE.getPasswordAttributePropertyDefinition());
        }

        @Override
        public void setPasswordAttribute(AttributeType value) {
            this.impl.setPropertyValue(INSTANCE.getPasswordAttributePropertyDefinition(), value);
        }

        @Override
        public boolean isPasswordChangeRequiresCurrentPassword() {
            return this.impl.getPropertyValue(INSTANCE.getPasswordChangeRequiresCurrentPasswordPropertyDefinition());
        }

        @Override
        public void setPasswordChangeRequiresCurrentPassword(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getPasswordChangeRequiresCurrentPasswordPropertyDefinition(), value);
        }

        @Override
        public long getPasswordExpirationWarningInterval() {
            return this.impl.getPropertyValue(INSTANCE.getPasswordExpirationWarningIntervalPropertyDefinition());
        }

        @Override
        public void setPasswordExpirationWarningInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getPasswordExpirationWarningIntervalPropertyDefinition(), value);
        }

        @Override
        public String getPasswordGenerator() {
            return this.impl.getPropertyValue(INSTANCE.getPasswordGeneratorPropertyDefinition());
        }

        @Override
        public void setPasswordGenerator(String value) {
            this.impl.setPropertyValue(INSTANCE.getPasswordGeneratorPropertyDefinition(), value);
        }

        @Override
        public int getPasswordHistoryCount() {
            return this.impl.getPropertyValue(INSTANCE.getPasswordHistoryCountPropertyDefinition());
        }

        @Override
        public void setPasswordHistoryCount(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getPasswordHistoryCountPropertyDefinition(), value);
        }

        @Override
        public long getPasswordHistoryDuration() {
            return this.impl.getPropertyValue(INSTANCE.getPasswordHistoryDurationPropertyDefinition());
        }

        @Override
        public void setPasswordHistoryDuration(Long value) {
            this.impl.setPropertyValue(INSTANCE.getPasswordHistoryDurationPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getPasswordValidator() {
            return this.impl.getPropertyValues(INSTANCE.getPasswordValidatorPropertyDefinition());
        }

        @Override
        public void setPasswordValidator(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getPasswordValidatorPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getPreviousLastLoginTimeFormat() {
            return this.impl.getPropertyValues(INSTANCE.getPreviousLastLoginTimeFormatPropertyDefinition());
        }

        @Override
        public void setPreviousLastLoginTimeFormat(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getPreviousLastLoginTimeFormatPropertyDefinition(), values);
        }

        @Override
        public String getRequireChangeByTime() {
            return this.impl.getPropertyValue(INSTANCE.getRequireChangeByTimePropertyDefinition());
        }

        @Override
        public void setRequireChangeByTime(String value) {
            this.impl.setPropertyValue(INSTANCE.getRequireChangeByTimePropertyDefinition(), value);
        }

        @Override
        public boolean isRequireSecureAuthentication() {
            return this.impl.getPropertyValue(INSTANCE.getRequireSecureAuthenticationPropertyDefinition());
        }

        @Override
        public void setRequireSecureAuthentication(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getRequireSecureAuthenticationPropertyDefinition(), value);
        }

        @Override
        public boolean isRequireSecurePasswordChanges() {
            return this.impl.getPropertyValue(INSTANCE.getRequireSecurePasswordChangesPropertyDefinition());
        }

        @Override
        public void setRequireSecurePasswordChanges(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getRequireSecurePasswordChangesPropertyDefinition(), value);
        }

        @Override
        public boolean isSkipValidationForAdministrators() {
            return this.impl.getPropertyValue(INSTANCE.getSkipValidationForAdministratorsPropertyDefinition());
        }

        @Override
        public void setSkipValidationForAdministrators(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getSkipValidationForAdministratorsPropertyDefinition(), value);
        }

        @Override
        public StateUpdateFailurePolicy getStateUpdateFailurePolicy() {
            return this.impl.getPropertyValue(INSTANCE.getStateUpdateFailurePolicyPropertyDefinition());
        }

        @Override
        public void setStateUpdateFailurePolicy(StateUpdateFailurePolicy value) {
            this.impl.setPropertyValue(INSTANCE.getStateUpdateFailurePolicyPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends PasswordPolicyCfgClient, ? extends PasswordPolicyCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }
    }

    public static enum StateUpdateFailurePolicy {
        IGNORE("ignore"),
        PROACTIVE("proactive"),
        REACTIVE("reactive");

        private final String name;

        private StateUpdateFailurePolicy(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

