/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.PKCS11KeyManagerProviderCfgClient;
import org.forgerock.opendj.server.config.meta.KeyManagerProviderCfgDefn;
import org.forgerock.opendj.server.config.server.KeyManagerProviderCfg;
import org.forgerock.opendj.server.config.server.PKCS11KeyManagerProviderCfg;

public final class PKCS11KeyManagerProviderCfgDefn
extends ManagedObjectDefinition<PKCS11KeyManagerProviderCfgClient, PKCS11KeyManagerProviderCfg> {
    private static final PKCS11KeyManagerProviderCfgDefn INSTANCE = new PKCS11KeyManagerProviderCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_KEY_STORE_PIN;
    private static final StringPropertyDefinition PD_KEY_STORE_PIN_ENVIRONMENT_VARIABLE;
    private static final StringPropertyDefinition PD_KEY_STORE_PIN_FILE;
    private static final StringPropertyDefinition PD_KEY_STORE_PIN_PROPERTY;

    public static PKCS11KeyManagerProviderCfgDefn getInstance() {
        return INSTANCE;
    }

    private PKCS11KeyManagerProviderCfgDefn() {
        super("pkcs11-key-manager-provider", KeyManagerProviderCfgDefn.getInstance());
    }

    @Override
    public PKCS11KeyManagerProviderCfgClient createClientConfiguration(ManagedObject<? extends PKCS11KeyManagerProviderCfgClient> impl) {
        return new PKCS11KeyManagerProviderCfgClientImpl(impl);
    }

    @Override
    public PKCS11KeyManagerProviderCfg createServerConfiguration(ServerManagedObject<? extends PKCS11KeyManagerProviderCfg> impl) {
        return new PKCS11KeyManagerProviderCfgServerImpl(impl);
    }

    @Override
    public Class<PKCS11KeyManagerProviderCfg> getServerConfigurationClass() {
        return PKCS11KeyManagerProviderCfg.class;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return KeyManagerProviderCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getKeyStorePinPropertyDefinition() {
        return PD_KEY_STORE_PIN;
    }

    public StringPropertyDefinition getKeyStorePinEnvironmentVariablePropertyDefinition() {
        return PD_KEY_STORE_PIN_ENVIRONMENT_VARIABLE;
    }

    public StringPropertyDefinition getKeyStorePinFilePropertyDefinition() {
        return PD_KEY_STORE_PIN_FILE;
    }

    public StringPropertyDefinition getKeyStorePinPropertyPropertyDefinition() {
        return PD_KEY_STORE_PIN_PROPERTY;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.PKCS11KeyManagerProvider");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.KeyManagerProvider");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-pin");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-pin"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_KEY_STORE_PIN = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_PIN);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-pin-environment-variable");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-pin-environment-variable"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "STRING");
        PD_KEY_STORE_PIN_ENVIRONMENT_VARIABLE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_PIN_ENVIRONMENT_VARIABLE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-pin-file");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-pin-file"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "FILE");
        PD_KEY_STORE_PIN_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_PIN_FILE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-pin-property");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-pin-property"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "STRING");
        PD_KEY_STORE_PIN_PROPERTY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_PIN_PROPERTY);
        INSTANCE.registerTag(Tag.valueOf("security"));
    }

    private static class PKCS11KeyManagerProviderCfgServerImpl
    implements PKCS11KeyManagerProviderCfg {
        private ServerManagedObject<? extends PKCS11KeyManagerProviderCfg> impl;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final String pKeyStorePin;
        private final String pKeyStorePinEnvironmentVariable;
        private final String pKeyStorePinFile;
        private final String pKeyStorePinProperty;

        private PKCS11KeyManagerProviderCfgServerImpl(ServerManagedObject<? extends PKCS11KeyManagerProviderCfg> impl) {
            this.impl = impl;
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pKeyStorePin = impl.getPropertyValue(INSTANCE.getKeyStorePinPropertyDefinition());
            this.pKeyStorePinEnvironmentVariable = impl.getPropertyValue(INSTANCE.getKeyStorePinEnvironmentVariablePropertyDefinition());
            this.pKeyStorePinFile = impl.getPropertyValue(INSTANCE.getKeyStorePinFilePropertyDefinition());
            this.pKeyStorePinProperty = impl.getPropertyValue(INSTANCE.getKeyStorePinPropertyPropertyDefinition());
        }

        @Override
        public void addPKCS11ChangeListener(ConfigurationChangeListener<PKCS11KeyManagerProviderCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removePKCS11ChangeListener(ConfigurationChangeListener<PKCS11KeyManagerProviderCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<KeyManagerProviderCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<KeyManagerProviderCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getKeyStorePin() {
            return this.pKeyStorePin;
        }

        @Override
        public String getKeyStorePinEnvironmentVariable() {
            return this.pKeyStorePinEnvironmentVariable;
        }

        @Override
        public String getKeyStorePinFile() {
            return this.pKeyStorePinFile;
        }

        @Override
        public String getKeyStorePinProperty() {
            return this.pKeyStorePinProperty;
        }

        @Override
        public Class<? extends PKCS11KeyManagerProviderCfg> configurationClass() {
            return PKCS11KeyManagerProviderCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class PKCS11KeyManagerProviderCfgClientImpl
    implements PKCS11KeyManagerProviderCfgClient {
        private ManagedObject<? extends PKCS11KeyManagerProviderCfgClient> impl;

        private PKCS11KeyManagerProviderCfgClientImpl(ManagedObject<? extends PKCS11KeyManagerProviderCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getKeyStorePin() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinPropertyDefinition());
        }

        @Override
        public void setKeyStorePin(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStorePinPropertyDefinition(), value);
        }

        @Override
        public String getKeyStorePinEnvironmentVariable() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinEnvironmentVariablePropertyDefinition());
        }

        @Override
        public void setKeyStorePinEnvironmentVariable(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStorePinEnvironmentVariablePropertyDefinition(), value);
        }

        @Override
        public String getKeyStorePinFile() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinFilePropertyDefinition());
        }

        @Override
        public void setKeyStorePinFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStorePinFilePropertyDefinition(), value);
        }

        @Override
        public String getKeyStorePinProperty() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinPropertyPropertyDefinition());
        }

        @Override
        public void setKeyStorePinProperty(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStorePinPropertyPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends PKCS11KeyManagerProviderCfgClient, ? extends PKCS11KeyManagerProviderCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }
    }
}

