/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.IPAddressMaskPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.AddressMask;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.LDIFConnectionHandlerCfgClient;
import org.forgerock.opendj.server.config.meta.ConnectionHandlerCfgDefn;
import org.forgerock.opendj.server.config.server.ConnectionHandlerCfg;
import org.forgerock.opendj.server.config.server.LDIFConnectionHandlerCfg;

public final class LDIFConnectionHandlerCfgDefn
extends ManagedObjectDefinition<LDIFConnectionHandlerCfgClient, LDIFConnectionHandlerCfg> {
    private static final LDIFConnectionHandlerCfgDefn INSTANCE = new LDIFConnectionHandlerCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_LDIF_DIRECTORY;
    private static final DurationPropertyDefinition PD_POLL_INTERVAL;

    public static LDIFConnectionHandlerCfgDefn getInstance() {
        return INSTANCE;
    }

    private LDIFConnectionHandlerCfgDefn() {
        super("ldif-connection-handler", ConnectionHandlerCfgDefn.getInstance());
    }

    @Override
    public LDIFConnectionHandlerCfgClient createClientConfiguration(ManagedObject<? extends LDIFConnectionHandlerCfgClient> impl) {
        return new LDIFConnectionHandlerCfgClientImpl(impl);
    }

    @Override
    public LDIFConnectionHandlerCfg createServerConfiguration(ServerManagedObject<? extends LDIFConnectionHandlerCfg> impl) {
        return new LDIFConnectionHandlerCfgServerImpl(impl);
    }

    @Override
    public Class<LDIFConnectionHandlerCfg> getServerConfigurationClass() {
        return LDIFConnectionHandlerCfg.class;
    }

    public IPAddressMaskPropertyDefinition getAllowedClientPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getAllowedClientPropertyDefinition();
    }

    public IPAddressMaskPropertyDefinition getDeniedClientPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getDeniedClientPropertyDefinition();
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return ConnectionHandlerCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getLDIFDirectoryPropertyDefinition() {
        return PD_LDIF_DIRECTORY;
    }

    public DurationPropertyDefinition getPollIntervalPropertyDefinition() {
        return PD_POLL_INTERVAL;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.protocols.LDIFConnectionHandler");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.ConnectionHandler");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ldif-directory");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "ldif-directory"));
        provider = new DefinedDefaultBehaviorProvider("config/auto-process-ldif");
        builder.setDefaultBehaviorProvider(provider);
        PD_LDIF_DIRECTORY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LDIF_DIRECTORY);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "poll-interval");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "poll-interval"));
        provider = new DefinedDefaultBehaviorProvider("5 seconds");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_POLL_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_POLL_INTERVAL);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class LDIFConnectionHandlerCfgServerImpl
    implements LDIFConnectionHandlerCfg {
        private ServerManagedObject<? extends LDIFConnectionHandlerCfg> impl;
        private final SortedSet<AddressMask> pAllowedClient;
        private final SortedSet<AddressMask> pDeniedClient;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final String pLDIFDirectory;
        private final long pPollInterval;

        private LDIFConnectionHandlerCfgServerImpl(ServerManagedObject<? extends LDIFConnectionHandlerCfg> impl) {
            this.impl = impl;
            this.pAllowedClient = impl.getPropertyValues((PropertyDefinition)INSTANCE.getAllowedClientPropertyDefinition());
            this.pDeniedClient = impl.getPropertyValues((PropertyDefinition)INSTANCE.getDeniedClientPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pLDIFDirectory = impl.getPropertyValue(INSTANCE.getLDIFDirectoryPropertyDefinition());
            this.pPollInterval = impl.getPropertyValue(INSTANCE.getPollIntervalPropertyDefinition());
        }

        @Override
        public void addLDIFChangeListener(ConfigurationChangeListener<LDIFConnectionHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeLDIFChangeListener(ConfigurationChangeListener<LDIFConnectionHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<ConnectionHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<ConnectionHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<AddressMask> getAllowedClient() {
            return this.pAllowedClient;
        }

        @Override
        public SortedSet<AddressMask> getDeniedClient() {
            return this.pDeniedClient;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getLDIFDirectory() {
            return this.pLDIFDirectory;
        }

        @Override
        public long getPollInterval() {
            return this.pPollInterval;
        }

        @Override
        public Class<? extends LDIFConnectionHandlerCfg> configurationClass() {
            return LDIFConnectionHandlerCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class LDIFConnectionHandlerCfgClientImpl
    implements LDIFConnectionHandlerCfgClient {
        private ManagedObject<? extends LDIFConnectionHandlerCfgClient> impl;

        private LDIFConnectionHandlerCfgClientImpl(ManagedObject<? extends LDIFConnectionHandlerCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<AddressMask> getAllowedClient() {
            return this.impl.getPropertyValues(INSTANCE.getAllowedClientPropertyDefinition());
        }

        @Override
        public void setAllowedClient(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getAllowedClientPropertyDefinition(), values);
        }

        @Override
        public SortedSet<AddressMask> getDeniedClient() {
            return this.impl.getPropertyValues(INSTANCE.getDeniedClientPropertyDefinition());
        }

        @Override
        public void setDeniedClient(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getDeniedClientPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getLDIFDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getLDIFDirectoryPropertyDefinition());
        }

        @Override
        public void setLDIFDirectory(String value) {
            this.impl.setPropertyValue(INSTANCE.getLDIFDirectoryPropertyDefinition(), value);
        }

        @Override
        public long getPollInterval() {
            return this.impl.getPropertyValue(INSTANCE.getPollIntervalPropertyDefinition());
        }

        @Override
        public void setPollInterval(long value) {
            this.impl.setPropertyValue(INSTANCE.getPollIntervalPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends LDIFConnectionHandlerCfgClient, ? extends LDIFConnectionHandlerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }
    }
}

