/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.LDIFBackendCfgClient;
import org.forgerock.opendj.server.config.meta.BackendCfgDefn;
import org.forgerock.opendj.server.config.server.BackendCfg;
import org.forgerock.opendj.server.config.server.LDIFBackendCfg;

public final class LDIFBackendCfgDefn
extends ManagedObjectDefinition<LDIFBackendCfgClient, LDIFBackendCfg> {
    private static final LDIFBackendCfgDefn INSTANCE = new LDIFBackendCfgDefn();
    private static final BooleanPropertyDefinition PD_IS_PRIVATE_BACKEND;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_LDIF_FILE;
    private static final EnumPropertyDefinition<BackendCfgDefn.WritabilityMode> PD_WRITABILITY_MODE;

    public static LDIFBackendCfgDefn getInstance() {
        return INSTANCE;
    }

    private LDIFBackendCfgDefn() {
        super("ldif-backend", BackendCfgDefn.getInstance());
    }

    @Override
    public LDIFBackendCfgClient createClientConfiguration(ManagedObject<? extends LDIFBackendCfgClient> impl) {
        return new LDIFBackendCfgClientImpl(impl);
    }

    @Override
    public LDIFBackendCfg createServerConfiguration(ServerManagedObject<? extends LDIFBackendCfg> impl) {
        return new LDIFBackendCfgServerImpl(impl);
    }

    @Override
    public Class<LDIFBackendCfg> getServerConfigurationClass() {
        return LDIFBackendCfg.class;
    }

    public StringPropertyDefinition getBackendIdPropertyDefinition() {
        return BackendCfgDefn.getInstance().getBackendIdPropertyDefinition();
    }

    public DNPropertyDefinition getBaseDNPropertyDefinition() {
        return BackendCfgDefn.getInstance().getBaseDNPropertyDefinition();
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return BackendCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public BooleanPropertyDefinition getIsPrivateBackendPropertyDefinition() {
        return PD_IS_PRIVATE_BACKEND;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getLDIFFilePropertyDefinition() {
        return PD_LDIF_FILE;
    }

    public EnumPropertyDefinition<BackendCfgDefn.WritabilityMode> getWritabilityModePropertyDefinition() {
        return PD_WRITABILITY_MODE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "is-private-backend");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "is-private-backend"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_IS_PRIVATE_BACKEND = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_IS_PRIVATE_BACKEND);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.backends.LDIFBackend");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.Backend");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ldif-file");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "ldif-file"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_LDIF_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LDIF_FILE);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "writability-mode");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "writability-mode"));
        provider = new DefinedDefaultBehaviorProvider("enabled");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(BackendCfgDefn.WritabilityMode.class);
        PD_WRITABILITY_MODE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_WRITABILITY_MODE);
        INSTANCE.registerTag(Tag.valueOf("database"));
    }

    private static class LDIFBackendCfgServerImpl
    implements LDIFBackendCfg {
        private ServerManagedObject<? extends LDIFBackendCfg> impl;
        private final String pBackendId;
        private final SortedSet<DN> pBaseDN;
        private final boolean pEnabled;
        private final boolean pIsPrivateBackend;
        private final String pJavaClass;
        private final String pLDIFFile;
        private final BackendCfgDefn.WritabilityMode pWritabilityMode;

        private LDIFBackendCfgServerImpl(ServerManagedObject<? extends LDIFBackendCfg> impl) {
            this.impl = impl;
            this.pBackendId = impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
            this.pBaseDN = impl.getPropertyValues((PropertyDefinition)INSTANCE.getBaseDNPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pIsPrivateBackend = impl.getPropertyValue(INSTANCE.getIsPrivateBackendPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pLDIFFile = impl.getPropertyValue(INSTANCE.getLDIFFilePropertyDefinition());
            this.pWritabilityMode = impl.getPropertyValue(INSTANCE.getWritabilityModePropertyDefinition());
        }

        @Override
        public void addLDIFChangeListener(ConfigurationChangeListener<LDIFBackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeLDIFChangeListener(ConfigurationChangeListener<LDIFBackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getBackendId() {
            return this.pBackendId;
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.pBaseDN;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public boolean isIsPrivateBackend() {
            return this.pIsPrivateBackend;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getLDIFFile() {
            return this.pLDIFFile;
        }

        @Override
        public BackendCfgDefn.WritabilityMode getWritabilityMode() {
            return this.pWritabilityMode;
        }

        @Override
        public Class<? extends LDIFBackendCfg> configurationClass() {
            return LDIFBackendCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class LDIFBackendCfgClientImpl
    implements LDIFBackendCfgClient {
        private ManagedObject<? extends LDIFBackendCfgClient> impl;

        private LDIFBackendCfgClientImpl(ManagedObject<? extends LDIFBackendCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getBackendId() {
            return this.impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
        }

        @Override
        public void setBackendId(String value) throws PropertyException {
            this.impl.setPropertyValue(INSTANCE.getBackendIdPropertyDefinition(), value);
        }

        @Override
        public SortedSet<DN> getBaseDN() {
            return this.impl.getPropertyValues(INSTANCE.getBaseDNPropertyDefinition());
        }

        @Override
        public void setBaseDN(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getBaseDNPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public boolean isIsPrivateBackend() {
            return this.impl.getPropertyValue(INSTANCE.getIsPrivateBackendPropertyDefinition());
        }

        @Override
        public void setIsPrivateBackend(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getIsPrivateBackendPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getLDIFFile() {
            return this.impl.getPropertyValue(INSTANCE.getLDIFFilePropertyDefinition());
        }

        @Override
        public void setLDIFFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getLDIFFilePropertyDefinition(), value);
        }

        @Override
        public BackendCfgDefn.WritabilityMode getWritabilityMode() {
            return this.impl.getPropertyValue(INSTANCE.getWritabilityModePropertyDefinition());
        }

        @Override
        public void setWritabilityMode(BackendCfgDefn.WritabilityMode value) {
            this.impl.setPropertyValue(INSTANCE.getWritabilityModePropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends LDIFBackendCfgClient, ? extends LDIFBackendCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }
    }
}

