/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.TopCfgDefn;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.GlobalCfgClient;
import org.forgerock.opendj.server.config.client.IdentityMapperCfgClient;
import org.forgerock.opendj.server.config.client.PasswordPolicyCfgClient;
import org.forgerock.opendj.server.config.server.GlobalCfg;
import org.forgerock.opendj.server.config.server.IdentityMapperCfg;
import org.forgerock.opendj.server.config.server.PasswordPolicyCfg;

public final class GlobalCfgDefn
extends ManagedObjectDefinition<GlobalCfgClient, GlobalCfg> {
    private static final GlobalCfgDefn INSTANCE = new GlobalCfgDefn();
    private static final BooleanPropertyDefinition PD_ADD_MISSING_RDN_ATTRIBUTES;
    private static final BooleanPropertyDefinition PD_ALLOW_ATTRIBUTE_NAME_EXCEPTIONS;
    private static final StringPropertyDefinition PD_ALLOWED_TASK;
    private static final BooleanPropertyDefinition PD_BIND_WITH_DN_REQUIRES_PASSWORD;
    private static final BooleanPropertyDefinition PD_CHECK_SCHEMA;
    private static final AggregationPropertyDefinition<PasswordPolicyCfgClient, PasswordPolicyCfg> PD_DEFAULT_PASSWORD_POLICY;
    private static final EnumPropertyDefinition<DisabledPrivilege> PD_DISABLED_PRIVILEGE;
    private static final EnumPropertyDefinition<EtimeResolution> PD_ETIME_RESOLUTION;
    private static final DurationPropertyDefinition PD_IDLE_TIME_LIMIT;
    private static final EnumPropertyDefinition<InvalidAttributeSyntaxBehavior> PD_INVALID_ATTRIBUTE_SYNTAX_BEHAVIOR;
    private static final IntegerPropertyDefinition PD_LOOKTHROUGH_LIMIT;
    private static final IntegerPropertyDefinition PD_MAX_ALLOWED_CLIENT_CONNECTIONS;
    private static final SizePropertyDefinition PD_MAX_INTERNAL_BUFFER_SIZE;
    private static final IntegerPropertyDefinition PD_MAX_PSEARCHES;
    private static final BooleanPropertyDefinition PD_NOTIFY_ABANDONED_OPERATIONS;
    private static final AggregationPropertyDefinition<IdentityMapperCfgClient, IdentityMapperCfg> PD_PROXIED_AUTHORIZATION_IDENTITY_MAPPER;
    private static final BooleanPropertyDefinition PD_REJECT_UNAUTHENTICATED_REQUESTS;
    private static final BooleanPropertyDefinition PD_RETURN_BIND_ERROR_MESSAGES;
    private static final BooleanPropertyDefinition PD_SAVE_CONFIG_ON_SUCCESSFUL_STARTUP;
    private static final IntegerPropertyDefinition PD_SERVER_ERROR_RESULT_CODE;
    private static final EnumPropertyDefinition<SingleStructuralObjectclassBehavior> PD_SINGLE_STRUCTURAL_OBJECTCLASS_BEHAVIOR;
    private static final IntegerPropertyDefinition PD_SIZE_LIMIT;
    private static final StringPropertyDefinition PD_SMTP_SERVER;
    private static final DurationPropertyDefinition PD_TIME_LIMIT;
    private static final EnumPropertyDefinition<WritabilityMode> PD_WRITABILITY_MODE;

    public static GlobalCfgDefn getInstance() {
        return INSTANCE;
    }

    private GlobalCfgDefn() {
        super("global", TopCfgDefn.getInstance());
    }

    @Override
    public GlobalCfgClient createClientConfiguration(ManagedObject<? extends GlobalCfgClient> impl) {
        return new GlobalCfgClientImpl(impl);
    }

    @Override
    public GlobalCfg createServerConfiguration(ServerManagedObject<? extends GlobalCfg> impl) {
        return new GlobalCfgServerImpl(impl);
    }

    @Override
    public Class<GlobalCfg> getServerConfigurationClass() {
        return GlobalCfg.class;
    }

    public BooleanPropertyDefinition getAddMissingRDNAttributesPropertyDefinition() {
        return PD_ADD_MISSING_RDN_ATTRIBUTES;
    }

    public BooleanPropertyDefinition getAllowAttributeNameExceptionsPropertyDefinition() {
        return PD_ALLOW_ATTRIBUTE_NAME_EXCEPTIONS;
    }

    public StringPropertyDefinition getAllowedTaskPropertyDefinition() {
        return PD_ALLOWED_TASK;
    }

    public BooleanPropertyDefinition getBindWithDNRequiresPasswordPropertyDefinition() {
        return PD_BIND_WITH_DN_REQUIRES_PASSWORD;
    }

    public BooleanPropertyDefinition getCheckSchemaPropertyDefinition() {
        return PD_CHECK_SCHEMA;
    }

    public AggregationPropertyDefinition<PasswordPolicyCfgClient, PasswordPolicyCfg> getDefaultPasswordPolicyPropertyDefinition() {
        return PD_DEFAULT_PASSWORD_POLICY;
    }

    public EnumPropertyDefinition<DisabledPrivilege> getDisabledPrivilegePropertyDefinition() {
        return PD_DISABLED_PRIVILEGE;
    }

    public EnumPropertyDefinition<EtimeResolution> getEtimeResolutionPropertyDefinition() {
        return PD_ETIME_RESOLUTION;
    }

    public DurationPropertyDefinition getIdleTimeLimitPropertyDefinition() {
        return PD_IDLE_TIME_LIMIT;
    }

    public EnumPropertyDefinition<InvalidAttributeSyntaxBehavior> getInvalidAttributeSyntaxBehaviorPropertyDefinition() {
        return PD_INVALID_ATTRIBUTE_SYNTAX_BEHAVIOR;
    }

    public IntegerPropertyDefinition getLookthroughLimitPropertyDefinition() {
        return PD_LOOKTHROUGH_LIMIT;
    }

    public IntegerPropertyDefinition getMaxAllowedClientConnectionsPropertyDefinition() {
        return PD_MAX_ALLOWED_CLIENT_CONNECTIONS;
    }

    public SizePropertyDefinition getMaxInternalBufferSizePropertyDefinition() {
        return PD_MAX_INTERNAL_BUFFER_SIZE;
    }

    public IntegerPropertyDefinition getMaxPsearchesPropertyDefinition() {
        return PD_MAX_PSEARCHES;
    }

    public BooleanPropertyDefinition getNotifyAbandonedOperationsPropertyDefinition() {
        return PD_NOTIFY_ABANDONED_OPERATIONS;
    }

    public AggregationPropertyDefinition<IdentityMapperCfgClient, IdentityMapperCfg> getProxiedAuthorizationIdentityMapperPropertyDefinition() {
        return PD_PROXIED_AUTHORIZATION_IDENTITY_MAPPER;
    }

    public BooleanPropertyDefinition getRejectUnauthenticatedRequestsPropertyDefinition() {
        return PD_REJECT_UNAUTHENTICATED_REQUESTS;
    }

    public BooleanPropertyDefinition getReturnBindErrorMessagesPropertyDefinition() {
        return PD_RETURN_BIND_ERROR_MESSAGES;
    }

    public BooleanPropertyDefinition getSaveConfigOnSuccessfulStartupPropertyDefinition() {
        return PD_SAVE_CONFIG_ON_SUCCESSFUL_STARTUP;
    }

    public IntegerPropertyDefinition getServerErrorResultCodePropertyDefinition() {
        return PD_SERVER_ERROR_RESULT_CODE;
    }

    public EnumPropertyDefinition<SingleStructuralObjectclassBehavior> getSingleStructuralObjectclassBehaviorPropertyDefinition() {
        return PD_SINGLE_STRUCTURAL_OBJECTCLASS_BEHAVIOR;
    }

    public IntegerPropertyDefinition getSizeLimitPropertyDefinition() {
        return PD_SIZE_LIMIT;
    }

    public StringPropertyDefinition getSMTPServerPropertyDefinition() {
        return PD_SMTP_SERVER;
    }

    public DurationPropertyDefinition getTimeLimitPropertyDefinition() {
        return PD_TIME_LIMIT;
    }

    public EnumPropertyDefinition<WritabilityMode> getWritabilityModePropertyDefinition() {
        return PD_WRITABILITY_MODE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "add-missing-rdn-attributes");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "add-missing-rdn-attributes"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_ADD_MISSING_RDN_ATTRIBUTES = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ADD_MISSING_RDN_ATTRIBUTES);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "allow-attribute-name-exceptions");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allow-attribute-name-exceptions"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_ALLOW_ATTRIBUTE_NAME_EXCEPTIONS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOW_ATTRIBUTE_NAME_EXCEPTIONS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "allowed-task");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allowed-task"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "allowed-task"));
        PD_ALLOWED_TASK = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOWED_TASK);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "bind-with-dn-requires-password");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "bind-with-dn-requires-password"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_BIND_WITH_DN_REQUIRES_PASSWORD = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BIND_WITH_DN_REQUIRES_PASSWORD);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "check-schema");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "check-schema"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_CHECK_SCHEMA = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CHECK_SCHEMA);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "default-password-policy");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "default-password-policy"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("password-policy");
        PD_DEFAULT_PASSWORD_POLICY = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DEFAULT_PASSWORD_POLICY);
        INSTANCE.registerConstraint(PD_DEFAULT_PASSWORD_POLICY.getSourceConstraint());
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "disabled-privilege");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "disabled-privilege"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "disabled-privilege"));
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(DisabledPrivilege.class);
        PD_DISABLED_PRIVILEGE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DISABLED_PRIVILEGE);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "etime-resolution");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "etime-resolution"));
        provider = new DefinedDefaultBehaviorProvider("milliseconds");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(EtimeResolution.class);
        PD_ETIME_RESOLUTION = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ETIME_RESOLUTION);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "idle-time-limit");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "idle-time-limit"));
        provider = new DefinedDefaultBehaviorProvider("0 seconds");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_IDLE_TIME_LIMIT = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_IDLE_TIME_LIMIT);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "invalid-attribute-syntax-behavior");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "invalid-attribute-syntax-behavior"));
        provider = new DefinedDefaultBehaviorProvider("reject");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(InvalidAttributeSyntaxBehavior.class);
        PD_INVALID_ATTRIBUTE_SYNTAX_BEHAVIOR = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INVALID_ATTRIBUTE_SYNTAX_BEHAVIOR);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "lookthrough-limit");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "lookthrough-limit"));
        provider = new DefinedDefaultBehaviorProvider("5000");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_LOOKTHROUGH_LIMIT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOOKTHROUGH_LIMIT);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "max-allowed-client-connections");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-allowed-client-connections"));
        provider = new DefinedDefaultBehaviorProvider("0");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_MAX_ALLOWED_CLIENT_CONNECTIONS = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_ALLOWED_CLIENT_CONNECTIONS);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "max-internal-buffer-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-internal-buffer-size"));
        provider = new DefinedDefaultBehaviorProvider("32 KB");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setUpperLimit("1 GB");
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("512 B");
        PD_MAX_INTERNAL_BUFFER_SIZE = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_INTERNAL_BUFFER_SIZE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "max-psearches");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-psearches"));
        provider = new DefinedDefaultBehaviorProvider("-1");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setAllowUnlimited(true);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_MAX_PSEARCHES = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_PSEARCHES);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "notify-abandoned-operations");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "notify-abandoned-operations"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_NOTIFY_ABANDONED_OPERATIONS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_NOTIFY_ABANDONED_OPERATIONS);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "proxied-authorization-identity-mapper");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "proxied-authorization-identity-mapper"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("identity-mapper");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_PROXIED_AUTHORIZATION_IDENTITY_MAPPER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PROXIED_AUTHORIZATION_IDENTITY_MAPPER);
        INSTANCE.registerConstraint(PD_PROXIED_AUTHORIZATION_IDENTITY_MAPPER.getSourceConstraint());
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "reject-unauthenticated-requests");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "reject-unauthenticated-requests"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_REJECT_UNAUTHENTICATED_REQUESTS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REJECT_UNAUTHENTICATED_REQUESTS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "return-bind-error-messages");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "return-bind-error-messages"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_RETURN_BIND_ERROR_MESSAGES = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_RETURN_BIND_ERROR_MESSAGES);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "save-config-on-successful-startup");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "save-config-on-successful-startup"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_SAVE_CONFIG_ON_SUCCESSFUL_STARTUP = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SAVE_CONFIG_ON_SUCCESSFUL_STARTUP);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "server-error-result-code");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "server-error-result-code"));
        provider = new DefinedDefaultBehaviorProvider("80");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_SERVER_ERROR_RESULT_CODE = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SERVER_ERROR_RESULT_CODE);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "single-structural-objectclass-behavior");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "single-structural-objectclass-behavior"));
        provider = new DefinedDefaultBehaviorProvider("reject");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(SingleStructuralObjectclassBehavior.class);
        PD_SINGLE_STRUCTURAL_OBJECTCLASS_BEHAVIOR = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SINGLE_STRUCTURAL_OBJECTCLASS_BEHAVIOR);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "size-limit");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "size-limit"));
        provider = new DefinedDefaultBehaviorProvider("1000");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_SIZE_LIMIT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SIZE_LIMIT);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "smtp-server");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "smtp-server"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "smtp-server"));
        ((StringPropertyDefinition.Builder)builder).setPattern("^.+(:[0-9]+)?$", "HOST[:PORT]");
        PD_SMTP_SERVER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SMTP_SERVER);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "time-limit");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "time-limit"));
        provider = new DefinedDefaultBehaviorProvider("60 seconds");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_TIME_LIMIT = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TIME_LIMIT);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "writability-mode");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "writability-mode"));
        provider = new DefinedDefaultBehaviorProvider("enabled");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(WritabilityMode.class);
        PD_WRITABILITY_MODE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_WRITABILITY_MODE);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class GlobalCfgServerImpl
    implements GlobalCfg {
        private ServerManagedObject<? extends GlobalCfg> impl;
        private final boolean pAddMissingRDNAttributes;
        private final boolean pAllowAttributeNameExceptions;
        private final SortedSet<String> pAllowedTask;
        private final boolean pBindWithDNRequiresPassword;
        private final boolean pCheckSchema;
        private final String pDefaultPasswordPolicy;
        private final SortedSet<DisabledPrivilege> pDisabledPrivilege;
        private final EtimeResolution pEtimeResolution;
        private final long pIdleTimeLimit;
        private final InvalidAttributeSyntaxBehavior pInvalidAttributeSyntaxBehavior;
        private final int pLookthroughLimit;
        private final int pMaxAllowedClientConnections;
        private final long pMaxInternalBufferSize;
        private final int pMaxPsearches;
        private final boolean pNotifyAbandonedOperations;
        private final String pProxiedAuthorizationIdentityMapper;
        private final boolean pRejectUnauthenticatedRequests;
        private final boolean pReturnBindErrorMessages;
        private final boolean pSaveConfigOnSuccessfulStartup;
        private final int pServerErrorResultCode;
        private final SingleStructuralObjectclassBehavior pSingleStructuralObjectclassBehavior;
        private final int pSizeLimit;
        private final SortedSet<String> pSMTPServer;
        private final long pTimeLimit;
        private final WritabilityMode pWritabilityMode;

        private GlobalCfgServerImpl(ServerManagedObject<? extends GlobalCfg> impl) {
            this.impl = impl;
            this.pAddMissingRDNAttributes = impl.getPropertyValue(INSTANCE.getAddMissingRDNAttributesPropertyDefinition());
            this.pAllowAttributeNameExceptions = impl.getPropertyValue(INSTANCE.getAllowAttributeNameExceptionsPropertyDefinition());
            this.pAllowedTask = impl.getPropertyValues((PropertyDefinition)INSTANCE.getAllowedTaskPropertyDefinition());
            this.pBindWithDNRequiresPassword = impl.getPropertyValue(INSTANCE.getBindWithDNRequiresPasswordPropertyDefinition());
            this.pCheckSchema = impl.getPropertyValue(INSTANCE.getCheckSchemaPropertyDefinition());
            this.pDefaultPasswordPolicy = impl.getPropertyValue(INSTANCE.getDefaultPasswordPolicyPropertyDefinition());
            this.pDisabledPrivilege = impl.getPropertyValues(INSTANCE.getDisabledPrivilegePropertyDefinition());
            this.pEtimeResolution = impl.getPropertyValue(INSTANCE.getEtimeResolutionPropertyDefinition());
            this.pIdleTimeLimit = impl.getPropertyValue(INSTANCE.getIdleTimeLimitPropertyDefinition());
            this.pInvalidAttributeSyntaxBehavior = impl.getPropertyValue(INSTANCE.getInvalidAttributeSyntaxBehaviorPropertyDefinition());
            this.pLookthroughLimit = impl.getPropertyValue(INSTANCE.getLookthroughLimitPropertyDefinition());
            this.pMaxAllowedClientConnections = impl.getPropertyValue(INSTANCE.getMaxAllowedClientConnectionsPropertyDefinition());
            this.pMaxInternalBufferSize = impl.getPropertyValue(INSTANCE.getMaxInternalBufferSizePropertyDefinition());
            this.pMaxPsearches = impl.getPropertyValue(INSTANCE.getMaxPsearchesPropertyDefinition());
            this.pNotifyAbandonedOperations = impl.getPropertyValue(INSTANCE.getNotifyAbandonedOperationsPropertyDefinition());
            this.pProxiedAuthorizationIdentityMapper = impl.getPropertyValue(INSTANCE.getProxiedAuthorizationIdentityMapperPropertyDefinition());
            this.pRejectUnauthenticatedRequests = impl.getPropertyValue(INSTANCE.getRejectUnauthenticatedRequestsPropertyDefinition());
            this.pReturnBindErrorMessages = impl.getPropertyValue(INSTANCE.getReturnBindErrorMessagesPropertyDefinition());
            this.pSaveConfigOnSuccessfulStartup = impl.getPropertyValue(INSTANCE.getSaveConfigOnSuccessfulStartupPropertyDefinition());
            this.pServerErrorResultCode = impl.getPropertyValue(INSTANCE.getServerErrorResultCodePropertyDefinition());
            this.pSingleStructuralObjectclassBehavior = impl.getPropertyValue(INSTANCE.getSingleStructuralObjectclassBehaviorPropertyDefinition());
            this.pSizeLimit = impl.getPropertyValue(INSTANCE.getSizeLimitPropertyDefinition());
            this.pSMTPServer = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSMTPServerPropertyDefinition());
            this.pTimeLimit = impl.getPropertyValue(INSTANCE.getTimeLimitPropertyDefinition());
            this.pWritabilityMode = impl.getPropertyValue(INSTANCE.getWritabilityModePropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<GlobalCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<GlobalCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isAddMissingRDNAttributes() {
            return this.pAddMissingRDNAttributes;
        }

        @Override
        public boolean isAllowAttributeNameExceptions() {
            return this.pAllowAttributeNameExceptions;
        }

        @Override
        public SortedSet<String> getAllowedTask() {
            return this.pAllowedTask;
        }

        @Override
        public boolean isBindWithDNRequiresPassword() {
            return this.pBindWithDNRequiresPassword;
        }

        @Override
        public boolean isCheckSchema() {
            return this.pCheckSchema;
        }

        @Override
        public String getDefaultPasswordPolicy() {
            return this.pDefaultPasswordPolicy;
        }

        @Override
        public DN getDefaultPasswordPolicyDN() {
            String value = this.getDefaultPasswordPolicy();
            if (value == null) {
                return null;
            }
            return INSTANCE.getDefaultPasswordPolicyPropertyDefinition().getChildDN(value);
        }

        @Override
        public SortedSet<DisabledPrivilege> getDisabledPrivilege() {
            return this.pDisabledPrivilege;
        }

        @Override
        public EtimeResolution getEtimeResolution() {
            return this.pEtimeResolution;
        }

        @Override
        public long getIdleTimeLimit() {
            return this.pIdleTimeLimit;
        }

        @Override
        public InvalidAttributeSyntaxBehavior getInvalidAttributeSyntaxBehavior() {
            return this.pInvalidAttributeSyntaxBehavior;
        }

        @Override
        public int getLookthroughLimit() {
            return this.pLookthroughLimit;
        }

        @Override
        public int getMaxAllowedClientConnections() {
            return this.pMaxAllowedClientConnections;
        }

        @Override
        public long getMaxInternalBufferSize() {
            return this.pMaxInternalBufferSize;
        }

        @Override
        public int getMaxPsearches() {
            return this.pMaxPsearches;
        }

        @Override
        public boolean isNotifyAbandonedOperations() {
            return this.pNotifyAbandonedOperations;
        }

        @Override
        public String getProxiedAuthorizationIdentityMapper() {
            return this.pProxiedAuthorizationIdentityMapper;
        }

        @Override
        public DN getProxiedAuthorizationIdentityMapperDN() {
            String value = this.getProxiedAuthorizationIdentityMapper();
            if (value == null) {
                return null;
            }
            return INSTANCE.getProxiedAuthorizationIdentityMapperPropertyDefinition().getChildDN(value);
        }

        @Override
        public boolean isRejectUnauthenticatedRequests() {
            return this.pRejectUnauthenticatedRequests;
        }

        @Override
        public boolean isReturnBindErrorMessages() {
            return this.pReturnBindErrorMessages;
        }

        @Override
        public boolean isSaveConfigOnSuccessfulStartup() {
            return this.pSaveConfigOnSuccessfulStartup;
        }

        @Override
        public int getServerErrorResultCode() {
            return this.pServerErrorResultCode;
        }

        @Override
        public SingleStructuralObjectclassBehavior getSingleStructuralObjectclassBehavior() {
            return this.pSingleStructuralObjectclassBehavior;
        }

        @Override
        public int getSizeLimit() {
            return this.pSizeLimit;
        }

        @Override
        public SortedSet<String> getSMTPServer() {
            return this.pSMTPServer;
        }

        @Override
        public long getTimeLimit() {
            return this.pTimeLimit;
        }

        @Override
        public WritabilityMode getWritabilityMode() {
            return this.pWritabilityMode;
        }

        @Override
        public Class<? extends GlobalCfg> configurationClass() {
            return GlobalCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class GlobalCfgClientImpl
    implements GlobalCfgClient {
        private ManagedObject<? extends GlobalCfgClient> impl;

        private GlobalCfgClientImpl(ManagedObject<? extends GlobalCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public boolean isAddMissingRDNAttributes() {
            return this.impl.getPropertyValue(INSTANCE.getAddMissingRDNAttributesPropertyDefinition());
        }

        @Override
        public void setAddMissingRDNAttributes(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAddMissingRDNAttributesPropertyDefinition(), value);
        }

        @Override
        public boolean isAllowAttributeNameExceptions() {
            return this.impl.getPropertyValue(INSTANCE.getAllowAttributeNameExceptionsPropertyDefinition());
        }

        @Override
        public void setAllowAttributeNameExceptions(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAllowAttributeNameExceptionsPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getAllowedTask() {
            return this.impl.getPropertyValues(INSTANCE.getAllowedTaskPropertyDefinition());
        }

        @Override
        public void setAllowedTask(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getAllowedTaskPropertyDefinition(), values);
        }

        @Override
        public boolean isBindWithDNRequiresPassword() {
            return this.impl.getPropertyValue(INSTANCE.getBindWithDNRequiresPasswordPropertyDefinition());
        }

        @Override
        public void setBindWithDNRequiresPassword(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getBindWithDNRequiresPasswordPropertyDefinition(), value);
        }

        @Override
        public boolean isCheckSchema() {
            return this.impl.getPropertyValue(INSTANCE.getCheckSchemaPropertyDefinition());
        }

        @Override
        public void setCheckSchema(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getCheckSchemaPropertyDefinition(), value);
        }

        @Override
        public String getDefaultPasswordPolicy() {
            return this.impl.getPropertyValue(INSTANCE.getDefaultPasswordPolicyPropertyDefinition());
        }

        @Override
        public void setDefaultPasswordPolicy(String value) {
            this.impl.setPropertyValue(INSTANCE.getDefaultPasswordPolicyPropertyDefinition(), value);
        }

        @Override
        public SortedSet<DisabledPrivilege> getDisabledPrivilege() {
            return this.impl.getPropertyValues(INSTANCE.getDisabledPrivilegePropertyDefinition());
        }

        @Override
        public void setDisabledPrivilege(Collection<DisabledPrivilege> values) {
            this.impl.setPropertyValues(INSTANCE.getDisabledPrivilegePropertyDefinition(), values);
        }

        @Override
        public EtimeResolution getEtimeResolution() {
            return this.impl.getPropertyValue(INSTANCE.getEtimeResolutionPropertyDefinition());
        }

        @Override
        public void setEtimeResolution(EtimeResolution value) {
            this.impl.setPropertyValue(INSTANCE.getEtimeResolutionPropertyDefinition(), value);
        }

        @Override
        public long getIdleTimeLimit() {
            return this.impl.getPropertyValue(INSTANCE.getIdleTimeLimitPropertyDefinition());
        }

        @Override
        public void setIdleTimeLimit(Long value) {
            this.impl.setPropertyValue(INSTANCE.getIdleTimeLimitPropertyDefinition(), value);
        }

        @Override
        public InvalidAttributeSyntaxBehavior getInvalidAttributeSyntaxBehavior() {
            return this.impl.getPropertyValue(INSTANCE.getInvalidAttributeSyntaxBehaviorPropertyDefinition());
        }

        @Override
        public void setInvalidAttributeSyntaxBehavior(InvalidAttributeSyntaxBehavior value) {
            this.impl.setPropertyValue(INSTANCE.getInvalidAttributeSyntaxBehaviorPropertyDefinition(), value);
        }

        @Override
        public int getLookthroughLimit() {
            return this.impl.getPropertyValue(INSTANCE.getLookthroughLimitPropertyDefinition());
        }

        @Override
        public void setLookthroughLimit(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getLookthroughLimitPropertyDefinition(), value);
        }

        @Override
        public int getMaxAllowedClientConnections() {
            return this.impl.getPropertyValue(INSTANCE.getMaxAllowedClientConnectionsPropertyDefinition());
        }

        @Override
        public void setMaxAllowedClientConnections(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getMaxAllowedClientConnectionsPropertyDefinition(), value);
        }

        @Override
        public long getMaxInternalBufferSize() {
            return this.impl.getPropertyValue(INSTANCE.getMaxInternalBufferSizePropertyDefinition());
        }

        @Override
        public void setMaxInternalBufferSize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getMaxInternalBufferSizePropertyDefinition(), value);
        }

        @Override
        public int getMaxPsearches() {
            return this.impl.getPropertyValue(INSTANCE.getMaxPsearchesPropertyDefinition());
        }

        @Override
        public void setMaxPsearches(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getMaxPsearchesPropertyDefinition(), value);
        }

        @Override
        public boolean isNotifyAbandonedOperations() {
            return this.impl.getPropertyValue(INSTANCE.getNotifyAbandonedOperationsPropertyDefinition());
        }

        @Override
        public void setNotifyAbandonedOperations(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getNotifyAbandonedOperationsPropertyDefinition(), value);
        }

        @Override
        public String getProxiedAuthorizationIdentityMapper() {
            return this.impl.getPropertyValue(INSTANCE.getProxiedAuthorizationIdentityMapperPropertyDefinition());
        }

        @Override
        public void setProxiedAuthorizationIdentityMapper(String value) {
            this.impl.setPropertyValue(INSTANCE.getProxiedAuthorizationIdentityMapperPropertyDefinition(), value);
        }

        @Override
        public boolean isRejectUnauthenticatedRequests() {
            return this.impl.getPropertyValue(INSTANCE.getRejectUnauthenticatedRequestsPropertyDefinition());
        }

        @Override
        public void setRejectUnauthenticatedRequests(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getRejectUnauthenticatedRequestsPropertyDefinition(), value);
        }

        @Override
        public boolean isReturnBindErrorMessages() {
            return this.impl.getPropertyValue(INSTANCE.getReturnBindErrorMessagesPropertyDefinition());
        }

        @Override
        public void setReturnBindErrorMessages(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getReturnBindErrorMessagesPropertyDefinition(), value);
        }

        @Override
        public boolean isSaveConfigOnSuccessfulStartup() {
            return this.impl.getPropertyValue(INSTANCE.getSaveConfigOnSuccessfulStartupPropertyDefinition());
        }

        @Override
        public void setSaveConfigOnSuccessfulStartup(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getSaveConfigOnSuccessfulStartupPropertyDefinition(), value);
        }

        @Override
        public int getServerErrorResultCode() {
            return this.impl.getPropertyValue(INSTANCE.getServerErrorResultCodePropertyDefinition());
        }

        @Override
        public void setServerErrorResultCode(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getServerErrorResultCodePropertyDefinition(), value);
        }

        @Override
        public SingleStructuralObjectclassBehavior getSingleStructuralObjectclassBehavior() {
            return this.impl.getPropertyValue(INSTANCE.getSingleStructuralObjectclassBehaviorPropertyDefinition());
        }

        @Override
        public void setSingleStructuralObjectclassBehavior(SingleStructuralObjectclassBehavior value) {
            this.impl.setPropertyValue(INSTANCE.getSingleStructuralObjectclassBehaviorPropertyDefinition(), value);
        }

        @Override
        public int getSizeLimit() {
            return this.impl.getPropertyValue(INSTANCE.getSizeLimitPropertyDefinition());
        }

        @Override
        public void setSizeLimit(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getSizeLimitPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getSMTPServer() {
            return this.impl.getPropertyValues(INSTANCE.getSMTPServerPropertyDefinition());
        }

        @Override
        public void setSMTPServer(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSMTPServerPropertyDefinition(), values);
        }

        @Override
        public long getTimeLimit() {
            return this.impl.getPropertyValue(INSTANCE.getTimeLimitPropertyDefinition());
        }

        @Override
        public void setTimeLimit(Long value) {
            this.impl.setPropertyValue(INSTANCE.getTimeLimitPropertyDefinition(), value);
        }

        @Override
        public WritabilityMode getWritabilityMode() {
            return this.impl.getPropertyValue(INSTANCE.getWritabilityModePropertyDefinition());
        }

        @Override
        public void setWritabilityMode(WritabilityMode value) {
            this.impl.setPropertyValue(INSTANCE.getWritabilityModePropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends GlobalCfgClient, ? extends GlobalCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }
    }

    public static enum WritabilityMode {
        DISABLED("disabled"),
        ENABLED("enabled"),
        INTERNAL_ONLY("internal-only");

        private final String name;

        private WritabilityMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum SingleStructuralObjectclassBehavior {
        ACCEPT("accept"),
        REJECT("reject"),
        WARN("warn");

        private final String name;

        private SingleStructuralObjectclassBehavior(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum InvalidAttributeSyntaxBehavior {
        ACCEPT("accept"),
        REJECT("reject"),
        WARN("warn");

        private final String name;

        private InvalidAttributeSyntaxBehavior(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum EtimeResolution {
        MILLISECONDS("milliseconds"),
        NANOSECONDS("nanoseconds");

        private final String name;

        private EtimeResolution(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum DisabledPrivilege {
        BACKEND_BACKUP("backend-backup"),
        BACKEND_RESTORE("backend-restore"),
        BYPASS_ACL("bypass-acl"),
        BYPASS_LOCKDOWN("bypass-lockdown"),
        CANCEL_REQUEST("cancel-request"),
        CHANGELOG_READ("changelog-read"),
        CONFIG_READ("config-read"),
        CONFIG_WRITE("config-write"),
        DATA_SYNC("data-sync"),
        DISCONNECT_CLIENT("disconnect-client"),
        JMX_NOTIFY("jmx-notify"),
        JMX_READ("jmx-read"),
        JMX_WRITE("jmx-write"),
        LDIF_EXPORT("ldif-export"),
        LDIF_IMPORT("ldif-import"),
        MODIFY_ACL("modify-acl"),
        PASSWORD_RESET("password-reset"),
        PRIVILEGE_CHANGE("privilege-change"),
        PROXIED_AUTH("proxied-auth"),
        SERVER_LOCKDOWN("server-lockdown"),
        SERVER_RESTART("server-restart"),
        SERVER_SHUTDOWN("server-shutdown"),
        SUBENTRY_WRITE("subentry-write"),
        UNINDEXED_SEARCH("unindexed-search"),
        UPDATE_SCHEMA("update-schema");

        private final String name;

        private DisabledPrivilege(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

