/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.FreeDiskSpaceLogRetentionPolicyCfgClient;
import org.forgerock.opendj.server.config.meta.LogRetentionPolicyCfgDefn;
import org.forgerock.opendj.server.config.server.FreeDiskSpaceLogRetentionPolicyCfg;
import org.forgerock.opendj.server.config.server.LogRetentionPolicyCfg;

public final class FreeDiskSpaceLogRetentionPolicyCfgDefn
extends ManagedObjectDefinition<FreeDiskSpaceLogRetentionPolicyCfgClient, FreeDiskSpaceLogRetentionPolicyCfg> {
    private static final FreeDiskSpaceLogRetentionPolicyCfgDefn INSTANCE = new FreeDiskSpaceLogRetentionPolicyCfgDefn();
    private static final SizePropertyDefinition PD_FREE_DISK_SPACE;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static FreeDiskSpaceLogRetentionPolicyCfgDefn getInstance() {
        return INSTANCE;
    }

    private FreeDiskSpaceLogRetentionPolicyCfgDefn() {
        super("free-disk-space-log-retention-policy", LogRetentionPolicyCfgDefn.getInstance());
    }

    @Override
    public FreeDiskSpaceLogRetentionPolicyCfgClient createClientConfiguration(ManagedObject<? extends FreeDiskSpaceLogRetentionPolicyCfgClient> impl) {
        return new FreeDiskSpaceLogRetentionPolicyCfgClientImpl(impl);
    }

    @Override
    public FreeDiskSpaceLogRetentionPolicyCfg createServerConfiguration(ServerManagedObject<? extends FreeDiskSpaceLogRetentionPolicyCfg> impl) {
        return new FreeDiskSpaceLogRetentionPolicyCfgServerImpl(impl);
    }

    @Override
    public Class<FreeDiskSpaceLogRetentionPolicyCfg> getServerConfigurationClass() {
        return FreeDiskSpaceLogRetentionPolicyCfg.class;
    }

    public SizePropertyDefinition getFreeDiskSpacePropertyDefinition() {
        return PD_FREE_DISK_SPACE;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = SizePropertyDefinition.createBuilder(INSTANCE, "free-disk-space");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "free-disk-space"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_FREE_DISK_SPACE = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_FREE_DISK_SPACE);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.loggers.FreeDiskSpaceRetentionPolicy");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.loggers.RetentionPolicy");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("logging"));
    }

    private static class FreeDiskSpaceLogRetentionPolicyCfgServerImpl
    implements FreeDiskSpaceLogRetentionPolicyCfg {
        private ServerManagedObject<? extends FreeDiskSpaceLogRetentionPolicyCfg> impl;
        private final long pFreeDiskSpace;
        private final String pJavaClass;

        private FreeDiskSpaceLogRetentionPolicyCfgServerImpl(ServerManagedObject<? extends FreeDiskSpaceLogRetentionPolicyCfg> impl) {
            this.impl = impl;
            this.pFreeDiskSpace = impl.getPropertyValue(INSTANCE.getFreeDiskSpacePropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addFreeDiskSpaceChangeListener(ConfigurationChangeListener<FreeDiskSpaceLogRetentionPolicyCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeFreeDiskSpaceChangeListener(ConfigurationChangeListener<FreeDiskSpaceLogRetentionPolicyCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<LogRetentionPolicyCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<LogRetentionPolicyCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public long getFreeDiskSpace() {
            return this.pFreeDiskSpace;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends FreeDiskSpaceLogRetentionPolicyCfg> configurationClass() {
            return FreeDiskSpaceLogRetentionPolicyCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class FreeDiskSpaceLogRetentionPolicyCfgClientImpl
    implements FreeDiskSpaceLogRetentionPolicyCfgClient {
        private ManagedObject<? extends FreeDiskSpaceLogRetentionPolicyCfgClient> impl;

        private FreeDiskSpaceLogRetentionPolicyCfgClientImpl(ManagedObject<? extends FreeDiskSpaceLogRetentionPolicyCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Long getFreeDiskSpace() {
            return this.impl.getPropertyValue(INSTANCE.getFreeDiskSpacePropertyDefinition());
        }

        @Override
        public void setFreeDiskSpace(long value) {
            this.impl.setPropertyValue(INSTANCE.getFreeDiskSpacePropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends FreeDiskSpaceLogRetentionPolicyCfgClient, ? extends FreeDiskSpaceLogRetentionPolicyCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }
    }
}

