/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.ACIPropertyDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.DseeCompatAccessControlHandlerCfgClient;
import org.forgerock.opendj.server.config.meta.AccessControlHandlerCfgDefn;
import org.forgerock.opendj.server.config.server.AccessControlHandlerCfg;
import org.forgerock.opendj.server.config.server.DseeCompatAccessControlHandlerCfg;

public final class DseeCompatAccessControlHandlerCfgDefn
extends ManagedObjectDefinition<DseeCompatAccessControlHandlerCfgClient, DseeCompatAccessControlHandlerCfg> {
    private static final DseeCompatAccessControlHandlerCfgDefn INSTANCE = new DseeCompatAccessControlHandlerCfgDefn();
    private static final ACIPropertyDefinition PD_GLOBAL_ACI;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static DseeCompatAccessControlHandlerCfgDefn getInstance() {
        return INSTANCE;
    }

    private DseeCompatAccessControlHandlerCfgDefn() {
        super("dsee-compat-access-control-handler", AccessControlHandlerCfgDefn.getInstance());
    }

    @Override
    public DseeCompatAccessControlHandlerCfgClient createClientConfiguration(ManagedObject<? extends DseeCompatAccessControlHandlerCfgClient> impl) {
        return new DseeCompatAccessControlHandlerCfgClientImpl(impl);
    }

    @Override
    public DseeCompatAccessControlHandlerCfg createServerConfiguration(ServerManagedObject<? extends DseeCompatAccessControlHandlerCfg> impl) {
        return new DseeCompatAccessControlHandlerCfgServerImpl(impl);
    }

    @Override
    public Class<DseeCompatAccessControlHandlerCfg> getServerConfigurationClass() {
        return DseeCompatAccessControlHandlerCfg.class;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return AccessControlHandlerCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ACIPropertyDefinition getGlobalACIPropertyDefinition() {
        return PD_GLOBAL_ACI;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ACIPropertyDefinition.createBuilder(INSTANCE, "global-aci");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "global-aci"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "global-aci"));
        PD_GLOBAL_ACI = (ACIPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_GLOBAL_ACI);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.authorization.dseecompat.AciHandler");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.AccessControlHandler");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("security"));
    }

    private static class DseeCompatAccessControlHandlerCfgServerImpl
    implements DseeCompatAccessControlHandlerCfg {
        private ServerManagedObject<? extends DseeCompatAccessControlHandlerCfg> impl;
        private final boolean pEnabled;
        private final SortedSet<String> pGlobalACI;
        private final String pJavaClass;

        private DseeCompatAccessControlHandlerCfgServerImpl(ServerManagedObject<? extends DseeCompatAccessControlHandlerCfg> impl) {
            this.impl = impl;
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pGlobalACI = impl.getPropertyValues((PropertyDefinition)INSTANCE.getGlobalACIPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addDseeCompatChangeListener(ConfigurationChangeListener<DseeCompatAccessControlHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeDseeCompatChangeListener(ConfigurationChangeListener<DseeCompatAccessControlHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<AccessControlHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<AccessControlHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public SortedSet<String> getGlobalACI() {
            return this.pGlobalACI;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends DseeCompatAccessControlHandlerCfg> configurationClass() {
            return DseeCompatAccessControlHandlerCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class DseeCompatAccessControlHandlerCfgClientImpl
    implements DseeCompatAccessControlHandlerCfgClient {
        private ManagedObject<? extends DseeCompatAccessControlHandlerCfgClient> impl;

        private DseeCompatAccessControlHandlerCfgClientImpl(ManagedObject<? extends DseeCompatAccessControlHandlerCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getGlobalACI() {
            return this.impl.getPropertyValues(INSTANCE.getGlobalACIPropertyDefinition());
        }

        @Override
        public void setGlobalACI(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getGlobalACIPropertyDefinition(), values);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends DseeCompatAccessControlHandlerCfgClient, ? extends DseeCompatAccessControlHandlerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }
    }
}

