/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.CryptPasswordStorageSchemeCfgClient;
import org.forgerock.opendj.server.config.meta.PasswordStorageSchemeCfgDefn;
import org.forgerock.opendj.server.config.server.CryptPasswordStorageSchemeCfg;
import org.forgerock.opendj.server.config.server.PasswordStorageSchemeCfg;

public final class CryptPasswordStorageSchemeCfgDefn
extends ManagedObjectDefinition<CryptPasswordStorageSchemeCfgClient, CryptPasswordStorageSchemeCfg> {
    private static final CryptPasswordStorageSchemeCfgDefn INSTANCE = new CryptPasswordStorageSchemeCfgDefn();
    private static final EnumPropertyDefinition<CryptPasswordStorageEncryptionAlgorithm> PD_CRYPT_PASSWORD_STORAGE_ENCRYPTION_ALGORITHM;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static CryptPasswordStorageSchemeCfgDefn getInstance() {
        return INSTANCE;
    }

    private CryptPasswordStorageSchemeCfgDefn() {
        super("crypt-password-storage-scheme", PasswordStorageSchemeCfgDefn.getInstance());
    }

    @Override
    public CryptPasswordStorageSchemeCfgClient createClientConfiguration(ManagedObject<? extends CryptPasswordStorageSchemeCfgClient> impl) {
        return new CryptPasswordStorageSchemeCfgClientImpl(impl);
    }

    @Override
    public CryptPasswordStorageSchemeCfg createServerConfiguration(ServerManagedObject<? extends CryptPasswordStorageSchemeCfg> impl) {
        return new CryptPasswordStorageSchemeCfgServerImpl(impl);
    }

    @Override
    public Class<CryptPasswordStorageSchemeCfg> getServerConfigurationClass() {
        return CryptPasswordStorageSchemeCfg.class;
    }

    public EnumPropertyDefinition<CryptPasswordStorageEncryptionAlgorithm> getCryptPasswordStorageEncryptionAlgorithmPropertyDefinition() {
        return PD_CRYPT_PASSWORD_STORAGE_ENCRYPTION_ALGORITHM;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PasswordStorageSchemeCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = EnumPropertyDefinition.createBuilder(INSTANCE, "crypt-password-storage-encryption-algorithm");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "crypt-password-storage-encryption-algorithm"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("unix");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(CryptPasswordStorageEncryptionAlgorithm.class);
        PD_CRYPT_PASSWORD_STORAGE_ENCRYPTION_ALGORITHM = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CRYPT_PASSWORD_STORAGE_ENCRYPTION_ALGORITHM);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.CryptPasswordStorageScheme");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.PasswordStorageScheme");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("user-management"));
    }

    private static class CryptPasswordStorageSchemeCfgServerImpl
    implements CryptPasswordStorageSchemeCfg {
        private ServerManagedObject<? extends CryptPasswordStorageSchemeCfg> impl;
        private final CryptPasswordStorageEncryptionAlgorithm pCryptPasswordStorageEncryptionAlgorithm;
        private final boolean pEnabled;
        private final String pJavaClass;

        private CryptPasswordStorageSchemeCfgServerImpl(ServerManagedObject<? extends CryptPasswordStorageSchemeCfg> impl) {
            this.impl = impl;
            this.pCryptPasswordStorageEncryptionAlgorithm = impl.getPropertyValue(INSTANCE.getCryptPasswordStorageEncryptionAlgorithmPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addCryptChangeListener(ConfigurationChangeListener<CryptPasswordStorageSchemeCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeCryptChangeListener(ConfigurationChangeListener<CryptPasswordStorageSchemeCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<PasswordStorageSchemeCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<PasswordStorageSchemeCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public CryptPasswordStorageEncryptionAlgorithm getCryptPasswordStorageEncryptionAlgorithm() {
            return this.pCryptPasswordStorageEncryptionAlgorithm;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends CryptPasswordStorageSchemeCfg> configurationClass() {
            return CryptPasswordStorageSchemeCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class CryptPasswordStorageSchemeCfgClientImpl
    implements CryptPasswordStorageSchemeCfgClient {
        private ManagedObject<? extends CryptPasswordStorageSchemeCfgClient> impl;

        private CryptPasswordStorageSchemeCfgClientImpl(ManagedObject<? extends CryptPasswordStorageSchemeCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public CryptPasswordStorageEncryptionAlgorithm getCryptPasswordStorageEncryptionAlgorithm() {
            return this.impl.getPropertyValue(INSTANCE.getCryptPasswordStorageEncryptionAlgorithmPropertyDefinition());
        }

        @Override
        public void setCryptPasswordStorageEncryptionAlgorithm(CryptPasswordStorageEncryptionAlgorithm value) {
            this.impl.setPropertyValue(INSTANCE.getCryptPasswordStorageEncryptionAlgorithmPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends CryptPasswordStorageSchemeCfgClient, ? extends CryptPasswordStorageSchemeCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }
    }

    public static enum CryptPasswordStorageEncryptionAlgorithm {
        MD5("md5"),
        SHA256("sha256"),
        SHA512("sha512"),
        UNIX("unix");

        private final String name;

        private CryptPasswordStorageEncryptionAlgorithm(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

