/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.CollationMatchingRuleCfgClient;
import org.forgerock.opendj.server.config.meta.MatchingRuleCfgDefn;
import org.forgerock.opendj.server.config.server.CollationMatchingRuleCfg;
import org.forgerock.opendj.server.config.server.MatchingRuleCfg;

public final class CollationMatchingRuleCfgDefn
extends ManagedObjectDefinition<CollationMatchingRuleCfgClient, CollationMatchingRuleCfg> {
    private static final CollationMatchingRuleCfgDefn INSTANCE = new CollationMatchingRuleCfgDefn();
    private static final StringPropertyDefinition PD_COLLATION;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final EnumPropertyDefinition<MatchingRuleType> PD_MATCHING_RULE_TYPE;

    public static CollationMatchingRuleCfgDefn getInstance() {
        return INSTANCE;
    }

    private CollationMatchingRuleCfgDefn() {
        super("collation-matching-rule", MatchingRuleCfgDefn.getInstance());
    }

    @Override
    public CollationMatchingRuleCfgClient createClientConfiguration(ManagedObject<? extends CollationMatchingRuleCfgClient> impl) {
        return new CollationMatchingRuleCfgClientImpl(impl);
    }

    @Override
    public CollationMatchingRuleCfg createServerConfiguration(ServerManagedObject<? extends CollationMatchingRuleCfg> impl) {
        return new CollationMatchingRuleCfgServerImpl(impl);
    }

    @Override
    public Class<CollationMatchingRuleCfg> getServerConfigurationClass() {
        return CollationMatchingRuleCfg.class;
    }

    public StringPropertyDefinition getCollationPropertyDefinition() {
        return PD_COLLATION;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return MatchingRuleCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public EnumPropertyDefinition<MatchingRuleType> getMatchingRuleTypePropertyDefinition() {
        return PD_MATCHING_RULE_TYPE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = StringPropertyDefinition.createBuilder(INSTANCE, "collation");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "collation"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern("^[a-z-A-Z]+:[0-9.]+\\d$", "LOCALE:OID");
        PD_COLLATION = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_COLLATION);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.schema.CollationMatchingRuleFactory");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.MatchingRuleFactory");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "matching-rule-type");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "matching-rule-type"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(MatchingRuleType.class);
        PD_MATCHING_RULE_TYPE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MATCHING_RULE_TYPE);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class CollationMatchingRuleCfgServerImpl
    implements CollationMatchingRuleCfg {
        private ServerManagedObject<? extends CollationMatchingRuleCfg> impl;
        private final SortedSet<String> pCollation;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final SortedSet<MatchingRuleType> pMatchingRuleType;

        private CollationMatchingRuleCfgServerImpl(ServerManagedObject<? extends CollationMatchingRuleCfg> impl) {
            this.impl = impl;
            this.pCollation = impl.getPropertyValues((PropertyDefinition)INSTANCE.getCollationPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pMatchingRuleType = impl.getPropertyValues(INSTANCE.getMatchingRuleTypePropertyDefinition());
        }

        @Override
        public void addCollationChangeListener(ConfigurationChangeListener<CollationMatchingRuleCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeCollationChangeListener(ConfigurationChangeListener<CollationMatchingRuleCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<MatchingRuleCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<MatchingRuleCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<String> getCollation() {
            return this.pCollation;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public SortedSet<MatchingRuleType> getMatchingRuleType() {
            return this.pMatchingRuleType;
        }

        @Override
        public Class<? extends CollationMatchingRuleCfg> configurationClass() {
            return CollationMatchingRuleCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class CollationMatchingRuleCfgClientImpl
    implements CollationMatchingRuleCfgClient {
        private ManagedObject<? extends CollationMatchingRuleCfgClient> impl;

        private CollationMatchingRuleCfgClientImpl(ManagedObject<? extends CollationMatchingRuleCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<String> getCollation() {
            return this.impl.getPropertyValues(INSTANCE.getCollationPropertyDefinition());
        }

        @Override
        public void setCollation(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getCollationPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public SortedSet<MatchingRuleType> getMatchingRuleType() {
            return this.impl.getPropertyValues(INSTANCE.getMatchingRuleTypePropertyDefinition());
        }

        @Override
        public void setMatchingRuleType(Collection<MatchingRuleType> values) {
            this.impl.setPropertyValues(INSTANCE.getMatchingRuleTypePropertyDefinition(), values);
        }

        @Override
        public ManagedObjectDefinition<? extends CollationMatchingRuleCfgClient, ? extends CollationMatchingRuleCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }
    }

    public static enum MatchingRuleType {
        EQUALITY("equality"),
        GREATER_THAN("greater-than"),
        GREATER_THAN_OR_EQUAL_TO("greater-than-or-equal-to"),
        LESS_THAN("less-than"),
        LESS_THAN_OR_EQUAL_TO("less-than-or-equal-to"),
        SUBSTRING("substring");

        private final String name;

        private MatchingRuleType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

