/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.GenericConstraint;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.CharacterSetPasswordValidatorCfgClient;
import org.forgerock.opendj.server.config.meta.PasswordValidatorCfgDefn;
import org.forgerock.opendj.server.config.server.CharacterSetPasswordValidatorCfg;
import org.forgerock.opendj.server.config.server.PasswordValidatorCfg;

public final class CharacterSetPasswordValidatorCfgDefn
extends ManagedObjectDefinition<CharacterSetPasswordValidatorCfgClient, CharacterSetPasswordValidatorCfg> {
    private static final CharacterSetPasswordValidatorCfgDefn INSTANCE = new CharacterSetPasswordValidatorCfgDefn();
    private static final BooleanPropertyDefinition PD_ALLOW_UNCLASSIFIED_CHARACTERS;
    private static final StringPropertyDefinition PD_CHARACTER_SET;
    private static final StringPropertyDefinition PD_CHARACTER_SET_RANGES;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final IntegerPropertyDefinition PD_MIN_CHARACTER_SETS;

    public static CharacterSetPasswordValidatorCfgDefn getInstance() {
        return INSTANCE;
    }

    private CharacterSetPasswordValidatorCfgDefn() {
        super("character-set-password-validator", PasswordValidatorCfgDefn.getInstance());
    }

    @Override
    public CharacterSetPasswordValidatorCfgClient createClientConfiguration(ManagedObject<? extends CharacterSetPasswordValidatorCfgClient> impl) {
        return new CharacterSetPasswordValidatorCfgClientImpl(impl);
    }

    @Override
    public CharacterSetPasswordValidatorCfg createServerConfiguration(ServerManagedObject<? extends CharacterSetPasswordValidatorCfg> impl) {
        return new CharacterSetPasswordValidatorCfgServerImpl(impl);
    }

    @Override
    public Class<CharacterSetPasswordValidatorCfg> getServerConfigurationClass() {
        return CharacterSetPasswordValidatorCfg.class;
    }

    public BooleanPropertyDefinition getAllowUnclassifiedCharactersPropertyDefinition() {
        return PD_ALLOW_UNCLASSIFIED_CHARACTERS;
    }

    public StringPropertyDefinition getCharacterSetPropertyDefinition() {
        return PD_CHARACTER_SET;
    }

    public StringPropertyDefinition getCharacterSetRangesPropertyDefinition() {
        return PD_CHARACTER_SET_RANGES;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PasswordValidatorCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public IntegerPropertyDefinition getMinCharacterSetsPropertyDefinition() {
        return PD_MIN_CHARACTER_SETS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "allow-unclassified-characters");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allow-unclassified-characters"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ALLOW_UNCLASSIFIED_CHARACTERS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOW_UNCLASSIFIED_CHARACTERS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "character-set");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "character-set"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "character-set"));
        ((StringPropertyDefinition.Builder)builder).setCaseInsensitive(false);
        PD_CHARACTER_SET = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CHARACTER_SET);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "character-set-ranges");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "character-set-ranges"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "character-set-ranges"));
        ((StringPropertyDefinition.Builder)builder).setCaseInsensitive(false);
        PD_CHARACTER_SET_RANGES = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CHARACTER_SET_RANGES);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.CharacterSetPasswordValidator");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.PasswordValidator");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "min-character-sets");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "min-character-sets"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "min-character-sets"));
        PD_MIN_CHARACTER_SETS = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MIN_CHARACTER_SETS);
        INSTANCE.registerTag(Tag.valueOf("user-management"));
        INSTANCE.registerConstraint(new GenericConstraint(INSTANCE, 1, Conditions.or(Conditions.isPresent("character-set"), Conditions.isPresent("character-set-ranges"))));
    }

    private static class CharacterSetPasswordValidatorCfgServerImpl
    implements CharacterSetPasswordValidatorCfg {
        private ServerManagedObject<? extends CharacterSetPasswordValidatorCfg> impl;
        private final boolean pAllowUnclassifiedCharacters;
        private final SortedSet<String> pCharacterSet;
        private final SortedSet<String> pCharacterSetRanges;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final Integer pMinCharacterSets;

        private CharacterSetPasswordValidatorCfgServerImpl(ServerManagedObject<? extends CharacterSetPasswordValidatorCfg> impl) {
            this.impl = impl;
            this.pAllowUnclassifiedCharacters = impl.getPropertyValue(INSTANCE.getAllowUnclassifiedCharactersPropertyDefinition());
            this.pCharacterSet = impl.getPropertyValues((PropertyDefinition)INSTANCE.getCharacterSetPropertyDefinition());
            this.pCharacterSetRanges = impl.getPropertyValues((PropertyDefinition)INSTANCE.getCharacterSetRangesPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pMinCharacterSets = impl.getPropertyValue(INSTANCE.getMinCharacterSetsPropertyDefinition());
        }

        @Override
        public void addCharacterSetChangeListener(ConfigurationChangeListener<CharacterSetPasswordValidatorCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeCharacterSetChangeListener(ConfigurationChangeListener<CharacterSetPasswordValidatorCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<PasswordValidatorCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<PasswordValidatorCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isAllowUnclassifiedCharacters() {
            return this.pAllowUnclassifiedCharacters;
        }

        @Override
        public SortedSet<String> getCharacterSet() {
            return this.pCharacterSet;
        }

        @Override
        public SortedSet<String> getCharacterSetRanges() {
            return this.pCharacterSetRanges;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Integer getMinCharacterSets() {
            return this.pMinCharacterSets;
        }

        @Override
        public Class<? extends CharacterSetPasswordValidatorCfg> configurationClass() {
            return CharacterSetPasswordValidatorCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class CharacterSetPasswordValidatorCfgClientImpl
    implements CharacterSetPasswordValidatorCfgClient {
        private ManagedObject<? extends CharacterSetPasswordValidatorCfgClient> impl;

        private CharacterSetPasswordValidatorCfgClientImpl(ManagedObject<? extends CharacterSetPasswordValidatorCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isAllowUnclassifiedCharacters() {
            return this.impl.getPropertyValue(INSTANCE.getAllowUnclassifiedCharactersPropertyDefinition());
        }

        @Override
        public void setAllowUnclassifiedCharacters(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAllowUnclassifiedCharactersPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getCharacterSet() {
            return this.impl.getPropertyValues(INSTANCE.getCharacterSetPropertyDefinition());
        }

        @Override
        public void setCharacterSet(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getCharacterSetPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getCharacterSetRanges() {
            return this.impl.getPropertyValues(INSTANCE.getCharacterSetRangesPropertyDefinition());
        }

        @Override
        public void setCharacterSetRanges(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getCharacterSetRangesPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public Integer getMinCharacterSets() {
            return this.impl.getPropertyValue(INSTANCE.getMinCharacterSetsPropertyDefinition());
        }

        @Override
        public void setMinCharacterSets(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getMinCharacterSetsPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends CharacterSetPasswordValidatorCfgClient, ? extends CharacterSetPasswordValidatorCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }
    }
}

