/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.server;

import com.forgerock.opendj.ldap.AdminMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbsoluteInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.DefaultBehaviorProviderVisitor;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.DefinitionResolver;
import org.forgerock.opendj.config.LDAPProfile;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyNotFoundException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.Reference;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.RelativeInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConfigExceptionFactory;
import org.forgerock.opendj.config.server.ConstraintViolationException;
import org.forgerock.opendj.config.server.DNBuilder;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.config.server.ServerManagedObjectDecodingException;
import org.forgerock.opendj.config.server.spi.ConfigurationRepository;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.server.config.meta.RootCfgDefn;
import org.forgerock.opendj.server.config.server.RootCfg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerManagementContext {
    private static final Logger debugLogger = LoggerFactory.getLogger(ServerManagementContext.class);
    private volatile ServerManagedObject<RootCfg> root;
    private final ConfigurationRepository configRepository;

    public ServerManagementContext(ConfigurationRepository repository) {
        this.configRepository = repository;
    }

    public <C extends ConfigurationClient, S extends Configuration> ServerManagedObject<? extends S> getManagedObject(ManagedObjectPath<C, S> path) throws ConfigException {
        if (path.isEmpty()) {
            return this.getRootConfigurationManagedObject();
        }
        DN targetDN = DNBuilder.create(path);
        Entry configEntry = this.getManagedObjectConfigEntry(targetDN);
        try {
            ServerManagedObject<S> managedObject = this.decode(path, configEntry);
            managedObject.ensureIsUsable();
            return managedObject;
        }
        catch (DefinitionDecodingException e) {
            throw ConfigExceptionFactory.getInstance().createDecodingExceptionAdaptor(targetDN, e);
        }
        catch (ServerManagedObjectDecodingException e) {
            throw ConfigExceptionFactory.getInstance().createDecodingExceptionAdaptor(e);
        }
        catch (ConstraintViolationException e) {
            throw ConfigExceptionFactory.getInstance().createDecodingExceptionAdaptor(e);
        }
    }

    public <C extends ConfigurationClient, S extends Configuration, P> P getPropertyValue(ManagedObjectPath<C, S> path, PropertyDefinition<P> pd) throws ConfigException {
        SortedSet<P> values = this.getPropertyValues(path, pd);
        if (!values.isEmpty()) {
            return values.first();
        }
        return null;
    }

    public <C extends ConfigurationClient, S extends Configuration, P> SortedSet<P> getPropertyValues(ManagedObjectPath<C, S> path, PropertyDefinition<P> propertyDef) throws ConfigException {
        ManagedObjectDefinition<C, S> managedObjDef;
        AbstractManagedObjectDefinition<C, S> definition = path.getManagedObjectDefinition();
        PropertyDefinition<?> tmpPropertyDef = definition.getPropertyDefinition(propertyDef.getName());
        if (tmpPropertyDef != propertyDef) {
            throw new IllegalArgumentException("The property " + propertyDef.getName() + " is not associated with a " + definition.getName());
        }
        DN dn = DNBuilder.create(path);
        Entry configEntry = this.getManagedObjectConfigEntry(dn);
        MyDefinitionResolver resolver = new MyDefinitionResolver(configEntry);
        try {
            managedObjDef = definition.resolveManagedObjectDefinition(resolver);
        }
        catch (DefinitionDecodingException e) {
            throw ConfigExceptionFactory.getInstance().createDecodingExceptionAdaptor(dn, e);
        }
        propertyDef = managedObjDef.getPropertyDefinition(propertyDef.getName());
        List<String> attributeValues = this.getAttributeValues(managedObjDef, propertyDef, configEntry);
        return this.decodeProperty(path.asSubType(managedObjDef), propertyDef, attributeValues, null);
    }

    public RootCfg getRootConfiguration() {
        return this.getRootConfigurationManagedObject().getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerManagedObject<RootCfg> getRootConfigurationManagedObject() {
        ServerManagedObject<RootCfg> rootObject = this.root;
        if (rootObject == null) {
            ServerManagementContext serverManagementContext = this;
            synchronized (serverManagementContext) {
                rootObject = this.root;
                if (rootObject == null) {
                    this.root = rootObject = new ServerManagedObject<RootCfg>(ManagedObjectPath.emptyPath(), RootCfgDefn.getInstance(), Collections.emptyMap(), null, this);
                }
            }
        }
        return rootObject;
    }

    public <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> parent, RelationDefinition<C, S> relationDef) {
        Set<DN> children;
        this.validateRelationDefinition(parent, relationDef);
        DN targetDN = DNBuilder.create(parent, relationDef);
        try {
            children = this.configRepository.getChildren(targetDN);
        }
        catch (ConfigException e) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>(children.size());
        for (DN child : children) {
            String name = child.rdn().getFirstAVA().getAttributeValue().toString().trim();
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }

    public boolean managedObjectExists(ManagedObjectPath<?, ?> path) {
        DN targetDN = DNBuilder.create(path);
        try {
            return this.configRepository.getEntry(targetDN) != null;
        }
        catch (ConfigException e) {
            return false;
        }
    }

    <C extends ConfigurationClient, S extends Configuration> ServerManagedObject<? extends S> decode(ManagedObjectPath<C, S> path, Entry configEntry) throws DefinitionDecodingException, ServerManagedObjectDecodingException {
        return this.decode(path, configEntry, null);
    }

    <C extends ConfigurationClient, S extends Configuration> ServerManagedObject<? extends S> decode(ManagedObjectPath<C, S> path, Entry configEntry, Entry newConfigEntry) throws DefinitionDecodingException, ServerManagedObjectDecodingException {
        MyDefinitionResolver resolver = new MyDefinitionResolver(configEntry);
        AbstractManagedObjectDefinition<C, S> d = path.getManagedObjectDefinition();
        ManagedObjectDefinition<C, S> mod = d.resolveManagedObjectDefinition(resolver);
        LinkedList<PropertyException> exceptions = new LinkedList<PropertyException>();
        HashMap properties = new HashMap();
        for (PropertyDefinition<?> propertyDef : mod.getAllPropertyDefinitions()) {
            List<String> attributeValues = this.getAttributeValues(mod, propertyDef, configEntry);
            try {
                SortedSet<?> pvalues = this.decodeProperty(path, propertyDef, attributeValues, newConfigEntry);
                properties.put(propertyDef, pvalues);
            }
            catch (PropertyException e) {
                exceptions.add(e);
            }
        }
        ServerManagedObject<S> managedObject = this.decodeAux(path, mod, properties, configEntry.getName());
        if (exceptions.isEmpty()) {
            return managedObject;
        }
        throw new ServerManagedObjectDecodingException(managedObject, exceptions);
    }

    private <C extends ConfigurationClient, S extends Configuration> ServerManagedObject<S> decodeAux(ManagedObjectPath<? super C, ? super S> path, ManagedObjectDefinition<C, S> d, Map<PropertyDefinition<?>, SortedSet<?>> properties, DN configDN) {
        ManagedObjectPath<C, S> newPath = path.asSubType(d);
        return new ServerManagedObject<S>(newPath, d, properties, configDN, this);
    }

    private <T> SortedSet<T> decodeProperty(ManagedObjectPath<?, ?> path, PropertyDefinition<T> propertyDef, List<String> attributeValues, Entry newConfigEntry) {
        PropertyException exception = null;
        TreeSet<T> pvalues = new TreeSet<T>(propertyDef);
        if (attributeValues.size() > 0) {
            for (String value : attributeValues) {
                try {
                    pvalues.add(ValueDecoder.decode(propertyDef, value));
                }
                catch (PropertyException e) {
                    exception = e;
                }
            }
        } else {
            try {
                pvalues.addAll(this.getDefaultValues(path, propertyDef, newConfigEntry));
            }
            catch (PropertyException e) {
                exception = e;
            }
        }
        if (pvalues.size() > 1 && !propertyDef.hasOption(PropertyOption.MULTI_VALUED)) {
            exception = PropertyException.propertyIsSingleValuedException(propertyDef);
            Object value = pvalues.first();
            pvalues.clear();
            pvalues.add(value);
        }
        if (pvalues.isEmpty() && propertyDef.hasOption(PropertyOption.MANDATORY) && exception == null) {
            exception = PropertyException.propertyIsMandatoryException(propertyDef);
        }
        if (exception != null) {
            throw exception;
        }
        return pvalues;
    }

    private List<String> getAttributeValues(ManagedObjectDefinition<?, ?> d, PropertyDefinition<?> pd, Entry configEntry) {
        String attrID = LDAPProfile.getInstance().getAttributeName(d, pd);
        AttributeType type = Schema.getDefaultSchema().getAttributeType(attrID);
        Iterable attributes = configEntry.getAllAttributes(AttributeDescription.create((AttributeType)type));
        ArrayList<String> values = new ArrayList<String>();
        for (Attribute attribute : attributes) {
            for (ByteString byteValue : attribute) {
                values.add(byteValue.toString());
            }
        }
        return values;
    }

    private <T> Collection<T> getDefaultValues(ManagedObjectPath<?, ?> p, PropertyDefinition<T> pd, Entry newConfigEntry) {
        DefaultValueFinder v = new DefaultValueFinder(newConfigEntry);
        return v.find(p, pd);
    }

    public Entry getConfigEntry(DN dn) throws ConfigException {
        return this.configRepository.getEntry(dn);
    }

    public ConfigurationRepository getConfigRepository() {
        return this.configRepository;
    }

    private Entry getManagedObjectConfigEntry(DN dn) throws ConfigException {
        Entry configEntry;
        try {
            configEntry = this.configRepository.getEntry(dn);
        }
        catch (ConfigException e) {
            debugLogger.trace("Unable to perform post add", (Throwable)e);
            LocalizableMessage message = AdminMessages.ERR_ADMIN_CANNOT_GET_MANAGED_OBJECT.get((Object)String.valueOf(dn), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
            throw new ConfigException(message, (Throwable)e);
        }
        if (configEntry == null) {
            LocalizableMessage message = AdminMessages.ERR_ADMIN_MANAGED_OBJECT_DOES_NOT_EXIST.get((Object)String.valueOf(dn));
            throw new ConfigException(message);
        }
        return configEntry;
    }

    private void validateRelationDefinition(ManagedObjectPath<?, ?> path, RelationDefinition<?, ?> rd) {
        AbstractManagedObjectDefinition<?, ?> d = path.getManagedObjectDefinition();
        RelationDefinition<?, ?> tmp = d.getRelationDefinition(rd.getName());
        if (tmp != rd) {
            throw new IllegalArgumentException("The relation " + rd.getName() + " is not associated with a " + d.getName());
        }
    }

    private static final class ValueDecoder
    extends PropertyDefinitionVisitor<Object, String> {
        public static <P> P decode(PropertyDefinition<P> propertyDef, String value) {
            return propertyDef.castValue(propertyDef.accept(new ValueDecoder(), value));
        }

        private ValueDecoder() {
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Object visitAggregation(AggregationPropertyDefinition<C, S> d, String p) {
            try {
                Reference<C, S> reference = Reference.parseDN(d.getParentPath(), d.getRelationDefinition(), p);
                return reference.getName();
            }
            catch (IllegalArgumentException e) {
                throw PropertyException.illegalPropertyValueException(d, p);
            }
        }

        @Override
        public <T> Object visitUnknown(PropertyDefinition<T> d, String p) {
            return d.decodeValue(p);
        }
    }

    private static final class MyDefinitionResolver
    implements DefinitionResolver {
        private final Entry entry;

        private MyDefinitionResolver(Entry entry) {
            this.entry = entry;
        }

        @Override
        public boolean matches(AbstractManagedObjectDefinition<?, ?> d) {
            String oc = LDAPProfile.getInstance().getObjectClass(d);
            return this.entry.containsAttribute("objectClass", new Object[]{oc});
        }
    }

    private final class DefaultValueFinder<T>
    implements DefaultBehaviorProviderVisitor<T, Collection<T>, Void> {
        private PropertyException exception;
        private final Entry newConfigEntry;
        private ManagedObjectPath<?, ?> nextPath;
        private PropertyDefinition<T> nextProperty;

        private DefaultValueFinder(Entry newConfigEntry) {
            this.newConfigEntry = newConfigEntry;
        }

        @Override
        public Collection<T> visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, Void p) {
            try {
                return this.getInheritedProperty(d.getManagedObjectPath(), d.getManagedObjectDefinition(), d.getPropertyName());
            }
            catch (PropertyException e) {
                this.exception = e;
                return Collections.emptySet();
            }
        }

        @Override
        public Collection<T> visitAlias(AliasDefaultBehaviorProvider<T> d, Void p) {
            return Collections.emptySet();
        }

        @Override
        public Collection<T> visitDefined(DefinedDefaultBehaviorProvider<T> d, Void p) {
            Collection<String> stringValues = d.getDefaultValues();
            ArrayList<T> values = new ArrayList<T>(stringValues.size());
            for (String stringValue : stringValues) {
                try {
                    values.add(this.nextProperty.decodeValue(stringValue));
                }
                catch (PropertyException e) {
                    this.exception = PropertyException.defaultBehaviorException(this.nextProperty, e);
                    break;
                }
            }
            return values;
        }

        @Override
        public Collection<T> visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, Void p) {
            try {
                return this.getInheritedProperty(d.getManagedObjectPath(this.nextPath), d.getManagedObjectDefinition(), d.getPropertyName());
            }
            catch (PropertyException e) {
                this.exception = e;
                return Collections.emptySet();
            }
        }

        @Override
        public Collection<T> visitUndefined(UndefinedDefaultBehaviorProvider<T> d, Void p) {
            return Collections.emptySet();
        }

        private Collection<T> find(ManagedObjectPath<?, ?> path, PropertyDefinition<T> propertyDef) {
            this.nextPath = path;
            this.nextProperty = propertyDef;
            Collection values = (Collection)this.nextProperty.getDefaultBehaviorProvider().accept(this, null);
            if (this.exception != null) {
                throw this.exception;
            }
            if (values.size() > 1 && !propertyDef.hasOption(PropertyOption.MULTI_VALUED)) {
                throw PropertyException.defaultBehaviorException(propertyDef, PropertyException.propertyIsSingleValuedException(propertyDef));
            }
            return values;
        }

        private Collection<T> getInheritedProperty(ManagedObjectPath<?, ?> target, AbstractManagedObjectDefinition<?, ?> definition, String propertyName) {
            AbstractManagedObjectDefinition<?, ?> actual = target.getManagedObjectDefinition();
            if (!definition.isParentOf(actual)) {
                throw PropertyException.defaultBehaviorException(this.nextProperty, new DefinitionDecodingException(actual, DefinitionDecodingException.Reason.WRONG_TYPE_INFORMATION));
            }
            PropertyDefinition<T> propDef1 = this.nextProperty;
            try {
                PropertyDefinition propDef2;
                DN dn = DNBuilder.create(target);
                Entry configEntry = this.newConfigEntry != null && this.newConfigEntry.getName().equals((Object)dn) ? this.newConfigEntry : ServerManagementContext.this.getManagedObjectConfigEntry(dn);
                MyDefinitionResolver resolver = new MyDefinitionResolver(configEntry);
                ManagedObjectDefinition<?, ?> mod = definition.resolveManagedObjectDefinition(resolver);
                try {
                    PropertyDefinition<?> propDefTmp = mod.getPropertyDefinition(propertyName);
                    propDef2 = (PropertyDefinition)propDef1.getClass().cast(propDefTmp);
                }
                catch (ClassCastException | IllegalArgumentException e) {
                    throw new PropertyNotFoundException(propertyName);
                }
                List attributeValues = ServerManagementContext.this.getAttributeValues(mod, propDef2, configEntry);
                if (attributeValues.size() > 0) {
                    ArrayList<T> pvalues = new ArrayList<T>();
                    for (String value : attributeValues) {
                        pvalues.add(ValueDecoder.decode(propDef1, value));
                    }
                    return pvalues;
                }
                Collection<T> tmp = this.find(target, propDef2);
                ArrayList<T> pvalues = new ArrayList<T>(tmp.size());
                for (T value : tmp) {
                    propDef1.validateValue(value);
                    pvalues.add(value);
                }
                return pvalues;
            }
            catch (Exception e) {
                throw PropertyException.defaultBehaviorException(propDef1, e);
            }
        }
    }
}

