/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.server;

import com.forgerock.opendj.ldap.AdminMessages;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.Constraint;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.SingletonRelationDefinition;
import org.forgerock.opendj.config.server.ConfigAddListenerAdaptor;
import org.forgerock.opendj.config.server.ConfigChangeListenerAdaptor;
import org.forgerock.opendj.config.server.ConfigDeleteListenerAdaptor;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConfigurationAddListener;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ConfigurationDeleteListener;
import org.forgerock.opendj.config.server.ConstraintViolationException;
import org.forgerock.opendj.config.server.DNBuilder;
import org.forgerock.opendj.config.server.DelayedConfigAddListener;
import org.forgerock.opendj.config.server.ServerConstraintHandler;
import org.forgerock.opendj.config.server.ServerManagedObjectAddListener;
import org.forgerock.opendj.config.server.ServerManagedObjectAddListenerAdaptor;
import org.forgerock.opendj.config.server.ServerManagedObjectChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObjectChangeListenerAdaptor;
import org.forgerock.opendj.config.server.ServerManagedObjectDeleteListener;
import org.forgerock.opendj.config.server.ServerManagedObjectDeleteListenerAdaptor;
import org.forgerock.opendj.config.server.ServerManagementContext;
import org.forgerock.opendj.config.server.spi.ConfigAddListener;
import org.forgerock.opendj.config.server.spi.ConfigChangeListener;
import org.forgerock.opendj.config.server.spi.ConfigDeleteListener;
import org.forgerock.opendj.config.server.spi.ConfigurationRepository;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerManagedObject<S extends Configuration>
implements PropertyProvider {
    private static final Logger logger = LoggerFactory.getLogger(ServerManagedObject.class);
    private DN configDN;
    private final ServerManagementContext serverContext;
    private final ConfigurationRepository configRepository;
    private final ManagedObjectDefinition<?, S> definition;
    private final ManagedObjectPath<?, S> path;
    private final Map<PropertyDefinition<?>, SortedSet<?>> properties;

    ServerManagedObject(ManagedObjectPath<?, S> path, ManagedObjectDefinition<?, S> definition, Map<PropertyDefinition<?>, SortedSet<?>> properties, DN configDN, ServerManagementContext context) {
        this.definition = definition;
        this.path = path;
        this.properties = properties;
        this.configDN = configDN;
        this.serverContext = context;
        this.configRepository = context.getConfigRepository();
    }

    public <M extends Configuration> void deregisterAddListener(InstantiableRelationDefinition<?, M> d, ConfigurationAddListener<M> listener) {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        this.deregisterAddListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterAddListener(InstantiableRelationDefinition<?, M> d, ServerManagedObjectAddListener<M> listener) {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        this.deregisterAddListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterAddListener(OptionalRelationDefinition<?, M> d, ConfigurationAddListener<M> listener) {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).parent();
        this.deregisterAddListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterAddListener(OptionalRelationDefinition<?, M> d, ServerManagedObjectAddListener<M> listener) {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).parent();
        this.deregisterAddListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterAddListener(SetRelationDefinition<?, M> d, ConfigurationAddListener<M> listener) {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        this.deregisterAddListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterAddListener(SetRelationDefinition<?, M> d, ServerManagedObjectAddListener<M> listener) {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        this.deregisterAddListener(baseDN, listener);
    }

    public void deregisterChangeListener(ConfigurationChangeListener<? super S> listener) {
        for (ConfigChangeListener l : this.configRepository.getChangeListeners(this.configDN)) {
            ServerManagedObjectChangeListenerAdaptor adaptor2;
            ConfigChangeListenerAdaptor adaptor;
            ServerManagedObjectChangeListener l2;
            if (!(l instanceof ConfigChangeListenerAdaptor) || !((l2 = (adaptor = (ConfigChangeListenerAdaptor)l).getServerManagedObjectChangeListener()) instanceof ServerManagedObjectChangeListenerAdaptor) || (adaptor2 = (ServerManagedObjectChangeListenerAdaptor)l2).getConfigurationChangeListener() != listener) continue;
            adaptor.finalizeChangeListener();
            this.configRepository.deregisterChangeListener(this.configDN, adaptor);
        }
    }

    public void deregisterChangeListener(ServerManagedObjectChangeListener<? super S> listener) {
        for (ConfigChangeListener l : this.configRepository.getChangeListeners(this.configDN)) {
            ConfigChangeListenerAdaptor adaptor;
            if (!(l instanceof ConfigChangeListenerAdaptor) || (adaptor = (ConfigChangeListenerAdaptor)l).getServerManagedObjectChangeListener() != listener) continue;
            adaptor.finalizeChangeListener();
            this.configRepository.deregisterChangeListener(this.configDN, adaptor);
        }
    }

    public <M extends Configuration> void deregisterDeleteListener(InstantiableRelationDefinition<?, M> d, ConfigurationDeleteListener<M> listener) {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        this.deregisterDeleteListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterDeleteListener(InstantiableRelationDefinition<?, M> d, ServerManagedObjectDeleteListener<M> listener) {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        this.deregisterDeleteListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterDeleteListener(OptionalRelationDefinition<?, M> d, ConfigurationDeleteListener<M> listener) {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).parent();
        this.deregisterDeleteListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterDeleteListener(OptionalRelationDefinition<?, M> d, ServerManagedObjectDeleteListener<M> listener) {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).parent();
        this.deregisterDeleteListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterDeleteListener(SetRelationDefinition<?, M> d, ConfigurationDeleteListener<M> listener) {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        this.deregisterDeleteListener(baseDN, listener);
    }

    public <M extends Configuration> void deregisterDeleteListener(SetRelationDefinition<?, M> d, ServerManagedObjectDeleteListener<M> listener) {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        this.deregisterDeleteListener(baseDN, listener);
    }

    public <M extends Configuration> ServerManagedObject<? extends M> getChild(InstantiableRelationDefinition<?, M> d, String name) throws ConfigException {
        this.validateRelationDefinition(d);
        return this.serverContext.getManagedObject(this.path.child(d, name));
    }

    public <M extends Configuration> ServerManagedObject<? extends M> getChild(OptionalRelationDefinition<?, M> d) throws ConfigException {
        this.validateRelationDefinition(d);
        return this.serverContext.getManagedObject(this.path.child(d));
    }

    public <M extends Configuration> ServerManagedObject<? extends M> getChild(SetRelationDefinition<?, M> d, String name) throws ConfigException {
        this.validateRelationDefinition(d);
        return this.serverContext.getManagedObject(this.path.child(d, name));
    }

    public <M extends Configuration> ServerManagedObject<? extends M> getChild(SingletonRelationDefinition<?, M> d) throws ConfigException {
        this.validateRelationDefinition(d);
        return this.serverContext.getManagedObject(this.path.child(d));
    }

    public ServerManagementContext getServerContext() {
        return this.serverContext;
    }

    public S getConfiguration() {
        return this.definition.createServerConfiguration(this);
    }

    public DN getDN() {
        if (this.configDN != null) {
            return this.configDN;
        }
        return DN.rootDN();
    }

    public ManagedObjectDefinition<?, S> getManagedObjectDefinition() {
        return this.definition;
    }

    public ManagedObjectPath<?, S> getManagedObjectPath() {
        return this.path;
    }

    public <T> T getPropertyValue(PropertyDefinition<T> d) {
        Collection values = this.getPropertyValues((PropertyDefinition)d);
        if (!values.isEmpty()) {
            return (T)values.iterator().next();
        }
        return null;
    }

    public <T> SortedSet<T> getPropertyValues(PropertyDefinition<T> d) {
        if (!this.properties.containsKey(d)) {
            throw new IllegalArgumentException("Unknown property " + d.getName());
        }
        return Collections.unmodifiableSortedSet(this.properties.get(d));
    }

    public boolean hasChild(OptionalRelationDefinition<?, ?> d) {
        this.validateRelationDefinition(d);
        return this.serverContext.managedObjectExists(this.path.child(d));
    }

    public String[] listChildren(InstantiableRelationDefinition<?, ?> d) {
        this.validateRelationDefinition(d);
        return this.serverContext.listManagedObjects(this.path, d);
    }

    public String[] listChildren(SetRelationDefinition<?, ?> d) {
        this.validateRelationDefinition(d);
        return this.serverContext.listManagedObjects(this.path, d);
    }

    public <M extends Configuration> void registerAddListener(InstantiableRelationDefinition<?, M> d, ConfigurationAddListener<M> listener) throws ConfigException {
        this.registerAddListener(d, new ServerManagedObjectAddListenerAdaptor<M>(listener));
    }

    public <M extends Configuration> void registerAddListener(InstantiableRelationDefinition<?, M> d, ServerManagedObjectAddListener<M> listener) throws ConfigException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        ConfigAddListenerAdaptor<M> adaptor = new ConfigAddListenerAdaptor<M>(this.serverContext, this.path, d, listener);
        this.registerAddListener(baseDN, adaptor);
    }

    public <M extends Configuration> void registerAddListener(OptionalRelationDefinition<?, M> d, ConfigurationAddListener<M> listener) throws ConfigException {
        this.registerAddListener(d, new ServerManagedObjectAddListenerAdaptor<M>(listener));
    }

    public <M extends Configuration> void registerAddListener(OptionalRelationDefinition<?, M> d, ServerManagedObjectAddListener<M> listener) throws ConfigException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).parent();
        ConfigAddListenerAdaptor<M> adaptor = new ConfigAddListenerAdaptor<M>(this.serverContext, this.path, d, listener);
        this.registerAddListener(baseDN, adaptor);
    }

    public <M extends Configuration> void registerAddListener(SetRelationDefinition<?, M> d, ConfigurationAddListener<M> listener) throws ConfigException {
        this.registerAddListener(d, new ServerManagedObjectAddListenerAdaptor<M>(listener));
    }

    public <M extends Configuration> void registerAddListener(SetRelationDefinition<?, M> d, ServerManagedObjectAddListener<M> listener) throws ConfigException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        ConfigAddListenerAdaptor<M> adaptor = new ConfigAddListenerAdaptor<M>(this.serverContext, this.path, d, listener);
        this.registerAddListener(baseDN, adaptor);
    }

    public void registerChangeListener(ConfigurationChangeListener<? super S> listener) {
        this.registerChangeListener(new ServerManagedObjectChangeListenerAdaptor<S>(listener));
    }

    public void registerChangeListener(ServerManagedObjectChangeListener<? super S> listener) {
        ConfigChangeListenerAdaptor<? super S> adaptor = new ConfigChangeListenerAdaptor<S>(this.serverContext, this.path, listener);
        this.configRepository.registerChangeListener(this.configDN, adaptor);
        for (Constraint constraint : this.definition.getAllConstraints()) {
            for (ServerConstraintHandler handler : constraint.getServerConstraintHandlers()) {
                try {
                    handler.performPostAdd(this);
                }
                catch (ConfigException e) {
                    logger.trace("Unable to perform post add", (Throwable)e);
                }
            }
        }
    }

    public <M extends Configuration> void registerDeleteListener(InstantiableRelationDefinition<?, M> d, ConfigurationDeleteListener<M> listener) throws ConfigException {
        this.registerDeleteListener(d, new ServerManagedObjectDeleteListenerAdaptor<M>(listener));
    }

    public <M extends Configuration> void registerDeleteListener(InstantiableRelationDefinition<?, M> d, ServerManagedObjectDeleteListener<M> listener) throws ConfigException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        ConfigDeleteListenerAdaptor<M> adaptor = new ConfigDeleteListenerAdaptor<M>(this.serverContext, this.path, d, listener);
        this.registerDeleteListener(baseDN, adaptor);
    }

    public <M extends Configuration> void registerDeleteListener(OptionalRelationDefinition<?, M> d, ConfigurationDeleteListener<M> listener) throws ConfigException {
        this.registerDeleteListener(d, new ServerManagedObjectDeleteListenerAdaptor<M>(listener));
    }

    public <M extends Configuration> void registerDeleteListener(OptionalRelationDefinition<?, M> d, ServerManagedObjectDeleteListener<M> listener) throws ConfigException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d).parent();
        ConfigDeleteListenerAdaptor<M> adaptor = new ConfigDeleteListenerAdaptor<M>(this.serverContext, this.path, d, listener);
        this.registerDeleteListener(baseDN, adaptor);
    }

    public <M extends Configuration> void registerDeleteListener(SetRelationDefinition<?, M> d, ConfigurationDeleteListener<M> listener) throws ConfigException {
        this.registerDeleteListener(d, new ServerManagedObjectDeleteListenerAdaptor<M>(listener));
    }

    public <M extends Configuration> void registerDeleteListener(SetRelationDefinition<?, M> d, ServerManagedObjectDeleteListener<M> listener) throws ConfigException {
        this.validateRelationDefinition(d);
        DN baseDN = DNBuilder.create(this.path, d);
        ConfigDeleteListenerAdaptor<M> adaptor = new ConfigDeleteListenerAdaptor<M>(this.serverContext, this.path, d, listener);
        this.registerDeleteListener(baseDN, adaptor);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ TYPE=");
        builder.append(this.definition.getName());
        builder.append(", DN=\"");
        builder.append(this.getDN());
        builder.append('\"');
        for (Map.Entry<PropertyDefinition<?>, SortedSet<?>> value : this.properties.entrySet()) {
            builder.append(", ");
            builder.append(value.getKey().getName());
            builder.append('=');
            builder.append(value.getValue());
        }
        builder.append(" }");
        return builder.toString();
    }

    void ensureIsUsable() throws ConstraintViolationException {
        boolean isUsable = true;
        LinkedList<LocalizableMessage> reasons = new LinkedList<LocalizableMessage>();
        for (Constraint constraint : this.definition.getAllConstraints()) {
            for (ServerConstraintHandler handler : constraint.getServerConstraintHandlers()) {
                try {
                    if (handler.isUsable(this, reasons)) continue;
                    isUsable = false;
                }
                catch (ConfigException e) {
                    LocalizableMessage message = AdminMessages.ERR_SERVER_CONSTRAINT_EXCEPTION.get((Object)e.getMessageObject());
                    reasons.add(message);
                    isUsable = false;
                }
            }
        }
        if (!isUsable) {
            throw new ConstraintViolationException(this, reasons);
        }
    }

    void setConfigDN(DN configDN) {
        this.configDN = configDN;
    }

    private <M extends Configuration> void deregisterAddListener(DN baseDN, ConfigurationAddListener<M> listener) {
        try {
            if (this.configRepository.hasEntry(baseDN)) {
                for (ConfigAddListener configListener : this.configRepository.getAddListeners(baseDN)) {
                    ServerManagedObjectAddListenerAdaptor adaptor2;
                    ConfigAddListenerAdaptor adaptor;
                    ServerManagedObjectAddListener smoListener;
                    if (!(configListener instanceof ConfigAddListenerAdaptor) || !((smoListener = (adaptor = (ConfigAddListenerAdaptor)configListener).getServerManagedObjectAddListener()) instanceof ServerManagedObjectAddListenerAdaptor) || (adaptor2 = (ServerManagedObjectAddListenerAdaptor)smoListener).getConfigurationAddListener() != listener) continue;
                    this.configRepository.deregisterAddListener(baseDN, adaptor);
                }
            } else {
                this.deregisterDelayedAddListener(baseDN, listener);
            }
        }
        catch (ConfigException e) {
            logger.trace("Unable to deregister add listener", (Throwable)e);
        }
    }

    private <M extends Configuration> void deregisterAddListener(DN baseDN, ServerManagedObjectAddListener<M> listener) {
        try {
            if (this.configRepository.hasEntry(baseDN)) {
                for (ConfigAddListener configListener : this.configRepository.getAddListeners(baseDN)) {
                    ConfigAddListenerAdaptor adaptor;
                    if (!(configListener instanceof ConfigAddListenerAdaptor) || (adaptor = (ConfigAddListenerAdaptor)configListener).getServerManagedObjectAddListener() != listener) continue;
                    this.configRepository.deregisterAddListener(baseDN, adaptor);
                }
            } else {
                this.deregisterDelayedAddListener(baseDN, listener);
            }
        }
        catch (ConfigException e) {
            logger.trace("Unable to deregister add listener", (Throwable)e);
        }
    }

    static <T extends Configuration> Pair<ConfigAddListenerAdaptor<T>, ConfigurationAddListener<T>> extractInitialListener(ConfigAddListener configListener) {
        Pair<ConfigAddListenerAdaptor<T>, ServerManagedObjectAddListener<T>> pair = ServerManagedObject.extractIntermediateListener(configListener);
        if (!pair.equals((Object)Pair.EMPTY) && pair.getSecond() instanceof ServerManagedObjectAddListenerAdaptor) {
            ServerManagedObjectAddListenerAdaptor adaptor2 = (ServerManagedObjectAddListenerAdaptor)pair.getSecond();
            return Pair.of((Object)pair.getFirst(), adaptor2.getConfigurationAddListener());
        }
        return Pair.empty();
    }

    static <T extends Configuration> Pair<ConfigAddListenerAdaptor<T>, ServerManagedObjectAddListener<T>> extractIntermediateListener(ConfigAddListener configListener) {
        if (configListener instanceof ConfigAddListenerAdaptor) {
            ConfigAddListenerAdaptor adaptor = (ConfigAddListenerAdaptor)configListener;
            return Pair.of((Object)adaptor, adaptor.getServerManagedObjectAddListener());
        }
        return Pair.empty();
    }

    private <M extends Configuration> void deregisterDeleteListener(DN baseDN, ConfigurationDeleteListener<M> listener) {
        try {
            if (this.configRepository.hasEntry(baseDN)) {
                for (ConfigDeleteListener l : this.configRepository.getDeleteListeners(baseDN)) {
                    ServerManagedObjectDeleteListenerAdaptor adaptor2;
                    ConfigDeleteListenerAdaptor adaptor;
                    ServerManagedObjectDeleteListener l2;
                    if (!(l instanceof ConfigDeleteListenerAdaptor) || !((l2 = (adaptor = (ConfigDeleteListenerAdaptor)l).getServerManagedObjectDeleteListener()) instanceof ServerManagedObjectDeleteListenerAdaptor) || (adaptor2 = (ServerManagedObjectDeleteListenerAdaptor)l2).getConfigurationDeleteListener() != listener) continue;
                    this.configRepository.deregisterDeleteListener(baseDN, adaptor);
                }
            } else {
                this.deregisterDelayedDeleteListener(baseDN, listener);
            }
        }
        catch (ConfigException e) {
            logger.trace("Unable to deregister delete listener", (Throwable)e);
        }
    }

    private <M extends Configuration> void deregisterDeleteListener(DN baseDN, ServerManagedObjectDeleteListener<M> listener) {
        try {
            if (this.configRepository.hasEntry(baseDN)) {
                for (ConfigDeleteListener l : this.configRepository.getDeleteListeners(baseDN)) {
                    ConfigDeleteListenerAdaptor adaptor;
                    if (!(l instanceof ConfigDeleteListenerAdaptor) || (adaptor = (ConfigDeleteListenerAdaptor)l).getServerManagedObjectDeleteListener() != listener) continue;
                    this.configRepository.deregisterDeleteListener(baseDN, adaptor);
                }
            } else {
                this.deregisterDelayedDeleteListener(baseDN, listener);
            }
        }
        catch (ConfigException e) {
            logger.trace("Unable to deregister delete listener", (Throwable)e);
        }
    }

    private void registerAddListener(DN baseDN, ConfigAddListener adaptor) throws ConfigException {
        if (this.configRepository.hasEntry(baseDN)) {
            this.configRepository.registerAddListener(baseDN, adaptor);
        } else {
            DelayedConfigAddListener delayedListener = new DelayedConfigAddListener(baseDN, adaptor, this.configRepository);
            this.registerDelayedListener(baseDN, delayedListener);
        }
    }

    private void registerDelayedListener(DN baseDN, ConfigAddListener delayedListener) throws ConfigException {
        DN currentDN;
        DN previousDN = currentDN = baseDN.parent();
        while (currentDN != null) {
            if (!this.configRepository.hasEntry(currentDN)) {
                delayedListener = new DelayedConfigAddListener(currentDN, delayedListener, this.configRepository);
                previousDN = currentDN;
                currentDN = currentDN.parent();
                continue;
            }
            this.configRepository.registerAddListener(previousDN, delayedListener);
            return;
        }
        LocalizableMessage message = AdminMessages.ERR_ADMIN_UNABLE_TO_REGISTER_LISTENER.get((Object)String.valueOf(baseDN));
        throw new ConfigException(message);
    }

    private <M extends Configuration> void deregisterDelayedAddListener(DN baseDN, ConfigurationAddListener<M> listener) throws ConfigException {
        DN parentDN = baseDN.parent();
        int delayWrappers = 0;
        while (parentDN != null) {
            if (!this.configRepository.hasEntry(parentDN)) {
                parentDN = parentDN.parent();
                ++delayWrappers;
                continue;
            }
            for (ConfigAddListener configListener : this.configRepository.getAddListeners(parentDN)) {
                ServerManagedObjectAddListenerAdaptor adaptor2;
                ConfigAddListenerAdaptor adaptor;
                ServerManagedObjectAddListener l2;
                ConfigAddListener delayedListener;
                ConfigAddListener wrappedListener;
                int i;
                if (!(configListener instanceof DelayedConfigAddListener)) continue;
                DelayedConfigAddListener delayListener = (DelayedConfigAddListener)configListener;
                for (i = delayWrappers; i > 0 && (wrappedListener = delayListener.getDelayedAddListener()) instanceof DelayedConfigAddListener; --i) {
                    delayListener = (DelayedConfigAddListener)configListener;
                }
                if (i > 0 || !((delayedListener = delayListener.getDelayedAddListener()) instanceof ConfigAddListenerAdaptor) || !((l2 = (adaptor = (ConfigAddListenerAdaptor)delayedListener).getServerManagedObjectAddListener()) instanceof ServerManagedObjectAddListenerAdaptor) || (adaptor2 = (ServerManagedObjectAddListenerAdaptor)l2).getConfigurationAddListener() != listener) continue;
                this.configRepository.deregisterAddListener(parentDN, configListener);
            }
            return;
        }
    }

    private <M extends Configuration> void deregisterDelayedDeleteListener(DN baseDN, ConfigurationDeleteListener<M> listener) throws ConfigException {
        DN parentDN = baseDN.parent();
        int delayWrappers = 0;
        while (parentDN != null) {
            if (!this.configRepository.hasEntry(parentDN)) {
                parentDN = parentDN.parent();
                ++delayWrappers;
                continue;
            }
            for (ConfigAddListener l : this.configRepository.getAddListeners(parentDN)) {
                ServerManagedObjectDeleteListenerAdaptor adaptor2;
                ConfigDeleteListenerAdaptor adaptor;
                ServerManagedObjectDeleteListener l2;
                ConfigDeleteListener delayedListener;
                ConfigAddListener wrappedListener;
                int i;
                if (!(l instanceof DelayedConfigAddListener)) continue;
                DelayedConfigAddListener delayListener = (DelayedConfigAddListener)l;
                for (i = delayWrappers; i > 0 && (wrappedListener = delayListener.getDelayedAddListener()) instanceof DelayedConfigAddListener; --i) {
                    delayListener = (DelayedConfigAddListener)l;
                }
                if (i > 0 || !((delayedListener = delayListener.getDelayedDeleteListener()) instanceof ConfigDeleteListenerAdaptor) || !((l2 = (adaptor = (ConfigDeleteListenerAdaptor)delayedListener).getServerManagedObjectDeleteListener()) instanceof ServerManagedObjectDeleteListenerAdaptor) || (adaptor2 = (ServerManagedObjectDeleteListenerAdaptor)l2).getConfigurationDeleteListener() != listener) continue;
                this.configRepository.deregisterAddListener(parentDN, l);
            }
            return;
        }
    }

    private <M extends Configuration> void deregisterDelayedAddListener(DN baseDN, ServerManagedObjectAddListener<M> listener) throws ConfigException {
        DN parentDN = baseDN.parent();
        int delayWrappers = 0;
        while (parentDN != null) {
            if (!this.configRepository.hasEntry(parentDN)) {
                parentDN = parentDN.parent();
                ++delayWrappers;
                continue;
            }
            for (ConfigAddListener configListener : this.configRepository.getAddListeners(parentDN)) {
                ConfigAddListenerAdaptor adaptor;
                ConfigAddListener delayedListener;
                ConfigAddListener wrappedListener;
                int i;
                if (!(configListener instanceof DelayedConfigAddListener)) continue;
                DelayedConfigAddListener delayListener = (DelayedConfigAddListener)configListener;
                for (i = delayWrappers; i > 0 && (wrappedListener = delayListener.getDelayedAddListener()) instanceof DelayedConfigAddListener; --i) {
                    delayListener = (DelayedConfigAddListener)configListener;
                }
                if (i > 0 || !((delayedListener = delayListener.getDelayedAddListener()) instanceof ConfigAddListenerAdaptor) || (adaptor = (ConfigAddListenerAdaptor)delayedListener).getServerManagedObjectAddListener() != listener) continue;
                this.configRepository.deregisterAddListener(parentDN, configListener);
            }
            return;
        }
    }

    private <M extends Configuration> void deregisterDelayedDeleteListener(DN baseDN, ServerManagedObjectDeleteListener<M> listener) throws ConfigException {
        DN parentDN = baseDN.parent();
        int delayWrappers = 0;
        while (parentDN != null) {
            if (!this.configRepository.hasEntry(parentDN)) {
                parentDN = parentDN.parent();
                ++delayWrappers;
                continue;
            }
            for (ConfigAddListener configListener : this.configRepository.getAddListeners(parentDN)) {
                ConfigDeleteListenerAdaptor adaptor;
                ConfigDeleteListener delayedListener;
                ConfigAddListener wrappedListener;
                int i;
                if (!(configListener instanceof DelayedConfigAddListener)) continue;
                DelayedConfigAddListener delayListener = (DelayedConfigAddListener)configListener;
                for (i = delayWrappers; i > 0 && (wrappedListener = delayListener.getDelayedAddListener()) instanceof DelayedConfigAddListener; --i) {
                    delayListener = (DelayedConfigAddListener)configListener;
                }
                if (i > 0 || !((delayedListener = delayListener.getDelayedDeleteListener()) instanceof ConfigDeleteListenerAdaptor) || (adaptor = (ConfigDeleteListenerAdaptor)delayedListener).getServerManagedObjectDeleteListener() != listener) continue;
                this.configRepository.deregisterAddListener(parentDN, configListener);
            }
            return;
        }
    }

    private void registerDeleteListener(DN baseDN, ConfigDeleteListener adaptor) throws ConfigException {
        if (this.configRepository.hasEntry(baseDN)) {
            this.configRepository.registerDeleteListener(baseDN, adaptor);
        } else {
            DelayedConfigAddListener delayedListener = new DelayedConfigAddListener(baseDN, adaptor, this.configRepository);
            this.registerDelayedListener(baseDN, delayedListener);
        }
    }

    private void validateRelationDefinition(RelationDefinition<?, ?> rd) {
        RelationDefinition<?, ?> tmp = this.definition.getRelationDefinition(rd.getName());
        if (tmp != rd) {
            throw new IllegalArgumentException("The relation " + rd.getName() + " is not associated with a " + this.definition.getName());
        }
    }
}

