/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ResultCode;

public final class ConfigChangeResult {
    private final List<LocalizableMessage> messages = new ArrayList<LocalizableMessage>();
    private boolean adminActionRequired;
    private ResultCode resultCode = ResultCode.SUCCESS;

    public ResultCode getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(ResultCode resultCode) {
        this.resultCode = resultCode;
    }

    public void setResultCodeIfSuccess(ResultCode newResultCode) {
        if (this.getResultCode() == ResultCode.SUCCESS) {
            this.setResultCode(newResultCode);
        }
    }

    public boolean adminActionRequired() {
        return this.adminActionRequired;
    }

    public void setAdminActionRequired(boolean adminActionRequired) {
        this.adminActionRequired = adminActionRequired;
    }

    public List<LocalizableMessage> getMessages() {
        return this.messages;
    }

    public void addMessage(LocalizableMessage message) {
        this.messages.add(message);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ConfigChangeResult(result=");
        buffer.append(this.resultCode);
        buffer.append(", adminActionRequired=");
        buffer.append(this.adminActionRequired);
        buffer.append(", messages={");
        if (!this.messages.isEmpty()) {
            Iterator<LocalizableMessage> iterator = this.messages.iterator();
            buffer.append((CharSequence)iterator.next());
            while (iterator.hasNext()) {
                buffer.append(",");
                buffer.append((CharSequence)iterator.next());
            }
        }
        buffer.append("})");
    }
}

