/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectDefinitionResource;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;

final class CLIProfile {
    private static final CLIProfile INSTANCE = new CLIProfile();
    private final ManagedObjectDefinitionResource resource = ManagedObjectDefinitionResource.createForProfile("cli");

    public static CLIProfile getInstance() {
        return INSTANCE;
    }

    private CLIProfile() {
    }

    public Set<String> getDefaultListPropertyNames(RelationDefinition<?, ?> r) {
        String s = this.resource.getString(r.getParentDefinition(), "relation." + r.getName() + ".list-properties");
        if (s.trim().length() == 0) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(Arrays.asList(s.split(",")));
    }

    public String getNamingArgument(RelationDefinition<?, ?> r) {
        String s = this.resource.getString(r.getParentDefinition(), "relation." + r.getName() + ".naming-argument-override").trim();
        if (s.length() == 0) {
            StringBuilder builder = new StringBuilder();
            s = r.getChildDefinition().getName();
            int i = s.lastIndexOf(45);
            if (i < 0 || i == s.length() - 1) {
                builder.append(s);
            } else {
                builder.append(s.substring(i + 1));
            }
            if (r instanceof SetRelationDefinition) {
                builder.append("-type");
            } else {
                builder.append("-name");
            }
            s = builder.toString();
        }
        return s;
    }

    public boolean isForCustomization(AbstractManagedObjectDefinition<?, ?> d) {
        return Boolean.parseBoolean(this.resource.getString(d, "is-for-customization"));
    }
}

