/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.ldap.ConfigMessages;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import org.forgerock.opendj.config.ConfigurationFramework;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.util.Utils;

public class BuildVersion
implements Comparable<BuildVersion> {
    private final int major;
    private final int minor;
    private final int point;
    private final long rev;

    public BuildVersion(int major, int minor, int point, long rev) {
        this.major = major;
        this.minor = minor;
        this.point = point;
        this.rev = rev;
    }

    public static BuildVersion binaryVersion(Connection connection) throws ConfigException {
        try {
            SearchResultEntry entry = connection.readEntry("", new String[]{"fullVendorVersion"});
            return BuildVersion.valueOf(entry.getAttribute("fullVendorVersion").firstValueAsString());
        }
        catch (LdapException e) {
            throw new ConfigException(ConfigMessages.ERR_CONFIGVERSION_NOT_FOUND.get());
        }
    }

    public static void checkVersionMismatch(Connection connection) throws ConfigException {
        BuildVersion binaryVersion = BuildVersion.binaryVersion(connection);
        BuildVersion instanceVersion = BuildVersion.instanceVersion();
        if (!binaryVersion.toString().equals(instanceVersion.toString())) {
            throw new ConfigException(ConfigMessages.ERR_BUILDVERSION_MISMATCH.get((Object)binaryVersion, (Object)instanceVersion));
        }
    }

    public static BuildVersion instanceVersion() throws ConfigException {
        BufferedReader reader;
        String buildInfo;
        block6: {
            buildInfo = ConfigurationFramework.getInstance().getInstancePath() + File.separator + "config" + File.separator + "buildinfo";
            reader = null;
            reader = new BufferedReader(new FileReader(buildInfo));
            String s = reader.readLine();
            if (s == null) break block6;
            BuildVersion buildVersion = BuildVersion.valueOf(s);
            Utils.closeSilently((Closeable[])new Closeable[]{reader});
            return buildVersion;
        }
        try {
            try {
                throw new ConfigException(ConfigMessages.ERR_BUILDVERSION_MALFORMED.get((Object)buildInfo));
            }
            catch (IOException e) {
                throw new ConfigException(ConfigMessages.ERR_BUILDVERSION_NOT_FOUND.get((Object)buildInfo));
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException(ConfigMessages.ERR_BUILDVERSION_MALFORMED.get((Object)buildInfo));
            }
        }
        catch (Throwable throwable) {
            Utils.closeSilently((Closeable[])new Closeable[]{reader});
            throw throwable;
        }
    }

    public static BuildVersion valueOf(String s) {
        String[] fields = s.split("\\.");
        if (fields.length != 4) {
            throw new IllegalArgumentException("Invalid version string " + s);
        }
        int major = Integer.parseInt(fields[0]);
        int minor = Integer.parseInt(fields[1]);
        int point = Integer.parseInt(fields[2]);
        long rev = Long.parseLong(fields[3]);
        return new BuildVersion(major, minor, point, rev);
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getPointVersion() {
        return this.point;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BuildVersion) {
            BuildVersion other = (BuildVersion)obj;
            return this.major == other.major && this.minor == other.minor && this.point == other.point && this.rev == other.rev;
        }
        return false;
    }

    @Override
    public int compareTo(BuildVersion version) {
        if (this.major == version.major) {
            if (this.minor == version.minor) {
                if (this.point == version.point) {
                    if (this.rev == version.rev) {
                        return 0;
                    }
                    if (this.rev < version.rev) {
                        return -1;
                    }
                } else if (this.point < version.point) {
                    return -1;
                }
            } else if (this.minor < version.minor) {
                return -1;
            }
        } else if (this.major < version.major) {
            return -1;
        }
        return 1;
    }

    public long getRevisionNumber() {
        return this.rev;
    }

    public int hashCode() {
        return Arrays.hashCode(new int[]{this.major, this.minor, this.point, (int)(this.rev >>> 32), (int)(this.rev & 0xFFFFL)});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major);
        builder.append('.');
        builder.append(this.minor);
        builder.append('.');
        builder.append(this.point);
        builder.append('.');
        builder.append(this.rev);
        return builder.toString();
    }
}

