/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.client.ldap;

import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.opendj.config.Reference;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.client.ldap.DNBuilder;
import org.forgerock.opendj.config.client.ldap.LDAPDriver;
import org.forgerock.opendj.config.client.spi.AbstractManagedObject;
import org.forgerock.opendj.config.client.spi.Driver;
import org.forgerock.opendj.config.client.spi.Property;
import org.forgerock.opendj.config.client.spi.PropertySet;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;

final class LDAPManagedObject<T extends ConfigurationClient>
extends AbstractManagedObject<T> {
    private final LDAPDriver driver;

    LDAPManagedObject(LDAPDriver driver, ManagedObjectDefinition<T, ? extends Configuration> d, ManagedObjectPath<T, ? extends Configuration> path, PropertySet properties, boolean existsOnServer, PropertyDefinition<?> namingPropertyDefinition) {
        super(d, path, properties, existsOnServer, namingPropertyDefinition);
        this.driver = driver;
    }

    @Override
    protected void addNewManagedObject() throws LdapException, OperationRejectedException, ConcurrentModificationException, ManagedObjectAlreadyExistsException {
        LinkedHashMapEntry entry;
        DN dn;
        ManagedObjectDefinition d = this.getManagedObjectDefinition();
        ManagedObjectPath path = this.getManagedObjectPath();
        ManagedObjectPath<?, ?> parent = path.parent();
        try {
            if (!this.driver.managedObjectExists(parent)) {
                throw new ConcurrentModificationException();
            }
        }
        catch (ManagedObjectNotFoundException e) {
            throw new ConcurrentModificationException();
        }
        RelationDefinition r = path.getRelationDefinition();
        if ((r instanceof InstantiableRelationDefinition || r instanceof SetRelationDefinition) && !this.driver.entryExists(dn = r instanceof InstantiableRelationDefinition ? DNBuilder.create(parent, (InstantiableRelationDefinition)r, this.driver.getLDAPProfile()) : DNBuilder.create(parent, (SetRelationDefinition)r, this.driver.getLDAPProfile()))) {
            entry = new LinkedHashMapEntry(dn);
            List<String> objectClasses = this.driver.getLDAPProfile().getRelationObjectClasses(r);
            this.addObjectClassesToEntry(objectClasses, (Entry)entry);
            entry.addAttribute(dn.rdn().getFirstAVA().toAttribute());
            try {
                this.driver.getLDAPConnection().add((Entry)entry);
            }
            catch (LdapException e) {
                if (e.getResult().getResultCode() == ResultCode.UNWILLING_TO_PERFORM) {
                    LocalizableMessage m = LocalizableMessage.raw((CharSequence)"%s", (Object[])new Object[]{e.getLocalizedMessage()});
                    throw new OperationRejectedException(OperationRejectedException.OperationType.CREATE, d.getUserFriendlyName(), m);
                }
                throw e;
            }
        }
        dn = DNBuilder.create(path, this.driver.getLDAPProfile());
        entry = new LinkedHashMapEntry(dn);
        ManagedObjectDefinition definition = this.getManagedObjectDefinition();
        List<String> objectClasses = this.driver.getLDAPProfile().getObjectClasses(definition);
        this.addObjectClassesToEntry(objectClasses, (Entry)entry);
        PropertyDefinition<?> namingPropertyDef = this.getNamingPropertyDefinition();
        if (namingPropertyDef == null) {
            entry.addAttribute(dn.rdn().getFirstAVA().toAttribute());
        }
        for (PropertyDefinition<?> propertyDef : definition.getAllPropertyDefinitions()) {
            String attrID = this.driver.getLDAPProfile().getAttributeName(definition, propertyDef);
            LinkedAttribute attribute = new LinkedAttribute(attrID);
            this.encodeProperty((Attribute)attribute, propertyDef);
            if (attribute.size() == 0) continue;
            entry.addAttribute((Attribute)attribute);
        }
        try {
            this.driver.getLDAPConnection().add((Entry)entry);
        }
        catch (LdapException e) {
            if (e.getResult().getResultCode() == ResultCode.ENTRY_ALREADY_EXISTS) {
                throw new ManagedObjectAlreadyExistsException();
            }
            if (e.getResult().getResultCode() == ResultCode.UNWILLING_TO_PERFORM) {
                LocalizableMessage m = LocalizableMessage.raw((CharSequence)"%s", (Object[])new Object[]{e.getLocalizedMessage()});
                throw new OperationRejectedException(OperationRejectedException.OperationType.CREATE, d.getUserFriendlyName(), m);
            }
            throw e;
        }
    }

    private void addObjectClassesToEntry(List<String> objectClasses, Entry entry) {
        for (String objectClass : objectClasses) {
            LinkedAttribute attr = new LinkedAttribute("objectClass");
            attr.add(ByteString.valueOf((CharSequence)objectClass));
            entry.addAttribute((Attribute)attr);
        }
    }

    @Override
    protected Driver getDriver() {
        return this.driver;
    }

    @Override
    protected void modifyExistingManagedObject() throws ConcurrentModificationException, OperationRejectedException, LdapException {
        ManagedObjectPath path = this.getManagedObjectPath();
        DN dn = DNBuilder.create(path, this.driver.getLDAPProfile());
        ModifyRequest request = Requests.newModifyRequest((DN)dn);
        ManagedObjectDefinition d = this.getManagedObjectDefinition();
        for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
            Property<?> p = this.getProperty(pd);
            if (!p.isModified()) continue;
            String attrID = this.driver.getLDAPProfile().getAttributeName(d, pd);
            LinkedAttribute attribute = new LinkedAttribute(attrID);
            this.encodeProperty((Attribute)attribute, pd);
            request.addModification(ModificationType.REPLACE, attrID, attribute.toArray(new Object[attribute.size()]));
        }
        if (!request.getModifications().isEmpty()) {
            try {
                this.driver.getLDAPConnection().modify(request);
            }
            catch (LdapException e) {
                if (e.getResult().getResultCode() == ResultCode.UNWILLING_TO_PERFORM) {
                    LocalizableMessage m = LocalizableMessage.raw((CharSequence)"%s", (Object[])new Object[]{e.getLocalizedMessage()});
                    throw new OperationRejectedException(OperationRejectedException.OperationType.MODIFY, d.getUserFriendlyName(), m);
                }
                throw e;
            }
        }
    }

    @Override
    protected <M extends ConfigurationClient> ManagedObject<M> newInstance(ManagedObjectDefinition<M, ?> d, ManagedObjectPath<M, ?> path, PropertySet properties, boolean existsOnServer, PropertyDefinition<?> namingPropertyDefinition) {
        return new LDAPManagedObject<M>(this.driver, d, path, properties, existsOnServer, namingPropertyDefinition);
    }

    private <P> void encodeProperty(Attribute attribute, PropertyDefinition<P> propertyDef) {
        ValueEncoder visitor = new ValueEncoder();
        Property<P> property = this.getProperty(propertyDef);
        if (propertyDef.hasOption(PropertyOption.MANDATORY)) {
            for (Object value : property.getEffectiveValues()) {
                attribute.add(new Object[]{propertyDef.accept(visitor, (Void)value, null)});
            }
        } else {
            for (Object value : property.getPendingValues()) {
                attribute.add(new Object[]{propertyDef.accept(visitor, (Void)value, null)});
            }
        }
    }

    @Override
    public boolean isModified() {
        ManagedObjectDefinition d = this.getManagedObjectDefinition();
        for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
            Property<?> p = this.getProperty(pd);
            if (!p.isModified()) continue;
            return true;
        }
        return false;
    }

    private static final class ValueEncoder
    extends PropertyValueVisitor<Object, Void> {
        private ValueEncoder() {
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Object visitAggregation(AggregationPropertyDefinition<C, S> pd, String v, Void p) {
            Reference<C, S> reference = Reference.parseName(pd.getParentPath(), pd.getRelationDefinition(), v);
            return reference.toDN().toString();
        }

        @Override
        public <P> Object visitUnknown(PropertyDefinition<P> propertyDef, P value, Void p) {
            return propertyDef.encodeValue(value);
        }
    }
}

