/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.client;

import com.forgerock.opendj.ldap.AdminMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.config.client.AdminClientException;
import org.forgerock.util.Reject;

public class OperationRejectedException
extends AdminClientException {
    private static final long serialVersionUID = 8547688890613079044L;
    private final Collection<LocalizableMessage> messages;
    private final OperationType type;
    private final LocalizableMessage ufn;

    private static LocalizableMessage getDefaultMessage(Collection<LocalizableMessage> messages) {
        Reject.ifNull(messages);
        Reject.ifFalse((!messages.isEmpty() ? 1 : 0) != 0, (String)"Messages should not be empty");
        if (messages.size() == 1) {
            return AdminMessages.ERR_OPERATION_REJECTED_EXCEPTION_SINGLE.get((Object)messages.iterator().next());
        }
        return AdminMessages.ERR_OPERATION_REJECTED_EXCEPTION_PLURAL.get((Object)OperationRejectedException.getSingleMessage(messages));
    }

    private static LocalizableMessage getSingleMessage(Collection<LocalizableMessage> messages) {
        if (messages.size() == 1) {
            return messages.iterator().next();
        }
        LocalizableMessageBuilder builder = new LocalizableMessageBuilder();
        boolean isFirst = true;
        for (LocalizableMessage m : messages) {
            if (!isFirst) {
                builder.append((CharSequence)";  ");
            }
            builder.append(m);
            isFirst = false;
        }
        return builder.toMessage();
    }

    public OperationRejectedException(OperationType type, LocalizableMessage ufn) {
        this(type, ufn, AdminMessages.ERR_OPERATION_REJECTED_DEFAULT.get());
    }

    public OperationRejectedException(OperationType type, LocalizableMessage ufn, Collection<LocalizableMessage> messages) {
        super(OperationRejectedException.getDefaultMessage(messages));
        this.messages = new ArrayList<LocalizableMessage>(messages);
        this.type = type;
        this.ufn = ufn;
    }

    public OperationRejectedException(OperationType type, LocalizableMessage ufn, LocalizableMessage message) {
        this(type, ufn, Collections.singleton(message));
    }

    public Collection<LocalizableMessage> getMessages() {
        return Collections.unmodifiableCollection(this.messages);
    }

    public LocalizableMessage getMessagesAsSingleMessage() {
        return OperationRejectedException.getSingleMessage(this.messages);
    }

    public OperationType getOperationType() {
        return this.type;
    }

    public LocalizableMessage getUserFriendlyName() {
        return this.ufn;
    }

    public static enum OperationType {
        CREATE,
        DELETE,
        MODIFY;

    }
}

