/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.client;

import com.forgerock.opendj.ldap.AdminMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.OperationsException;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionUsageBuilder;
import org.forgerock.opendj.config.PropertyException;

public class IllegalManagedObjectNameException
extends OperationsException {
    private static final long serialVersionUID = 7491748228684293291L;
    private final String illegalName;
    private final PropertyDefinition<?> namingPropertyDefinition;

    private static LocalizableMessage createMessage(String illegalName, PropertyDefinition<?> namingPropertyDefinition) {
        if (illegalName.length() == 0) {
            return AdminMessages.ERR_ILLEGAL_MANAGED_OBJECT_NAME_EXCEPTION_EMPTY.get();
        }
        if (illegalName.trim().length() == 0) {
            return AdminMessages.ERR_ILLEGAL_MANAGED_OBJECT_NAME_EXCEPTION_BLANK.get();
        }
        if (namingPropertyDefinition != null) {
            try {
                namingPropertyDefinition.decodeValue(illegalName);
            }
            catch (PropertyException e) {
                PropertyDefinitionUsageBuilder builder = new PropertyDefinitionUsageBuilder(true);
                return AdminMessages.ERR_ILLEGAL_MANAGED_OBJECT_NAME_EXCEPTION_SYNTAX.get((Object)illegalName, (Object)namingPropertyDefinition.getName(), (Object)builder.getUsage(namingPropertyDefinition));
            }
        }
        return AdminMessages.ERR_ILLEGAL_MANAGED_OBJECT_NAME_EXCEPTION_OTHER.get((Object)illegalName);
    }

    public IllegalManagedObjectNameException(String illegalName) {
        this(illegalName, (PropertyDefinition<?>)null);
    }

    public IllegalManagedObjectNameException(String illegalName, PropertyDefinition<?> namingPropertyDefinition) {
        super(IllegalManagedObjectNameException.createMessage(illegalName, namingPropertyDefinition));
        this.illegalName = illegalName;
        this.namingPropertyDefinition = namingPropertyDefinition;
    }

    public String getIllegalName() {
        return this.illegalName;
    }

    public PropertyDefinition<?> getNamingPropertyDefinition() {
        return this.namingPropertyDefinition;
    }
}

