/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.net.InetAddress;
import org.forgerock.opendj.config.ACIPropertyDefinition;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AttributeTypePropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.IPAddressMaskPropertyDefinition;
import org.forgerock.opendj.config.IPAddressPropertyDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.SizePropertyDefinition;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.ldap.AddressMask;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.schema.AttributeType;

public abstract class PropertyValueVisitor<R, P> {
    protected PropertyValueVisitor() {
    }

    public R visitACI(ACIPropertyDefinition pd, String v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public <C extends ConfigurationClient, S extends Configuration> R visitAggregation(AggregationPropertyDefinition<C, S> pd, String v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitAttributeType(AttributeTypePropertyDefinition pd, AttributeType v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitBoolean(BooleanPropertyDefinition pd, Boolean v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitClass(ClassPropertyDefinition pd, String v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitDN(DNPropertyDefinition pd, DN v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitDuration(DurationPropertyDefinition pd, Long v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public <E extends Enum<E>> R visitEnum(EnumPropertyDefinition<E> pd, E v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitInteger(IntegerPropertyDefinition pd, Integer v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitIPAddress(IPAddressPropertyDefinition pd, InetAddress v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitIPAddressMask(IPAddressMaskPropertyDefinition pd, AddressMask v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitSize(SizePropertyDefinition pd, Long v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitString(StringPropertyDefinition pd, String v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public <T> R visitUnknown(PropertyDefinition<T> pd, T v, P p) {
        throw PropertyException.unknownPropertyDefinitionException(pd, p);
    }
}

