/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import com.forgerock.opendj.ldap.AdminMessages;
import com.forgerock.opendj.ldap.ExtensionMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.server.config.meta.RootCfgDefn;
import org.forgerock.util.Reject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationFramework {
    private static final String MANIFEST = "/META-INF/services/org.forgerock.opendj.config.AbstractManagedObjectDefinition";
    private static final LocalizedLogger adminLogger = LocalizedLogger.getLocalizedLogger((String)AdminMessages.resourceName());
    private static final Logger debugLogger = LoggerFactory.getLogger(ConfigurationFramework.class);
    private static final String LIB_DIR = "lib";
    private static final String EXTENSIONS_DIR = "extensions";
    private static final ConfigurationFramework INSTANCE = new ConfigurationFramework();
    private static final String REVISION_NUMBER = "Revision-Number";
    private static final String[] BUILD_INFORMATION_ATTRIBUTE_NAMES = new String[]{Attributes.Name.EXTENSION_NAME.toString(), Attributes.Name.IMPLEMENTATION_VERSION.toString(), "Revision-Number"};
    private Set<File> jarFiles = new HashSet<File>();
    private MyURLClassLoader loader;
    private boolean isClient = true;
    private String installPath;
    private String instancePath;
    private ClassLoader parent;

    public static ConfigurationFramework getInstance() {
        return INSTANCE;
    }

    private ConfigurationFramework() {
    }

    public synchronized void addExtension(String ... extensions) throws ConfigException {
        Reject.ifNull((Object[])extensions);
        this.ensureInitialized();
        File libPath = new File(this.instancePath, LIB_DIR);
        File extensionsPath = new File(libPath, EXTENSIONS_DIR);
        ArrayList<File> files = new ArrayList<File>(extensions.length);
        for (String extension : extensions) {
            File file = new File(extensionsPath, extension);
            if (!extensionsPath.equals(file.getParentFile())) {
                throw new IllegalArgumentException("Illegal file name: " + extension);
            }
            files.add(file);
        }
        this.addExtension(files.toArray(new File[files.size()]));
    }

    public synchronized ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    public ConfigurationFramework initialize() throws ConfigException {
        return this.initialize(null);
    }

    public ConfigurationFramework initialize(String installAndInstancePath) throws ConfigException {
        return this.initialize(installAndInstancePath, installAndInstancePath);
    }

    public ConfigurationFramework initialize(String installPath, String instancePath) throws ConfigException {
        return this.initialize(installPath, instancePath, RootCfgDefn.class.getClassLoader());
    }

    public synchronized ConfigurationFramework initialize(String installPath, String instancePath, ClassLoader parent) throws ConfigException {
        if (this.loader != null) {
            throw new IllegalStateException("configuration framework already initialized.");
        }
        String string = this.installPath = installPath == null ? System.getenv("INSTALL_ROOT") : installPath;
        this.instancePath = instancePath != null ? instancePath : (System.getenv("INSTANCE_ROOT") != null ? System.getenv("INSTANCE_ROOT") : this.installPath);
        this.parent = parent;
        this.initialize0();
        return this;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public synchronized boolean isInitialized() {
        return this.loader != null;
    }

    public String printExtensionInformation() {
        File extensionsPath = new File(this.installPath + File.separator + LIB_DIR + File.separator + EXTENSIONS_DIR);
        if (!extensionsPath.exists() || !extensionsPath.isDirectory()) {
            return null;
        }
        File[] extensions = extensionsPath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".jar");
            }
        });
        if (extensions.length == 0) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ps.printf("--%s           %-20s %-20s %-20s%s", StaticUtils.EOL, "Name", "Build number", "Revision number", StaticUtils.EOL);
        for (File extension : extensions) {
            try {
                JarFile jarFile = new JarFile(extension);
                JarEntry entry = jarFile.getJarEntry(MANIFEST);
                if (entry == null) continue;
                String[] information = this.getBuildInformation(jarFile);
                ps.append("Extension: ");
                boolean addBlank = false;
                for (String name : information) {
                    if (addBlank) {
                        ps.append(addBlank ? " " : "");
                    } else {
                        addBlank = true;
                    }
                    ps.printf("%-20s", name);
                }
                ps.append(StaticUtils.EOL);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return baos.toString();
    }

    public synchronized void reload() throws ConfigException {
        this.ensureInitialized();
        this.loader = null;
        this.jarFiles = new HashSet<File>();
        this.initialize0();
    }

    public ConfigurationFramework setIsClient(boolean isClient) {
        this.isClient = isClient;
        return this;
    }

    private void addExtension(File ... extensions) throws ConfigException {
        LinkedList<JarFile> jars = new LinkedList<JarFile>();
        for (File extension : extensions) {
            if (this.jarFiles.contains(extension)) continue;
            jars.add(this.loadJarFile(extension));
            try {
                this.loader.addJarFile(extension);
            }
            catch (Exception e) {
                debugLogger.trace("Unable to register the jar file with the class loader", (Throwable)e);
                LocalizableMessage message = AdminMessages.ERR_ADMIN_CANNOT_OPEN_JAR_FILE.get((Object)extension.getName(), (Object)extension.getParent(), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
                throw new ConfigException(message);
            }
            this.jarFiles.add(extension);
        }
        for (JarFile jar : jars) {
            this.initializeExtension(jar);
        }
    }

    private void ensureInitialized() {
        if (this.loader == null) {
            throw new IllegalStateException("configuration framework is disabled.");
        }
    }

    private String[] getBuildInformation(JarFile extension) throws IOException {
        String[] result = new String[3];
        Manifest manifest = extension.getManifest();
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            int index = 0;
            for (String name : BUILD_INFORMATION_ATTRIBUTE_NAMES) {
                String value = attributes.getValue(name);
                if (value == null) {
                    value = "<unknown>";
                }
                result[index++] = value;
            }
        }
        return result;
    }

    private void initialize0() throws ConfigException {
        File instanceExtensionsPath;
        File installExtensionsPath;
        this.loader = this.parent != null ? new MyURLClassLoader(this.parent) : new MyURLClassLoader();
        this.initializeCoreComponents();
        File libDir = new File(this.installPath, LIB_DIR);
        try {
            installExtensionsPath = new File(libDir, EXTENSIONS_DIR).getCanonicalFile();
        }
        catch (Exception e) {
            installExtensionsPath = new File(libDir, EXTENSIONS_DIR);
        }
        this.initializeAllExtensions(installExtensionsPath);
        libDir = new File(this.instancePath, LIB_DIR);
        try {
            instanceExtensionsPath = new File(libDir, EXTENSIONS_DIR).getCanonicalFile();
        }
        catch (Exception e) {
            instanceExtensionsPath = new File(libDir, EXTENSIONS_DIR);
        }
        if (!installExtensionsPath.getAbsolutePath().equals(instanceExtensionsPath.getAbsolutePath())) {
            this.initializeAllExtensions(instanceExtensionsPath);
        }
    }

    private void initializeAllExtensions(File extensionsPath) throws ConfigException {
        try {
            if (!extensionsPath.exists()) {
                adminLogger.error(AdminMessages.ERR_ADMIN_NO_EXTENSIONS_DIR, (Object)String.valueOf(extensionsPath));
                return;
            }
            if (!extensionsPath.isDirectory()) {
                LocalizableMessage message = AdminMessages.ERR_ADMIN_EXTENSIONS_DIR_NOT_DIRECTORY.get((Object)String.valueOf(extensionsPath));
                throw new ConfigException(message);
            }
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (!pathname.isFile()) {
                        return false;
                    }
                    String name = pathname.getName();
                    return name.endsWith(".jar");
                }
            };
            this.addExtension(extensionsPath.listFiles(filter));
        }
        catch (ConfigException e) {
            debugLogger.trace("Unable to initialize all extensions", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            debugLogger.trace("Unable to initialize all extensions", (Throwable)e);
            LocalizableMessage message = AdminMessages.ERR_ADMIN_EXTENSIONS_CANNOT_LIST_FILES.get((Object)String.valueOf(extensionsPath), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
            throw new ConfigException(message, (Throwable)e);
        }
    }

    private void initializeCoreComponents() throws ConfigException {
        InputStream is = RootCfgDefn.class.getResourceAsStream(MANIFEST);
        if (is == null) {
            LocalizableMessage message = AdminMessages.ERR_ADMIN_CANNOT_FIND_CORE_MANIFEST.get((Object)MANIFEST);
            throw new ConfigException(message);
        }
        try {
            this.loadDefinitionClasses(is);
        }
        catch (ConfigException e) {
            debugLogger.trace("Unable to initialize core components", (Throwable)e);
            LocalizableMessage message = AdminMessages.ERR_CLASS_LOADER_CANNOT_LOAD_CORE.get((Object)MANIFEST, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
            throw new ConfigException(message);
        }
    }

    private void initializeExtension(JarFile jarFile) throws ConfigException {
        JarEntry entry = jarFile.getJarEntry(MANIFEST);
        if (entry != null) {
            InputStream is;
            try {
                is = jarFile.getInputStream(entry);
            }
            catch (Exception e) {
                debugLogger.trace("Unable to get input stream from jar", (Throwable)e);
                LocalizableMessage message = AdminMessages.ERR_ADMIN_CANNOT_READ_EXTENSION_MANIFEST.get((Object)MANIFEST, (Object)jarFile.getName(), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
                throw new ConfigException(message);
            }
            try {
                this.loadDefinitionClasses(is);
            }
            catch (ConfigException e) {
                debugLogger.trace("Unable to load classes from input stream", (Throwable)e);
                LocalizableMessage message = AdminMessages.ERR_CLASS_LOADER_CANNOT_LOAD_EXTENSION.get((Object)jarFile.getName(), (Object)MANIFEST, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
                throw new ConfigException(message);
            }
            try {
                String[] information = this.getBuildInformation(jarFile);
                LocalizableMessage message = ExtensionMessages.NOTE_LOG_EXTENSION_INFORMATION.get((Object)jarFile.getName(), (Object)information[1], (Object)information[2]);
                LocalizedLogger.getLocalizedLogger((String)message.resourceName()).error(message);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void loadDefinitionClasses(InputStream is) throws ConfigException {
        LocalizableMessage msg;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        LinkedList<AbstractManagedObjectDefinition> definitions = new LinkedList<AbstractManagedObjectDefinition>();
        while (true) {
            AbstractManagedObjectDefinition d;
            Method method;
            Class<?> theClass;
            String className;
            try {
                className = reader.readLine();
            }
            catch (IOException e) {
                LocalizableMessage msg2 = AdminMessages.ERR_CLASS_LOADER_CANNOT_READ_MANIFEST_FILE.get((Object)String.valueOf(e.getMessage()));
                throw new ConfigException(msg2, (Throwable)e);
            }
            if (className == null) break;
            if ((className = className.trim()).length() == 0 || className.startsWith("#")) continue;
            debugLogger.trace("Loading class " + className);
            try {
                theClass = Class.forName(className, true, this.loader);
            }
            catch (Exception e) {
                msg = AdminMessages.ERR_CLASS_LOADER_CANNOT_LOAD_CLASS.get((Object)className, (Object)String.valueOf(e.getMessage()));
                throw new ConfigException(msg, (Throwable)e);
            }
            if (!AbstractManagedObjectDefinition.class.isAssignableFrom(theClass)) continue;
            try {
                method = theClass.getMethod("getInstance", new Class[0]);
            }
            catch (Exception e) {
                LocalizableMessage msg3 = AdminMessages.ERR_CLASS_LOADER_CANNOT_FIND_GET_INSTANCE_METHOD.get((Object)className, (Object)String.valueOf(e.getMessage()));
                throw new ConfigException(msg3, (Throwable)e);
            }
            try {
                d = (AbstractManagedObjectDefinition)method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LocalizableMessage msg4 = AdminMessages.ERR_CLASS_LOADER_CANNOT_INVOKE_GET_INSTANCE_METHOD.get((Object)className, (Object)String.valueOf(e.getMessage()));
                throw new ConfigException(msg4, (Throwable)e);
            }
            definitions.add(d);
        }
        for (AbstractManagedObjectDefinition d : definitions) {
            try {
                d.initialize();
            }
            catch (Exception e) {
                msg = AdminMessages.ERR_CLASS_LOADER_CANNOT_INITIALIZE_DEFN.get((Object)d.getName(), (Object)d.getClass().getName(), (Object)String.valueOf(e.getMessage()));
                throw new ConfigException(msg, (Throwable)e);
            }
        }
    }

    private JarFile loadJarFile(File jar) throws ConfigException {
        try {
            return new JarFile(jar);
        }
        catch (Exception e) {
            debugLogger.trace("Unable to load jar file: " + jar, (Throwable)e);
            LocalizableMessage message = AdminMessages.ERR_ADMIN_CANNOT_OPEN_JAR_FILE.get((Object)jar.getName(), (Object)jar.getParent(), (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e, (boolean)true));
            throw new ConfigException(message);
        }
    }

    public String getInstallPath() {
        return this.installPath;
    }

    public String getInstancePath() {
        return this.instancePath;
    }

    private static final class MyURLClassLoader
    extends URLClassLoader {
        public MyURLClassLoader() {
            super(new URL[0]);
        }

        public MyURLClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        public void addJarFile(File jarFile) throws MalformedURLException {
            this.addURL(jarFile.toURI().toURL());
        }
    }
}

