/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.descriptor;

public final class Version
implements Comparable<Version> {
    private static final Version[] DOT_ZERO_CACHE = new Version[10];
    private final int major;
    private final int minor;
    private final int micro;
    private final String s;

    public static Version valueOf(int major, int minor, int micro) {
        return Version.valueOf(major, minor, micro, null);
    }

    public static Version valueOf(int major, int minor) {
        return Version.valueOf(major, minor, 0);
    }

    public static Version valueOf(int major) {
        return Version.valueOf(major, 0, 0);
    }

    private static Version valueOf(int major, int minor, int micro, String s) {
        if (minor == 0 && micro == 0 && major >= 0 && major < DOT_ZERO_CACHE.length) {
            return DOT_ZERO_CACHE[major];
        }
        return new Version(major, minor, micro, s);
    }

    private Version(int major, int minor, int micro, String s) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.s = s != null ? s : major + "." + minor + "." + micro;
    }

    public static Version valueOf(String s) {
        String[] fields = s.split("\\.");
        if (fields.length == 0 || fields.length > 3) {
            throw new IllegalArgumentException("Invalid version string " + s);
        }
        int major = Integer.parseInt(fields[0]);
        int minor = fields.length > 1 ? Integer.parseInt(fields[1]) : 0;
        int micro = fields.length > 2 ? Integer.parseInt(fields[2]) : 0;
        return Version.valueOf(major, minor, micro, s);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public int hashCode() {
        return ((31 + this.major) * 31 + this.minor) * 31 + this.micro;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Version) {
            Version that = (Version)obj;
            return this.major == that.major && this.minor == that.minor && this.micro == that.micro;
        }
        return false;
    }

    @Override
    public int compareTo(Version that) {
        if (this.major != that.major) {
            return this.major - that.major;
        }
        if (this.minor != that.minor) {
            return this.minor - that.minor;
        }
        if (this.micro != that.micro) {
            return this.micro - that.micro;
        }
        return 0;
    }

    public String toString() {
        return this.s;
    }

    static {
        for (int i = 0; i < DOT_ZERO_CACHE.length; ++i) {
            Version.DOT_ZERO_CACHE[i] = new Version(i, 0, 0, null);
        }
    }
}

