/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.descriptor;

import java.util.Locale;
import org.forgerock.json.resource.descriptor.Version;

public final class Urn
implements Comparable<Urn> {
    private final String organization;
    private final String namespace;
    private final Type type;
    private final String name;
    private final Version version;
    private final String urn;
    private final String nurn;

    private Urn(String urn, String organization, String namespace, Type type, String name, Version version) {
        this.urn = urn;
        this.organization = organization;
        this.namespace = namespace;
        this.type = type;
        this.name = name;
        this.version = version;
        StringBuilder builder = new StringBuilder("urn:");
        builder.append(organization.toLowerCase(Locale.ENGLISH));
        builder.append(':');
        builder.append(namespace.toLowerCase(Locale.ENGLISH));
        builder.append(':');
        builder.append(type.lowerName);
        builder.append(':');
        builder.append(name.toLowerCase(Locale.ENGLISH));
        builder.append(':');
        builder.append(version);
        this.nurn = builder.toString();
    }

    public static Urn valueOf(String s) {
        String[] fields = s.split(":");
        try {
            if (fields.length == 6 && fields[0].equalsIgnoreCase("urn")) {
                String organization = fields[1];
                String namespace = fields[2];
                Type type = Type.valueOf(fields[3].toUpperCase(Locale.ENGLISH));
                String name = fields[4];
                Version version = Version.valueOf(fields[5]);
                return new Urn(s, organization, namespace, type, name, version);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Descriptor urn string '" + s + "' is not of the form 'urn:<org>:<namespace>:api|resource:<name>:<version>'");
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.nurn.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Urn) {
            Urn that = (Urn)obj;
            return this.nurn.equals(that.nurn);
        }
        return false;
    }

    @Override
    public int compareTo(Urn that) {
        return this.nurn.compareTo(that.nurn);
    }

    public String toString() {
        return this.urn;
    }

    public static enum Type {
        API("api"),
        RESOURCE("resource"),
        PROFILE("profile");

        private final String lowerName;

        private Type(String lowerName) {
            this.lowerName = lowerName;
        }
    }
}

