/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.descriptor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.ResourceName;
import org.forgerock.json.resource.descriptor.ActionCapableBuilder;
import org.forgerock.json.resource.descriptor.ActionDescriptor;
import org.forgerock.json.resource.descriptor.Api;
import org.forgerock.json.resource.descriptor.ApiDescriptor;
import org.forgerock.json.resource.descriptor.Profile;
import org.forgerock.json.resource.descriptor.RelationCapableBuilder;
import org.forgerock.json.resource.descriptor.RelationDescriptor;
import org.forgerock.json.resource.descriptor.Schema;
import org.forgerock.json.resource.descriptor.Urn;
import org.forgerock.json.resource.descriptor.Version;

public final class ResourceDescriptor {
    private final LocalizableMessage description;
    private final Schema schema;
    private ResourceDescriptor parent;
    private final Urn parentUrn;
    private final Set<ResourceDescriptor> mutableChildren = new LinkedHashSet<ResourceDescriptor>();
    private final Set<ResourceDescriptor> children = Collections.unmodifiableSet(this.mutableChildren);
    private final Set<ActionDescriptor> actions;
    private final Set<RelationDescriptor> relations;
    private final Set<Profile> profiles;
    private final Urn urn;

    static Builder builder(Urn urn, ApiDescriptor.Builder parentBuilder) {
        return new Builder(urn, parentBuilder);
    }

    private ResourceDescriptor(Urn urn, LocalizableMessage description, Urn parentUrn, Schema schema, Set<ActionDescriptor> actions, Set<RelationDescriptor> relations, Set<Profile> profiles) {
        this.urn = urn;
        this.description = Api.defaultToEmptyMessageIfNull(description);
        this.parentUrn = parentUrn;
        this.schema = schema;
        this.actions = actions;
        this.relations = relations;
        this.profiles = profiles;
    }

    ResourceDescriptor(ResourceDescriptor resource) {
        this.urn = resource.urn;
        this.description = resource.description;
        this.parentUrn = resource.parentUrn;
        this.schema = resource.schema;
        this.actions = resource.actions;
        this.profiles = resource.profiles;
        LinkedHashSet<RelationDescriptor> unresolvedRelations = new LinkedHashSet<RelationDescriptor>(resource.relations.size());
        for (RelationDescriptor relation : resource.relations) {
            unresolvedRelations.add(new RelationDescriptor(relation));
        }
        this.relations = Collections.unmodifiableSet(unresolvedRelations);
    }

    public String getName() {
        return this.urn.getName();
    }

    public LocalizableMessage getDescription() {
        return this.description;
    }

    public Version getVersion() {
        return this.urn.getVersion();
    }

    public Set<RelationDescriptor> getRelations() {
        return this.relations;
    }

    public Set<ResourceDescriptor> getChildren() {
        return this.children;
    }

    public ResourceDescriptor getParent() {
        return this.parent;
    }

    public Set<ActionDescriptor> getActions() {
        return this.actions;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Urn getParentUrn() {
        return this.parentUrn;
    }

    void setParent(ResourceDescriptor parent) {
        this.parent = parent;
        parent.mutableChildren.add(this);
    }

    public Set<Profile> getProfiles() {
        return this.profiles;
    }

    public Urn getUrn() {
        return this.urn;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ResourceDescriptor) {
            return this.urn.equals(((ResourceDescriptor)obj).urn);
        }
        return false;
    }

    public int hashCode() {
        return this.urn.hashCode();
    }

    public String toString() {
        return this.urn.toString();
    }

    public static final class Builder {
        private LocalizableMessage description;
        private final Set<RelationDescriptor> relations = new LinkedHashSet<RelationDescriptor>();
        private Urn parentResourceUrn;
        private Schema schema;
        private final Set<ActionDescriptor> actions = new LinkedHashSet<ActionDescriptor>();
        private final ApiDescriptor.Builder parentBuilder;
        private final Set<Profile> profiles = new LinkedHashSet<Profile>();
        private final Urn urn;

        private Builder(Urn urn, ApiDescriptor.Builder parentBuilder) {
            this.urn = urn;
            this.parentBuilder = parentBuilder;
        }

        public RelationDescriptor.Builder<Builder> addRelation(String name, String resourceUrn) {
            return this.addRelation(ResourceName.valueOf(name), Urn.valueOf(resourceUrn));
        }

        public RelationDescriptor.Builder<Builder> addRelation(String name, Urn resourceUrn) {
            return this.addRelation(ResourceName.valueOf(name), resourceUrn);
        }

        public Builder addProfile(String urn, JsonValue content) {
            return this.addProfile(Urn.valueOf(urn), content);
        }

        public Builder addProfile(Urn urn, JsonValue content) {
            this.profiles.add(new Profile(urn, content));
            return this;
        }

        public RelationDescriptor.Builder<Builder> addRelation(ResourceName name, Urn resourceUrn) {
            return RelationDescriptor.builder(name, resourceUrn, new RelationCapableBuilder<Builder>(){

                @Override
                public Builder addRelationFromBuilder(RelationDescriptor relation) {
                    Builder.this.relations.add(relation);
                    return Builder.this;
                }
            });
        }

        public Builder addRelation(RelationDescriptor relation) {
            this.relations.add(new RelationDescriptor(relation));
            return this;
        }

        public ActionDescriptor.Builder<Builder> addAction(String name) {
            return ActionDescriptor.builder(name, new ActionCapableBuilder<Builder>(){

                @Override
                public Builder addActionFromBuilder(ActionDescriptor action) {
                    Builder.this.actions.add(action);
                    return Builder.this;
                }
            });
        }

        public Builder addRelation(ActionDescriptor action) {
            this.actions.add(action);
            return this;
        }

        public Builder setDescription(String description) {
            return this.setDescription(LocalizableMessage.raw((CharSequence)description, (Object[])new Object[0]));
        }

        public Builder setDescription(LocalizableMessage description) {
            this.description = description;
            return this;
        }

        public Builder setParent(Urn parentResourceUrn) {
            this.parentResourceUrn = parentResourceUrn;
            return this;
        }

        public Builder setParent(String parentResourceUrn) {
            return this.setParent(Urn.valueOf(parentResourceUrn));
        }

        public Builder setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public ApiDescriptor.Builder build() {
            ResourceDescriptor resource = new ResourceDescriptor(this.urn, this.description, this.parentResourceUrn, this.schema, Api.unmodifiableCopyOf(this.actions), Api.unmodifiableCopyOf(this.relations), Api.unmodifiableCopyOf(this.profiles));
            this.parentBuilder.addResourceFromBuilder(resource);
            return this.parentBuilder;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Builder) {
                return this.urn.equals(((Builder)obj).urn);
            }
            return false;
        }

        public int hashCode() {
            return this.urn.hashCode();
        }

        public String toString() {
            return this.urn.toString();
        }
    }
}

