/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.descriptor;

import java.util.LinkedHashSet;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.ResourceName;
import org.forgerock.json.resource.descriptor.ActionCapableBuilder;
import org.forgerock.json.resource.descriptor.ActionDescriptor;
import org.forgerock.json.resource.descriptor.Api;
import org.forgerock.json.resource.descriptor.Profile;
import org.forgerock.json.resource.descriptor.RelationCapableBuilder;
import org.forgerock.json.resource.descriptor.ResourceDescriptor;
import org.forgerock.json.resource.descriptor.Urn;

public final class RelationDescriptor {
    private final ResourceName name;
    private final Urn resourceUrn;
    private ResourceDescriptor resource;
    private final LocalizableMessage description;
    private final Multiplicity multiplicity;
    private final Set<Profile> profiles;
    private final Set<ActionDescriptor> actions;

    static <T> Builder<T> builder(ResourceName name, Urn resourceUrn, RelationCapableBuilder<T> parentBuilder) {
        return new Builder(name, resourceUrn, parentBuilder);
    }

    private RelationDescriptor(ResourceName name, LocalizableMessage description, Multiplicity multiplicity, Set<ActionDescriptor> actions, Urn resourceUrn, Set<Profile> profiles) {
        this.name = name;
        this.description = description;
        this.multiplicity = multiplicity;
        this.actions = actions;
        this.resourceUrn = resourceUrn;
        this.profiles = profiles;
    }

    RelationDescriptor(RelationDescriptor relation) {
        this.name = relation.name;
        this.description = relation.description;
        this.multiplicity = relation.multiplicity;
        this.actions = relation.actions;
        this.resourceUrn = relation.resourceUrn;
        this.profiles = relation.profiles;
    }

    void setResource(ResourceDescriptor resource) {
        this.resource = resource;
    }

    public Set<ActionDescriptor> getActions() {
        return this.actions;
    }

    public Urn getResourceUrn() {
        return this.resourceUrn;
    }

    public String getResourceName() {
        return this.name.toString();
    }

    public ResourceName getResourceNameObject() {
        return this.name;
    }

    public LocalizableMessage getDescription() {
        return this.description != null ? this.description : this.resource.getDescription();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RelationDescriptor) {
            return this.name.equals(((RelationDescriptor)obj).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name.toString();
    }

    public Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public ResourceDescriptor getResource() {
        return this.resource;
    }

    public Set<Profile> getProfiles() {
        return this.profiles;
    }

    public static final class Builder<T> {
        private final ResourceName name;
        private final Urn resourceUrn;
        private LocalizableMessage description;
        private Multiplicity multiplicity = Multiplicity.ONE_TO_MANY;
        private final RelationCapableBuilder<T> parentBuilder;
        private final Set<Profile> profiles = new LinkedHashSet<Profile>();
        private final Set<ActionDescriptor> actions = new LinkedHashSet<ActionDescriptor>();

        private Builder(ResourceName name, Urn resourceUrn, RelationCapableBuilder<T> parentBuilder) {
            this.name = name;
            this.resourceUrn = resourceUrn;
            this.parentBuilder = parentBuilder;
        }

        public ActionDescriptor.Builder<Builder<T>> addAction(String name) {
            return ActionDescriptor.builder(name, new ActionCapableBuilder<Builder<T>>(){

                @Override
                public Builder<T> addActionFromBuilder(ActionDescriptor action) {
                    Builder.this.actions.add(action);
                    return Builder.this;
                }
            });
        }

        public Builder<T> setDescription(String description) {
            return this.setDescription(LocalizableMessage.raw((CharSequence)description, (Object[])new Object[0]));
        }

        public Builder<T> addProfile(String urn, JsonValue content) {
            return this.addProfile(Urn.valueOf(urn), content);
        }

        public Builder<T> addProfile(Urn urn, JsonValue content) {
            this.profiles.add(new Profile(urn, content));
            return this;
        }

        public Builder<T> setDescription(LocalizableMessage description) {
            this.description = description;
            return this;
        }

        public Builder<T> setMultiplicity(Multiplicity multiplicity) {
            this.multiplicity = multiplicity;
            return this;
        }

        public T build() {
            RelationDescriptor relation = new RelationDescriptor(this.name, this.description, this.multiplicity, Api.unmodifiableCopyOf(this.actions), this.resourceUrn, Api.unmodifiableCopyOf(this.profiles));
            return this.parentBuilder.addRelationFromBuilder(relation);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Builder) {
                return this.name.equals(((Builder)obj).name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name.toString();
        }
    }

    public static enum Multiplicity {
        ONE_TO_ONE,
        ONE_TO_MANY;

    }
}

