/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.descriptor;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.ResourceName;
import org.forgerock.json.resource.descriptor.Api;
import org.forgerock.json.resource.descriptor.Profile;
import org.forgerock.json.resource.descriptor.RelationCapableBuilder;
import org.forgerock.json.resource.descriptor.RelationDescriptor;
import org.forgerock.json.resource.descriptor.ResourceDescriptor;
import org.forgerock.json.resource.descriptor.Urn;
import org.forgerock.json.resource.descriptor.Version;

public final class ApiDescriptor {
    private final LocalizableMessage description;
    private final Set<ResourceDescriptor> resources;
    private final Set<RelationDescriptor> relations;
    private final Set<Profile> profiles;
    private final Urn urn;

    private ApiDescriptor(Urn urn, LocalizableMessage description, Set<RelationDescriptor> relations, Set<ResourceDescriptor> resources, Set<Profile> profiles) {
        this.urn = urn;
        this.description = Api.defaultToEmptyMessageIfNull(description);
        this.relations = relations;
        this.resources = resources;
        this.profiles = profiles;
    }

    public static Builder builder(String urn) {
        return new Builder(Urn.valueOf(urn));
    }

    public static Builder builder(Urn urn) {
        return new Builder(urn);
    }

    public String getName() {
        return this.urn.getName();
    }

    public LocalizableMessage getDescription() {
        return this.description;
    }

    public Version getVersion() {
        return this.urn.getVersion();
    }

    public Set<RelationDescriptor> getRelations() {
        return this.relations;
    }

    public Set<ResourceDescriptor> getResources() {
        return this.resources;
    }

    public Set<Profile> getProfiles() {
        return this.profiles;
    }

    public Urn getUrn() {
        return this.urn;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ApiDescriptor) {
            return this.urn.equals(((ApiDescriptor)obj).urn);
        }
        return false;
    }

    public int hashCode() {
        return this.urn.hashCode();
    }

    public String toString() {
        return this.urn.toString();
    }

    public static final class Builder {
        private LocalizableMessage description;
        private final Map<Urn, ResourceDescriptor> resources = new LinkedHashMap<Urn, ResourceDescriptor>();
        private final Set<RelationDescriptor> relations = new LinkedHashSet<RelationDescriptor>();
        private final Set<Profile> profiles = new LinkedHashSet<Profile>();
        private final Urn urn;

        private Builder(Urn urn) {
            this.urn = urn;
        }

        public Builder addResource(ResourceDescriptor resource) {
            this.resources.put(resource.getUrn(), new ResourceDescriptor(resource));
            return this;
        }

        public Builder addProfile(String urn, JsonValue content) {
            return this.addProfile(Urn.valueOf(urn), content);
        }

        public Builder addProfile(Urn urn, JsonValue content) {
            this.profiles.add(new Profile(urn, content));
            return this;
        }

        public ResourceDescriptor.Builder addResource(Urn urn) {
            return ResourceDescriptor.builder(urn, this);
        }

        public ResourceDescriptor.Builder addResource(String urn) {
            return this.addResource(Urn.valueOf(urn));
        }

        public RelationDescriptor.Builder<Builder> addRelation(String name, String resourceUrn) {
            return this.addRelation(ResourceName.valueOf(name), Urn.valueOf(resourceUrn));
        }

        public RelationDescriptor.Builder<Builder> addRelation(String name, Urn resourceUrn) {
            return this.addRelation(ResourceName.valueOf(name), resourceUrn);
        }

        public RelationDescriptor.Builder<Builder> addRelation(ResourceName name, Urn resourceUrn) {
            return RelationDescriptor.builder(name, resourceUrn, new RelationCapableBuilder<Builder>(){

                @Override
                public Builder addRelationFromBuilder(RelationDescriptor relation) {
                    Builder.this.relations.add(relation);
                    return Builder.this;
                }
            });
        }

        public Builder addRelation(RelationDescriptor relation) {
            this.relations.add(new RelationDescriptor(relation));
            return this;
        }

        void addResourceFromBuilder(ResourceDescriptor resource) {
            this.resources.put(resource.getUrn(), resource);
        }

        public Builder setDescription(String description) {
            return this.setDescription(LocalizableMessage.raw((CharSequence)description, (Object[])new Object[0]));
        }

        public Builder setDescription(LocalizableMessage description) {
            this.description = description;
            return this;
        }

        public ApiDescriptor build() {
            LinkedList<LocalizableMessage> warnings = new LinkedList<LocalizableMessage>();
            ApiDescriptor descriptor = this.build(warnings);
            if (warnings.isEmpty()) {
                return descriptor;
            }
            throw new LocalizedIllegalArgumentException((LocalizableMessage)warnings.get(0));
        }

        public ApiDescriptor build(Collection<LocalizableMessage> warnings) {
            boolean foundInvalidResource;
            LinkedHashMap<Urn, ResourceDescriptor> resolvedResources = new LinkedHashMap<Urn, ResourceDescriptor>(this.resources);
            do {
                foundInvalidResource = false;
                Iterator iterator = resolvedResources.entrySet().iterator();
                while (iterator.hasNext()) {
                    ResourceDescriptor resource;
                    boolean resourceIsValid = true;
                    ResourceDescriptor rd = resource = (ResourceDescriptor)iterator.next().getValue();
                    Urn parentUrn = rd.getParentUrn();
                    while (parentUrn != null) {
                        if (parentUrn.equals(resource.getUrn())) {
                            if (warnings != null) {
                                warnings.add(LocalizableMessage.raw((CharSequence)"The resource '%s' in API '%s' is invalid because it has a circular parent chain", (Object[])new Object[]{resource.getUrn(), this.urn}));
                            }
                            resourceIsValid = false;
                            break;
                        }
                        rd = (ResourceDescriptor)resolvedResources.get(parentUrn);
                        if (rd == null) {
                            if (warnings != null) {
                                warnings.add(LocalizableMessage.raw((CharSequence)"The resource '%s' in API '%s' is invalid because it has a non-existant parent '%s'", (Object[])new Object[]{resource.getUrn(), this.urn, parentUrn}));
                            }
                            resourceIsValid = false;
                            break;
                        }
                        parentUrn = rd.getParentUrn();
                    }
                    for (RelationDescriptor relation : resource.getRelations()) {
                        ResourceDescriptor target = (ResourceDescriptor)resolvedResources.get(relation.getResourceUrn());
                        if (target != null) continue;
                        if (warnings != null) {
                            warnings.add(LocalizableMessage.raw((CharSequence)"The relation '%s' for resource '%s' in API '%s' is invalid because it refers to a non-existant resource '%s'", (Object[])new Object[]{relation.getResourceName(), resource.getUrn(), this.urn, relation.getResourceUrn()}));
                        }
                        resourceIsValid = false;
                    }
                    if (resourceIsValid) continue;
                    iterator.remove();
                    foundInvalidResource = true;
                }
            } while (foundInvalidResource);
            for (ResourceDescriptor resource : resolvedResources.values()) {
                Urn parentUrn = resource.getParentUrn();
                if (parentUrn != null) {
                    resource.setParent((ResourceDescriptor)resolvedResources.get(parentUrn));
                }
                for (RelationDescriptor relation : resource.getRelations()) {
                    relation.setResource((ResourceDescriptor)resolvedResources.get(relation.getResourceUrn()));
                }
            }
            LinkedHashSet<RelationDescriptor> resolvedRelations = new LinkedHashSet<RelationDescriptor>(this.relations.size());
            for (RelationDescriptor relation : this.relations) {
                ResourceDescriptor resource = (ResourceDescriptor)resolvedResources.get(relation.getResourceUrn());
                if (resource != null) {
                    relation.setResource(resource);
                    resolvedRelations.add(relation);
                    continue;
                }
                if (warnings == null) continue;
                warnings.add(LocalizableMessage.raw((CharSequence)"The relation '%s' in API '%s' is invalid because it refers to a non-existant resource '%s'", (Object[])new Object[]{relation.getResourceName(), this.urn, relation.getResourceUrn()}));
            }
            return new ApiDescriptor(this.urn, this.description, Collections.unmodifiableSet(resolvedRelations), Api.unmodifiableCopyOf(resolvedResources.values()), Api.unmodifiableCopyOf(this.profiles));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Builder) {
                return this.urn.equals(((Builder)obj).urn);
            }
            return false;
        }

        public int hashCode() {
            return this.urn.hashCode();
        }

        public String toString() {
            return this.urn.toString();
        }
    }
}

