/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.AbstractRequestHandler;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.NotFoundException;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResultHandler;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.Requests;
import org.forgerock.json.resource.Resource;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceName;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.json.resource.ServerContext;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.json.resource.descriptor.ActionDescriptor;
import org.forgerock.json.resource.descriptor.ActionParameter;
import org.forgerock.json.resource.descriptor.ApiDescriptor;
import org.forgerock.json.resource.descriptor.Profile;
import org.forgerock.json.resource.descriptor.RelationDescriptor;
import org.forgerock.json.resource.descriptor.Resolver;
import org.forgerock.json.resource.descriptor.ResolverFactory;
import org.forgerock.json.resource.descriptor.ResourceDescriptor;
import org.forgerock.json.resource.descriptor.Urn;

public final class Api {
    public static RequestHandler newApiDescriptorRequestHandler(final ApiDescriptor api) {
        return new AbstractRequestHandler(){

            @Override
            public void handleRead(ServerContext context, ReadRequest request, ResultHandler<Resource> handler) {
                if (request.getResourceNameObject().isEmpty()) {
                    handler.handleResult(new Resource(null, null, JsonValue.json((Object)Api.apiToJson(api))));
                } else {
                    handler.handleError(new NotSupportedException());
                }
            }
        };
    }

    public static RequestHandler newApiDescriptorRequestHandler(final Collection<ApiDescriptor> apis) {
        return new AbstractRequestHandler(){

            @Override
            public void handleRead(ServerContext context, ReadRequest request, ResultHandler<Resource> handler) {
                if (request.getResourceNameObject().isEmpty()) {
                    ArrayList<Object> values = new ArrayList<Object>(apis.size());
                    for (ApiDescriptor api : apis) {
                        values.add(Api.apiToJson(api));
                    }
                    handler.handleResult(new Resource(null, null, JsonValue.json(values)));
                } else {
                    handler.handleError(new NotSupportedException());
                }
            }
        };
    }

    public static RequestHandler newApiDispatcher(final ApiDescriptor api, final ResolverFactory factory) {
        return new RequestHandler(){

            @Override
            public void handleAction(final ServerContext context, ActionRequest request, final ResultHandler<JsonValue> handler) {
                final ActionRequest mutableCopy = Requests.copyOfActionRequest(request);
                Resolver resolver = factory.createResolver(context, request);
                this.resolveAndInvoke(api.getRelations(), mutableCopy, resolver, new AbstractResolverHandler(handler, resolver){

                    @Override
                    protected void dispatch(RequestHandler resolvedRequestHandler) {
                        resolvedRequestHandler.handleAction(context, mutableCopy, handler);
                    }
                });
            }

            @Override
            public void handleCreate(final ServerContext context, CreateRequest request, final ResultHandler<Resource> handler) {
                final CreateRequest mutableCopy = Requests.copyOfCreateRequest(request);
                Resolver resolver = factory.createResolver(context, request);
                this.resolveAndInvoke(api.getRelations(), mutableCopy, resolver, new AbstractResolverHandler(handler, resolver){

                    @Override
                    protected void dispatch(RequestHandler resolvedRequestHandler) {
                        resolvedRequestHandler.handleCreate(context, mutableCopy, handler);
                    }
                });
            }

            @Override
            public void handleDelete(final ServerContext context, DeleteRequest request, final ResultHandler<Resource> handler) {
                final DeleteRequest mutableCopy = Requests.copyOfDeleteRequest(request);
                Resolver resolver = factory.createResolver(context, request);
                this.resolveAndInvoke(api.getRelations(), mutableCopy, resolver, new AbstractResolverHandler(handler, resolver){

                    @Override
                    protected void dispatch(RequestHandler resolvedRequestHandler) {
                        resolvedRequestHandler.handleDelete(context, mutableCopy, handler);
                    }
                });
            }

            @Override
            public void handlePatch(final ServerContext context, PatchRequest request, final ResultHandler<Resource> handler) {
                final PatchRequest mutableCopy = Requests.copyOfPatchRequest(request);
                Resolver resolver = factory.createResolver(context, request);
                this.resolveAndInvoke(api.getRelations(), mutableCopy, resolver, new AbstractResolverHandler(handler, resolver){

                    @Override
                    protected void dispatch(RequestHandler resolvedRequestHandler) {
                        resolvedRequestHandler.handlePatch(context, mutableCopy, handler);
                    }
                });
            }

            @Override
            public void handleQuery(final ServerContext context, QueryRequest request, final QueryResultHandler handler) {
                final QueryRequest mutableCopy = Requests.copyOfQueryRequest(request);
                Resolver resolver = factory.createResolver(context, request);
                this.resolveAndInvoke(api.getRelations(), mutableCopy, resolver, new AbstractResolverHandler(handler, resolver){

                    @Override
                    protected void dispatch(RequestHandler resolvedRequestHandler) {
                        resolvedRequestHandler.handleQuery(context, mutableCopy, handler);
                    }
                });
            }

            @Override
            public void handleRead(final ServerContext context, ReadRequest request, final ResultHandler<Resource> handler) {
                final ReadRequest mutableCopy = Requests.copyOfReadRequest(request);
                Resolver resolver = factory.createResolver(context, request);
                this.resolveAndInvoke(api.getRelations(), mutableCopy, resolver, new AbstractResolverHandler(handler, resolver){

                    @Override
                    protected void dispatch(RequestHandler resolvedRequestHandler) {
                        resolvedRequestHandler.handleRead(context, mutableCopy, handler);
                    }
                });
            }

            @Override
            public void handleUpdate(final ServerContext context, UpdateRequest request, final ResultHandler<Resource> handler) {
                final UpdateRequest mutableCopy = Requests.copyOfUpdateRequest(request);
                Resolver resolver = factory.createResolver(context, request);
                this.resolveAndInvoke(api.getRelations(), mutableCopy, resolver, new AbstractResolverHandler(handler, resolver){

                    @Override
                    protected void dispatch(RequestHandler resolvedRequestHandler) {
                        resolvedRequestHandler.handleUpdate(context, mutableCopy, handler);
                    }
                });
            }

            private boolean isBetterMatch(RelationDescriptor oldMatch, RelationDescriptor newMatch) {
                return oldMatch == null || oldMatch.getResourceNameObject().size() < newMatch.getResourceNameObject().size();
            }

            private boolean isChildRequest(ResourceName relationName, ResourceName target) {
                return target.size() == relationName.size() + 1;
            }

            private boolean isOneToMany(RelationDescriptor relation) {
                return relation.getMultiplicity() == RelationDescriptor.Multiplicity.ONE_TO_MANY;
            }

            private void resolveAndInvoke(Collection<RelationDescriptor> relations, final Request mutableRequest, final Resolver resolver, final ResultHandler<RequestHandler> handler) {
                ResourceName name = mutableRequest.getResourceNameObject();
                RelationDescriptor exactMatch = null;
                RelationDescriptor childMatch = null;
                RelationDescriptor subMatch = null;
                for (RelationDescriptor relation : relations) {
                    ResourceName relationName = relation.getResourceNameObject();
                    if (name.equals(relationName)) {
                        exactMatch = relation;
                        break;
                    }
                    if (!name.startsWith(relationName)) continue;
                    if (this.isOneToMany(relation) && this.isChildRequest(relationName, name)) {
                        childMatch = relation;
                        continue;
                    }
                    if (!this.isBetterMatch(subMatch, relation)) continue;
                    subMatch = relation;
                }
                if (exactMatch != null || childMatch != null) {
                    try {
                        RequestHandler resolvedRequestHandler;
                        if (exactMatch != null) {
                            resolvedRequestHandler = resolver.getRequestHandler(exactMatch);
                            mutableRequest.setResourceName(ResourceName.empty());
                        } else {
                            resolvedRequestHandler = resolver.getRequestHandler(childMatch);
                            mutableRequest.setResourceName(name.tail(name.size() - 1));
                        }
                        handler.handleResult(resolvedRequestHandler);
                    }
                    catch (ResourceException e) {
                        handler.handleError(e);
                    }
                } else if (subMatch != null) {
                    String childId;
                    int relationNameSize = subMatch.getResourceNameObject().size();
                    if (this.isOneToMany(subMatch)) {
                        mutableRequest.setResourceName(name.tail(relationNameSize + 1));
                        childId = name.get(relationNameSize);
                    } else {
                        mutableRequest.setResourceName(name.tail(relationNameSize));
                        childId = null;
                    }
                    resolver.getRelationsForResource(subMatch, childId, new ResultHandler<Collection<RelationDescriptor>>(){

                        @Override
                        public void handleError(ResourceException error) {
                            handler.handleError(error);
                        }

                        @Override
                        public void handleResult(Collection<RelationDescriptor> result) {
                            this.resolveAndInvoke(result, mutableRequest, resolver, handler);
                        }
                    });
                } else {
                    handler.handleError(new NotFoundException(String.format("Resource '%s' not found", name)));
                }
            }
        };
    }

    static LocalizableMessage defaultToEmptyMessageIfNull(LocalizableMessage description) {
        return description != null ? description : LocalizableMessage.EMPTY;
    }

    static <T> Set<T> unmodifiableCopyOf(Collection<T> set) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(set));
    }

    private static Map.Entry<String, Object> actionsToJson(Set<ActionDescriptor> actions) {
        if (actions.isEmpty()) {
            return null;
        }
        ArrayList<Object> json = new ArrayList<Object>(actions.size());
        for (ActionDescriptor action : actions) {
            json.add(JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"name", (Object)action.getName()), JsonValue.field((String)"description", (Object)action.getDescription()), Api.parametersToJson(action.getParameters()), Api.profilesToJson(action.getProfiles())}));
        }
        return JsonValue.field((String)"actions", json);
    }

    private static Object apiToJson(ApiDescriptor api) {
        return JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"urn", (Object)String.valueOf(api.getUrn())), JsonValue.field((String)"name", (Object)String.valueOf(api.getUrn().getName())), JsonValue.field((String)"version", (Object)String.valueOf(api.getUrn().getVersion())), JsonValue.field((String)"description", (Object)api.getDescription()), Api.relationsToJson(api.getRelations()), Api.resourcesToJson(api.getResources()), Api.profilesToJson(api.getProfiles())});
    }

    private static Map.Entry<String, Object> parametersToJson(Set<ActionParameter> parameters) {
        if (parameters.isEmpty()) {
            return null;
        }
        ArrayList<Object> json = new ArrayList<Object>(parameters.size());
        for (ActionParameter parameter : parameters) {
            json.add(JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"name", (Object)parameter.getName()), JsonValue.field((String)"description", (Object)parameter.getDescription())}));
        }
        return JsonValue.field((String)"parameters", json);
    }

    private static Map.Entry<String, Object> parentToJson(Urn parent) {
        return parent == null ? null : JsonValue.field((String)"parent", (Object)String.valueOf(parent));
    }

    private static Map.Entry<String, Object> profilesToJson(Set<Profile> profiles) {
        if (profiles.isEmpty()) {
            return null;
        }
        ArrayList<Object> json = new ArrayList<Object>(profiles.size());
        for (Profile profile : profiles) {
            json.add(JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"urn", (Object)String.valueOf(profile.getUrn())), JsonValue.field((String)"name", (Object)String.valueOf(profile.getUrn().getName())), JsonValue.field((String)"version", (Object)String.valueOf(profile.getUrn().getVersion())), JsonValue.field((String)"content", (Object)profile.getContent().getObject())}));
        }
        return JsonValue.field((String)"profiles", json);
    }

    private static Map.Entry<String, Object> relationsToJson(Set<RelationDescriptor> relations) {
        if (relations.isEmpty()) {
            return null;
        }
        ArrayList<Object> json = new ArrayList<Object>(relations.size());
        for (RelationDescriptor relation : relations) {
            json.add(JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"name", (Object)relation.getResourceName()), JsonValue.field((String)"description", (Object)relation.getDescription()), JsonValue.field((String)"multiplicity", (Object)((Object)relation.getMultiplicity())), Api.actionsToJson(relation.getActions()), JsonValue.field((String)"resource", (Object)String.valueOf(relation.getResource().getUrn())), Api.profilesToJson(relation.getProfiles())}));
        }
        return JsonValue.field((String)"relations", json);
    }

    private static Map.Entry<String, Object> resourcesToJson(Set<ResourceDescriptor> resources) {
        if (resources.isEmpty()) {
            return null;
        }
        ArrayList<Object> json = new ArrayList<Object>(resources.size());
        for (ResourceDescriptor resource : resources) {
            json.add(JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"urn", (Object)String.valueOf(resource.getUrn())), JsonValue.field((String)"name", (Object)String.valueOf(resource.getUrn().getName())), JsonValue.field((String)"version", (Object)String.valueOf(resource.getUrn().getVersion())), JsonValue.field((String)"description", (Object)resource.getDescription()), Api.parentToJson(resource.getParentUrn()), Api.actionsToJson(resource.getActions()), Api.relationsToJson(resource.getRelations()), Api.profilesToJson(resource.getProfiles())}));
        }
        return JsonValue.field((String)"resources", json);
    }

    private Api() {
    }

    private static abstract class AbstractResolverHandler
    implements ResultHandler<RequestHandler> {
        private final ResultHandler<?> handler;
        private final Resolver resolver;

        private AbstractResolverHandler(ResultHandler<?> handler, Resolver resolver) {
            this.handler = handler;
            this.resolver = resolver;
        }

        @Override
        public final void handleError(ResourceException error) {
            this.resolver.close();
            this.handler.handleError(error);
        }

        @Override
        public final void handleResult(RequestHandler requestHandler) {
            this.resolver.close();
            this.dispatch(requestHandler);
        }

        protected abstract void dispatch(RequestHandler var1);
    }
}

