/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.descriptor;

import java.util.Locale;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.json.resource.descriptor.Api;

public final class ActionParameter {
    private final String name;
    private final String normalizedName;
    private final LocalizableMessage description;

    ActionParameter(String name, LocalizableMessage description) {
        this.name = name;
        this.normalizedName = name.toLowerCase(Locale.ENGLISH);
        this.description = Api.defaultToEmptyMessageIfNull(description);
    }

    public String getName() {
        return this.name;
    }

    public LocalizableMessage getDescription() {
        return this.description;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ActionParameter) {
            return this.normalizedName.equals(((ActionParameter)obj).normalizedName);
        }
        return false;
    }

    public int hashCode() {
        return this.normalizedName.hashCode();
    }

    public String toString() {
        return this.name.toString();
    }
}

