/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.descriptor;

import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.descriptor.ActionCapableBuilder;
import org.forgerock.json.resource.descriptor.ActionParameter;
import org.forgerock.json.resource.descriptor.Api;
import org.forgerock.json.resource.descriptor.Profile;
import org.forgerock.json.resource.descriptor.Urn;

public final class ActionDescriptor {
    private final String name;
    private final LocalizableMessage description;
    private final Set<ActionParameter> parameters;
    private final String normalizedName;
    private final Set<Profile> profiles;

    static <T> Builder<T> builder(String name, ActionCapableBuilder<T> parentBuilder) {
        return new Builder<T>(name, parentBuilder);
    }

    private ActionDescriptor(String name, String normalizedName, LocalizableMessage description, Set<ActionParameter> parameters, Set<Profile> profiles) {
        this.name = name;
        this.normalizedName = normalizedName;
        this.description = Api.defaultToEmptyMessageIfNull(description);
        this.parameters = parameters;
        this.profiles = profiles;
    }

    public String getName() {
        return this.name;
    }

    public LocalizableMessage getDescription() {
        return this.description;
    }

    public Set<ActionParameter> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ActionDescriptor) {
            return this.normalizedName.equals(((ActionDescriptor)obj).normalizedName);
        }
        return false;
    }

    public int hashCode() {
        return this.normalizedName.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public Set<Profile> getProfiles() {
        return this.profiles;
    }

    public static final class Builder<T> {
        private final String name;
        private final String normalizedName;
        private LocalizableMessage description;
        private final Set<ActionParameter> parameters = new LinkedHashSet<ActionParameter>();
        private final ActionCapableBuilder<T> parentBuilder;
        private final Set<Profile> profiles = new LinkedHashSet<Profile>();

        Builder(String name, ActionCapableBuilder<T> parentBuilder) {
            this.name = name;
            this.normalizedName = name.toLowerCase(Locale.ENGLISH);
            this.parentBuilder = parentBuilder;
        }

        public Builder<T> addProfile(String urn, JsonValue content) {
            return this.addProfile(Urn.valueOf(urn), content);
        }

        public Builder<T> addProfile(Urn urn, JsonValue content) {
            this.profiles.add(new Profile(urn, content));
            return this;
        }

        public Builder<T> setDescription(String description) {
            return this.setDescription(LocalizableMessage.raw((CharSequence)description, (Object[])new Object[0]));
        }

        public Builder<T> setDescription(LocalizableMessage description) {
            this.description = description;
            return this;
        }

        public Builder<T> addParameter(String name) {
            return this.addParameter(name, (LocalizableMessage)null);
        }

        public Builder<T> addParameter(String name, String description) {
            return this.addParameter(name, LocalizableMessage.raw((CharSequence)description, (Object[])new Object[0]));
        }

        public Builder<T> addParameter(String name, LocalizableMessage description) {
            this.parameters.add(new ActionParameter(name, description));
            return this;
        }

        public T build() {
            ActionDescriptor action = new ActionDescriptor(this.name, this.normalizedName, this.description, Api.unmodifiableCopyOf(this.parameters), Api.unmodifiableCopyOf(this.profiles));
            return this.parentBuilder.addActionFromBuilder(action);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Builder) {
                return this.normalizedName.equals(((Builder)obj).normalizedName);
            }
            return false;
        }

        public int hashCode() {
            return this.normalizedName.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

