/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.PersistenceConfig;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.util.Reject;

public final class SecurityContext
extends Context {
    public static final String AUTHZID_COMPONENT = "component";
    public static final String AUTHZID_DN = "dn";
    public static final String AUTHZID_ID = "id";
    public static final String AUTHZID_REALM = "realm";
    public static final String AUTHZID_ROLES = "roles";
    private static final String ATTR_AUTHENTICATION_ID = "authentication-id";
    private static final String ATTR_AUTHORIZATION_ID = "authorization-id";
    private final String authenticationId;
    private final Map<String, Object> authorizationId;

    public SecurityContext(Context parent, String authenticationId, Map<String, Object> authorizationId) {
        super((Context)Reject.checkNotNull((Object)parent, (String)"Cannot instantiate SecurityContext with null parent Context"));
        this.authenticationId = authenticationId != null ? authenticationId : "";
        this.authorizationId = authorizationId != null ? Collections.unmodifiableMap(new LinkedHashMap<String, Object>(authorizationId)) : Collections.emptyMap();
    }

    public SecurityContext(String id, Context parent, String authenticationId, Map<String, Object> authorizationId) {
        super(id, (Context)Reject.checkNotNull((Object)parent, (String)"Cannot instantiate SecurityContext with null parent Context"));
        this.authenticationId = authenticationId != null ? authenticationId : "";
        this.authorizationId = authorizationId != null ? Collections.unmodifiableMap(new LinkedHashMap<String, Object>(authorizationId)) : Collections.emptyMap();
    }

    SecurityContext(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        super(savedContext, config);
        this.authenticationId = savedContext.get(ATTR_AUTHENTICATION_ID).required().asString();
        this.authorizationId = savedContext.get(ATTR_AUTHORIZATION_ID).required().asMap();
    }

    public String getAuthenticationId() {
        return this.authenticationId;
    }

    public Map<String, Object> getAuthorizationId() {
        return this.authorizationId;
    }

    @Override
    protected void saveToJson(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        super.saveToJson(savedContext, config);
        savedContext.put(ATTR_AUTHENTICATION_ID, (Object)this.authenticationId);
        savedContext.put(ATTR_AUTHORIZATION_ID, this.authorizationId);
    }
}

