/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.NotFoundException;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResultHandler;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.Requests;
import org.forgerock.json.resource.Resource;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.json.resource.Route;
import org.forgerock.json.resource.RoutingMode;
import org.forgerock.json.resource.ServerContext;
import org.forgerock.json.resource.SingletonResourceProvider;
import org.forgerock.json.resource.UpdateRequest;

public final class Router
implements RequestHandler {
    private volatile RequestHandler defaultRoute = null;
    private final Set<Route> routes = new CopyOnWriteArraySet<Route>();

    public Router() {
    }

    public Router(Router router) {
        this.defaultRoute = router.defaultRoute;
        this.routes.addAll(router.routes);
    }

    public Router addAllRoutes(Router router) {
        if (this != router) {
            this.routes.addAll(router.routes);
        }
        return this;
    }

    public Route addRoute(String uriTemplate, CollectionResourceProvider provider) {
        return this.addRoute(RoutingMode.STARTS_WITH, uriTemplate, Resources.newCollection(provider));
    }

    public Route addRoute(RoutingMode mode, String uriTemplate, RequestHandler handler) {
        return this.addRoute(new Route(mode, uriTemplate, handler));
    }

    public Route addRoute(String uriTemplate, SingletonResourceProvider provider) {
        return this.addRoute(RoutingMode.EQUALS, uriTemplate, Resources.newSingleton(provider));
    }

    public RequestHandler getDefaultRoute() {
        return this.defaultRoute;
    }

    @Override
    public void handleAction(ServerContext context, ActionRequest request, ResultHandler<JsonValue> handler) {
        try {
            Route.RouteMatcher bestMatch = this.getBestRoute(context, request);
            ActionRequest routedRequest = bestMatch.wasRouted() ? Requests.copyOfActionRequest(request).setResourceName(bestMatch.getRemaining()) : request;
            bestMatch.getRequestHandler().handleAction(bestMatch.getServerContext(), routedRequest, handler);
        }
        catch (ResourceException e) {
            handler.handleError(e);
        }
    }

    @Override
    public void handleCreate(ServerContext context, CreateRequest request, ResultHandler<Resource> handler) {
        try {
            Route.RouteMatcher bestMatch = this.getBestRoute(context, request);
            CreateRequest routedRequest = bestMatch.wasRouted() ? Requests.copyOfCreateRequest(request).setResourceName(bestMatch.getRemaining()) : request;
            bestMatch.getRequestHandler().handleCreate(bestMatch.getServerContext(), routedRequest, handler);
        }
        catch (ResourceException e) {
            handler.handleError(e);
        }
    }

    @Override
    public void handleDelete(ServerContext context, DeleteRequest request, ResultHandler<Resource> handler) {
        try {
            Route.RouteMatcher bestMatch = this.getBestRoute(context, request);
            DeleteRequest routedRequest = bestMatch.wasRouted() ? Requests.copyOfDeleteRequest(request).setResourceName(bestMatch.getRemaining()) : request;
            bestMatch.getRequestHandler().handleDelete(bestMatch.getServerContext(), routedRequest, handler);
        }
        catch (ResourceException e) {
            handler.handleError(e);
        }
    }

    @Override
    public void handlePatch(ServerContext context, PatchRequest request, ResultHandler<Resource> handler) {
        try {
            Route.RouteMatcher bestMatch = this.getBestRoute(context, request);
            PatchRequest routedRequest = bestMatch.wasRouted() ? Requests.copyOfPatchRequest(request).setResourceName(bestMatch.getRemaining()) : request;
            bestMatch.getRequestHandler().handlePatch(bestMatch.getServerContext(), routedRequest, handler);
        }
        catch (ResourceException e) {
            handler.handleError(e);
        }
    }

    @Override
    public void handleQuery(ServerContext context, QueryRequest request, QueryResultHandler handler) {
        try {
            Route.RouteMatcher bestMatch = this.getBestRoute(context, request);
            QueryRequest routedRequest = bestMatch.wasRouted() ? Requests.copyOfQueryRequest(request).setResourceName(bestMatch.getRemaining()) : request;
            bestMatch.getRequestHandler().handleQuery(bestMatch.getServerContext(), routedRequest, handler);
        }
        catch (ResourceException e) {
            handler.handleError(e);
        }
    }

    @Override
    public void handleRead(ServerContext context, ReadRequest request, ResultHandler<Resource> handler) {
        try {
            Route.RouteMatcher bestMatch = this.getBestRoute(context, request);
            ReadRequest routedRequest = bestMatch.wasRouted() ? Requests.copyOfReadRequest(request).setResourceName(bestMatch.getRemaining()) : request;
            bestMatch.getRequestHandler().handleRead(bestMatch.getServerContext(), routedRequest, handler);
        }
        catch (ResourceException e) {
            handler.handleError(e);
        }
    }

    @Override
    public void handleUpdate(ServerContext context, UpdateRequest request, ResultHandler<Resource> handler) {
        try {
            Route.RouteMatcher bestMatch = this.getBestRoute(context, request);
            UpdateRequest routedRequest = bestMatch.wasRouted() ? Requests.copyOfUpdateRequest(request).setResourceName(bestMatch.getRemaining()) : request;
            bestMatch.getRequestHandler().handleUpdate(bestMatch.getServerContext(), routedRequest, handler);
        }
        catch (ResourceException e) {
            handler.handleError(e);
        }
    }

    public Router removeAllRoutes() {
        this.routes.clear();
        return this;
    }

    public boolean removeRoute(Route ... routes) {
        boolean isModified = false;
        for (Route route : routes) {
            isModified |= this.routes.remove(route);
        }
        return isModified;
    }

    public Router setDefaultRoute(RequestHandler handler) {
        this.defaultRoute = handler;
        return this;
    }

    Route addRoute(Route route) {
        this.routes.add(route);
        return route;
    }

    private Route.RouteMatcher getBestRoute(ServerContext context, Request request) throws ResourceException {
        Route.RouteMatcher bestMatcher = null;
        for (Route route : this.routes) {
            Route.RouteMatcher matcher = route.getRouteMatcher(context, request);
            if (matcher == null || !matcher.isBetterMatchThan(bestMatcher)) continue;
            bestMatcher = matcher;
        }
        if (bestMatcher != null) {
            return bestMatcher;
        }
        RequestHandler handler = this.defaultRoute;
        if (handler != null) {
            return new Route.RouteMatcher(context, handler);
        }
        throw new NotFoundException(String.format("Resource '%s' not found", request.getResourceName()));
    }
}

