/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceName;
import org.forgerock.json.resource.RouterContext;
import org.forgerock.json.resource.RoutingMode;
import org.forgerock.json.resource.ServerContext;

public final class Route {
    private final RequestHandler handler;
    private final UriTemplate template;

    Route(RoutingMode mode, String uriTemplate, RequestHandler handler) {
        this.template = new UriTemplate(mode, uriTemplate);
        this.handler = handler;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append(this.template);
        builder.append(" -> ");
        builder.append(this.handler);
        builder.append('}');
        return builder.toString();
    }

    RequestHandler getRequestHandler() {
        return this.handler;
    }

    RouteMatcher getRouteMatcher(ServerContext context, Request request) {
        return this.template.getRouteMatcher(this, context, request);
    }

    private final class UriTemplate {
        private final RoutingMode mode;
        private final Pattern regex;
        private final String uriTemplate;
        private final List<String> variables = new LinkedList<String>();

        private UriTemplate(RoutingMode mode, String uriTemplate) {
            String t = this.removeTrailingSlash(this.removeLeadingSlash(uriTemplate));
            StringBuilder builder = new StringBuilder(t.length() + 8);
            boolean isInVariable = false;
            int elementStart = 0;
            builder.append('(');
            for (int i = 0; i < t.length(); ++i) {
                char c = t.charAt(i);
                if (isInVariable) {
                    if (c == '}') {
                        if (elementStart == i) {
                            throw new IllegalArgumentException("URI template " + t + " contains zero-length template variable");
                        }
                        this.variables.add(t.substring(elementStart, i));
                        builder.append("([^/]+)");
                        isInVariable = false;
                        elementStart = i + 1;
                        continue;
                    }
                    if (this.isValidVariableCharacter(c)) continue;
                    throw new IllegalArgumentException("URI template " + t + " contains an illegal character " + c + " in a template variable");
                }
                if (c != '{') continue;
                builder.append(Pattern.quote(t.substring(elementStart, i)));
                isInVariable = true;
                elementStart = i + 1;
            }
            if (isInVariable) {
                throw new IllegalArgumentException("URI template " + t + " contains a trailing unclosed variable");
            }
            builder.append(Pattern.quote(t.substring(elementStart)));
            builder.append(')');
            if (mode == RoutingMode.STARTS_WITH) {
                if (uriTemplate.isEmpty()) {
                    builder.append("((.*))?");
                } else {
                    builder.append("(/(.*))?");
                }
            }
            this.uriTemplate = uriTemplate;
            this.mode = mode;
            this.regex = Pattern.compile(builder.toString());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.mode == RoutingMode.EQUALS) {
                builder.append("equals(");
            } else {
                builder.append("startsWith(");
            }
            builder.append(this.uriTemplate);
            builder.append(')');
            return builder.toString();
        }

        private Route getRoute() {
            return Route.this;
        }

        private RouteMatcher getRouteMatcher(Route route, ServerContext context, Request request) {
            Map<Object, Object> variableMap;
            String resourceName = request.getResourceName();
            Matcher matcher = this.regex.matcher(resourceName);
            if (!matcher.matches()) {
                return null;
            }
            switch (this.variables.size()) {
                case 0: {
                    variableMap = Collections.emptyMap();
                    break;
                }
                case 1: {
                    variableMap = Collections.singletonMap(this.variables.get(0), ResourceName.urlDecode(matcher.group(2)));
                    break;
                }
                default: {
                    variableMap = new LinkedHashMap(this.variables.size());
                    for (int i = 0; i < this.variables.size(); ++i) {
                        variableMap.put(this.variables.get(i), ResourceName.urlDecode(matcher.group(i + 2)));
                    }
                }
            }
            String remaining = this.removeLeadingSlash(resourceName.substring(matcher.end(1)));
            String matched = matcher.group(1);
            return new RouteMatcher(this, matcher.group(1), remaining, new RouterContext(context, matched, variableMap));
        }

        private String removeLeadingSlash(String resourceName) {
            if (resourceName.startsWith("/")) {
                return resourceName.substring(1);
            }
            return resourceName;
        }

        private String removeTrailingSlash(String resourceName) {
            if (resourceName.endsWith("/")) {
                return resourceName.substring(0, resourceName.length() - 1);
            }
            return resourceName;
        }

        private boolean isValidVariableCharacter(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
        }
    }

    static final class RouteMatcher {
        private final RouterContext context;
        private final RequestHandler handler;
        private final String match;
        private final String remaining;
        private final UriTemplate template;

        RouteMatcher(ServerContext context, RequestHandler handler) {
            this.template = null;
            this.match = null;
            this.remaining = null;
            this.context = new RouterContext(context, "", Collections.<String, String>emptyMap());
            this.handler = handler;
        }

        RouteMatcher(UriTemplate template, String match, String remaining, RouterContext context) {
            this.template = template;
            this.match = match;
            this.remaining = remaining;
            this.context = context;
            this.handler = template.getRoute().getRequestHandler();
        }

        String getRemaining() {
            return this.remaining;
        }

        RequestHandler getRequestHandler() {
            return this.handler;
        }

        ServerContext getServerContext() {
            return this.context;
        }

        boolean isBetterMatchThan(RouteMatcher matcher) {
            if (matcher == null) {
                return true;
            }
            if (!this.match.equals(matcher.match)) {
                return this.match.length() > matcher.match.length();
            }
            if (this.template.mode != matcher.template.mode) {
                return this.template.mode == RoutingMode.EQUALS;
            }
            return this.context.getUriTemplateVariables().size() < matcher.context.getUriTemplateVariables().size();
        }

        boolean wasRouted() {
            return this.remaining != null;
        }
    }
}

