/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;

public final class ResourceName
implements Comparable<ResourceName>,
Iterable<String> {
    private static final ResourceName EMPTY = new ResourceName();
    private static final BitSet SAFE_URL_CHARS = new BitSet(128);
    private static final BitSet NORMALIZED_URL_CHARS;
    private final String path;
    private final String normalizedPath;
    private final int size;

    public static ResourceName empty() {
        return EMPTY;
    }

    public static ResourceName format(String template, Object ... pathElements) {
        String[] encodedPathElements = new String[pathElements.length];
        for (int i = 0; i < pathElements.length; ++i) {
            encodedPathElements[i] = ResourceName.urlEncode(pathElements[i]);
        }
        return ResourceName.valueOf(String.format(template, encodedPathElements));
    }

    public static String urlDecode(Object value) {
        String s = value.toString();
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            if (!ResourceName.isUrlEscapeChar(s.charAt(i))) continue;
            try {
                return URLDecoder.decode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return s;
    }

    public static String urlEncode(Object value) {
        String s = value.toString();
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (SAFE_URL_CHARS.get(c)) continue;
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return s;
    }

    public static ResourceName valueOf(String path) {
        String normalizedPath;
        String trimmedPath;
        String normalizedElement;
        String element;
        if (path.isEmpty()) {
            return EMPTY;
        }
        int size = path.length();
        StringBuilder normalizedPathBuilder = null;
        boolean lastCharWasSlash = false;
        int startOfLastElement = 0;
        boolean lastElementNeedsNormalizing = false;
        boolean lastElementNeedsDecoding = false;
        boolean trimLeadingSlash = false;
        int elementCount = 0;
        for (int i = 0; i < size; ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (lastCharWasSlash) {
                    throw new IllegalArgumentException("Resource name '" + path + "' contains empty path elements");
                }
                lastCharWasSlash = true;
                if (i != 0) {
                    if (lastElementNeedsDecoding || lastElementNeedsNormalizing) {
                        if (normalizedPathBuilder == null) {
                            normalizedPathBuilder = new StringBuilder(size);
                            if (startOfLastElement > 0) {
                                String pathStart = path.substring(trimLeadingSlash ? 1 : 0, startOfLastElement);
                                normalizedPathBuilder.append(pathStart);
                            }
                        } else {
                            normalizedPathBuilder.append('/');
                        }
                        element = path.substring(startOfLastElement, i);
                        normalizedElement = ResourceName.normalizePathElement(element, lastElementNeedsDecoding);
                        normalizedPathBuilder.append(normalizedElement);
                    } else if (normalizedPathBuilder != null) {
                        normalizedPathBuilder.append('/');
                        normalizedPathBuilder.append(path.substring(startOfLastElement, i));
                    }
                    ++elementCount;
                    continue;
                }
                trimLeadingSlash = true;
                continue;
            }
            if (lastCharWasSlash) {
                lastCharWasSlash = false;
                startOfLastElement = i;
                lastElementNeedsDecoding = ResourceName.isUrlEscapeChar(c);
                lastElementNeedsNormalizing = ResourceName.needsNormalizing(c);
                continue;
            }
            if (ResourceName.isUrlEscapeChar(c)) {
                lastElementNeedsDecoding = true;
                continue;
            }
            if (!ResourceName.needsNormalizing(c)) continue;
            lastElementNeedsNormalizing = true;
        }
        if (trimLeadingSlash) {
            if (size == 1) {
                return EMPTY;
            }
            trimmedPath = lastCharWasSlash ? path.substring(1, size - 1) : path.substring(1, size);
        } else {
            trimmedPath = lastCharWasSlash ? path.substring(0, size - 1) : path;
        }
        if (!lastCharWasSlash) {
            if (lastElementNeedsDecoding || lastElementNeedsNormalizing) {
                element = path.substring(startOfLastElement, size);
                normalizedElement = ResourceName.normalizePathElement(element, lastElementNeedsDecoding);
                if (normalizedPathBuilder == null) {
                    if (startOfLastElement > 0) {
                        String pathStart = path.substring(trimLeadingSlash ? 1 : 0, startOfLastElement);
                        normalizedPathBuilder = new StringBuilder(size);
                        normalizedPathBuilder.append(pathStart);
                        normalizedPathBuilder.append(normalizedElement);
                        normalizedPath = normalizedPathBuilder.toString();
                    } else {
                        normalizedPath = normalizedElement;
                    }
                } else {
                    normalizedPathBuilder.append('/');
                    normalizedPathBuilder.append(normalizedElement);
                    normalizedPath = normalizedPathBuilder.toString();
                }
            } else if (normalizedPathBuilder != null) {
                normalizedPathBuilder.append('/');
                normalizedPathBuilder.append(path.substring(startOfLastElement, size));
                normalizedPath = normalizedPathBuilder.toString();
            } else {
                normalizedPath = trimmedPath;
            }
            ++elementCount;
        } else {
            normalizedPath = normalizedPathBuilder != null ? normalizedPathBuilder.toString() : trimmedPath;
        }
        return new ResourceName(trimmedPath, normalizedPath, elementCount);
    }

    private static boolean isUrlEscapeChar(char c) {
        return c == '+' || c == '%';
    }

    private static boolean needsNormalizing(char c) {
        return !NORMALIZED_URL_CHARS.get(c);
    }

    private static String normalizePathElement(String element, boolean needsDecoding) {
        if (needsDecoding) {
            return ResourceName.urlEncode(ResourceName.urlDecode(element).toLowerCase(Locale.ENGLISH));
        }
        return element.toLowerCase(Locale.ENGLISH);
    }

    public ResourceName() {
        this.normalizedPath = "";
        this.path = "";
        this.size = 0;
    }

    public ResourceName(Collection<? extends Object> pathElements) {
        int i = 0;
        StringBuilder pathBuilder = new StringBuilder();
        StringBuilder normalizedPathBuilder = new StringBuilder();
        for (Object object : pathElements) {
            String s = object.toString();
            if (i > 0) {
                pathBuilder.append('/');
                normalizedPathBuilder.append('/');
            }
            String encodedPathElement = ResourceName.urlEncode(s);
            pathBuilder.append(encodedPathElement);
            String normalizedPathElement = s.toLowerCase(Locale.ENGLISH);
            if (normalizedPathElement == s) {
                normalizedPathBuilder.append(encodedPathElement);
            } else {
                normalizedPathBuilder.append(ResourceName.urlEncode(normalizedPathElement));
            }
            ++i;
        }
        this.path = pathBuilder.toString();
        this.normalizedPath = normalizedPathBuilder.toString();
        this.size = pathElements.size();
    }

    public ResourceName(Object ... pathElements) {
        this(Arrays.asList(pathElements));
    }

    private ResourceName(String path, String normalizedPath, int size) {
        this.path = path;
        this.normalizedPath = normalizedPath;
        this.size = size;
    }

    public ResourceName child(Object pathElement) {
        String normalizedEncodedPathElement;
        String s = pathElement.toString();
        String encodedPathElement = ResourceName.urlEncode(s);
        String normalizedPathElement = s.toLowerCase(Locale.ENGLISH);
        String string = normalizedEncodedPathElement = s == normalizedPathElement ? encodedPathElement : ResourceName.urlEncode(normalizedPathElement);
        if (this.isEmpty()) {
            return new ResourceName(encodedPathElement, normalizedEncodedPathElement, 1);
        }
        String newPath = this.path + "/" + encodedPathElement;
        String newNormalizedPath = this.normalizedPath + "/" + normalizedEncodedPathElement;
        return new ResourceName(newPath, newNormalizedPath, this.size + 1);
    }

    @Override
    public int compareTo(ResourceName o) {
        return this.normalizedPath.compareTo(o.normalizedPath);
    }

    public ResourceName concat(ResourceName suffix) {
        if (this.isEmpty()) {
            return suffix;
        }
        if (suffix.isEmpty()) {
            return this;
        }
        String newPath = this.path + "/" + suffix.path;
        String newNormalizedPath = this.normalizedPath + "/" + suffix.normalizedPath;
        return new ResourceName(newPath, newNormalizedPath, this.size + suffix.size);
    }

    public ResourceName concat(String suffix) {
        return this.concat(ResourceName.valueOf(suffix));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ResourceName) {
            return this.normalizedPath.equals(((ResourceName)obj).normalizedPath);
        }
        return false;
    }

    public String get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int startIndex = 0;
        int endIndex = this.nextElementEndIndex(this.path, 0);
        for (int i = 0; i < index; ++i) {
            startIndex = endIndex + 1;
            endIndex = this.nextElementEndIndex(this.path, startIndex);
        }
        return ResourceName.urlDecode(this.path.substring(startIndex, endIndex));
    }

    public int hashCode() {
        return this.normalizedPath.hashCode();
    }

    public ResourceName head(int endIndex) {
        return this.subSequence(0, endIndex);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int startIndex = 0;
            private int endIndex = ResourceName.access$100(ResourceName.this, ResourceName.access$000(ResourceName.this), 0);

            @Override
            public boolean hasNext() {
                return this.startIndex < ResourceName.this.path.length();
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String element = ResourceName.this.path.substring(this.startIndex, this.endIndex);
                this.startIndex = this.endIndex + 1;
                this.endIndex = ResourceName.this.nextElementEndIndex(ResourceName.this.path, this.startIndex);
                return ResourceName.urlDecode(element);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String leaf() {
        return this.get(this.size() - 1);
    }

    public ResourceName parent() {
        switch (this.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return EMPTY;
            }
        }
        String newPath = this.path.substring(0, this.path.lastIndexOf(47));
        String newNormalizedPath = this.normalizedPath.substring(0, this.normalizedPath.lastIndexOf(47));
        return new ResourceName(newPath, newNormalizedPath, this.size - 1);
    }

    public int size() {
        return this.size;
    }

    public boolean startsWith(ResourceName prefix) {
        if (this.size == prefix.size) {
            return this.equals(prefix);
        }
        if (this.size < prefix.size) {
            return false;
        }
        if (prefix.size == 0) {
            return true;
        }
        return this.normalizedPath.startsWith(prefix.normalizedPath) && this.normalizedPath.charAt(prefix.normalizedPath.length()) == '/';
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(ResourceName.valueOf(prefix));
    }

    public ResourceName subSequence(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.size || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        if (beginIndex == 0 && endIndex == this.size) {
            return this;
        }
        if (endIndex - beginIndex == 0) {
            return EMPTY;
        }
        String subPath = this.subPath(this.path, beginIndex, endIndex);
        String subNormalizedPath = this.subPath(this.normalizedPath, beginIndex, endIndex);
        return new ResourceName(subPath, subNormalizedPath, endIndex - beginIndex);
    }

    public ResourceName tail(int beginIndex) {
        return this.subSequence(beginIndex, this.size);
    }

    public String toString() {
        return this.path;
    }

    private int nextElementEndIndex(String s, int startIndex) {
        int index = s.indexOf(47, startIndex);
        return index < 0 ? s.length() : index;
    }

    private String subPath(String s, int beginIndex, int endIndex) {
        int startCharIndex = 0;
        int endCharIndex = this.nextElementEndIndex(s, 0);
        for (int i = 0; i < beginIndex; ++i) {
            startCharIndex = endCharIndex + 1;
            endCharIndex = this.nextElementEndIndex(s, startCharIndex);
        }
        for (int i = beginIndex + 1; i < endIndex; ++i) {
            int tmpStartCharIndex = endCharIndex + 1;
            endCharIndex = this.nextElementEndIndex(s, tmpStartCharIndex);
        }
        return s.substring(startCharIndex, endCharIndex);
    }

    static {
        SAFE_URL_CHARS.set(45);
        SAFE_URL_CHARS.set(95);
        SAFE_URL_CHARS.set(46);
        SAFE_URL_CHARS.set(42);
        SAFE_URL_CHARS.set(48, 58);
        SAFE_URL_CHARS.set(97, 123);
        SAFE_URL_CHARS.set(65, 91);
        NORMALIZED_URL_CHARS = new BitSet(128);
        NORMALIZED_URL_CHARS.set(45);
        NORMALIZED_URL_CHARS.set(95);
        NORMALIZED_URL_CHARS.set(46);
        NORMALIZED_URL_CHARS.set(42);
        NORMALIZED_URL_CHARS.set(48, 58);
        NORMALIZED_URL_CHARS.set(97, 123);
    }
}

