/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.ConflictException;
import org.forgerock.json.resource.ForbiddenException;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotFoundException;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PermanentException;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.PreconditionRequiredException;
import org.forgerock.json.resource.RetryableException;
import org.forgerock.json.resource.ServiceUnavailableException;
import org.forgerock.json.resource.UncategorizedException;

public class ResourceException
extends ExecutionException {
    public static final String FIELD_DETAIL = "detail";
    public static final String FIELD_MESSAGE = "message";
    public static final String FIELD_REASON = "reason";
    public static final String FIELD_CODE = "code";
    public static final int BAD_REQUEST = 400;
    public static final int CONFLICT = 409;
    public static final int FORBIDDEN = 403;
    public static final int INTERNAL_ERROR = 500;
    public static final int NOT_FOUND = 404;
    public static final int NOT_SUPPORTED = 501;
    public static final int UNAVAILABLE = 503;
    public static final int VERSION_MISMATCH = 412;
    public static final int VERSION_REQUIRED = 428;
    private static final long serialVersionUID = 1L;
    private final int code;
    private String reason;
    private JsonValue detail = new JsonValue(null);

    public static ResourceException getException(int code) {
        return ResourceException.getException(code, null);
    }

    public static ResourceException getException(int code, String message) {
        return ResourceException.getException(code, message, null);
    }

    public static ResourceException getException(int code, String message, Throwable cause) {
        ResourceException ex;
        switch (code) {
            case 400: {
                ex = new BadRequestException(message, cause);
                break;
            }
            case 403: {
                ex = new ForbiddenException(message, cause);
                break;
            }
            case 404: {
                ex = new NotFoundException(message, cause);
                break;
            }
            case 409: {
                ex = new ConflictException(message, cause);
                break;
            }
            case 412: {
                ex = new PreconditionFailedException(message, cause);
                break;
            }
            case 428: {
                ex = new PreconditionRequiredException(message, cause);
                break;
            }
            case 500: {
                ex = new InternalServerErrorException(message, cause);
                break;
            }
            case 501: {
                ex = new NotSupportedException(message, cause);
                break;
            }
            case 503: {
                ex = new ServiceUnavailableException(message, cause);
                break;
            }
            case 408: 
            case 504: {
                ex = new RetryableException(code, message, cause);
                break;
            }
            case 401: 
            case 402: 
            case 405: 
            case 406: 
            case 407: 
            case 410: 
            case 411: 
            case 413: 
            case 414: 
            case 415: 
            case 416: 
            case 417: 
            case 502: 
            case 505: {
                ex = new PermanentException(code, message, cause);
                break;
            }
            default: {
                ex = new UncategorizedException(code, message, cause);
            }
        }
        return ex;
    }

    private static String reason(int code) {
        String result = "Resource Exception";
        switch (code) {
            case 400: {
                result = "Bad Request";
                break;
            }
            case 401: {
                result = "Unauthorized";
                break;
            }
            case 402: {
                result = "Payment Required";
                break;
            }
            case 403: {
                result = "Forbidden";
                break;
            }
            case 404: {
                result = "Not Found";
                break;
            }
            case 405: {
                result = "Method Not Allowed";
                break;
            }
            case 406: {
                result = "Not Acceptable";
                break;
            }
            case 407: {
                result = "Proxy Authentication Required";
                break;
            }
            case 408: {
                result = "Request Time-out";
                break;
            }
            case 409: {
                result = "Conflict";
                break;
            }
            case 410: {
                result = "Gone";
                break;
            }
            case 411: {
                result = "Length Required";
                break;
            }
            case 412: {
                result = "Precondition Failed";
                break;
            }
            case 413: {
                result = "Request Entity Too Large";
                break;
            }
            case 414: {
                result = "Request-URI Too Large";
                break;
            }
            case 415: {
                result = "Unsupported Media Type";
                break;
            }
            case 416: {
                result = "Requested range not satisfiable";
                break;
            }
            case 417: {
                result = "Expectation Failed";
                break;
            }
            case 428: {
                result = "Precondition Required";
                break;
            }
            case 500: {
                result = "Internal Server Error";
                break;
            }
            case 501: {
                result = "Not Implemented";
                break;
            }
            case 502: {
                result = "Bad Gateway";
                break;
            }
            case 503: {
                result = "Service Unavailable";
                break;
            }
            case 504: {
                result = "Gateway Time-out";
                break;
            }
            case 505: {
                result = "HTTP Version not supported";
            }
        }
        return result;
    }

    private static String message(int code, String message, Throwable cause) {
        if (message != null) {
            return message;
        }
        if (cause != null && cause.getMessage() != null) {
            return cause.getMessage();
        }
        return ResourceException.reason(code);
    }

    protected ResourceException(int code) {
        this(code, null, null);
    }

    protected ResourceException(int code, String message) {
        this(code, message, null);
    }

    protected ResourceException(int code, Throwable cause) {
        this(code, null, cause);
    }

    protected ResourceException(int code, String message, Throwable cause) {
        super(ResourceException.message(code, message, cause), cause);
        this.code = code;
        this.reason = ResourceException.reason(code);
    }

    public final int getCode() {
        return this.code;
    }

    public boolean isServerError() {
        return this.code >= 500 && this.code <= 599;
    }

    public final JsonValue getDetail() {
        return this.detail;
    }

    public final String getReason() {
        return this.reason;
    }

    public final ResourceException setDetail(JsonValue detail) {
        this.detail = detail != null ? detail : new JsonValue(null);
        return this;
    }

    public final ResourceException setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public final JsonValue toJsonValue() {
        String message;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(4);
        result.put(FIELD_CODE, this.code);
        if (this.reason != null) {
            result.put(FIELD_REASON, this.reason);
        }
        if ((message = this.getMessage()) != null) {
            result.put(FIELD_MESSAGE, message);
        }
        if (!this.detail.isNull()) {
            result.put(FIELD_DETAIL, this.detail.getObject());
        }
        return new JsonValue(result);
    }
}

