/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.forgerock.json.fluent.JsonException;
import org.forgerock.json.fluent.JsonPointer;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryFilter;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestType;
import org.forgerock.json.resource.RequestVisitor;
import org.forgerock.json.resource.ResourceName;
import org.forgerock.json.resource.SortKey;
import org.forgerock.json.resource.UpdateRequest;

public final class Requests {
    public static ActionRequest copyOfActionRequest(ActionRequest request) {
        return new ActionRequestImpl(request);
    }

    public static CreateRequest copyOfCreateRequest(CreateRequest request) {
        return new CreateRequestImpl(request);
    }

    public static DeleteRequest copyOfDeleteRequest(DeleteRequest request) {
        return new DeleteRequestImpl(request);
    }

    public static PatchRequest copyOfPatchRequest(PatchRequest request) {
        return new PatchRequestImpl(request);
    }

    public static QueryRequest copyOfQueryRequest(QueryRequest request) {
        return new QueryRequestImpl(request);
    }

    public static ReadRequest copyOfReadRequest(ReadRequest request) {
        return new ReadRequestImpl(request);
    }

    public static UpdateRequest copyOfUpdateRequest(UpdateRequest request) {
        return new UpdateRequestImpl(request);
    }

    public static ActionRequest newActionRequest(String resourceName, String actionId) {
        return ((ActionRequest)new ActionRequestImpl().setResourceName(resourceName)).setAction(actionId);
    }

    public static ActionRequest newActionRequest(String resourceContainer, String resourceId, String actionId) {
        return Requests.newActionRequest(Requests.concat(resourceContainer, resourceId), actionId);
    }

    public static CreateRequest newCreateRequest(String resourceContainer, JsonValue content) {
        return ((CreateRequest)new CreateRequestImpl().setResourceName(resourceContainer)).setContent(content);
    }

    public static CreateRequest newCreateRequest(String resourceContainer, String newResourceId, JsonValue content) {
        return Requests.newCreateRequest(resourceContainer, content).setNewResourceId(newResourceId);
    }

    public static DeleteRequest newDeleteRequest(String resourceName) {
        return (DeleteRequest)new DeleteRequestImpl().setResourceName(resourceName);
    }

    public static DeleteRequest newDeleteRequest(String resourceContainer, String resourceId) {
        return Requests.newDeleteRequest(Requests.concat(resourceContainer, resourceId));
    }

    public static PatchRequest newPatchRequest(String resourceName, PatchOperation ... operations) {
        return ((PatchRequest)new PatchRequestImpl().setResourceName(resourceName)).addPatchOperation(operations);
    }

    public static PatchRequest newPatchRequest(String resourceContainer, String resourceId, PatchOperation ... operations) {
        return Requests.newPatchRequest(Requests.concat(resourceContainer, resourceId), operations);
    }

    public static QueryRequest newQueryRequest(String resourceContainer) {
        return (QueryRequest)new QueryRequestImpl().setResourceName(resourceContainer);
    }

    public static ReadRequest newReadRequest(String resourceName) {
        return (ReadRequest)new ReadRequestImpl().setResourceName(resourceName);
    }

    public static ReadRequest newReadRequest(String resourceContainer, String resourceId) {
        return Requests.newReadRequest(Requests.concat(resourceContainer, resourceId));
    }

    public static UpdateRequest newUpdateRequest(String resourceName, JsonValue newContent) {
        return ((UpdateRequest)new UpdateRequestImpl().setResourceName(resourceName)).setNewContent(newContent);
    }

    public static UpdateRequest newUpdateRequest(String resourceContainer, String resourceId, JsonValue newContent) {
        return Requests.newUpdateRequest(Requests.concat(resourceContainer, resourceId), newContent);
    }

    private static String concat(String resourceContainer, String resourceId) {
        String urlEncodedResourceId = ResourceName.urlEncode(resourceId);
        StringBuilder builder = new StringBuilder(resourceContainer.length() + 1 + urlEncodedResourceId.length());
        builder.append(resourceContainer);
        if (!resourceContainer.endsWith("/") && resourceContainer.length() > 1) {
            builder.append('/');
        }
        builder.append(urlEncodedResourceId);
        return builder.toString();
    }

    private static JsonValue copyJsonValue(JsonValue value) {
        return value != null ? value.copy() : null;
    }

    private static <T> T notNull(T object) {
        if (object != null) {
            return object;
        }
        throw new NullPointerException();
    }

    private Requests() {
    }

    private static final class UpdateRequestImpl
    extends AbstractRequestImpl<UpdateRequest>
    implements UpdateRequest {
        private JsonValue content;
        private String version;

        private UpdateRequestImpl() {
        }

        private UpdateRequestImpl(UpdateRequest request) {
            super(request);
            this.version = request.getRevision();
            this.content = Requests.copyJsonValue(request.getNewContent());
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            return v.visitUpdateRequest(p, this);
        }

        @Override
        public JsonValue getNewContent() {
            return this.content;
        }

        @Override
        public String getRevision() {
            return this.version;
        }

        @Override
        public UpdateRequest setNewContent(JsonValue content) {
            this.content = (JsonValue)Requests.notNull(content);
            return this;
        }

        @Override
        public UpdateRequest setRevision(String version) {
            this.version = version;
            return this;
        }

        @Override
        protected UpdateRequest getThis() {
            return this;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.UPDATE;
        }
    }

    private static final class ReadRequestImpl
    extends AbstractRequestImpl<ReadRequest>
    implements ReadRequest {
        private ReadRequestImpl() {
        }

        private ReadRequestImpl(ReadRequest request) {
            super(request);
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            return v.visitReadRequest(p, this);
        }

        @Override
        protected ReadRequest getThis() {
            return this;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.READ;
        }
    }

    private static final class QueryRequestImpl
    extends AbstractRequestImpl<QueryRequest>
    implements QueryRequest {
        private QueryFilter filter;
        private final List<SortKey> keys = new LinkedList<SortKey>();
        private String pagedResultsCookie;
        private int pagedResultsOffset = 0;
        private int pageSize = 0;
        private final Map<String, String> parameters = new LinkedHashMap<String, String>(2);
        private String queryId;
        private String queryExpression;

        private QueryRequestImpl() {
        }

        private QueryRequestImpl(QueryRequest request) {
            super(request);
            this.filter = request.getQueryFilter();
            this.queryId = request.getQueryId();
            this.queryExpression = request.getQueryExpression();
            this.keys.addAll(request.getSortKeys());
            this.parameters.putAll(request.getAdditionalQueryParameters());
            this.pageSize = request.getPageSize();
            this.pagedResultsCookie = request.getPagedResultsCookie();
            this.pagedResultsOffset = request.getPagedResultsOffset();
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            return v.visitQueryRequest(p, this);
        }

        @Override
        public QueryRequest addSortKey(SortKey ... keys) {
            for (SortKey key : keys) {
                this.keys.add((SortKey)Requests.notNull(key));
            }
            return this;
        }

        @Override
        public final QueryRequest addSortKey(String ... keys) {
            for (String key : keys) {
                this.keys.add(SortKey.valueOf(key));
            }
            return this;
        }

        @Override
        public Map<String, String> getAdditionalQueryParameters() {
            return this.parameters;
        }

        @Override
        public String getPagedResultsCookie() {
            return this.pagedResultsCookie;
        }

        @Override
        public int getPagedResultsOffset() {
            return this.pagedResultsOffset;
        }

        @Override
        public int getPageSize() {
            return this.pageSize;
        }

        @Override
        public QueryFilter getQueryFilter() {
            return this.filter;
        }

        @Override
        public String getQueryId() {
            return this.queryId;
        }

        @Override
        public String getQueryExpression() {
            return this.queryExpression;
        }

        @Override
        public List<SortKey> getSortKeys() {
            return this.keys;
        }

        @Override
        public QueryRequest setAdditionalQueryParameter(String name, String value) {
            this.parameters.put((String)Requests.notNull(name), (String)Requests.notNull(value));
            return this;
        }

        @Override
        public QueryRequest setPagedResultsCookie(String cookie) {
            this.pagedResultsCookie = cookie;
            return this;
        }

        @Override
        public QueryRequest setPagedResultsOffset(int offset) {
            this.pagedResultsOffset = offset;
            return this;
        }

        @Override
        public QueryRequest setPageSize(int size) {
            this.pageSize = size;
            return this;
        }

        @Override
        public QueryRequest setQueryExpression(String expression) {
            this.queryExpression = expression;
            return this;
        }

        @Override
        public QueryRequest setQueryFilter(QueryFilter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public QueryRequest setQueryId(String id) {
            this.queryId = id;
            return this;
        }

        @Override
        protected QueryRequest getThis() {
            return this;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.QUERY;
        }
    }

    private static final class PatchRequestImpl
    extends AbstractRequestImpl<PatchRequest>
    implements PatchRequest {
        private List<PatchOperation> operations;
        private String version;

        private PatchRequestImpl() {
            this.operations = new LinkedList<PatchOperation>();
        }

        private PatchRequestImpl(PatchRequest request) {
            super(request);
            this.operations = new LinkedList<PatchOperation>(request.getPatchOperations());
            this.version = request.getRevision();
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            return v.visitPatchRequest(p, this);
        }

        @Override
        public String getRevision() {
            return this.version;
        }

        @Override
        public PatchRequest addPatchOperation(PatchOperation ... operations) {
            for (PatchOperation operation : operations) {
                this.operations.add(operation);
            }
            return this;
        }

        @Override
        public List<PatchOperation> getPatchOperations() {
            return this.operations;
        }

        @Override
        public PatchRequest addPatchOperation(String operation, String field, JsonValue value) {
            this.operations.add(PatchOperation.operation(operation, field, (Object)value));
            return this;
        }

        @Override
        public PatchRequest setRevision(String version) {
            this.version = version;
            return this;
        }

        @Override
        protected PatchRequest getThis() {
            return this;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.PATCH;
        }
    }

    private static final class DeleteRequestImpl
    extends AbstractRequestImpl<DeleteRequest>
    implements DeleteRequest {
        private String version;

        private DeleteRequestImpl() {
        }

        private DeleteRequestImpl(DeleteRequest request) {
            super(request);
            this.version = request.getRevision();
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            return v.visitDeleteRequest(p, this);
        }

        @Override
        public String getRevision() {
            return this.version;
        }

        @Override
        public DeleteRequest setRevision(String version) {
            this.version = version;
            return this;
        }

        @Override
        protected DeleteRequest getThis() {
            return this;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.DELETE;
        }
    }

    private static final class CreateRequestImpl
    extends AbstractRequestImpl<CreateRequest>
    implements CreateRequest {
        private JsonValue content;
        private String newResourceId;

        private CreateRequestImpl() {
        }

        private CreateRequestImpl(CreateRequest request) {
            super(request);
            this.content = Requests.copyJsonValue(request.getContent());
            this.newResourceId = request.getNewResourceId();
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            return v.visitCreateRequest(p, this);
        }

        @Override
        public JsonValue getContent() {
            return this.content;
        }

        @Override
        public String getNewResourceId() {
            return this.newResourceId;
        }

        @Override
        public CreateRequest setContent(JsonValue content) {
            this.content = (JsonValue)Requests.notNull(content);
            return this;
        }

        @Override
        public CreateRequest setNewResourceId(String id) {
            this.newResourceId = id;
            return this;
        }

        @Override
        protected CreateRequest getThis() {
            return this;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.CREATE;
        }
    }

    private static final class ActionRequestImpl
    extends AbstractRequestImpl<ActionRequest>
    implements ActionRequest {
        private String actionId;
        private JsonValue content;
        private final Map<String, String> parameters = new LinkedHashMap<String, String>(2);

        private ActionRequestImpl() {
        }

        private ActionRequestImpl(ActionRequest request) {
            super(request);
            this.actionId = request.getAction();
            this.content = Requests.copyJsonValue(request.getContent());
            this.parameters.putAll(request.getAdditionalActionParameters());
        }

        @Override
        public <R, P> R accept(RequestVisitor<R, P> v, P p) {
            return v.visitActionRequest(p, this);
        }

        @Override
        public String getAction() {
            return this.actionId;
        }

        @Override
        public Map<String, String> getAdditionalActionParameters() {
            return this.parameters;
        }

        @Override
        public JsonValue getContent() {
            return this.content;
        }

        @Override
        public ActionRequest setAction(String id) {
            this.actionId = (String)Requests.notNull(id);
            return this;
        }

        @Override
        public ActionRequest setAdditionalActionParameter(String name, String value) {
            this.parameters.put((String)Requests.notNull(name), (String)Requests.notNull(value));
            return this;
        }

        @Override
        public ActionRequest setContent(JsonValue content) {
            this.content = content;
            return this;
        }

        @Override
        protected ActionRequest getThis() {
            return this;
        }

        @Override
        public RequestType getRequestType() {
            return RequestType.ACTION;
        }
    }

    private static abstract class AbstractRequestImpl<T extends Request>
    implements Request {
        private final List<JsonPointer> fields = new LinkedList<JsonPointer>();
        private ResourceName resourceName;

        protected AbstractRequestImpl() {
        }

        protected AbstractRequestImpl(Request request) {
            this.resourceName = request.getResourceNameObject();
            this.fields.addAll(request.getFields());
        }

        public final T addField(JsonPointer ... fields) {
            for (JsonPointer field : fields) {
                this.fields.add((JsonPointer)Requests.notNull(field));
            }
            return this.getThis();
        }

        public final T addField(String ... fields) {
            try {
                for (String field : fields) {
                    this.fields.add(new JsonPointer(field));
                }
            }
            catch (JsonException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            return this.getThis();
        }

        @Override
        public final List<JsonPointer> getFields() {
            return this.fields;
        }

        @Override
        public final String getResourceName() {
            return this.resourceName.toString();
        }

        @Override
        public final ResourceName getResourceNameObject() {
            return this.resourceName;
        }

        public final T setResourceName(String name) {
            this.resourceName = ResourceName.valueOf(name);
            return this.getThis();
        }

        public final T setResourceName(ResourceName name) {
            this.resourceName = (ResourceName)Requests.notNull(name);
            return this.getThis();
        }

        protected abstract T getThis();
    }
}

