/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.forgerock.json.fluent.JsonPointer;
import org.forgerock.json.resource.QueryFilterVisitor;

public final class QueryFilter {
    private static final QueryFilter ALWAYS_FALSE = new QueryFilter(new BooleanLiteralImpl(false));
    private static final QueryFilter ALWAYS_TRUE = new QueryFilter(new BooleanLiteralImpl(true));
    private static final int VALUE_OF_MAX_DEPTH = 256;
    private final Impl pimpl;

    public static QueryFilter alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static QueryFilter alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static QueryFilter and(Collection<QueryFilter> subFilters) {
        switch (subFilters.size()) {
            case 0: {
                return QueryFilter.alwaysTrue();
            }
            case 1: {
                return subFilters.iterator().next();
            }
        }
        return new QueryFilter(new AndImpl(Collections.unmodifiableList(new ArrayList<QueryFilter>(subFilters))));
    }

    public static QueryFilter and(QueryFilter ... subFilters) {
        return QueryFilter.and(Arrays.asList(subFilters));
    }

    public static QueryFilter comparisonFilter(JsonPointer field, String operator, Object valueAssertion) {
        if (operator.equalsIgnoreCase("eq")) {
            return QueryFilter.equalTo(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("gt")) {
            return QueryFilter.greaterThan(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("ge")) {
            return QueryFilter.greaterThanOrEqualTo(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("lt")) {
            return QueryFilter.lessThan(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("le")) {
            return QueryFilter.lessThanOrEqualTo(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("co")) {
            return QueryFilter.contains(field, valueAssertion);
        }
        if (operator.equalsIgnoreCase("sw")) {
            return QueryFilter.startsWith(field, valueAssertion);
        }
        if (operator.matches("[a-zA-Z_0-9.]+")) {
            return new QueryFilter(new ExtendedMatchImpl(field, operator, valueAssertion));
        }
        throw new IllegalArgumentException("\"" + operator + "\" is not a valid filter operator");
    }

    public static QueryFilter comparisonFilter(String field, String operator, Object valueAssertion) {
        return QueryFilter.comparisonFilter(new JsonPointer(field), operator, valueAssertion);
    }

    public static QueryFilter contains(JsonPointer field, Object valueAssertion) {
        return new QueryFilter(new ContainsImpl(field, valueAssertion));
    }

    public static QueryFilter contains(String field, Object valueAssertion) {
        return QueryFilter.contains(new JsonPointer(field), valueAssertion);
    }

    public static QueryFilter equalTo(JsonPointer field, Object valueAssertion) {
        return new QueryFilter(new EqualsImpl(field, valueAssertion));
    }

    public static QueryFilter equalTo(String field, Object valueAssertion) {
        return QueryFilter.equalTo(new JsonPointer(field), valueAssertion);
    }

    public static QueryFilter greaterThan(JsonPointer field, Object valueAssertion) {
        return new QueryFilter(new GreaterThanImpl(field, valueAssertion));
    }

    public static QueryFilter greaterThan(String field, Object valueAssertion) {
        return QueryFilter.greaterThan(new JsonPointer(field), valueAssertion);
    }

    public static QueryFilter greaterThanOrEqualTo(JsonPointer field, Object valueAssertion) {
        return new QueryFilter(new GreaterThanOrEqualToImpl(field, valueAssertion));
    }

    public static QueryFilter greaterThanOrEqualTo(String field, Object valueAssertion) {
        return QueryFilter.greaterThanOrEqualTo(new JsonPointer(field), valueAssertion);
    }

    public static QueryFilter lessThan(JsonPointer field, Object valueAssertion) {
        return new QueryFilter(new LessThanImpl(field, valueAssertion));
    }

    public static QueryFilter lessThan(String field, Object valueAssertion) {
        return QueryFilter.lessThan(new JsonPointer(field), valueAssertion);
    }

    public static QueryFilter lessThanOrEqualTo(JsonPointer field, Object valueAssertion) {
        return new QueryFilter(new LessThanOrEqualToImpl(field, valueAssertion));
    }

    public static QueryFilter lessThanOrEqualTo(String field, Object valueAssertion) {
        return QueryFilter.lessThanOrEqualTo(new JsonPointer(field), valueAssertion);
    }

    public static QueryFilter not(QueryFilter subFilter) {
        return new QueryFilter(new NotImpl(subFilter));
    }

    public static QueryFilter or(Collection<QueryFilter> subFilters) {
        switch (subFilters.size()) {
            case 0: {
                return QueryFilter.alwaysFalse();
            }
            case 1: {
                return subFilters.iterator().next();
            }
        }
        return new QueryFilter(new OrImpl(Collections.unmodifiableList(new ArrayList<QueryFilter>(subFilters))));
    }

    public static QueryFilter or(QueryFilter ... subFilters) {
        return QueryFilter.or(Arrays.asList(subFilters));
    }

    public static QueryFilter present(JsonPointer field) {
        return new QueryFilter(new PresentImpl(field));
    }

    public static QueryFilter present(String field) {
        return QueryFilter.present(new JsonPointer(field));
    }

    public static QueryFilter startsWith(JsonPointer field, Object valueAssertion) {
        return new QueryFilter(new StartsWithImpl(field, valueAssertion));
    }

    public static QueryFilter startsWith(String field, Object valueAssertion) {
        return QueryFilter.startsWith(new JsonPointer(field), valueAssertion);
    }

    public static QueryFilter valueOf(String string) {
        FilterTokenizer tokenizer = new FilterTokenizer(string);
        QueryFilter filter = QueryFilter.valueOfOrExpr(tokenizer, 0);
        if (tokenizer.hasNext()) {
            return QueryFilter.valueOfIllegalArgument(tokenizer);
        }
        return filter;
    }

    private static void checkDepth(FilterTokenizer tokenizer, int depth) {
        if (depth > 256) {
            throw new IllegalArgumentException("The query filter '" + tokenizer + "' cannot be parsed because it contains more than " + 256 + " nexted expressions");
        }
    }

    private static QueryFilter valueOfAndExpr(FilterTokenizer tokenizer, int depth) {
        QueryFilter.checkDepth(tokenizer, depth);
        QueryFilter filter = QueryFilter.valueOfNotExpr(tokenizer, depth + 1);
        LinkedList<QueryFilter> subFilters = null;
        while (tokenizer.hasNext() && tokenizer.peek().equalsIgnoreCase("and")) {
            tokenizer.next();
            if (subFilters == null) {
                subFilters = new LinkedList<QueryFilter>();
                subFilters.add(filter);
            }
            subFilters.add(QueryFilter.valueOfNotExpr(tokenizer, depth + 1));
        }
        if (subFilters != null) {
            filter = QueryFilter.and(subFilters);
        }
        return filter;
    }

    private static QueryFilter valueOfIllegalArgument(FilterTokenizer tokenizer) {
        throw new IllegalArgumentException("Invalid query filter '" + tokenizer + "'");
    }

    private static QueryFilter valueOfNotExpr(FilterTokenizer tokenizer, int depth) {
        QueryFilter.checkDepth(tokenizer, depth);
        if (tokenizer.hasNext() && tokenizer.peek().equalsIgnoreCase("!")) {
            tokenizer.next();
            QueryFilter rhs = QueryFilter.valueOfPrimaryExpr(tokenizer, depth + 1);
            return QueryFilter.not(rhs);
        }
        return QueryFilter.valueOfPrimaryExpr(tokenizer, depth + 1);
    }

    private static QueryFilter valueOfOrExpr(FilterTokenizer tokenizer, int depth) {
        QueryFilter.checkDepth(tokenizer, depth);
        QueryFilter filter = QueryFilter.valueOfAndExpr(tokenizer, depth + 1);
        LinkedList<QueryFilter> subFilters = null;
        while (tokenizer.hasNext() && tokenizer.peek().equalsIgnoreCase("or")) {
            tokenizer.next();
            if (subFilters == null) {
                subFilters = new LinkedList<QueryFilter>();
                subFilters.add(filter);
            }
            subFilters.add(QueryFilter.valueOfAndExpr(tokenizer, depth + 1));
        }
        if (subFilters != null) {
            filter = QueryFilter.or(subFilters);
        }
        return filter;
    }

    private static QueryFilter valueOfPrimaryExpr(FilterTokenizer tokenizer, int depth) {
        Object assertionValue;
        QueryFilter.checkDepth(tokenizer, depth);
        if (!tokenizer.hasNext()) {
            return QueryFilter.valueOfIllegalArgument(tokenizer);
        }
        String nextToken = tokenizer.next();
        if (nextToken.equals("(")) {
            QueryFilter filter = QueryFilter.valueOfOrExpr(tokenizer, depth + 1);
            if (!tokenizer.hasNext() || !tokenizer.next().equals(")")) {
                return QueryFilter.valueOfIllegalArgument(tokenizer);
            }
            return filter;
        }
        if (nextToken.equalsIgnoreCase("true")) {
            return QueryFilter.alwaysTrue();
        }
        if (nextToken.equalsIgnoreCase("false")) {
            return QueryFilter.alwaysFalse();
        }
        if (nextToken.equals("\"")) {
            return QueryFilter.valueOfIllegalArgument(tokenizer);
        }
        JsonPointer pointer = new JsonPointer(nextToken);
        if (!tokenizer.hasNext()) {
            return QueryFilter.valueOfIllegalArgument(tokenizer);
        }
        String operator = tokenizer.next();
        if (operator.equalsIgnoreCase("pr")) {
            return QueryFilter.present(pointer);
        }
        if (!tokenizer.hasNext()) {
            return QueryFilter.valueOfIllegalArgument(tokenizer);
        }
        nextToken = tokenizer.next();
        if (nextToken.equals("\"")) {
            if (!tokenizer.hasNext()) {
                return QueryFilter.valueOfIllegalArgument(tokenizer);
            }
            assertionValue = tokenizer.next();
            if (!tokenizer.hasNext() || !tokenizer.next().equals("\"")) {
                return QueryFilter.valueOfIllegalArgument(tokenizer);
            }
        } else {
            assertionValue = nextToken.equalsIgnoreCase("true") || nextToken.equalsIgnoreCase("false") ? (Serializable)Boolean.valueOf(Boolean.parseBoolean(nextToken)) : (Serializable)(nextToken.indexOf(46) >= 0 ? (Number)Double.parseDouble(nextToken) : (Number)Long.parseLong(nextToken));
        }
        try {
            return QueryFilter.comparisonFilter(pointer, operator, assertionValue);
        }
        catch (IllegalArgumentException e) {
            return QueryFilter.valueOfIllegalArgument(tokenizer);
        }
    }

    private QueryFilter(Impl pimpl) {
        this.pimpl = pimpl;
    }

    public <R, P> R accept(QueryFilterVisitor<R, P> v, P p) {
        return this.pimpl.accept(v, p);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QueryFilter) {
            return this.pimpl.equals(((QueryFilter)obj).pimpl);
        }
        return false;
    }

    public int hashCode() {
        return this.pimpl.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.pimpl.toString(builder);
        return builder.toString();
    }

    private static final class StartsWithImpl
    extends ComparatorImpl {
        private StartsWithImpl(JsonPointer field, Object valueAssertion) {
            super(field, valueAssertion);
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P> v, P p) {
            return v.visitStartsWithFilter(p, this.field, this.valueAssertion);
        }

        @Override
        protected String getOperator() {
            return "sw";
        }
    }

    private static final class PresentImpl
    extends Impl {
        private final JsonPointer field;

        private PresentImpl(JsonPointer field) {
            this.field = field;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PresentImpl) {
                PresentImpl o = (PresentImpl)obj;
                return this.field.equals((Object)o.field);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.field.hashCode();
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P> v, P p) {
            return v.visitPresentFilter(p, this.field);
        }

        @Override
        protected void toString(StringBuilder builder) {
            builder.append(this.field.toString());
            builder.append(' ');
            builder.append("pr");
        }
    }

    private static final class OrImpl
    extends Impl {
        private final List<QueryFilter> subFilters;

        private OrImpl(List<QueryFilter> subFilters) {
            this.subFilters = subFilters;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof OrImpl) {
                return ((Object)this.subFilters).equals(((OrImpl)obj).subFilters);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((Object)this.subFilters).hashCode();
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P> v, P p) {
            return v.visitOrFilter(p, this.subFilters);
        }

        @Override
        protected void toString(StringBuilder builder) {
            builder.append('(');
            boolean isFirst = true;
            for (QueryFilter subFilter : this.subFilters) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder.append(" or ");
                }
                subFilter.pimpl.toString(builder);
            }
            builder.append(')');
        }
    }

    private static final class NotImpl
    extends Impl {
        private final QueryFilter subFilter;

        private NotImpl(QueryFilter subFilter) {
            this.subFilter = subFilter;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof NotImpl) {
                return this.subFilter.equals(((NotImpl)obj).subFilter);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.subFilter.hashCode();
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P> v, P p) {
            return v.visitNotFilter(p, this.subFilter);
        }

        @Override
        protected void toString(StringBuilder builder) {
            builder.append("! (");
            this.subFilter.pimpl.toString(builder);
            builder.append(')');
        }
    }

    private static final class LessThanOrEqualToImpl
    extends ComparatorImpl {
        private LessThanOrEqualToImpl(JsonPointer field, Object valueAssertion) {
            super(field, valueAssertion);
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P> v, P p) {
            return v.visitLessThanOrEqualToFilter(p, this.field, this.valueAssertion);
        }

        @Override
        protected String getOperator() {
            return "le";
        }
    }

    private static final class LessThanImpl
    extends ComparatorImpl {
        private LessThanImpl(JsonPointer field, Object valueAssertion) {
            super(field, valueAssertion);
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P> v, P p) {
            return v.visitLessThanFilter(p, this.field, this.valueAssertion);
        }

        @Override
        protected String getOperator() {
            return "lt";
        }
    }

    private static abstract class Impl {
        protected Impl() {
        }

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        protected abstract <R, P> R accept(QueryFilterVisitor<R, P> var1, P var2);

        protected abstract void toString(StringBuilder var1);
    }

    private static final class GreaterThanOrEqualToImpl
    extends ComparatorImpl {
        private GreaterThanOrEqualToImpl(JsonPointer field, Object valueAssertion) {
            super(field, valueAssertion);
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P> v, P p) {
            return v.visitGreaterThanOrEqualToFilter(p, this.field, this.valueAssertion);
        }

        @Override
        protected String getOperator() {
            return "ge";
        }
    }

    private static final class GreaterThanImpl
    extends ComparatorImpl {
        private GreaterThanImpl(JsonPointer field, Object valueAssertion) {
            super(field, valueAssertion);
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P> v, P p) {
            return v.visitGreaterThanFilter(p, this.field, this.valueAssertion);
        }

        @Override
        protected String getOperator() {
            return "gt";
        }
    }

    private static final class FilterTokenizer
    implements Iterator<String> {
        private static final int NEED_END_STRING = 2;
        private static final int NEED_START_STRING = 1;
        private static final int NEED_TOKEN = 0;
        private final String filterString;
        private String nextToken;
        private int pos;
        private int state;

        private FilterTokenizer(String filterString) {
            this.filterString = filterString;
            this.pos = 0;
            this.state = 0;
            this.readNextToken();
        }

        @Override
        public boolean hasNext() {
            return this.nextToken != null;
        }

        @Override
        public String next() {
            String next = this.peek();
            this.readNextToken();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.filterString;
        }

        private String peek() {
            if (this.nextToken == null) {
                throw new NoSuchElementException();
            }
            return this.nextToken;
        }

        private void readNextToken() {
            switch (this.state) {
                case 1: {
                    int stringStart = this.pos;
                    while (this.pos < this.filterString.length() && this.filterString.charAt(this.pos) != '\"') {
                        ++this.pos;
                    }
                    this.nextToken = this.filterString.substring(stringStart, this.pos);
                    this.state = 2;
                    break;
                }
                case 2: {
                    this.nextToken = this.pos < this.filterString.length() ? this.filterString.substring(this.pos, ++this.pos) : null;
                    this.state = 0;
                    break;
                }
                default: {
                    if (!this.skipWhiteSpace()) {
                        this.nextToken = null;
                        break;
                    }
                    int tokenStart = this.pos;
                    switch (this.filterString.charAt(this.pos++)) {
                        case '(': 
                        case ')': {
                            break;
                        }
                        case '\"': {
                            this.state = 1;
                            break;
                        }
                        default: {
                            char c;
                            while (this.pos < this.filterString.length() && (c = this.filterString.charAt(this.pos)) != '(' && c != ')' && c != ' ') {
                                ++this.pos;
                            }
                            break block4;
                        }
                    }
                    this.nextToken = this.filterString.substring(tokenStart, this.pos);
                }
            }
        }

        private boolean skipWhiteSpace() {
            while (this.pos < this.filterString.length() && this.filterString.charAt(this.pos) == ' ') {
                ++this.pos;
            }
            return this.pos < this.filterString.length();
        }
    }

    private static final class ExtendedMatchImpl
    extends ComparatorImpl {
        private final String operator;

        private ExtendedMatchImpl(JsonPointer field, String operator, Object valueAssertion) {
            super(field, valueAssertion);
            this.operator = operator;
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P> v, P p) {
            return v.visitExtendedMatchFilter(p, this.field, this.operator, this.valueAssertion);
        }

        @Override
        protected String getOperator() {
            return this.operator;
        }
    }

    private static final class EqualsImpl
    extends ComparatorImpl {
        private EqualsImpl(JsonPointer field, Object valueAssertion) {
            super(field, valueAssertion);
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P> v, P p) {
            return v.visitEqualsFilter(p, this.field, this.valueAssertion);
        }

        @Override
        protected String getOperator() {
            return "eq";
        }
    }

    private static final class ContainsImpl
    extends ComparatorImpl {
        private ContainsImpl(JsonPointer field, Object valueAssertion) {
            super(field, valueAssertion);
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P> v, P p) {
            return v.visitContainsFilter(p, this.field, this.valueAssertion);
        }

        @Override
        protected String getOperator() {
            return "co";
        }
    }

    private static abstract class ComparatorImpl
    extends Impl {
        protected final JsonPointer field;
        protected final Object valueAssertion;

        protected ComparatorImpl(JsonPointer field, Object valueAssertion) {
            this.field = field;
            this.valueAssertion = valueAssertion;
        }

        @Override
        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ComparatorImpl) {
                ComparatorImpl o = (ComparatorImpl)obj;
                return this.field.equals((Object)o.field) && this.getOperator().equals(o.getOperator()) && this.valueAssertion.equals(o.valueAssertion);
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return (this.field.hashCode() * 31 + this.getOperator().hashCode()) * 31 + this.valueAssertion.hashCode();
        }

        protected abstract String getOperator();

        @Override
        protected final void toString(StringBuilder builder) {
            builder.append(this.field.toString());
            builder.append(' ');
            builder.append(this.getOperator());
            builder.append(' ');
            if (this.valueAssertion instanceof Boolean || this.valueAssertion instanceof Number) {
                builder.append(this.valueAssertion);
            } else {
                builder.append('\"');
                builder.append(this.valueAssertion);
                builder.append('\"');
            }
        }
    }

    private static final class BooleanLiteralImpl
    extends Impl {
        private final boolean value;

        private BooleanLiteralImpl(boolean value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BooleanLiteralImpl) {
                return this.value == ((BooleanLiteralImpl)obj).value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Boolean.valueOf(this.value).hashCode();
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P> v, P p) {
            return v.visitBooleanLiteralFilter(p, this.value);
        }

        @Override
        protected void toString(StringBuilder builder) {
            builder.append(this.value);
        }
    }

    private static final class AndImpl
    extends Impl {
        private final List<QueryFilter> subFilters;

        private AndImpl(List<QueryFilter> subFilters) {
            this.subFilters = subFilters;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AndImpl) {
                return ((Object)this.subFilters).equals(((AndImpl)obj).subFilters);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((Object)this.subFilters).hashCode();
        }

        @Override
        protected <R, P> R accept(QueryFilterVisitor<R, P> v, P p) {
            return v.visitAndFilter(p, this.subFilters);
        }

        @Override
        protected void toString(StringBuilder builder) {
            builder.append('(');
            boolean isFirst = true;
            for (QueryFilter subFilter : this.subFilters) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder.append(" and ");
                }
                subFilter.pimpl.toString(builder);
            }
            builder.append(')');
        }
    }
}

