/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.forgerock.json.fluent.JsonPointer;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.util.Reject;

public final class PatchOperation {
    public static final String FIELD_FIELD = "field";
    public static final String FIELD_OPERATION = "operation";
    public static final String FIELD_VALUE = "value";
    public static final String OPERATION_ADD = "add";
    public static final String OPERATION_INCREMENT = "increment";
    public static final String OPERATION_REMOVE = "remove";
    public static final String OPERATION_REPLACE = "replace";
    private final JsonPointer field;
    private final String operation;
    private final JsonValue value;

    public static PatchOperation add(JsonPointer field, Object value) {
        return PatchOperation.operation(OPERATION_ADD, field, (Object)PatchOperation.json(value));
    }

    public static PatchOperation add(String field, Object value) {
        return PatchOperation.add(new JsonPointer(field), value);
    }

    public static PatchOperation copyOf(PatchOperation operation) {
        return PatchOperation.operation(operation.getOperation(), operation.getField(), (Object)operation.getValue().copy());
    }

    public static PatchOperation increment(JsonPointer field, Number amount) {
        return PatchOperation.operation(OPERATION_INCREMENT, field, (Object)new JsonValue((Object)amount));
    }

    public static PatchOperation increment(String field, Number amount) {
        return PatchOperation.increment(new JsonPointer(field), amount);
    }

    public static PatchOperation operation(String operation, JsonPointer field, Object value) {
        return new PatchOperation(operation, field, PatchOperation.json(value));
    }

    public static PatchOperation operation(String operation, String field, Object value) {
        return PatchOperation.operation(operation, new JsonPointer(field), value);
    }

    public static PatchOperation remove(JsonPointer field) {
        return PatchOperation.remove(field, null);
    }

    public static PatchOperation remove(JsonPointer field, Object value) {
        return PatchOperation.operation(OPERATION_REMOVE, field, (Object)PatchOperation.json(value));
    }

    public static PatchOperation remove(String field) {
        return PatchOperation.remove(new JsonPointer(field));
    }

    public static PatchOperation remove(String field, Object value) {
        return PatchOperation.remove(new JsonPointer(field), value);
    }

    public static PatchOperation replace(JsonPointer field, Object value) {
        return PatchOperation.operation(OPERATION_REPLACE, field, (Object)PatchOperation.json(value));
    }

    public static PatchOperation replace(String field, Object value) {
        return PatchOperation.replace(new JsonPointer(field), value);
    }

    public static PatchOperation valueOf(JsonValue json) throws BadRequestException {
        if (!json.isMap()) {
            throw new BadRequestException("The request could not be processed because the provided content is not a valid JSON patch");
        }
        try {
            String type = json.get(FIELD_OPERATION).required().asString();
            JsonPointer field = json.get(FIELD_FIELD).required().asPointer();
            JsonValue value = json.get(FIELD_VALUE);
            return PatchOperation.operation(type, field, (Object)value);
        }
        catch (Exception e) {
            throw new BadRequestException("The request could not be processed because the provided content is not a valid JSON patch: " + e.getMessage(), (Throwable)e);
        }
    }

    public static List<PatchOperation> valueOfList(JsonValue json) throws BadRequestException {
        if (!json.isList()) {
            throw new BadRequestException("The request could not be processed because the provided content is not a JSON array of patch operations");
        }
        ArrayList<PatchOperation> patch = new ArrayList<PatchOperation>(json.size());
        for (JsonValue operation : json) {
            patch.add(PatchOperation.valueOf(operation));
        }
        return patch;
    }

    private static JsonValue json(Object value) {
        return value instanceof JsonValue ? (JsonValue)value : new JsonValue(value);
    }

    private PatchOperation(String operation, JsonPointer field, JsonValue value) {
        this.operation = (String)Reject.checkNotNull((Object)operation, (String)"Cannot instantiate PatchOperation with null operation value");
        this.field = (JsonPointer)Reject.checkNotNull((Object)field, (String)"Cannot instantiate PatchOperation with null field value");
        this.value = value != null ? value : new JsonValue(null);
        this.checkOperationType();
        this.checkOperationValue();
    }

    public JsonPointer getField() {
        return this.field;
    }

    public String getOperation() {
        return this.operation;
    }

    public JsonValue getValue() {
        return this.value;
    }

    public boolean isAdd() {
        return this.is(OPERATION_ADD);
    }

    public boolean isIncrement() {
        return this.is(OPERATION_INCREMENT);
    }

    public boolean isRemove() {
        return this.is(OPERATION_REMOVE);
    }

    public boolean isReplace() {
        return this.is(OPERATION_REPLACE);
    }

    public JsonValue toJsonValue() {
        JsonValue json = new JsonValue(new LinkedHashMap(3));
        json.put(FIELD_OPERATION, (Object)this.operation);
        json.put(FIELD_FIELD, (Object)this.field.toString());
        if (!this.value.isNull()) {
            json.put(FIELD_VALUE, this.value.getObject());
        }
        return json;
    }

    public String toString() {
        return this.toJsonValue().toString();
    }

    private void checkOperationValue() {
        if (this.isAdd() && this.value.isNull()) {
            throw new NullPointerException("No value provided for add patch operation");
        }
        if (this.isIncrement()) {
            if (this.value.isNull()) {
                throw new NullPointerException("No value provided for increment patch operation");
            }
            if (!this.value.isNumber()) {
                throw new IllegalArgumentException("Non-numeric value provided for increment patch operation");
            }
        }
    }

    private void checkOperationType() {
        if (!(this.isAdd() || this.isRemove() || this.isIncrement() || this.isReplace())) {
            throw new IllegalArgumentException("Invalid patch operation type " + this.operation);
        }
    }

    private boolean is(String type) {
        return this.operation == type || this.operation.equalsIgnoreCase(type);
    }
}

