/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.PersistenceConfig;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.util.Reject;

public abstract class Context {
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ID = "id";
    private static final String ATTR_PARENT = "parent";
    private volatile String id;
    private final Context parent;

    private static Context load0(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        String className = savedContext.get(ATTR_CLASS).required().asString();
        try {
            Class<Context> clazz = Class.forName(className, true, config.getClassLoader()).asSubclass(Context.class);
            Constructor<Context> constructor = clazz.getDeclaredConstructor(JsonValue.class, PersistenceConfig.class);
            return constructor.newInstance(savedContext, config);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate Context implementation class '" + className + "'", e);
        }
    }

    protected Context(Context parent) {
        this.parent = parent;
    }

    protected Context(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        this.id = savedContext.get(ATTR_ID).required().asString();
        JsonValue savedParentContext = savedContext.get(ATTR_PARENT);
        this.parent = savedParentContext.isNull() ? null : Context.load0(savedParentContext, config);
    }

    protected Context(String id, Context parent) {
        this.id = (String)Reject.checkNotNull((Object)id, (String)"Cannot create Context with null id");
        this.parent = parent;
    }

    public final <T extends Context> T asContext(Class<T> clazz) {
        T context = this.asContext0(clazz);
        if (context != null) {
            return context;
        }
        throw new IllegalArgumentException("No context of type " + clazz.getName() + " found.");
    }

    public final boolean containsContext(Class<? extends Context> clazz) {
        return this.asContext0(clazz) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getId() {
        if (this.id == null) {
            Context context = this;
            synchronized (context) {
                if (this.id == null) {
                    this.id = UUID.randomUUID().toString();
                }
            }
        }
        return this.id;
    }

    public final Context getParent() {
        return this.parent;
    }

    public final boolean isRootContext() {
        return this.getParent() == null;
    }

    protected void saveToJson(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        savedContext.put(ATTR_ID, (Object)this.getId());
        savedContext.put(ATTR_CLASS, (Object)this.getClass().getName());
        if (this.parent != null) {
            JsonValue savedParentContext = new JsonValue(new LinkedHashMap(4));
            this.parent.saveToJson(savedParentContext, config);
            savedContext.put(ATTR_PARENT, (Object)savedParentContext.asMap());
        }
    }

    private final <T extends Context> T asContext0(Class<T> clazz) {
        for (Context context = this; context != null; context = context.getParent()) {
            Class<?> contextClass = context.getClass();
            if (!clazz.isAssignableFrom(contextClass)) continue;
            return (T)((Context)contextClass.asSubclass(clazz).cast(context));
        }
        return null;
    }
}

