/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.regex.Pattern;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldif.AbstractLDIFStream;
import org.forgerock.util.Reject;

abstract class AbstractLDIFWriter
extends AbstractLDIFStream {
    private static final Pattern SPLIT_NEWLINE = Pattern.compile("\\r?\\n");
    boolean addUserFriendlyComments;
    final LDIFWriterImpl impl;
    int wrapColumn;
    private final StringBuilder builder = new StringBuilder(80);

    AbstractLDIFWriter(List<String> ldifLines) {
        this.impl = new LDIFWriterListImpl(ldifLines);
    }

    AbstractLDIFWriter(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    AbstractLDIFWriter(Writer writer) {
        this.impl = new LDIFWriterOutputStreamImpl(writer);
    }

    final void close0() throws IOException {
        this.flush0();
        this.impl.close();
    }

    final void flush0() throws IOException {
        this.impl.flush();
    }

    final void writeComment0(CharSequence comment) throws IOException {
        String[] lines;
        Reject.ifNull((Object)comment);
        for (String line : lines = SPLIT_NEWLINE.split(comment)) {
            if (!this.shouldWrap()) {
                this.impl.print("# ");
                this.impl.print(line);
                this.impl.println();
                continue;
            }
            int breakColumn = this.wrapColumn - 2;
            if (line.length() <= breakColumn) {
                this.impl.print("# ");
                this.impl.print(line);
                this.impl.println();
                continue;
            }
            int startPos = 0;
            block1: while (startPos < line.length()) {
                if (startPos + breakColumn >= line.length()) {
                    this.impl.print("# ");
                    this.impl.print(line.substring(startPos));
                    this.impl.println();
                    startPos = line.length();
                    continue;
                }
                int endPos = startPos + breakColumn;
                for (int i = endPos - 1; i > startPos; --i) {
                    if (line.charAt(i) != ' ') continue;
                    this.impl.print("# ");
                    this.impl.print(line.substring(startPos, i));
                    this.impl.println();
                    startPos = i + 1;
                    continue block1;
                }
                this.impl.print("# ");
                this.impl.print(line.substring(startPos, endPos));
                this.impl.println();
                startPos = endPos;
            }
        }
    }

    final void writeControls(List<Control> controls) throws IOException {
        for (Control control : controls) {
            StringBuilder key = new StringBuilder("control: ");
            key.append(control.getOID());
            key.append(control.isCritical() ? " true" : " false");
            if (control.hasValue()) {
                this.writeKeyAndValue((CharSequence)key, control.getValue());
                continue;
            }
            this.writeLine(key);
        }
    }

    final void writeKeyAndValue(CharSequence key, ByteSequence value) throws IOException {
        this.builder.setLength(0);
        if (value.length() == 0) {
            this.builder.append(key);
            this.builder.append(": ");
        } else if (this.needsBase64Encoding(value)) {
            if (this.addUserFriendlyComments) {
                // empty if block
            }
            this.builder.setLength(0);
            this.builder.append(key);
            this.builder.append(":: ");
            this.builder.append(value.toBase64String());
        } else {
            this.builder.append(key);
            this.builder.append(": ");
            this.builder.append(value.toString());
        }
        this.writeLine(this.builder);
    }

    final void writeKeyAndValue(CharSequence key, CharSequence value) throws IOException {
        this.writeKeyAndValue(key, ByteString.valueOf(value));
    }

    final void writeLine(CharSequence line) throws IOException {
        int length = line.length();
        if (this.shouldWrap() && length > this.wrapColumn) {
            this.impl.print(line.subSequence(0, this.wrapColumn));
            this.impl.println();
            for (int pos = this.wrapColumn; pos < length; pos += this.wrapColumn - 1) {
                int writeLength = Math.min(this.wrapColumn - 1, length - pos);
                this.impl.print(" ");
                this.impl.print(line.subSequence(pos, pos + writeLength));
                this.impl.println();
            }
        } else {
            this.impl.print(line);
            this.impl.println();
        }
    }

    private boolean needsBase64Encoding(ByteSequence bytes) {
        int length = bytes.length();
        if (length == 0) {
            return false;
        }
        switch (bytes.byteAt(0)) {
            case 32: 
            case 58: 
            case 60: {
                return true;
            }
        }
        if (length > 1 && bytes.byteAt(length - 1) == 32) {
            return true;
        }
        for (int i = 0; i < bytes.length(); ++i) {
            byte b = bytes.byteAt(i);
            if (b < 0) {
                return true;
            }
            switch (b) {
                case 0: 
                case 10: 
                case 13: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean shouldWrap() {
        return this.wrapColumn > 1;
    }

    private void writeKeyAndURL(CharSequence key, CharSequence url) throws IOException {
        this.builder.setLength(0);
        this.builder.append(key);
        this.builder.append(":: ");
        this.builder.append(url);
        this.writeLine(this.builder);
    }

    private static final class LDIFWriterOutputStreamImpl
    implements LDIFWriterImpl {
        private final BufferedWriter writer;

        LDIFWriterOutputStreamImpl(Writer writer) {
            this.writer = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void print(CharSequence s) throws IOException {
            this.writer.append(s);
        }

        @Override
        public void println() throws IOException {
            this.writer.newLine();
        }
    }

    private static final class LDIFWriterListImpl
    implements LDIFWriterImpl {
        private final StringBuilder builder = new StringBuilder();
        private final List<String> ldifLines;

        LDIFWriterListImpl(List<String> ldifLines) {
            this.ldifLines = ldifLines;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void print(CharSequence s) throws IOException {
            this.builder.append(s);
        }

        @Override
        public void println() throws IOException {
            this.ldifLines.add(this.builder.toString());
            this.builder.setLength(0);
        }
    }

    static interface LDIFWriterImpl {
        public void close() throws IOException;

        public void flush() throws IOException;

        public void print(CharSequence var1) throws IOException;

        public void println() throws IOException;
    }
}

