/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.spi;

import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.spi.BindResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.ExtendedResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.LdapPromiseWrapper;
import org.forgerock.opendj.ldap.spi.ResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.SearchResultLdapPromiseImpl;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public final class LdapPromises {
    public static <R> LdapPromise<R> newSuccessfulLdapPromise(R result) {
        return LdapPromises.wrap(Promises.newResultPromise(result), -1);
    }

    public static <R> LdapPromise<R> newSuccessfulLdapPromise(R result, int requestID) {
        return LdapPromises.wrap(Promises.newResultPromise(result), requestID);
    }

    public static <R, E extends LdapException> LdapPromise<R> newFailedLdapPromise(E error) {
        return LdapPromises.wrap(Promises.newExceptionPromise(error), -1);
    }

    public static <R, E extends LdapException> LdapPromise<R> newFailedLdapPromise(E error, int requestID) {
        return LdapPromises.wrap(Promises.newExceptionPromise(error), requestID);
    }

    public static <R extends Request> ResultLdapPromiseImpl<R, Result> newResultLdapPromise(int requestID, R request, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        return new ResultLdapPromiseImpl<R, Result>(requestID, request, intermediateResponseHandler, connection){

            @Override
            protected Result newErrorResult(ResultCode resultCode, String diagnosticMessage, Throwable cause) {
                return Responses.newResult(resultCode).setDiagnosticMessage(diagnosticMessage).setCause(cause);
            }
        };
    }

    public static BindResultLdapPromiseImpl newBindLdapPromise(int requestID, BindRequest request, BindClient bindClient, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        return new BindResultLdapPromiseImpl(requestID, request, bindClient, intermediateResponseHandler, connection);
    }

    public static ResultLdapPromiseImpl<CompareRequest, CompareResult> newCompareLdapPromise(int requestID, CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        return new ResultLdapPromiseImpl<CompareRequest, CompareResult>(requestID, request, intermediateResponseHandler, connection){

            @Override
            protected CompareResult newErrorResult(ResultCode resultCode, String diagnosticMessage, Throwable cause) {
                return Responses.newCompareResult(resultCode).setDiagnosticMessage(diagnosticMessage).setCause(cause);
            }
        };
    }

    public static <S extends ExtendedResult> ExtendedResultLdapPromiseImpl<S> newExtendedLdapPromise(int requestID, ExtendedRequest<S> request, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        return new ExtendedResultLdapPromiseImpl<S>(requestID, request, intermediateResponseHandler, connection);
    }

    public static SearchResultLdapPromiseImpl newSearchLdapPromise(int requestID, SearchRequest request, SearchResultHandler resultHandler, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        return new SearchResultLdapPromiseImpl(requestID, request, resultHandler, intermediateResponseHandler, connection);
    }

    public static <R> LdapPromise<R> asPromise(Promise<R, LdapException> wrappedPromise) {
        return LdapPromises.wrap(wrappedPromise, -1);
    }

    static <R> LdapPromise<R> wrap(Promise<R, LdapException> wrappedPromise, int requestID) {
        return new LdapPromiseWrapper(wrappedPromise, requestID);
    }

    private LdapPromises() {
    }
}

