/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.spi;

import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.spi.ResultLdapPromiseImpl;
import org.forgerock.util.promise.PromiseImpl;

public final class BindResultLdapPromiseImpl
extends ResultLdapPromiseImpl<BindRequest, BindResult> {
    private final BindClient bindClient;

    BindResultLdapPromiseImpl(int requestID, BindRequest request, BindClient bindClient, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        super(new PromiseImpl<BindResult, LdapException>(){

            protected LdapException tryCancel(boolean mayInterruptIfRunning) {
                return null;
            }
        }, requestID, request, intermediateResponseHandler, connection);
        this.bindClient = bindClient;
    }

    @Override
    public boolean isBindOrStartTLS() {
        return true;
    }

    public BindClient getBindClient() {
        return this.bindClient;
    }

    @Override
    BindResult newErrorResult(ResultCode resultCode, String diagnosticMessage, Throwable cause) {
        return Responses.newBindResult(resultCode).setDiagnosticMessage(diagnosticMessage).setCause(cause);
    }
}

