/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class UUIDEqualityMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    UUIDEqualityMatchingRuleImpl() {
        super("uuidMatch");
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        if (value.length() != 36) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_UUID_INVALID_LENGTH.get((Object)value.toString(), (Object)value.length());
            throw DecodeException.error(message);
        }
        StringBuilder builder = new StringBuilder(36);
        block12: for (int i = 0; i < 36; ++i) {
            char c = (char)value.byteAt(i);
            switch (i) {
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    if (c != '-') {
                        LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_UUID_EXPECTED_DASH.get((Object)value.toString(), (Object)i, (Object)String.valueOf(c));
                        throw DecodeException.error(message);
                    }
                    builder.append(c);
                    continue block12;
                }
                default: {
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            builder.append(c);
                            continue block12;
                        }
                        case 'A': {
                            builder.append('a');
                            continue block12;
                        }
                        case 'B': {
                            builder.append('b');
                            continue block12;
                        }
                        case 'C': {
                            builder.append('c');
                            continue block12;
                        }
                        case 'D': {
                            builder.append('d');
                            continue block12;
                        }
                        case 'E': {
                            builder.append('e');
                            continue block12;
                        }
                        case 'F': {
                            builder.append('f');
                            continue block12;
                        }
                    }
                    LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_UUID_EXPECTED_HEX.get((Object)value.toString(), (Object)i, (Object)String.valueOf(value.byteAt(i)));
                    throw DecodeException.error(message);
                }
            }
        }
        return ByteString.valueOf(builder);
    }
}

