/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.GeneralizedTime;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.MatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.opendj.ldap.spi.Indexer;
import org.forgerock.opendj.ldap.spi.IndexingOptions;
import org.forgerock.util.time.TimeService;

final class TimeBasedMatchingRulesImpl {
    private static final TimeZone TIME_ZONE_UTC = TimeZone.getTimeZone("UTC");
    private static final char SECOND = 's';
    private static final char MINUTE = 'm';
    private static final char HOUR = 'h';
    private static final char MONTH = 'M';
    private static final char DATE = 'D';
    private static final char YEAR = 'Y';

    private TimeBasedMatchingRulesImpl() {
    }

    static MatchingRuleImpl relativeTimeGTOMatchingRule() {
        return new RelativeTimeGreaterThanOrderingMatchingRuleImpl();
    }

    static MatchingRuleImpl relativeTimeLTOMatchingRule() {
        return new RelativeTimeLessThanOrderingMatchingRuleImpl();
    }

    static MatchingRuleImpl partialDateAndTimeMatchingRule() {
        return new PartialDateAndTimeMatchingRuleImpl();
    }

    private static final class PartialDateAndTimeIndexer
    implements Indexer {
        private final PartialDateAndTimeMatchingRuleImpl matchingRule;

        private PartialDateAndTimeIndexer(PartialDateAndTimeMatchingRuleImpl matchingRule) {
            this.matchingRule = matchingRule;
        }

        @Override
        public void createKeys(Schema schema, ByteSequence value, Collection<ByteString> keys) {
            this.matchingRule.timeKeys(value, keys);
        }

        @Override
        public String getIndexID() {
            return "partialDateAndTimeMatchingRule";
        }
    }

    private static final class PartialDateAndTimeMatchingRuleImpl
    extends TimeBasedMatchingRuleImpl {
        private final Indexer indexer = new PartialDateAndTimeIndexer(this);

        private PartialDateAndTimeMatchingRuleImpl() {
        }

        @Override
        public Collection<? extends Indexer> createIndexers(IndexingOptions options) {
            return Collections.singletonList(this.indexer);
        }

        @Override
        public Assertion getAssertion(Schema schema, ByteSequence value) throws DecodeException {
            final ByteString assertionValue = this.normalizeAssertionValue(value);
            return new Assertion(){

                @Override
                public ConditionResult matches(ByteSequence attributeValue) {
                    return PartialDateAndTimeMatchingRuleImpl.this.valuesMatch(attributeValue, assertionValue);
                }

                @Override
                public <T> T createIndexQuery(IndexQueryFactory<T> factory) throws DecodeException {
                    ByteBuffer buffer = ByteBuffer.wrap(assertionValue.toByteArray());
                    int assertSecond = buffer.getInt(0);
                    int assertMinute = buffer.getInt(4);
                    int assertHour = buffer.getInt(8);
                    int assertDate = buffer.getInt(12);
                    int assertMonth = buffer.getInt(16);
                    int assertYear = buffer.getInt(20);
                    ArrayList<T> queries = new ArrayList<T>();
                    if (assertSecond >= 0) {
                        queries.add(this.createExactMatchQuery(factory, assertSecond, 's'));
                    }
                    if (assertMinute >= 0) {
                        queries.add(this.createExactMatchQuery(factory, assertMinute, 'm'));
                    }
                    if (assertHour >= 0) {
                        queries.add(this.createExactMatchQuery(factory, assertHour, 'h'));
                    }
                    if (assertDate > 0) {
                        queries.add(this.createExactMatchQuery(factory, assertDate, 'D'));
                    }
                    if (assertMonth >= 0) {
                        queries.add(this.createExactMatchQuery(factory, assertMonth, 'M'));
                    }
                    if (assertYear > 0) {
                        queries.add(this.createExactMatchQuery(factory, assertYear, 'Y'));
                    }
                    return factory.createIntersectionQuery(queries);
                }

                private <T> T createExactMatchQuery(IndexQueryFactory<T> factory, int assertionValue2, char type) {
                    return factory.createExactMatchQuery(PartialDateAndTimeMatchingRuleImpl.this.indexer.getIndexID(), PartialDateAndTimeMatchingRuleImpl.this.getKey(assertionValue2, type));
                }
            };
        }

        private ByteString normalizeAssertionValue(ByteSequence assertionValue) throws DecodeException {
            boolean initDate = false;
            int initValue = -1;
            int second = -1;
            int minute = -1;
            int hour = -1;
            int date = 0;
            int month = -1;
            int year = 0;
            int number = 0;
            int length = assertionValue.length();
            for (int index = 0; index < length; ++index) {
                byte b = assertionValue.byteAt(index);
                if (StaticUtils.isDigit((char)b)) {
                    number = this.multiplyByTenAndAddUnits(number, b);
                    continue;
                }
                switch (b) {
                    case 115: {
                        if (second != -1) {
                            throw DecodeException.error(CoreMessages.WARN_ATTR_DUPLICATE_SECOND_ASSERTION_FORMAT.get((Object)assertionValue, (Object)date));
                        }
                        second = number;
                        break;
                    }
                    case 109: {
                        if (minute != -1) {
                            throw DecodeException.error(CoreMessages.WARN_ATTR_DUPLICATE_MINUTE_ASSERTION_FORMAT.get((Object)assertionValue, (Object)date));
                        }
                        minute = number;
                        break;
                    }
                    case 104: {
                        if (hour != -1) {
                            throw DecodeException.error(CoreMessages.WARN_ATTR_DUPLICATE_HOUR_ASSERTION_FORMAT.get((Object)assertionValue, (Object)date));
                        }
                        hour = number;
                        break;
                    }
                    case 68: {
                        if (number == 0) {
                            throw DecodeException.error(CoreMessages.WARN_ATTR_INVALID_DATE_ASSERTION_FORMAT.get((Object)assertionValue, (Object)number));
                        }
                        if (date != 0) {
                            throw DecodeException.error(CoreMessages.WARN_ATTR_DUPLICATE_DATE_ASSERTION_FORMAT.get((Object)assertionValue, (Object)date));
                        }
                        date = number;
                        break;
                    }
                    case 77: {
                        if (number == 0) {
                            throw DecodeException.error(CoreMessages.WARN_ATTR_INVALID_MONTH_ASSERTION_FORMAT.get((Object)assertionValue, (Object)number));
                        }
                        if (month != -1) {
                            throw DecodeException.error(CoreMessages.WARN_ATTR_DUPLICATE_MONTH_ASSERTION_FORMAT.get((Object)assertionValue, (Object)month));
                        }
                        month = number;
                        break;
                    }
                    case 89: {
                        if (number == 0) {
                            throw DecodeException.error(CoreMessages.WARN_ATTR_INVALID_YEAR_ASSERTION_FORMAT.get((Object)assertionValue, (Object)number));
                        }
                        if (year != 0) {
                            throw DecodeException.error(CoreMessages.WARN_ATTR_DUPLICATE_YEAR_ASSERTION_FORMAT.get((Object)assertionValue, (Object)year));
                        }
                        year = number;
                        break;
                    }
                    default: {
                        throw DecodeException.error(CoreMessages.WARN_ATTR_INVALID_PARTIAL_TIME_ASSERTION_FORMAT.get((Object)assertionValue, (Object)Character.valueOf((char)b)));
                    }
                }
                number = 0;
            }
            month = this.toCalendarMonth(month, assertionValue);
            if (year < 0) {
                throw DecodeException.error(CoreMessages.WARN_ATTR_INVALID_YEAR_ASSERTION_FORMAT.get((Object)assertionValue, (Object)year));
            }
            if (this.isDateInvalid(date, month, year)) {
                throw DecodeException.error(CoreMessages.WARN_ATTR_INVALID_DATE_ASSERTION_FORMAT.get((Object)assertionValue, (Object)date));
            }
            if (hour < -1 || hour > 23) {
                throw DecodeException.error(CoreMessages.WARN_ATTR_INVALID_HOUR_ASSERTION_FORMAT.get((Object)assertionValue, (Object)hour));
            }
            if (minute < -1 || minute > 59) {
                throw DecodeException.error(CoreMessages.WARN_ATTR_INVALID_MINUTE_ASSERTION_FORMAT.get((Object)assertionValue, (Object)minute));
            }
            if (second < -1 || second > 60) {
                throw DecodeException.error(CoreMessages.WARN_ATTR_INVALID_SECOND_ASSERTION_FORMAT.get((Object)assertionValue, (Object)second));
            }
            return new ByteStringBuilder(24).append(second).append(minute).append(hour).append(date).append(month).append(year).toByteString();
        }

        private boolean isDateInvalid(int date, int month, int year) {
            switch (date) {
                case 29: {
                    return month == 1 && !this.isLeapYear(year);
                }
                case 30: {
                    return month == 1;
                }
                case 31: {
                    return month != -1 && month != 0 && month != 2 && month != 4 && month != 6 && month != 7 && month != 9 && month != 11;
                }
            }
            return date < 0 || date > 31;
        }

        private boolean isLeapYear(int year) {
            return year % 400 == 0 || year % 100 != 0 && year % 4 == 0;
        }

        private int toCalendarMonth(int month, ByteSequence value) throws DecodeException {
            if (month == -1) {
                return -1;
            }
            if (1 <= month && month <= 12) {
                return month - 1;
            }
            throw DecodeException.error(CoreMessages.WARN_ATTR_INVALID_MONTH_ASSERTION_FORMAT.get((Object)value, (Object)month));
        }

        private ConditionResult valuesMatch(ByteSequence attributeValue, ByteSequence assertionValue) {
            GregorianCalendar cal = new GregorianCalendar(TIME_ZONE_UTC);
            cal.setLenient(false);
            cal.setTimeInMillis(((ByteString)attributeValue).toLong());
            int second = cal.get(13);
            int minute = cal.get(12);
            int hour = cal.get(11);
            int date = cal.get(5);
            int month = cal.get(2);
            int year = cal.get(1);
            ByteBuffer b = ByteBuffer.wrap(assertionValue.toByteArray());
            int assertSecond = b.getInt(0);
            int assertMinute = b.getInt(4);
            int assertHour = b.getInt(8);
            int assertDate = b.getInt(12);
            int assertMonth = b.getInt(16);
            int assertYear = b.getInt(20);
            if (assertSecond != -1 && assertSecond != second || assertMinute != -1 && assertMinute != minute || assertHour != -1 && assertHour != hour || assertDate != 0 && assertDate != date || assertMonth != -1 && assertMonth != month || assertYear != 0 && assertYear != year) {
                return ConditionResult.FALSE;
            }
            return ConditionResult.TRUE;
        }

        private void timeKeys(ByteSequence attributeValue, Collection<ByteString> keys) {
            long timeInMillis = 0L;
            try {
                timeInMillis = GeneralizedTime.valueOf(attributeValue.toString()).getTimeInMillis();
            }
            catch (IllegalArgumentException e) {
                return;
            }
            GregorianCalendar cal = new GregorianCalendar(TIME_ZONE_UTC);
            cal.setTimeInMillis(timeInMillis);
            this.addKeyIfNotZero(keys, cal, 13, 's');
            this.addKeyIfNotZero(keys, cal, 12, 'm');
            this.addKeyIfNotZero(keys, cal, 11, 'h');
            this.addKeyIfNotZero(keys, cal, 5, 'D');
            this.addKeyIfNotZero(keys, cal, 2, 'M');
            this.addKeyIfNotZero(keys, cal, 1, 'Y');
        }

        private void addKeyIfNotZero(Collection<ByteString> keys, GregorianCalendar cal, int calField, char type) {
            int value = cal.get(calField);
            if (value >= 0) {
                keys.add(this.getKey(value, type));
            }
        }

        private ByteString getKey(int value, char type) {
            return new ByteStringBuilder().append(type).append(value).toByteString();
        }
    }

    private static final class RelativeTimeLessThanOrderingMatchingRuleImpl
    extends RelativeTimeOrderingMatchingRuleImpl {
        private RelativeTimeLessThanOrderingMatchingRuleImpl() {
        }

        @Override
        public Assertion getAssertion(Schema schema, ByteSequence value) throws DecodeException {
            final ByteString assertionValue = this.normalizeAssertionValue(value);
            return new Assertion(){

                @Override
                public ConditionResult matches(ByteSequence attributeValue) {
                    return ConditionResult.valueOf(attributeValue.compareTo(assertionValue) < 0);
                }

                @Override
                public <T> T createIndexQuery(IndexQueryFactory<T> factory) throws DecodeException {
                    return factory.createRangeMatchQuery(RelativeTimeLessThanOrderingMatchingRuleImpl.this.indexer.getIndexID(), ByteString.empty(), assertionValue, false, false);
                }
            };
        }
    }

    private static final class RelativeTimeGreaterThanOrderingMatchingRuleImpl
    extends RelativeTimeOrderingMatchingRuleImpl {
        private RelativeTimeGreaterThanOrderingMatchingRuleImpl() {
        }

        @Override
        public Assertion getAssertion(Schema schema, ByteSequence value) throws DecodeException {
            final ByteString assertionValue = this.normalizeAssertionValue(value);
            return new Assertion(){

                @Override
                public ConditionResult matches(ByteSequence attributeValue) {
                    return ConditionResult.valueOf(attributeValue.compareTo(assertionValue) > 0);
                }

                @Override
                public <T> T createIndexQuery(IndexQueryFactory<T> factory) throws DecodeException {
                    return factory.createRangeMatchQuery(RelativeTimeGreaterThanOrderingMatchingRuleImpl.this.indexer.getIndexID(), assertionValue, ByteString.empty(), false, false);
                }
            };
        }
    }

    private static abstract class RelativeTimeOrderingMatchingRuleImpl
    extends TimeBasedMatchingRuleImpl {
        final Indexer indexer = new AbstractMatchingRuleImpl.DefaultIndexer("generalizedTimeMatch");

        private RelativeTimeOrderingMatchingRuleImpl() {
        }

        @Override
        public Collection<? extends Indexer> createIndexers(IndexingOptions options) {
            return Collections.singletonList(this.indexer);
        }

        ByteString normalizeAssertionValue(ByteSequence assertionValue) throws DecodeException {
            int index = 0;
            boolean signed = false;
            byte firstByte = assertionValue.byteAt(0);
            if (firstByte == 45) {
                signed = true;
                index = 1;
            } else if (firstByte == 43) {
                index = 1;
            }
            long second = 0L;
            long minute = 0L;
            long hour = 0L;
            long day = 0L;
            long week = 0L;
            boolean containsTimeUnit = false;
            int number = 0;
            while (index < assertionValue.length()) {
                byte b = assertionValue.byteAt(index);
                if (StaticUtils.isDigit((char)b)) {
                    number = this.multiplyByTenAndAddUnits(number, b);
                } else {
                    if (containsTimeUnit) {
                        throw DecodeException.error(CoreMessages.WARN_ATTR_CONFLICTING_ASSERTION_FORMAT.get((Object)assertionValue));
                    }
                    switch (b) {
                        case 115: {
                            second = number;
                            break;
                        }
                        case 109: {
                            minute = number;
                            break;
                        }
                        case 104: {
                            hour = number;
                            break;
                        }
                        case 100: {
                            day = number;
                            break;
                        }
                        case 119: {
                            week = number;
                            break;
                        }
                        default: {
                            throw DecodeException.error(CoreMessages.WARN_ATTR_INVALID_RELATIVE_TIME_ASSERTION_FORMAT.get((Object)assertionValue, (Object)Character.valueOf((char)b)));
                        }
                    }
                    containsTimeUnit = true;
                    number = 0;
                }
                ++index;
            }
            if (!containsTimeUnit) {
                second = number;
            }
            long delta = (second + minute * 60L + hour * 3600L + day * 24L * 3600L + week * 7L * 24L * 3600L) * 1000L;
            long now = this.timeService.now();
            return ByteString.valueOf(signed ? now - delta : now + delta);
        }
    }

    private static abstract class TimeBasedMatchingRuleImpl
    extends AbstractMatchingRuleImpl {
        final TimeService timeService = TimeService.SYSTEM;

        private TimeBasedMatchingRuleImpl() {
        }

        @Override
        public final ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
            try {
                return ByteString.valueOf(GeneralizedTime.valueOf(value.toString()).getTimeInMillis());
            }
            catch (LocalizedIllegalArgumentException e) {
                throw DecodeException.error(e.getMessageObject());
            }
        }

        int multiplyByTenAndAddUnits(int number, byte digitByte) {
            return number * 10 + (digitByte - 48);
        }
    }
}

