/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.forgerock.opendj.ldap.Option;

public final class SchemaOptions {
    public static final Option<Boolean> ALLOW_MALFORMED_NAMES_AND_OPTIONS = Option.withDefault(true);
    public static final Option<Boolean> ALLOW_MALFORMED_JPEG_PHOTOS = Option.withDefault(true);
    public static final Option<Boolean> ALLOW_MALFORMED_CERTIFICATES = Option.withDefault(true);
    public static final Option<Boolean> ALLOW_NON_STANDARD_TELEPHONE_NUMBERS = Option.withDefault(true);
    public static final Option<Boolean> ALLOW_ZERO_LENGTH_DIRECTORY_STRINGS = Option.withDefault(false);
    public static final Option<String> DEFAULT_SYNTAX_OID = Option.of(String.class, "1.3.6.1.4.1.1466.115.121.1.40");
    public static final Option<String> DEFAULT_MATCHING_RULE_OID = Option.of(String.class, "2.5.13.17");
    public static final Option<Boolean> STRICT_FORMAT_FOR_COUNTRY_STRINGS = Option.withDefault(true);
    public static final Option<Boolean> STRIP_UPPER_BOUND_FOR_ATTRIBUTE_TYPE = Option.withDefault(false);
    private final Map<Option<?>, Object> options;

    static SchemaOptions defaultSchemaOptions() {
        return new SchemaOptions(new IdentityHashMap());
    }

    static SchemaOptions copyOf(SchemaOptions schemaOptions) {
        return new SchemaOptions(new IdentityHashMap(schemaOptions.options));
    }

    static SchemaOptions unmodifiable(SchemaOptions schemaOptions) {
        return new SchemaOptions(Collections.unmodifiableMap(new IdentityHashMap(schemaOptions.options)));
    }

    private SchemaOptions(Map<Option<?>, Object> optionsMap) {
        this.options = optionsMap;
    }

    <T> T get(Option<T> option) {
        return option.getValue(this.options.get(option));
    }

    <T> SchemaOptions set(Option<T> option, T value) {
        this.options.put(option, value);
        return this;
    }
}

