/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.Option;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.AttributeUsage;
import org.forgerock.opendj.ldap.schema.ConflictingSchemaElementException;
import org.forgerock.opendj.ldap.schema.CoreSchemaImpl;
import org.forgerock.opendj.ldap.schema.DITContentRule;
import org.forgerock.opendj.ldap.schema.DITStructureRule;
import org.forgerock.opendj.ldap.schema.EnumOrderingMatchingRule;
import org.forgerock.opendj.ldap.schema.EnumSyntaxImpl;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleUse;
import org.forgerock.opendj.ldap.schema.NameForm;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaElement;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.SchemaOptions;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;

public final class SchemaBuilder {
    public static final String AMBIGUOUS_OID = "<ambiguous-oid>";
    private static final String ATTR_SUBSCHEMA_SUBENTRY = "subschemaSubentry";
    private static final String[] SUBSCHEMA_ATTRS = new String[]{"ldapSyntaxes", "attributeTypes", "dITContentRules", "dITStructureRules", "matchingRuleUse", "matchingRules", "nameForms", "objectClasses"};
    private static final Filter SUBSCHEMA_FILTER = Filter.valueOf("(objectClass=subschema)");
    private static final String[] SUBSCHEMA_SUBENTRY_ATTRS = new String[]{"subschemaSubentry"};
    private Map<Integer, DITStructureRule> id2StructureRules;
    private Map<String, List<AttributeType>> name2AttributeTypes;
    private Map<String, List<DITContentRule>> name2ContentRules;
    private Map<String, List<MatchingRule>> name2MatchingRules;
    private Map<String, List<MatchingRuleUse>> name2MatchingRuleUses;
    private Map<String, List<NameForm>> name2NameForms;
    private Map<String, List<ObjectClass>> name2ObjectClasses;
    private Map<String, List<DITStructureRule>> name2StructureRules;
    private Map<String, List<DITStructureRule>> nameForm2StructureRules;
    private Map<String, AttributeType> numericOID2AttributeTypes;
    private Map<String, DITContentRule> numericOID2ContentRules;
    private Map<String, MatchingRule> numericOID2MatchingRules;
    private Map<String, MatchingRuleUse> numericOID2MatchingRuleUses;
    private Map<String, NameForm> numericOID2NameForms;
    private Map<String, ObjectClass> numericOID2ObjectClasses;
    private Map<String, Syntax> numericOID2Syntaxes;
    private Map<String, List<NameForm>> objectClass2NameForms;
    private Map<String, String> name2OIDs;
    private String schemaName;
    private List<LocalizableMessage> warnings;
    private SchemaOptions options;
    private Schema copyOnWriteSchema;
    private static final AtomicInteger NEXT_SCHEMA_ID = new AtomicInteger();

    private static SearchRequest getReadSchemaForEntrySearchRequest(DN dn) {
        return Requests.newSearchRequest(dn, SearchScope.BASE_OBJECT, Filter.objectClassPresent(), SUBSCHEMA_SUBENTRY_ATTRS);
    }

    private static SearchRequest getReadSchemaSearchRequest(DN dn) {
        return Requests.newSearchRequest(dn, SearchScope.BASE_OBJECT, SUBSCHEMA_FILTER, SUBSCHEMA_ATTRS);
    }

    private static DN getSubschemaSubentryDN(DN name, Entry entry) throws LdapException {
        DN subschemaDN;
        Attribute subentryAttr = entry.getAttribute(ATTR_SUBSCHEMA_SUBENTRY);
        if (subentryAttr == null || subentryAttr.isEmpty()) {
            throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_NO_RESULTS_RETURNED, CoreMessages.ERR_NO_SUBSCHEMA_SUBENTRY_ATTR.get((Object)name.toString()).toString());
        }
        String dnString = subentryAttr.iterator().next().toString();
        try {
            subschemaDN = DN.valueOf(dnString);
        }
        catch (LocalizedIllegalArgumentException e) {
            throw LdapException.newLdapException(ResultCode.CLIENT_SIDE_NO_RESULTS_RETURNED, CoreMessages.ERR_INVALID_SUBSCHEMA_SUBENTRY_ATTR.get((Object)name.toString(), (Object)dnString, (Object)e.getMessageObject()).toString());
        }
        return subschemaDN;
    }

    public SchemaBuilder() {
        this.preLazyInitBuilder(null, null);
    }

    public SchemaBuilder(Entry entry) {
        this.preLazyInitBuilder(entry.getName().toString(), null);
        this.addSchema(entry, true);
    }

    public SchemaBuilder(Schema schema) {
        this.preLazyInitBuilder(schema.getSchemaName(), schema);
    }

    public SchemaBuilder(String schemaName) {
        this.preLazyInitBuilder(schemaName, null);
    }

    private Boolean allowsMalformedNamesAndOptions() {
        return this.options.get(SchemaOptions.ALLOW_MALFORMED_NAMES_AND_OPTIONS);
    }

    public SchemaBuilder addAttributeType(String definition, boolean overwrite) {
        Reject.ifNull((Object)definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_EMPTY_VALUE1.get((Object)definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            String oid = SchemaUtils.readOID(reader, this.allowsMalformedNamesAndOptions());
            AttributeType.Builder atBuilder = new AttributeType.Builder(oid, this);
            atBuilder.definition(definition);
            String superiorType = null;
            String syntax = null;
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    atBuilder.names(SchemaUtils.readNameDescriptors(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    atBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) {
                    atBuilder.obsolete(true);
                    continue;
                }
                if ("sup".equalsIgnoreCase(tokenName)) {
                    superiorType = SchemaUtils.readOID(reader, this.allowsMalformedNamesAndOptions());
                    continue;
                }
                if ("equality".equalsIgnoreCase(tokenName)) {
                    atBuilder.equalityMatchingRule(SchemaUtils.readOID(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("ordering".equalsIgnoreCase(tokenName)) {
                    atBuilder.orderingMatchingRule(SchemaUtils.readOID(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("substr".equalsIgnoreCase(tokenName)) {
                    atBuilder.substringMatchingRule(SchemaUtils.readOID(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("syntax".equalsIgnoreCase(tokenName)) {
                    syntax = SchemaUtils.readOIDLen(reader, this.allowsMalformedNamesAndOptions());
                    continue;
                }
                if ("single-value".equalsIgnoreCase(tokenName)) {
                    atBuilder.singleValue(true);
                    continue;
                }
                if ("collective".equalsIgnoreCase(tokenName)) {
                    atBuilder.collective(true);
                    continue;
                }
                if ("no-user-modification".equalsIgnoreCase(tokenName)) {
                    atBuilder.noUserModification(true);
                    continue;
                }
                if ("usage".equalsIgnoreCase(tokenName)) {
                    int length = 0;
                    reader.skipWhitespaces();
                    reader.mark();
                    while (" )".indexOf(reader.read()) == -1) {
                        ++length;
                    }
                    reader.reset();
                    String usageStr = reader.read(length);
                    if ("userapplications".equalsIgnoreCase(usageStr)) {
                        atBuilder.usage(AttributeUsage.USER_APPLICATIONS);
                        continue;
                    }
                    if ("directoryoperation".equalsIgnoreCase(usageStr)) {
                        atBuilder.usage(AttributeUsage.DIRECTORY_OPERATION);
                        continue;
                    }
                    if ("distributedoperation".equalsIgnoreCase(usageStr)) {
                        atBuilder.usage(AttributeUsage.DISTRIBUTED_OPERATION);
                        continue;
                    }
                    if ("dsaoperation".equalsIgnoreCase(usageStr)) {
                        atBuilder.usage(AttributeUsage.DSA_OPERATION);
                        continue;
                    }
                    throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_INVALID_ATTRIBUTE_USAGE1.get((Object)definition, (Object)usageStr));
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    atBuilder.extraProperties(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName));
            }
            List<String> approxRules = atBuilder.getExtraProperties().get("X-APPROX");
            if (approxRules != null && !approxRules.isEmpty()) {
                atBuilder.approximateMatchingRule(approxRules.get(0));
            }
            if (superiorType == null && syntax == null) {
                throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_MISSING_SYNTAX_AND_SUPERIOR.get((Object)definition));
            }
            atBuilder.superiorType(superiorType).syntax(syntax);
            return overwrite ? atBuilder.addToSchemaOverwrite() : atBuilder.addToSchema();
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
    }

    public SchemaBuilder addDITContentRule(String definition, boolean overwrite) {
        Reject.ifNull((Object)definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DCR_EMPTY_VALUE1.get((Object)definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            DITContentRule.Builder contentRuleBuilder = this.buildDITContentRule(SchemaUtils.readOID(reader, this.allowsMalformedNamesAndOptions()));
            contentRuleBuilder.definition(definition);
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    contentRuleBuilder.names(SchemaUtils.readNameDescriptors(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    contentRuleBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) {
                    contentRuleBuilder.obsolete(true);
                    continue;
                }
                if ("aux".equalsIgnoreCase(tokenName)) {
                    contentRuleBuilder.auxiliaryObjectClasses(SchemaUtils.readOIDs(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("must".equalsIgnoreCase(tokenName)) {
                    contentRuleBuilder.requiredAttributes(SchemaUtils.readOIDs(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("may".equalsIgnoreCase(tokenName)) {
                    contentRuleBuilder.optionalAttributes(SchemaUtils.readOIDs(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("not".equalsIgnoreCase(tokenName)) {
                    contentRuleBuilder.prohibitedAttributes(SchemaUtils.readOIDs(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    contentRuleBuilder.extraProperties(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName));
            }
            return overwrite ? contentRuleBuilder.addToSchemaOverwrite() : contentRuleBuilder.addToSchema();
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_DCR_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
    }

    public SchemaBuilder addDITStructureRule(String definition, boolean overwrite) {
        Reject.ifNull((Object)definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DSR_EMPTY_VALUE1.get((Object)definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DSR_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            DITStructureRule.Builder ruleBuilder = new DITStructureRule.Builder(SchemaUtils.readRuleID(reader), this);
            String nameForm = null;
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    ruleBuilder.names(SchemaUtils.readNameDescriptors(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    ruleBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) {
                    ruleBuilder.obsolete(true);
                    continue;
                }
                if ("form".equalsIgnoreCase(tokenName)) {
                    nameForm = SchemaUtils.readOID(reader, this.allowsMalformedNamesAndOptions());
                    continue;
                }
                if ("sup".equalsIgnoreCase(tokenName)) {
                    ruleBuilder.superiorRules(SchemaUtils.readRuleIDs(reader));
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    ruleBuilder.extraProperties(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DSR_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName));
            }
            if (nameForm == null) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_DSR_NO_NAME_FORM.get((Object)definition));
            }
            ruleBuilder.nameForm(nameForm);
            return overwrite ? ruleBuilder.addToSchemaOverwrite() : ruleBuilder.addToSchema();
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_DSR_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
    }

    public SchemaBuilder addEnumerationSyntax(String oid, String description, boolean overwrite, String ... enumerations) {
        Reject.ifNull((Object)enumerations);
        this.lazyInitBuilder();
        EnumSyntaxImpl enumImpl = new EnumSyntaxImpl(oid, Arrays.asList(enumerations));
        Syntax.Builder syntaxBuilder = ((Syntax.Builder)this.buildSyntax(oid).description(description).extraProperties((Map)Collections.singletonMap("X-ENUM", Arrays.asList(enumerations)))).implementation(enumImpl);
        syntaxBuilder.addToSchema(overwrite);
        try {
            ((MatchingRule.Builder)this.buildMatchingRule(enumImpl.getOrderingMatchingRule()).names("enumOrderingMatch" + oid).syntaxOID(oid).extraProperties((Map)CoreSchemaImpl.OPENDS_ORIGIN)).implementation(new EnumOrderingMatchingRule(enumImpl)).addToSchemaOverwrite();
        }
        catch (ConflictingSchemaElementException e) {
            this.removeSyntax(oid);
        }
        return this;
    }

    public SchemaBuilder addMatchingRule(String definition, boolean overwrite) {
        Reject.ifNull((Object)definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_MR_EMPTY_VALUE1.get((Object)definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MR_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            MatchingRule.Builder matchingRuleBuilder = new MatchingRule.Builder(SchemaUtils.readOID(reader, this.allowsMalformedNamesAndOptions()), this);
            matchingRuleBuilder.definition(definition);
            String syntax = null;
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    matchingRuleBuilder.names(SchemaUtils.readNameDescriptors(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    matchingRuleBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) {
                    matchingRuleBuilder.obsolete(true);
                    continue;
                }
                if ("syntax".equalsIgnoreCase(tokenName)) {
                    syntax = SchemaUtils.readOID(reader, this.allowsMalformedNamesAndOptions());
                    matchingRuleBuilder.syntaxOID(syntax);
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    List<String> extensions = SchemaUtils.readExtensions(reader);
                    matchingRuleBuilder.extraProperties(tokenName, extensions.toArray(new String[extensions.size()]));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_MR_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName));
            }
            if (syntax == null) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_MR_NO_SYNTAX.get((Object)definition));
            }
            if (overwrite) {
                matchingRuleBuilder.addToSchemaOverwrite();
            } else {
                matchingRuleBuilder.addToSchema();
            }
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_MR_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
        return this;
    }

    public SchemaBuilder addMatchingRuleUse(String definition, boolean overwrite) {
        Reject.ifNull((Object)definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_MRUSE_EMPTY_VALUE1.get((Object)definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            MatchingRuleUse.Builder useBuilder = this.buildMatchingRuleUse(SchemaUtils.readOID(reader, this.allowsMalformedNamesAndOptions()));
            Set<String> attributes = null;
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    useBuilder.names(SchemaUtils.readNameDescriptors(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    useBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) {
                    useBuilder.obsolete(true);
                    continue;
                }
                if ("applies".equalsIgnoreCase(tokenName)) {
                    attributes = SchemaUtils.readOIDs(reader, this.allowsMalformedNamesAndOptions());
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    useBuilder.extraProperties(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName));
            }
            if (attributes == null || attributes.size() == 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_MRUSE_NO_ATTR.get((Object)definition));
            }
            useBuilder.attributes((Collection<String>)attributes);
            return overwrite ? useBuilder.addToSchemaOverwrite() : useBuilder.addToSchema();
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
    }

    public AttributeType.Builder buildAttributeType(String oid) {
        this.lazyInitBuilder();
        return new AttributeType.Builder(oid, this);
    }

    public DITStructureRule.Builder buildDITStructureRule(int ruleID) {
        this.lazyInitBuilder();
        return new DITStructureRule.Builder(ruleID, this);
    }

    public MatchingRule.Builder buildMatchingRule(String oid) {
        this.lazyInitBuilder();
        return new MatchingRule.Builder(oid, this);
    }

    public MatchingRuleUse.Builder buildMatchingRuleUse(String oid) {
        this.lazyInitBuilder();
        return new MatchingRuleUse.Builder(oid, this);
    }

    public SchemaBuilder addNameForm(String definition, boolean overwrite) {
        Reject.ifNull((Object)definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_EMPTY_VALUE1.get((Object)definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)Character.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            NameForm.Builder nameFormBuilder = new NameForm.Builder(SchemaUtils.readOID(reader, this.allowsMalformedNamesAndOptions()), this);
            nameFormBuilder.definition(definition);
            String structuralOID = null;
            List<String> requiredAttributes = Collections.emptyList();
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    nameFormBuilder.names(SchemaUtils.readNameDescriptors(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    nameFormBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) {
                    nameFormBuilder.obsolete(true);
                    continue;
                }
                if ("oc".equalsIgnoreCase(tokenName)) {
                    structuralOID = SchemaUtils.readOID(reader, this.allowsMalformedNamesAndOptions());
                    nameFormBuilder.structuralObjectClassOID(structuralOID);
                    continue;
                }
                if ("must".equalsIgnoreCase(tokenName)) {
                    requiredAttributes = SchemaUtils.readOIDs(reader, this.allowsMalformedNamesAndOptions());
                    nameFormBuilder.requiredAttributes(requiredAttributes);
                    continue;
                }
                if ("may".equalsIgnoreCase(tokenName)) {
                    nameFormBuilder.optionalAttributes(SchemaUtils.readOIDs(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    List<String> extensions = SchemaUtils.readExtensions(reader);
                    nameFormBuilder.extraProperties(tokenName, extensions.toArray(new String[extensions.size()]));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName));
            }
            if (structuralOID == null) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_NO_STRUCTURAL_CLASS1.get((Object)definition));
            }
            if (requiredAttributes.isEmpty()) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_NO_REQUIRED_ATTR.get((Object)definition));
            }
            if (overwrite) {
                nameFormBuilder.addToSchemaOverwrite();
            } else {
                nameFormBuilder.addToSchema();
            }
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
        return this;
    }

    public DITContentRule.Builder buildDITContentRule(String structuralClassOID) {
        this.lazyInitBuilder();
        return new DITContentRule.Builder(structuralClassOID, this);
    }

    public NameForm.Builder buildNameForm(String oid) {
        this.lazyInitBuilder();
        return new NameForm.Builder(oid, this);
    }

    public ObjectClass.Builder buildObjectClass(String oid) {
        this.lazyInitBuilder();
        return new ObjectClass.Builder(oid, this);
    }

    public Syntax.Builder buildSyntax(String oid) {
        this.lazyInitBuilder();
        return new Syntax.Builder(oid, this);
    }

    public AttributeType.Builder buildAttributeType(AttributeType attributeType) {
        this.lazyInitBuilder();
        return new AttributeType.Builder(attributeType, this);
    }

    public DITContentRule.Builder buildDITContentRule(DITContentRule contentRule) {
        this.lazyInitBuilder();
        return new DITContentRule.Builder(contentRule, this);
    }

    public DITStructureRule.Builder buildDITStructureRule(DITStructureRule structureRule) {
        this.lazyInitBuilder();
        return new DITStructureRule.Builder(structureRule, this);
    }

    public MatchingRule.Builder buildMatchingRule(MatchingRule matchingRule) {
        return this.buildMatchingRule(matchingRule, true);
    }

    private MatchingRule.Builder buildMatchingRule(MatchingRule matchingRule, boolean initialize) {
        if (initialize) {
            this.lazyInitBuilder();
        }
        return new MatchingRule.Builder(matchingRule, this);
    }

    public MatchingRuleUse.Builder buildMatchingRuleUse(MatchingRuleUse matchingRuleUse) {
        this.lazyInitBuilder();
        return new MatchingRuleUse.Builder(matchingRuleUse, this);
    }

    public NameForm.Builder buildNameForm(NameForm nameForm) {
        this.lazyInitBuilder();
        return new NameForm.Builder(nameForm, this);
    }

    public ObjectClass.Builder buildObjectClass(ObjectClass objectClass) {
        this.lazyInitBuilder();
        return new ObjectClass.Builder(objectClass, this);
    }

    public Syntax.Builder buildSyntax(Syntax syntax) {
        return this.buildSyntax(syntax, true);
    }

    private Syntax.Builder buildSyntax(Syntax syntax, boolean initialize) {
        if (initialize) {
            this.lazyInitBuilder();
        }
        return new Syntax.Builder(syntax, this);
    }

    public SchemaBuilder addObjectClass(String definition, boolean overwrite) {
        Reject.ifNull((Object)definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_EMPTY_VALUE1.get((Object)definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_EXPECTED_OPEN_PARENTHESIS1.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            String oid = SchemaUtils.readOID(reader, this.allowsMalformedNamesAndOptions());
            Set<String> superiorClasses = Collections.emptySet();
            ObjectClassType ocType = null;
            ObjectClass.Builder ocBuilder = (ObjectClass.Builder)new ObjectClass.Builder(oid, this).definition(definition);
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("name".equalsIgnoreCase(tokenName)) {
                    ocBuilder.names(SchemaUtils.readNameDescriptors(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("desc".equalsIgnoreCase(tokenName)) {
                    ocBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if ("obsolete".equalsIgnoreCase(tokenName)) {
                    ocBuilder.obsolete(true);
                    continue;
                }
                if ("sup".equalsIgnoreCase(tokenName)) {
                    superiorClasses = SchemaUtils.readOIDs(reader, this.allowsMalformedNamesAndOptions());
                    continue;
                }
                if ("abstract".equalsIgnoreCase(tokenName)) {
                    ocType = ObjectClassType.ABSTRACT;
                    continue;
                }
                if ("structural".equalsIgnoreCase(tokenName)) {
                    ocType = ObjectClassType.STRUCTURAL;
                    continue;
                }
                if ("auxiliary".equalsIgnoreCase(tokenName)) {
                    ocType = ObjectClassType.AUXILIARY;
                    continue;
                }
                if ("must".equalsIgnoreCase(tokenName)) {
                    ocBuilder.requiredAttributes(SchemaUtils.readOIDs(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if ("may".equalsIgnoreCase(tokenName)) {
                    ocBuilder.optionalAttributes(SchemaUtils.readOIDs(reader, this.allowsMalformedNamesAndOptions()));
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    List<String> extensions = SchemaUtils.readExtensions(reader);
                    ocBuilder.extraProperties(tokenName, extensions.toArray(new String[extensions.size()]));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName));
            }
            if ("1.3.6.1.4.1.1466.101.120.111".equals(oid)) {
                this.addObjectClass(ObjectClass.newExtensibleObjectObjectClass(ocBuilder.getDescription(), ocBuilder.getExtraProperties(), this), overwrite);
                return this;
            }
            if (ocType == ObjectClassType.STRUCTURAL && superiorClasses.isEmpty()) {
                superiorClasses = Collections.singleton("top");
            }
            ocBuilder.superiorObjectClasses(superiorClasses).type(ocType);
            return overwrite ? ocBuilder.addToSchemaOverwrite() : ocBuilder.addToSchema();
        }
        catch (DecodeException e) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_INVALID1.get((Object)definition, (Object)e.getMessageObject()), e.getCause());
        }
    }

    public SchemaBuilder addPatternSyntax(String oid, String description, Pattern pattern, boolean overwrite) {
        Reject.ifNull((Object)pattern);
        this.lazyInitBuilder();
        SchemaElement.SchemaElementBuilder syntaxBuilder = this.buildSyntax(oid).description(description).extraProperties((Map)Collections.singletonMap("X-PATTERN", Collections.singletonList(pattern.toString())));
        ((Syntax.Builder)syntaxBuilder).addToSchema(overwrite);
        return this;
    }

    public SchemaBuilder addSchema(Connection connection, DN name, boolean overwrite) throws LdapException {
        SearchRequest request = SchemaBuilder.getReadSchemaSearchRequest(name);
        SearchResultEntry entry = connection.searchSingleEntry(request);
        return this.addSchema(entry, overwrite);
    }

    public SchemaBuilder addSchema(Entry entry, boolean overwrite) {
        Reject.ifNull((Object)entry);
        this.lazyInitBuilder();
        Attribute attr = entry.getAttribute("ldapSyntaxes");
        if (attr != null) {
            for (ByteString def : attr) {
                try {
                    this.addSyntax(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("attributeTypes")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addAttributeType(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("objectClasses")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addObjectClass(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("matchingRuleUse")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addMatchingRuleUse(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("matchingRules")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addMatchingRule(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("dITContentRules")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addDITContentRule(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("dITStructureRules")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addDITStructureRule(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("nameForms")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addNameForm(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        return this;
    }

    public SchemaBuilder addSchema(Schema schema, boolean overwrite) {
        Reject.ifNull((Object)schema);
        this.lazyInitBuilder();
        this.addSchema0(schema, overwrite);
        return this;
    }

    public LdapPromise<SchemaBuilder> addSchemaAsync(Connection connection, DN name, final boolean overwrite) {
        return connection.searchSingleEntryAsync(SchemaBuilder.getReadSchemaSearchRequest(name)).then(new Function<SearchResultEntry, SchemaBuilder, LdapException>(){

            public SchemaBuilder apply(SearchResultEntry result) throws LdapException {
                SchemaBuilder.this.addSchema(result, overwrite);
                return SchemaBuilder.this;
            }
        });
    }

    public SchemaBuilder addSchemaForEntry(Connection connection, DN name, boolean overwrite) throws LdapException {
        SearchRequest request = SchemaBuilder.getReadSchemaForEntrySearchRequest(name);
        SearchResultEntry entry = connection.searchSingleEntry(request);
        DN subschemaDN = SchemaBuilder.getSubschemaSubentryDN(name, entry);
        return this.addSchema(connection, subschemaDN, overwrite);
    }

    public LdapPromise<SchemaBuilder> addSchemaForEntryAsync(final Connection connection, final DN name, final boolean overwrite) {
        return connection.searchSingleEntryAsync(SchemaBuilder.getReadSchemaForEntrySearchRequest(name)).thenAsync(new AsyncFunction<SearchResultEntry, SchemaBuilder, LdapException>(){

            public Promise<SchemaBuilder, LdapException> apply(SearchResultEntry result) throws LdapException {
                DN subschemaDN = SchemaBuilder.getSubschemaSubentryDN(name, result);
                return SchemaBuilder.this.addSchemaAsync(connection, subschemaDN, overwrite);
            }
        });
    }

    public SchemaBuilder addSubstitutionSyntax(String oid, String description, String substituteSyntax, boolean overwrite) {
        Reject.ifNull((Object)substituteSyntax);
        this.lazyInitBuilder();
        SchemaElement.SchemaElementBuilder syntaxBuilder = this.buildSyntax(oid).description(description).extraProperties((Map)Collections.singletonMap("X-SUBST", Collections.singletonList(substituteSyntax)));
        ((Syntax.Builder)syntaxBuilder).addToSchema(overwrite);
        return this;
    }

    public SchemaBuilder addSyntax(String definition, boolean overwrite) {
        Reject.ifNull((Object)definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EMPTY_VALUE1.get((Object)definition));
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            String oid = SchemaUtils.readOID(reader, this.allowsMalformedNamesAndOptions());
            Syntax.Builder syntaxBuilder = (Syntax.Builder)new Syntax.Builder(oid, this).definition(definition);
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if ("desc".equalsIgnoreCase(tokenName)) {
                    syntaxBuilder.description(SchemaUtils.readQuotedString(reader));
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    List<String> extensions = SchemaUtils.readExtensions(reader);
                    syntaxBuilder.extraProperties(tokenName, extensions.toArray(new String[extensions.size()]));
                    continue;
                }
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName));
            }
            for (Map.Entry<String, List<String>> property : syntaxBuilder.getExtraProperties().entrySet()) {
                if (!"x-enum".equalsIgnoreCase(property.getKey())) continue;
                EnumSyntaxImpl enumImpl = new EnumSyntaxImpl(oid, property.getValue());
                syntaxBuilder.implementation(enumImpl);
                syntaxBuilder.addToSchema(overwrite);
                ((MatchingRule.Builder)this.buildMatchingRule(enumImpl.getOrderingMatchingRule()).names("enumOrderingMatch" + oid).syntaxOID(oid).extraProperties((Map)CoreSchemaImpl.OPENDS_ORIGIN)).implementation(new EnumOrderingMatchingRule(enumImpl)).addToSchemaOverwrite();
                return this;
            }
            syntaxBuilder.addToSchema(overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
        return this;
    }

    SchemaOptions getOptions() {
        this.lazyInitBuilder();
        return this.options;
    }

    public boolean removeAttributeType(String name) {
        this.lazyInitBuilder();
        AttributeType element = this.numericOID2AttributeTypes.get(name);
        if (element != null) {
            this.removeAttributeType(element);
            return true;
        }
        List<AttributeType> elements = this.name2AttributeTypes.get(StaticUtils.toLowerCase(name));
        if (elements != null) {
            for (AttributeType e : elements) {
                this.removeAttributeType(e);
            }
            return true;
        }
        return false;
    }

    public boolean removeDITContentRule(String name) {
        this.lazyInitBuilder();
        DITContentRule element = this.numericOID2ContentRules.get(name);
        if (element != null) {
            this.removeDITContentRule(element);
            return true;
        }
        List<DITContentRule> elements = this.name2ContentRules.get(StaticUtils.toLowerCase(name));
        if (elements != null) {
            for (DITContentRule e : elements) {
                this.removeDITContentRule(e);
            }
            return true;
        }
        return false;
    }

    public boolean removeDITStructureRule(int ruleID) {
        this.lazyInitBuilder();
        DITStructureRule element = this.id2StructureRules.get(ruleID);
        if (element != null) {
            this.removeDITStructureRule(element);
            return true;
        }
        return false;
    }

    public boolean removeMatchingRule(String name) {
        this.lazyInitBuilder();
        MatchingRule element = this.numericOID2MatchingRules.get(name);
        if (element != null) {
            this.removeMatchingRule(element);
            return true;
        }
        List<MatchingRule> elements = this.name2MatchingRules.get(StaticUtils.toLowerCase(name));
        if (elements != null) {
            for (MatchingRule e : elements) {
                this.removeMatchingRule(e);
            }
            return true;
        }
        return false;
    }

    public boolean removeMatchingRuleUse(String name) {
        this.lazyInitBuilder();
        MatchingRuleUse element = this.numericOID2MatchingRuleUses.get(name);
        if (element != null) {
            this.removeMatchingRuleUse(element);
            return true;
        }
        List<MatchingRuleUse> elements = this.name2MatchingRuleUses.get(StaticUtils.toLowerCase(name));
        if (elements != null) {
            for (MatchingRuleUse e : elements) {
                this.removeMatchingRuleUse(e);
            }
            return true;
        }
        return false;
    }

    public boolean removeNameForm(String name) {
        this.lazyInitBuilder();
        NameForm element = this.numericOID2NameForms.get(name);
        if (element != null) {
            this.removeNameForm(element);
            return true;
        }
        List<NameForm> elements = this.name2NameForms.get(StaticUtils.toLowerCase(name));
        if (elements != null) {
            for (NameForm e : elements) {
                this.removeNameForm(e);
            }
            return true;
        }
        return false;
    }

    public boolean removeObjectClass(String name) {
        this.lazyInitBuilder();
        ObjectClass element = this.numericOID2ObjectClasses.get(name);
        if (element != null) {
            this.removeObjectClass(element);
            return true;
        }
        List<ObjectClass> elements = this.name2ObjectClasses.get(StaticUtils.toLowerCase(name));
        if (elements != null) {
            for (ObjectClass e : elements) {
                this.removeObjectClass(e);
            }
            return true;
        }
        return false;
    }

    public boolean removeSyntax(String numericOID) {
        this.lazyInitBuilder();
        Syntax element = this.numericOID2Syntaxes.get(numericOID);
        if (element != null) {
            this.removeSyntax(element);
            return true;
        }
        return false;
    }

    public <T> SchemaBuilder setOption(Option<T> option, T value) {
        this.getOptions().set(option, value);
        return this;
    }

    public Schema toSchema() {
        MatchingRule defaultMatchingRule;
        if (this.copyOnWriteSchema != null) {
            return this.copyOnWriteSchema;
        }
        this.lazyInitBuilder();
        String localSchemaName = this.schemaName != null ? this.schemaName : String.format("Schema#%d", NEXT_SCHEMA_ID.getAndIncrement());
        Syntax defaultSyntax = this.numericOID2Syntaxes.get(this.options.get(SchemaOptions.DEFAULT_SYNTAX_OID));
        if (defaultSyntax == null) {
            defaultSyntax = Schema.getCoreSchema().getDefaultSyntax();
        }
        if ((defaultMatchingRule = this.numericOID2MatchingRules.get(this.options.get(SchemaOptions.DEFAULT_MATCHING_RULE_OID))) == null) {
            defaultMatchingRule = Schema.getCoreSchema().getDefaultMatchingRule();
        }
        Schema schema = new Schema.StrictImpl(localSchemaName, this.options, defaultSyntax, defaultMatchingRule, this.numericOID2Syntaxes, this.numericOID2MatchingRules, this.numericOID2MatchingRuleUses, this.numericOID2AttributeTypes, this.numericOID2ObjectClasses, this.numericOID2NameForms, this.numericOID2ContentRules, this.id2StructureRules, this.name2MatchingRules, this.name2MatchingRuleUses, this.name2AttributeTypes, this.name2ObjectClasses, this.name2NameForms, this.name2ContentRules, this.name2StructureRules, this.objectClass2NameForms, this.nameForm2StructureRules, this.name2OIDs, this.warnings).asStrictSchema();
        this.validate(schema);
        this.preLazyInitBuilder(this.schemaName, schema);
        return schema;
    }

    private void registerNameToOIDMapping(String name, String anOID) {
        if (this.name2OIDs.put(name, anOID) != null) {
            this.name2OIDs.put(name, AMBIGUOUS_OID);
        }
    }

    SchemaBuilder addAttributeType(AttributeType attribute, boolean overwrite) {
        if (this.numericOID2AttributeTypes.containsKey(attribute.getOID())) {
            AttributeType conflictingAttribute = this.numericOID2AttributeTypes.get(attribute.getOID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_ATTRIBUTE_OID.get((Object)attribute.getNameOrOID(), (Object)attribute.getOID(), (Object)conflictingAttribute.getNameOrOID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeAttributeType(conflictingAttribute);
        }
        this.numericOID2AttributeTypes.put(attribute.getOID(), attribute);
        for (String name : attribute.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<AttributeType> attrs = this.name2AttributeTypes.get(lowerName);
            if (attrs == null) {
                this.name2AttributeTypes.put(lowerName, Collections.singletonList(attribute));
                continue;
            }
            if (attrs.size() == 1) {
                attrs = new ArrayList<AttributeType>(attrs);
                attrs.add(attribute);
                this.name2AttributeTypes.put(lowerName, attrs);
                continue;
            }
            attrs.add(attribute);
        }
        return this;
    }

    SchemaBuilder addDITContentRule(DITContentRule rule, boolean overwrite) {
        if (this.numericOID2ContentRules.containsKey(rule.getStructuralClassOID())) {
            DITContentRule conflictingRule = this.numericOID2ContentRules.get(rule.getStructuralClassOID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_DIT_CONTENT_RULE1.get((Object)rule.getNameOrOID(), (Object)rule.getStructuralClassOID(), (Object)conflictingRule.getNameOrOID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeDITContentRule(conflictingRule);
        }
        this.numericOID2ContentRules.put(rule.getStructuralClassOID(), rule);
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<DITContentRule> rules = this.name2ContentRules.get(lowerName);
            if (rules == null) {
                this.name2ContentRules.put(lowerName, Collections.singletonList(rule));
                continue;
            }
            if (rules.size() == 1) {
                rules = new ArrayList<DITContentRule>(rules);
                rules.add(rule);
                this.name2ContentRules.put(lowerName, rules);
                continue;
            }
            rules.add(rule);
        }
        return this;
    }

    SchemaBuilder addDITStructureRule(DITStructureRule rule, boolean overwrite) {
        if (this.id2StructureRules.containsKey(rule.getRuleID())) {
            DITStructureRule conflictingRule = this.id2StructureRules.get(rule.getRuleID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_DIT_STRUCTURE_RULE_ID.get((Object)rule.getNameOrRuleID(), (Object)rule.getRuleID(), (Object)conflictingRule.getNameOrRuleID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeDITStructureRule(conflictingRule);
        }
        this.id2StructureRules.put(rule.getRuleID(), rule);
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<DITStructureRule> rules = this.name2StructureRules.get(lowerName);
            if (rules == null) {
                this.name2StructureRules.put(lowerName, Collections.singletonList(rule));
                continue;
            }
            if (rules.size() == 1) {
                rules = new ArrayList<DITStructureRule>(rules);
                rules.add(rule);
                this.name2StructureRules.put(lowerName, rules);
                continue;
            }
            rules.add(rule);
        }
        return this;
    }

    SchemaBuilder addMatchingRuleUse(MatchingRuleUse use, boolean overwrite) {
        if (this.numericOID2MatchingRuleUses.containsKey(use.getMatchingRuleOID())) {
            MatchingRuleUse conflictingUse = this.numericOID2MatchingRuleUses.get(use.getMatchingRuleOID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_MATCHING_RULE_USE.get((Object)use.getNameOrOID(), (Object)use.getMatchingRuleOID(), (Object)conflictingUse.getNameOrOID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeMatchingRuleUse(conflictingUse);
        }
        this.numericOID2MatchingRuleUses.put(use.getMatchingRuleOID(), use);
        for (String name : use.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<MatchingRuleUse> uses = this.name2MatchingRuleUses.get(lowerName);
            if (uses == null) {
                this.name2MatchingRuleUses.put(lowerName, Collections.singletonList(use));
                continue;
            }
            if (uses.size() == 1) {
                uses = new ArrayList<MatchingRuleUse>(uses);
                uses.add(use);
                this.name2MatchingRuleUses.put(lowerName, uses);
                continue;
            }
            uses.add(use);
        }
        return this;
    }

    SchemaBuilder addMatchingRule(MatchingRule rule, boolean overwrite) {
        Reject.ifTrue((boolean)rule.isValidated(), (String)"Matching rule has already been validated, it can't be added");
        if (this.numericOID2MatchingRules.containsKey(rule.getOID())) {
            MatchingRule conflictingRule = this.numericOID2MatchingRules.get(rule.getOID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_OID.get((Object)rule.getNameOrOID(), (Object)rule.getOID(), (Object)conflictingRule.getNameOrOID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeMatchingRule(conflictingRule);
        }
        this.numericOID2MatchingRules.put(rule.getOID(), rule);
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<MatchingRule> rules = this.name2MatchingRules.get(lowerName);
            if (rules == null) {
                this.name2MatchingRules.put(lowerName, Collections.singletonList(rule));
                continue;
            }
            if (rules.size() == 1) {
                rules = new ArrayList<MatchingRule>(rules);
                rules.add(rule);
                this.name2MatchingRules.put(lowerName, rules);
                continue;
            }
            rules.add(rule);
        }
        return this;
    }

    SchemaBuilder addNameForm(NameForm form, boolean overwrite) {
        if (this.numericOID2NameForms.containsKey(form.getOID())) {
            NameForm conflictingForm = this.numericOID2NameForms.get(form.getOID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_NAME_FORM_OID.get((Object)form.getNameOrOID(), (Object)form.getOID(), (Object)conflictingForm.getNameOrOID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeNameForm(conflictingForm);
        }
        this.numericOID2NameForms.put(form.getOID(), form);
        for (String name : form.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<NameForm> forms = this.name2NameForms.get(lowerName);
            if (forms == null) {
                this.name2NameForms.put(lowerName, Collections.singletonList(form));
                continue;
            }
            if (forms.size() == 1) {
                forms = new ArrayList<NameForm>(forms);
                forms.add(form);
                this.name2NameForms.put(lowerName, forms);
                continue;
            }
            forms.add(form);
        }
        return this;
    }

    SchemaBuilder addObjectClass(ObjectClass oc, boolean overwrite) {
        if (this.numericOID2ObjectClasses.containsKey(oc.getOID())) {
            ObjectClass conflictingOC = this.numericOID2ObjectClasses.get(oc.getOID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_OBJECTCLASS_OID1.get((Object)oc.getNameOrOID(), (Object)oc.getOID(), (Object)conflictingOC.getNameOrOID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeObjectClass(conflictingOC);
        }
        this.numericOID2ObjectClasses.put(oc.getOID(), oc);
        for (String name : oc.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<ObjectClass> classes = this.name2ObjectClasses.get(lowerName);
            if (classes == null) {
                this.name2ObjectClasses.put(lowerName, Collections.singletonList(oc));
                continue;
            }
            if (classes.size() == 1) {
                classes = new ArrayList<ObjectClass>(classes);
                classes.add(oc);
                this.name2ObjectClasses.put(lowerName, classes);
                continue;
            }
            classes.add(oc);
        }
        return this;
    }

    private void addSchema0(Schema schema, boolean overwrite) {
        for (Syntax syntax : schema.getSyntaxes()) {
            if (overwrite) {
                this.buildSyntax(syntax, false).addToSchemaOverwrite();
                continue;
            }
            this.buildSyntax(syntax, false).addToSchema();
        }
        for (MatchingRule matchingRule : schema.getMatchingRules()) {
            if (overwrite) {
                this.buildMatchingRule(matchingRule, false).addToSchemaOverwrite();
                continue;
            }
            this.buildMatchingRule(matchingRule, false).addToSchema();
        }
        for (MatchingRuleUse matchingRuleUse : schema.getMatchingRuleUses()) {
            this.addMatchingRuleUse(matchingRuleUse, overwrite);
        }
        for (AttributeType attributeType : schema.getAttributeTypes()) {
            this.addAttributeType(attributeType, overwrite);
        }
        for (ObjectClass objectClass : schema.getObjectClasses()) {
            this.addObjectClass(objectClass, overwrite);
        }
        for (NameForm nameForm : schema.getNameForms()) {
            this.addNameForm(nameForm, overwrite);
        }
        for (DITContentRule contentRule : schema.getDITContentRules()) {
            this.addDITContentRule(contentRule, overwrite);
        }
        for (DITStructureRule structureRule : schema.getDITStuctureRules()) {
            this.addDITStructureRule(structureRule, overwrite);
        }
    }

    SchemaBuilder addSyntax(Syntax syntax, boolean overwrite) {
        Reject.ifTrue((boolean)syntax.isValidated(), (String)"Syntax has already been validated, it can't be added");
        if (this.numericOID2Syntaxes.containsKey(syntax.getOID())) {
            Syntax conflictingSyntax = this.numericOID2Syntaxes.get(syntax.getOID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_SYNTAX_OID.get((Object)syntax.toString(), (Object)syntax.getOID(), (Object)conflictingSyntax.getOID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeSyntax(conflictingSyntax);
        }
        this.numericOID2Syntaxes.put(syntax.getOID(), syntax);
        return this;
    }

    private void lazyInitBuilder() {
        if (this.numericOID2Syntaxes == null) {
            this.options = SchemaOptions.defaultSchemaOptions();
            this.numericOID2Syntaxes = new LinkedHashMap<String, Syntax>();
            this.numericOID2MatchingRules = new LinkedHashMap<String, MatchingRule>();
            this.numericOID2MatchingRuleUses = new LinkedHashMap<String, MatchingRuleUse>();
            this.numericOID2AttributeTypes = new LinkedHashMap<String, AttributeType>();
            this.numericOID2ObjectClasses = new LinkedHashMap<String, ObjectClass>();
            this.numericOID2NameForms = new LinkedHashMap<String, NameForm>();
            this.numericOID2ContentRules = new LinkedHashMap<String, DITContentRule>();
            this.id2StructureRules = new LinkedHashMap<Integer, DITStructureRule>();
            this.name2MatchingRules = new LinkedHashMap<String, List<MatchingRule>>();
            this.name2MatchingRuleUses = new LinkedHashMap<String, List<MatchingRuleUse>>();
            this.name2AttributeTypes = new LinkedHashMap<String, List<AttributeType>>();
            this.name2ObjectClasses = new LinkedHashMap<String, List<ObjectClass>>();
            this.name2NameForms = new LinkedHashMap<String, List<NameForm>>();
            this.name2ContentRules = new LinkedHashMap<String, List<DITContentRule>>();
            this.name2StructureRules = new LinkedHashMap<String, List<DITStructureRule>>();
            this.objectClass2NameForms = new HashMap<String, List<NameForm>>();
            this.nameForm2StructureRules = new HashMap<String, List<DITStructureRule>>();
            this.name2OIDs = new HashMap<String, String>();
            this.warnings = new LinkedList<LocalizableMessage>();
        }
        if (this.copyOnWriteSchema != null) {
            this.addSchema0(this.copyOnWriteSchema, true);
            this.options = SchemaOptions.copyOf(this.copyOnWriteSchema.getOptions());
            this.copyOnWriteSchema = null;
        }
    }

    private void preLazyInitBuilder(String schemaName, Schema copyOnWriteSchema) {
        this.schemaName = schemaName;
        this.copyOnWriteSchema = copyOnWriteSchema;
        this.options = null;
        this.numericOID2Syntaxes = null;
        this.numericOID2MatchingRules = null;
        this.numericOID2MatchingRuleUses = null;
        this.numericOID2AttributeTypes = null;
        this.numericOID2ObjectClasses = null;
        this.numericOID2NameForms = null;
        this.numericOID2ContentRules = null;
        this.id2StructureRules = null;
        this.name2MatchingRules = null;
        this.name2MatchingRuleUses = null;
        this.name2AttributeTypes = null;
        this.name2ObjectClasses = null;
        this.name2NameForms = null;
        this.name2ContentRules = null;
        this.name2StructureRules = null;
        this.objectClass2NameForms = null;
        this.nameForm2StructureRules = null;
        this.warnings = null;
    }

    private void removeAttributeType(AttributeType attributeType) {
        this.numericOID2AttributeTypes.remove(attributeType.getOID());
        for (String name : attributeType.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<AttributeType> attributes = this.name2AttributeTypes.get(lowerName);
            if (attributes == null || !attributes.contains(attributeType)) continue;
            if (attributes.size() <= 1) {
                this.name2AttributeTypes.remove(lowerName);
                continue;
            }
            attributes.remove(attributeType);
        }
    }

    private void removeDITContentRule(DITContentRule rule) {
        this.numericOID2ContentRules.remove(rule.getStructuralClassOID());
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<DITContentRule> rules = this.name2ContentRules.get(lowerName);
            if (rules == null || !rules.contains(rule)) continue;
            if (rules.size() <= 1) {
                this.name2ContentRules.remove(lowerName);
                continue;
            }
            rules.remove(rule);
        }
    }

    private void removeDITStructureRule(DITStructureRule rule) {
        this.id2StructureRules.remove(rule.getRuleID());
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<DITStructureRule> rules = this.name2StructureRules.get(lowerName);
            if (rules == null || !rules.contains(rule)) continue;
            if (rules.size() <= 1) {
                this.name2StructureRules.remove(lowerName);
                continue;
            }
            rules.remove(rule);
        }
    }

    private void removeMatchingRule(MatchingRule rule) {
        this.numericOID2MatchingRules.remove(rule.getOID());
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<MatchingRule> rules = this.name2MatchingRules.get(lowerName);
            if (rules == null || !rules.contains(rule)) continue;
            if (rules.size() <= 1) {
                this.name2MatchingRules.remove(lowerName);
                continue;
            }
            rules.remove(rule);
        }
    }

    private void removeMatchingRuleUse(MatchingRuleUse use) {
        this.numericOID2MatchingRuleUses.remove(use.getMatchingRuleOID());
        for (String name : use.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<MatchingRuleUse> uses = this.name2MatchingRuleUses.get(lowerName);
            if (uses == null || !uses.contains(use)) continue;
            if (uses.size() <= 1) {
                this.name2MatchingRuleUses.remove(lowerName);
                continue;
            }
            uses.remove(use);
        }
    }

    private void removeNameForm(NameForm form) {
        this.numericOID2NameForms.remove(form.getOID());
        this.name2NameForms.remove(form.getOID());
        for (String name : form.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<NameForm> forms = this.name2NameForms.get(lowerName);
            if (forms == null || !forms.contains(form)) continue;
            if (forms.size() <= 1) {
                this.name2NameForms.remove(lowerName);
                continue;
            }
            forms.remove(form);
        }
    }

    private void removeObjectClass(ObjectClass oc) {
        this.numericOID2ObjectClasses.remove(oc.getOID());
        this.name2ObjectClasses.remove(oc.getOID());
        for (String name : oc.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<ObjectClass> classes = this.name2ObjectClasses.get(lowerName);
            if (classes == null || !classes.contains(oc)) continue;
            if (classes.size() <= 1) {
                this.name2ObjectClasses.remove(lowerName);
                continue;
            }
            classes.remove(oc);
        }
    }

    private void removeSyntax(Syntax syntax) {
        this.numericOID2Syntaxes.remove(syntax.getOID());
    }

    private void validate(Schema schema) {
        for (Syntax syntax : this.numericOID2Syntaxes.values().toArray(new Syntax[this.numericOID2Syntaxes.values().size()])) {
            try {
                syntax.validate(schema, this.warnings);
                this.registerNameToOIDMapping(syntax.getName(), syntax.getOID());
            }
            catch (SchemaException e) {
                this.removeSyntax(syntax);
                this.warnings.add(CoreMessages.ERR_SYNTAX_VALIDATION_FAIL.get((Object)syntax.toString(), (Object)e.getMessageObject()));
            }
        }
        for (SchemaElement schemaElement : this.numericOID2MatchingRules.values().toArray(new MatchingRule[this.numericOID2MatchingRules.values().size()])) {
            try {
                ((MatchingRule)schemaElement).validate(schema, this.warnings);
                for (String string : ((MatchingRule)schemaElement).getNames()) {
                    this.registerNameToOIDMapping(StaticUtils.toLowerCase(string), ((MatchingRule)schemaElement).getOID());
                }
            }
            catch (SchemaException e) {
                this.removeMatchingRule((MatchingRule)schemaElement);
                this.warnings.add(CoreMessages.ERR_MR_VALIDATION_FAIL.get((Object)schemaElement.toString(), (Object)e.getMessageObject()));
            }
        }
        LinkedList<AttributeType> invalidAttributeTypes = new LinkedList<AttributeType>();
        for (AttributeType attributeType : this.numericOID2AttributeTypes.values()) {
            attributeType.validate(schema, invalidAttributeTypes, this.warnings);
        }
        for (AttributeType attributeType : invalidAttributeTypes) {
            this.removeAttributeType(attributeType);
        }
        for (AttributeType attributeType : this.numericOID2AttributeTypes.values()) {
            for (String name : attributeType.getNames()) {
                this.registerNameToOIDMapping(StaticUtils.toLowerCase(name), attributeType.getOID());
            }
        }
        LinkedList<ObjectClass> invalidObjectClasses = new LinkedList<ObjectClass>();
        for (ObjectClass objectClass : this.numericOID2ObjectClasses.values()) {
            objectClass.validate(schema, invalidObjectClasses, this.warnings);
        }
        for (ObjectClass objectClass : invalidObjectClasses) {
            this.removeObjectClass(objectClass);
        }
        for (ObjectClass objectClass : this.numericOID2ObjectClasses.values()) {
            for (String string : objectClass.getNames()) {
                this.registerNameToOIDMapping(StaticUtils.toLowerCase(string), objectClass.getOID());
            }
        }
        for (MatchingRuleUse matchingRuleUse : this.numericOID2MatchingRuleUses.values().toArray(new MatchingRuleUse[this.numericOID2MatchingRuleUses.values().size()])) {
            try {
                matchingRuleUse.validate(schema, this.warnings);
                for (String name : matchingRuleUse.getNames()) {
                    this.registerNameToOIDMapping(StaticUtils.toLowerCase(name), matchingRuleUse.getMatchingRuleOID());
                }
            }
            catch (SchemaException e) {
                this.removeMatchingRuleUse(matchingRuleUse);
                this.warnings.add(CoreMessages.ERR_MRU_VALIDATION_FAIL.get((Object)matchingRuleUse.toString(), (Object)e.getMessageObject()));
            }
        }
        for (SchemaElement schemaElement : this.numericOID2NameForms.values().toArray(new NameForm[this.numericOID2NameForms.values().size()])) {
            try {
                ((NameForm)schemaElement).validate(schema, this.warnings);
                String ocOID = ((NameForm)schemaElement).getStructuralClass().getOID();
                List<NameForm> forms = this.objectClass2NameForms.get(ocOID);
                if (forms == null) {
                    this.objectClass2NameForms.put(ocOID, Collections.singletonList(schemaElement));
                } else if (forms.size() == 1) {
                    forms = new ArrayList<NameForm>(forms);
                    forms.add((NameForm)schemaElement);
                    this.objectClass2NameForms.put(ocOID, forms);
                } else {
                    forms.add((NameForm)schemaElement);
                }
                for (String name : ((NameForm)schemaElement).getNames()) {
                    this.registerNameToOIDMapping(StaticUtils.toLowerCase(name), ((NameForm)schemaElement).getOID());
                }
            }
            catch (SchemaException e) {
                this.removeNameForm((NameForm)schemaElement);
                this.warnings.add(CoreMessages.ERR_NAMEFORM_VALIDATION_FAIL.get((Object)schemaElement.toString(), (Object)e.getMessageObject()));
            }
        }
        for (SchemaElement schemaElement : this.numericOID2ContentRules.values().toArray(new DITContentRule[this.numericOID2ContentRules.values().size()])) {
            try {
                ((DITContentRule)schemaElement).validate(schema, this.warnings);
                for (String name : ((DITContentRule)schemaElement).getNames()) {
                    this.registerNameToOIDMapping(StaticUtils.toLowerCase(name), ((DITContentRule)schemaElement).getStructuralClassOID());
                }
            }
            catch (SchemaException e) {
                this.removeDITContentRule((DITContentRule)schemaElement);
                this.warnings.add(CoreMessages.ERR_DCR_VALIDATION_FAIL.get((Object)schemaElement.toString(), (Object)e.getMessageObject()));
            }
        }
        LinkedList<DITStructureRule> invalidStructureRules = new LinkedList<DITStructureRule>();
        for (DITStructureRule rule : this.id2StructureRules.values()) {
            rule.validate(schema, invalidStructureRules, this.warnings);
        }
        for (DITStructureRule rule : invalidStructureRules) {
            this.removeDITStructureRule(rule);
        }
        for (DITStructureRule rule : this.id2StructureRules.values()) {
            String string = rule.getNameForm().getOID();
            List<DITStructureRule> rules = this.nameForm2StructureRules.get(string);
            if (rules == null) {
                this.nameForm2StructureRules.put(string, Collections.singletonList(rule));
                continue;
            }
            if (rules.size() == 1) {
                rules = new ArrayList<DITStructureRule>(rules);
                rules.add(rule);
                this.nameForm2StructureRules.put(string, rules);
                continue;
            }
            rules.add(rule);
        }
    }
}

