/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.EnumSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.util.Reject;

final class EnumOrderingMatchingRule
extends AbstractOrderingMatchingRuleImpl {
    private final EnumSyntaxImpl syntax;

    EnumOrderingMatchingRule(EnumSyntaxImpl syntax) {
        super("enumOrderingMatch");
        Reject.ifNull((Object)syntax);
        this.syntax = syntax;
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        int index = this.syntax.indexOf(value);
        if (index < 0) {
            throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_LDAPSYNTAX_ENUM_INVALID_VALUE.get((Object)value.toString(), (Object)this.syntax.getName()));
        }
        return ByteString.valueOf(index);
    }
}

