/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.SubstringReader;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class DirectoryStringFirstComponentEqualityMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    DirectoryStringFirstComponentEqualityMatchingRuleImpl() {
        super("directoryStringFirstComponentMatch");
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence assertionValue) {
        return DirectoryStringFirstComponentEqualityMatchingRuleImpl.named("directoryStringFirstComponentMatch", SchemaUtils.normalizeStringAttributeValue(assertionValue, true, true));
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String definition = value.toString();
        SubstringReader reader = new SubstringReader(definition);
        reader.skipWhitespaces();
        if (reader.remaining() <= 0) {
            throw DecodeException.error(CoreMessages.ERR_ATTR_SYNTAX_EMPTY_VALUE.get());
        }
        char c = reader.read();
        if (c != '(') {
            throw DecodeException.error(CoreMessages.ERR_ATTR_SYNTAX_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)Character.valueOf(c)));
        }
        reader.skipWhitespaces();
        String string = SchemaUtils.readQuotedString(reader);
        return ByteString.valueOf(string);
    }
}

