/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class BitStringEqualityMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    BitStringEqualityMatchingRuleImpl() {
        super("bitStringMatch");
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String valueString = value.toString().toUpperCase();
        int length = valueString.length();
        if (length < 3) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_BIT_STRING_TOO_SHORT.get((Object)value.toString());
            throw DecodeException.error(message);
        }
        if (valueString.charAt(0) != '\'' || valueString.charAt(length - 2) != '\'' || valueString.charAt(length - 1) != 'B') {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_BIT_STRING_NOT_QUOTED.get((Object)value.toString());
            throw DecodeException.error(message);
        }
        block3: for (int i = 1; i < length - 2; ++i) {
            switch (valueString.charAt(i)) {
                case '0': 
                case '1': {
                    continue block3;
                }
                default: {
                    LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_BIT_STRING_INVALID_BIT.get((Object)value.toString(), (Object)String.valueOf(valueString.charAt(i)));
                    throw DecodeException.error(message);
                }
            }
        }
        return ByteString.valueOf(valueString);
    }
}

