/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.responses;

import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.responses.AbstractExtendedResult;
import org.forgerock.opendj.ldap.responses.PasswordModifyExtendedResult;

final class PasswordModifyExtendedResultImpl
extends AbstractExtendedResult<PasswordModifyExtendedResult>
implements PasswordModifyExtendedResult {
    private static final byte TYPE_PASSWORD_MODIFY_GENERATED_PASSWORD = -128;
    private byte[] password;

    PasswordModifyExtendedResultImpl(PasswordModifyExtendedResult passwordModifyExtendedResult) {
        super(passwordModifyExtendedResult);
        this.password = passwordModifyExtendedResult.getGeneratedPassword();
    }

    PasswordModifyExtendedResultImpl(ResultCode resultCode) {
        super(resultCode);
    }

    @Override
    public byte[] getGeneratedPassword() {
        return this.password;
    }

    @Override
    public String getOID() {
        return null;
    }

    @Override
    public ByteString getValue() {
        if (this.password != null) {
            ByteStringBuilder buffer = new ByteStringBuilder();
            ASN1Writer writer = ASN1.getWriter(buffer);
            try {
                writer.writeStartSequence();
                writer.writeOctetString((byte)-128, this.password);
                writer.writeEndSequence();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return buffer.toByteString();
        }
        return null;
    }

    @Override
    public boolean hasValue() {
        return this.password != null;
    }

    @Override
    public PasswordModifyExtendedResult setGeneratedPassword(byte[] password) {
        this.password = password;
        return this;
    }

    @Override
    public PasswordModifyExtendedResult setGeneratedPassword(char[] password) {
        this.password = password != null ? StaticUtils.getBytes(password) : null;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PasswordModifyExtendedResponse(resultCode=");
        builder.append(this.getResultCode());
        builder.append(", matchedDN=");
        builder.append(this.getMatchedDN());
        builder.append(", diagnosticMessage=");
        builder.append(this.getDiagnosticMessage());
        builder.append(", referrals=");
        builder.append(this.getReferralURIs());
        if (this.password != null) {
            builder.append(", genPassword=");
            builder.append(ByteString.valueOf(this.password));
        }
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }
}

